/****************************************************************************
                             Hyper's CD Catalog 
		A multiplatform qt and xml based catalog program
  
 Author    : Peter Deak (hyperr@freemail.hu)
 License   : GPL
 Copyright : (C) 2003 Peter Deak
****************************************************************************/

#include "recode.h"

#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>

char *recode2(const char *c)
 {
  int i;
  char *r=NULL;
  
  if(c == NULL) 
    return r;
  
  r=new char[strlen(c)];
  for(i=0;i<=(int)strlen(c);i++)
   if(c[i] == '#')
     r[i] = '\n';
   else
     r[i]=c[i];
  return r;
 }

char *recode2rev(const char *c)
 {
  int i;
  char *r=NULL;
  
  if(c == NULL) 
    return r;
  
  r=(char *)malloc(sizeof(char)*strlen(c));
  for(i=0;i<=(int)strlen(c);i++)
   if(c[i] == '\n')
     r[i] = '#';
   else
     r[i]=c[i];
  return r;
 }


/* I use this when writing the data to the xml file */
char *recode(char *c,char** buff)
 {
  int i,j,n;

  // & -> &amp; / ->a / < -> {
  if(c==NULL) return NULL;
  
  for(i=0,n=0;i<(int)strlen(c);i++)
     if(c[i] == '&') n++;

  if((*buff) !=NULL) 
    delete[] (*buff); 
  (*buff)=new char[strlen(c)+2+n*4];

  for(i=0,j=0;i<(int)strlen(c);i++,j++)
   {
    switch(c[i])
     {
       case '&': 
             (*buff)[j]=c[i]; j++;
             (*buff)[j]='a';  j++; 
	     (*buff)[j]='m';  j++; 
	     (*buff)[j]='p'; j++; 
	     (*buff)[j]=';';           break;
       case '<': (*buff)[j]='{';       break;	     
       case '>': (*buff)[j]='}';       break;	            
       case '"': (*buff)[j]='\'';      break;	                   

       case '': case '': case '': (*buff)[j]='o';  break;	                          
       case '': case '': case '': (*buff)[j]='u';  break;	                          
       case '': (*buff)[j]='a';      break;	                          
       case '': (*buff)[j]='e';      break;	                          
       case '': (*buff)[j]='i';      break;	                          

       case '': case '': case '': (*buff)[j]='O';  break;	                          
       case '': case '': case '': (*buff)[j]='U';  break;	                          
       case '': (*buff)[j]='A';      break;	                          
       case '': (*buff)[j]='E';      break;	                          
       case '': (*buff)[j]='I';      break;	                          
       
       case '\'': case '+': case '!': case '%':
       case '/':  case '=': case '(': case ')':
       case '[':  case ']': case '$': case '#': 
       case '@':  case '{': case '}': case '?': 
       case ',':  case ';': case ':': case '.':  
       case '*':  case '-': case '_': case ' ':  
       case '\t':  /*case '\n': */ 
           (*buff)[j]=c[i];  break;
       case '\n': (*buff)[j]='#'; break;
       
       default :
              if((c[i] >= 'a' && c[i]<='z') || 
	         (c[i] >= 'A' && c[i]<='Z') ||
		 (c[i] >= '0' && c[i]<='9') )
	       {
	        (*buff)[j]=c[i];	
	       }	
              else
	       {
	        //cerr <<"dropped char:"<<c[i]<<endl;
	        (*buff)[j]=' ';  
	       }	
	    
         break;
     }
   }     
  (*buff)[j]='\0';    
  return (*buff);  
 }

/* I use this when reading the filesystem from the disc */
char *recodeI(char *c,char** buff)
 {
  int i,j;

  // & -> &amp; / ->a / < -> {
  if(c==NULL) return NULL;
  

  if((*buff) !=NULL) 
    delete[] (*buff); 
  (*buff)=new char[strlen(c)+2];

  for(i=0,j=0;i<(int)strlen(c);i++,j++)
   {
    switch(c[i])
     {
       case '<': (*buff)[j]='{';       break;	     
       case '>': (*buff)[j]='}';       break;	            
       case '"': (*buff)[j]='\'';      break;	                   

       case '': case '': case '': (*buff)[j]='o';  break;	                          
       case '': case '': case '': (*buff)[j]='u';  break;	                          
       case '': (*buff)[j]='a';      break;	                          
       case '': (*buff)[j]='e';      break;	                          
       case '': (*buff)[j]='i';      break;	                          

       case '': case '': case '': (*buff)[j]='O';  break;	                          
       case '': case '': case '': (*buff)[j]='U';  break;	                          
       case '': (*buff)[j]='A';      break;	                          
       case '': (*buff)[j]='E';      break;	                          
       case '': (*buff)[j]='I';      break;	                          
       
       case '\'': case '+': case '!': case '%':
       case '/':  case '=': case '(': case ')':
       case '[':  case ']': case '$': case '#': 
       case '@':  case '{': case '}': case '?': 
       case ',':  case ';': case ':': case '.':  
       case '*':  case '-': case '_': case ' ':  
       case '\t': case '&':  /*case '\n': */ 
           (*buff)[j]=c[i];  break;
       case '\n': (*buff)[j]='#'; break;
       
       default :
              if((c[i] >= 'a' && c[i]<='z') || 
	         (c[i] >= 'A' && c[i]<='Z') ||
		 (c[i] >= '0' && c[i]<='9') )
	       {
	        (*buff)[j]=c[i];	
	       }	
              else
	       {
	        //cerr <<"dropped char:"<<c[i]<<endl;
	        (*buff)[j]=' ';  
	       }	
	    
         break;
     }
   }     
  (*buff)[j]='\0';    
  return (*buff);  
 }

