/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#define MONITOR_NOT_MONITORED 0
#define MONITOR_MONITORED 1
#define MONITOR_NOMINAL   2
#define MONITOR_WARNING  3
#define MONITOR_CRITICAL 4

struct monitor {
	/* A monitor plugin */
	char service[40];
	char label[40];
	int default_level;
	void (*monitor)(struct net_object *no, int status, void **data, void *setupdata);
	void (*cleanup)(void **data);
	void *(*setup)(void *data, struct net_object *no);
	void (*setup_cleanup)(void *data);
	char *(*setup2str)(void *data);
	void *(*str2setup)(char *buf, struct net_object *no);
	void (*timeout_callback)(struct net_object *no, void **data, int expired);
};

struct monitor_tag {
	struct monitor_tag *next;
	struct net_object *no;
	struct net_page *tonp;
	struct monitor *mon;
	int error_level;
	int level;
	int failures;
	int maxfailures;
	int frequency;
	int id;
	int tid;
	char lastmsg[256];
	void *data;
	void *setupdata;
};

/* Provided by network.c */
extern void (*ping_callback)(struct net_object *no);

extern void show_monitor_box(struct net_object *no);
extern void monitor_report(struct net_object *no, struct net_page *np, int status, char *service, char *msg);
extern void init_monitoring();
extern int try_to_connect(int s, unsigned int ip, unsigned short port, 
			  void *data, void (*callback)(void *, int, GdkInputCondition));
extern void monitor_update(struct net_object *no);
extern void destroy_tag(struct monitor_tag *mt);
extern int wait_for_data(int s, void (*callback)(void *, int, GdkInputCondition), void *data);
extern void cancel_data(int);

extern int get_socket_error(int);
extern int connection_timeout;
extern int option_immediate_retry;
extern int option_goto_failure;
