/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: gethex.c,v 1.1 2000/11/20 22:23:56 olaf Exp $ */

#include "cipelib.h"

INLINE int dehex(char c)
{
    if (c>='0' && c<='9')
	return c-'0';
    if (c>='A' && c<='F')
	return c-'A'+10;
    if (c>='a' && c<='f')
	return c-'a'+10;
    return -1;
}

int gethex(const char *c, unsigned char *d, int max)
{
    int i=0, j;
    while (*c) {
	j=dehex(*c++);
	if (j<0)
	    continue; /* allows for abcd-0123 or ab:cd:01:23 etc. forms */
	d[i]=j<<4;
	j=dehex(*c++);
	if (j<0)
	    break; /* includes *c==0 */
	d[i]|=j;
	if (++i>=max)
	    break;
    }
    return i;
}

