(in-package :cl-user)

(defpackage :cmucl-interface
  (:use :cl :sb-alien :sb-c)
  (:export :foreign-define :foreign-function
	   :pointer :function :struct
	   :char :unsigned-char :signed-char
	   :float :double :short :unsigned-short
	   :int :unsigned-int :long :unsigned-long
	   :void))

(in-package :cmucl-interface)

(defmacro foreign-define (name value)
  `(eval-when (:load-toplevel :compile-toplevel :execute)
     (defconstant ,name ,value)
     (export ',name)))

(defun cmu-typename (typename)
  (if (atom typename)
    (case typename
      ((double float int short char unsigned-int unsigned-short
	unsigned-char long unsigned-long void)
       typename)
      (signed-char 'char)
      (string 'c-string)
      (pointer 'unsigned-int)
      (otherwise (error "Unknown type name ~A.~%" typename)))
    (case (first typename)
      (pointer
       (let ((sec (second typename)))
	 (cond
	  ((member sec '(char unsigned-char))
	   'c-string) ;; strings for char pointers
	  ((or (member sec '(struct function void union))
	       (and (consp sec) (member (first sec) '(struct pointer))))
	   'unsigned-int) ;; ints for several kinds of pointers
	  (t ;; otherwise assume an array
	   `(* ,(cmu-typename sec)))))))))

(defmacro foreign-function (name arguments rettype c-name)
  ;; symlist : list of gensyms used as arguments
  ;; alien-type : list of alien types converted from arguments
  ;; array-args : list of t (if alien-type is array) or nil (otherwise)
  ;; arg-mapping : mapping between array args old and new gensyms, and types
  ;;    (list argument-sym new-sym type) e.g. (#:g1 #:g2 double)
  ;; lengths : list of gensyms for the lengths of arrays
  (let* ((symlist (mapcar #'(lambda (x) (declare (ignore x)) (gensym))
	 		  arguments))
	 (alien-types (mapcar #'cmu-typename arguments))
	 (array-args (mapcar #'(lambda (x)
				 (and (consp x) (eql (first x) '*)))
			     alien-types))
	 (has-arrays (remove-if #'null array-args))
	 ;;(extern-function (intern (concatenate 'string
	 ;;"_EXTERN_" (symbol-name name))))
	 (extern-function (gensym))
	 )
    `(eval-when (:load-toplevel :compile-toplevel :execute)
       (#+cmu     def-alien-variable
        #+sbcl define-alien-variable (,c-name ,extern-function)
	   (function ,(cmu-typename rettype) ,@alien-types))
       ;(declaim (inline ,name))
       ,(if has-arrays
	  ;; hard version
	  `(defun ,name ,symlist
	     (declare (optimize (speed 3)
				(safety 0)
                                #+cmu
				(ext:inhibit-warnings 3)
                                #+sbcl
				(sb-ext:inhibit-warnings 3)
				))
	     ;(format t "In ~A (has arrays)~%" ',name)
	     (#+cmu system:without-gcing
              #+sbcl sb-sys:without-gcing
	      (alien-funcall ,extern-function
			     ,@(mapcar #'(lambda (x y)
                                           #+cmu
					   (if x `(system:vector-sap ,y) y)
                                           #+sbcl
					   (if x `(sb-sys:vector-sap ,y) y))
				       array-args symlist))))
	  ;; no arrays; easy version
	  `(defun ,name ,symlist
	     (declare (optimize (speed 3)
				(safety 0)
                                #+cmu
				(ext:inhibit-warnings 3)
                                #+sbcl
				(sb-ext:inhibit-warnings 3)
				))
	     ;(format t "In ~A~%" ',name)
	     (alien-funcall ,extern-function ,@symlist)))
       (export ',name))))
