/*  
 *  Copyright (C) 2004 Tony Sin(x) '76 <tony@becrux.com>
 *  All rights reserved.
 *
 */

/*
 *			 GNU GENERAL PUBLIC LICENSE
 *			    Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
  #ifndef __main_config_h__
    #define __main_config_h__
    #include "../config.h"
  #endif

  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <pthread.h>
  #include <clamav.h>
#endif

#include "clam.h"
#include "list.h"
#include "log.h"

pthread_mutex_t clam_db_mutex = PTHREAD_MUTEX_INITIALIZER;

cClamClient::cClamClient()
{
  memset(&limits,0,sizeof(struct cl_limits));
  limits.maxreclevel = 20;
  limits.maxfiles = 16384;
  limits.maxratio = 1024;
  limits.archivememlim = 0;
  limits.maxfilesize = 1073741824;
  root = NULL;
  last_error = 0;
}

cClamClient::~cClamClient()
{
  if (root != NULL)
    FreeDB();
}

bool cClamClient::InitVirDB()
{
  signo = 0;
  if (root != NULL)
    FreeDB();
  working = ((last_error = cl_loaddbdir(cl_retdbdir(), &root, (unsigned int *) &signo)) == 0);
  working = working && ((last_error = cl_build(root)) == 0);
  memset(&dbstat,0,sizeof(struct cl_stat));
  working = working && ((last_error = cl_statinidir(cl_retdbdir(),&dbstat)) == 0);
  
  return working;
}

void cClamClient::FreeDB()
{
  cl_statfree(&dbstat);
  cl_free(root);
  root = NULL;
}

bool cClamClient::ReloadHashes()
{
  bool result = false;

  pthread_mutex_lock(&clam_db_mutex);
  working = ((last_error = cl_statchkdir(&dbstat)) == 0);
  if (!working)
  {
    InitVirDB();
    result = true;
  }
  pthread_mutex_unlock(&clam_db_mutex);

  return result;
}

cList *cClamClient::GenerateFileList(FILE *loc_sock)
{
  bool finished = false;
  char prev_ch, ch = '\0', buf[255];
  int i = 0;
  cList *p = new cList;

  while (!finished)
  {
    prev_ch = ch;
    ch = (char) fgetc(loc_sock);
    if (ch == '\n')
    {
      if (prev_ch == '\n')
        finished = true;
      else
      {
        buf[i] = '\0';
        p->Add(buf);
        i = 0;
      }
    }
    else
      buf[i++] = ch;
  }

  return p;
}

void cClamClient::TestInfection(int loc_sock)
{
  bool found = false;
  const char *virname;
  cList *file_list;
  cLog *sys_log;
  FILE *sock_fp;

  sys_log = new cLog("Inspector");
  
  sock_fp = fdopen(loc_sock,"r+");
  file_list = GenerateFileList(sock_fp);

  if (ReloadHashes())
    sys_log->WriteLog("Hashes reloaded");
  if (working)
  {
    sys_log->WriteLog("Scan under progress...");
    while (!found && file_list->AreMore())
      found = (cl_scanfile(file_list->GetFile(),&virname,NULL,root,&limits,CL_SCAN_ARCHIVE|CL_SCAN_MAIL|CL_SCAN_OLE2|CL_SCAN_PE|CL_SCAN_BLOCKBROKEN|CL_SCAN_HTML) == CL_VIRUS);
    if (found)
      fprintf(sock_fp,"554 Error: Virus found - Signature is %s\n",virname);
    else
      fprintf(sock_fp,"200 OK\n");
  }
  else
  {
    sys_log->WriteLog("Clam DB not available, scan skipped");
    sys_log->WriteLog(GetErrStr());
    fprintf(sock_fp,"200 OK\n");
  }
  
  fclose(sock_fp);

  delete file_list;
  delete sys_log;
}

const char *cClamClient::GetErrStr()
{
  return cl_strerror(last_error);
}
