use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
(1)	PLEASE .4 <- #4
	PLEASE GIVE UP
	DO COME FROM (1)
	DO .5 <- #72
	DO .1 <- #42
(3)	DO READ OUT .1
	DO GIVE UP
	DO COME FROM (1)
	DO READ OUT .4
	PLEASE GIVE UP
';

print "1..16\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0', 'parser=ThreadedINTERCAL';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 2 ? "" : "not ", "ok 2\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "XLII\n" eq (shift @foo) ? "" : "not ", "ok 4\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 5\n";
print @foo == 2 ? "" : "not ", "ok 6\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 7\n";
print "XLII\n" eq (shift @foo) ? "" : "not ", "ok 8\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 9\n";
print @foo == 2 ? "" : "not ", "ok 10\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "XLII\n" eq (shift @foo) ? "" : "not ", "ok 12\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 13\n";
print @foo == 2 ? "" : "not ", "ok 14\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 15\n";
print "XLII\n" eq (shift @foo) ? "" : "not ", "ok 16\n";

sub foo {
    push @foo, join('', @_);
}

