;;;
;;;  cmail-x20.el - cmail functions for xemacs 20
;;; 
;;;  Author:        maeda shugo <shugo@po.aianet.ne.jp>
;;;                 Toshihiko Ueki <toshi@he.kobelcosys.co.jp>
;;;  Maintainer:    maeda shugo <shugo@po.aianet.ne.jp>
;;;  Created:       1997/08/20
;;;  Last modified: 1997/09/03
;;;
;;;  Copyright (C) 1995-1997 Yukihiro Matsumoto.

;;; cmail-x20.el

(provide 'cmail-x20)
(require 'cmail)
(require 'timezone)

(setq *cmail-file-coding-system 'binary)
(setq *cmail-primary-coding-system 'iso-2022-7bit)

(let ((alist cmail-highlight-attribute-alist) entry name fore back bold italic)
  (while (setq entry (pop alist))
    (setq name (nth 0 entry)
          fore (nth 1 entry)
          back (nth 2 entry)
          bold (nth 3 entry)
          italic (nth 4 entry))
    (if fore (set-face-foreground name fore))
    (if back (set-face-background name back))
    (if (and bold italic)
        (set-face-font name [bold-italic])
      (if bold (set-face-font name [bold]))
      (if italic (set-face-font name [italic])))))

(defvar cmail-use-toolbar (featurep 'toolbar)
  "*If non-nil, use cmail toolbar on XEmacs.")
(defvar cmail-glyph-directory
  "/usr/local/share/cmail"
  "*Where the toolbar icons for cmail are.")

;; mail mode menu
(defvar cmail-mail-menubar-menu
  (copy-sequence mail-menubar-menu))
(defadvice cmail-mail-mode (around cmail-mail-mode-xemacs activate)
  (let ((mail-menubar-menu cmail-mail-menubar-menu))
    ad-do-it))

(add-hook
 'cmail-derived-mail-mode-setter
 (function
  (lambda ()
    ;; replace existing mail-mode-menu
    ;; -> this will parmanetly change cmail-mail-menubar-menu
    (add-menu-button '("Mail")
		     ["Send and Exit" cmail-send-and-exit t])
    (add-menu-button '("Mail")
		     ["Send Mail" cmail-send t])
    (add-menu-button '("Mail")
		     ["Cancel"
		      (progn
			(unless (one-window-p)
			    (delete-window))
			(cmail-go-summary))
		      t])
    ;; and add cmail's original menu
    (add-menu-button '("Mail")
		       ["Go to Cmail Summary Buffer" cmail-go-summary t]
		       "Send and Exit")
    (add-menu-button '("Mail") "---" "Send and Exit"))))

;; summary menu
(defvar cmail-summary-mode-menu-spec
  `("CMail"
    ["Customize" cmail-customize t]
    "----"
    ["Display summary" cmail-disp-summary t]
    ["Go to mail" cmail-goto-index t]
    ["Get new mail"  cmail-get-newmail t]
    ["Visit folder" cmail-visit-folder t]
    ("Folder"
     ["List folders" cmail-folders t]
     ["Rename Folder" cmail-rename-folder t]
     ["Copy Folder" cmail-copy-folder t]
     ["Save Folder" cmail-save-folder t]
     ["Auto archive" cmail-auto-archive t]
     ["Catch up all" cmail-catch-up-all t]
     )
    "----"
    ["Mail send" cmail-mail-from-summary t]
    ["Reply" cmail-reply t]
    ["Reply(include)" cmail-reply-include-text t]
    ["Followup" cmail-followup t]
    ["Followup(include)" cmail-followup-include-text t]
    ["Forward" cmail-forward t]
    ("Misc"
     ["Mail to pipe" cmail-pipe t]
     ["Print mail" cmail-print t]
     ["Caesar message" cmail-caesar-message t]
     ["Stop page breaking" cmail-stop-page-breaking t]
     )
;    ["Mail to pipe" . cmail-pipe t]
;    ["Print mail" . cmail-print t]
;    ["Caesar message" cmail-caesar-message t]
;    ["Stop page breaking" cmail-stop-page-breaking t]
    "----"
    ("Mark"
     ["Mark ^" cmail-mark-mail t]
     ["Mark ^ to all mails" cmail-mark-all t]
     ["Unmark ^" cmail-unmark t]
     ["Mark active" cmail-mark-active t]
     ["Mark delete" cmail-mark-delete t]
     ["Mark hold" cmail-mark-hold t]
     ["Mark unread" cmail-mark-unread t]
     )
    ("Digest"
     ["Send digest" cmail-send-digest t]
     ["Burst digest" cmail-burst-digest t]
     )
    ("Sort"
     ["Sort by subject" cmail-sort-by-subject t]
     ["Sort by subject(relative)" cmail-sort-by-subject-relative t]
     ["Sort by time" cmail-sort-by-time t]
     ["Sort by number" cmail-sort-by-number t]
     ["Sort by author" cmail-sort-by-author t]
     ["Sort by byte" cmail-sort-by-bytes t]
     ["Sort by thread"
      (unless (cmail-thread-p)
	(cmail-toggle-thread))
      :active (not (cmail-thread-p))]
     ["Sort by original order"
      (progn
	(cmail-get-folder)
	(setq *cmail-disp-thread
	      (cmail-check-display-thread cmail-current-folder))
	(cmail-sort-header)
	(cmail-disp-summary))
      t]
     )
    ("Transfer"
     ["unix mail to cmail" cmail-m2c t]
     ["Rmail to cmail" cmail-r2c t]
     ["Cmail to unix mail" cmail-c2m t]
     )
    ,(setq cmail-summary-menu-bar-feature
	   '("Feature Control"
	     :filter (lambda (menu)
		       (let ((version
			      (cond
			       ((string= cmail-crypt-default-version "5.0")
				"2.6")
			       ((string= cmail-crypt-default-version "2.6")
				"GPG")
			       (t
				"5.0"))))
			 (mapcar
			  (lambda (elm)
			    (if (and (vectorp elm)
				     (string= "Default PGP version ->"
					      (aref elm 0)))
				(vector
				 "Default PGP version ->"
				 'cmail-crypt-change-default-version
				 :included (and cmail-use-mailcrypt
						(not (string= mc-version "3.4")))
				 :suffix version)
			      elm))
			  menu)))
	     ["Always displaying folders"
	      cmail-toggle-always-display-folders
	      :included cmail-use-full-window
	      :style toggle
	      :selected cmail-always-display-folders]
	     ["Highlighting"
	      cmail-toggle-highlight-mode
	      :included (not (featurep 'hilit19))
	      :style toggle
	      :selected cmail-highlight-mode]
	     ["MIME forwarding"
	      cmail-toggle-mime-forwarding
	      :included cmail-use-mime
	      :style toggle
	      :selected cmail-mime-forwarding]
	     ["Automatic MIME preview"
	      cmail-mime-toggle-automatic-preview
	      :included cmail-use-mime
	      :style toggle
	      :selected cmail-mime-automatic-preview
	      ]
	     ["Automatic PGP decrypt/verify"
	      cmail-crypt-toggle-automatic-decrypt/verify
	      :included cmail-use-mailcrypt
	      :style toggle
	      :selected cmail-crypt-automatic-decrypt/verify
	      ]
	     ["Default PGP version ->"
	      cmail-crypt-change-default-version
	      :included nil
	      ]
	     ))
    "----"
    ["Quit" cmail-summary-quit t]
    )
  "Menu spec for cmail summary mode.")

(defvar cmail-folders-mode-menu-spec
  '("CMail"
    ["Customize" cmail-customize t]
    "----"
    ["New mail"  cmail-folders-get-newmail t]
    ["Write mail" cmail-mail t]
    "----"
    ["Update folders" cmail-folders-update t]
    ["Visit folder" cmail-folders-visit-folder t]
    ["Copy folder" cmail-folders-copy-folder t]
    ["Rename folder" cmail-folders-rename-folder t]
    ["Kill folder" cmail-folders-kill-folder t]
    "----"
    ["Quit" cmail-folders-quit t]
    )
  "Menu spec for cmail folders mode.")

(defun cmail-make-toolbar-icon (name)
  "Create toolbar icon."
  (let ((filename)
	(ext (if (featurep 'xpm) ".xpm" ".xbm")))
    (setq filename (concat name ext))
    (setq filename
	  (expand-file-name filename cmail-glyph-directory))
    (toolbar-make-button-list filename)))

(defvar cmail-toolbar-get-mail-icon
  (cmail-make-toolbar-icon "get-mail")
  "Toolbar icon for get mail")

(defvar cmail-toolbar-write-mail-icon
  (cmail-make-toolbar-icon "write-mail")
  "Toolbar icon for write mail")

(defvar cmail-toolbar-folders-icon
  (cmail-make-toolbar-icon "folders")
  "Toolbar icon for folders")

(defvar cmail-toolbar-reply-icon
  (cmail-make-toolbar-icon "reply")
  "Toolbar icon for reply")

(defvar cmail-toolbar-reply-include-icon
  (cmail-make-toolbar-icon "reply-include")
  "Toolbar icon for reply(include)")

(defvar cmail-toolbar-follow-icon
  (cmail-make-toolbar-icon "follow")
  "Toolbar icon for follow")

(defvar cmail-toolbar-follow-include-icon
  (cmail-make-toolbar-icon "follow-include")
  "Toolbar icon for follow(include)")

(defvar cmail-toolbar-forward-icon
  (cmail-make-toolbar-icon "forward")
  "Toolbar icon for forward")

(defvar cmail-toolbar-delete-icon
  (cmail-make-toolbar-icon "delete")
  "Toolbar icon for delete")

(defvar cmail-toolbar-update-icon
  (cmail-make-toolbar-icon "update")
  "Toolbar icon for update")

(defvar cmail-toolbar-copy-icon
  (cmail-make-toolbar-icon "copy")
  "Toolbar icon for copy")

(defvar cmail-toolbar-rename-icon
  (cmail-make-toolbar-icon "rename")
  "Toolbar icon for rename")

(defvar cmail-summary-toolbar
  '(
    [cmail-toolbar-get-mail-icon cmail-get-newmail t "Get new mail"]
    [cmail-toolbar-write-mail-icon
     cmail-mail-from-summary t "Write mail"]
    [cmail-toolbar-folders-icon cmail-folders t "View folders"]
    [:style 2d :size 5]
    [cmail-toolbar-reply-icon cmail-reply t "Reply"]
    [cmail-toolbar-reply-include-icon
     cmail-reply-include-text t "Reply (include text)"]
    [cmail-toolbar-follow-icon cmail-followup t "Follow up"]
    [cmail-toolbar-follow-include-icon
     cmail-followup-include-text t "Follow up (include text)"]
    [cmail-toolbar-forward-icon cmail-forward t "Forward"]
    [cmail-toolbar-delete-icon cmail-mark-delete t "Mark delete"]
    )
  "The toolbar for summary")

(defvar cmail-folders-toolbar
  '(
    [cmail-toolbar-update-icon cmail-folders-update t "Update folders"]
    [cmail-toolbar-copy-icon cmail-folders-copy-folder t "Copy folder"]
    [cmail-toolbar-rename-icon cmail-folders-rename-folder t "Rename folder"]
    [cmail-toolbar-delete-icon cmail-folders-kill-folder t "Kill folder"]
    [cmail-toolbar-write-mail-icon cmail-mail t "Write mail"]
    )
  "The toolbar for folders")

(cond (window-system
       (add-menu-item '("Apps") "Read Mail (Cmail)"
		      'cmail t "Read Mail (VM)...")
       (add-menu-item '("Apps") "Send Mail (Cmail)"
		      'cmail-mail t "Read Mail (VM)...")
       (delete-menu-item '("Apps" "Read Mail (VM)..."))
       (delete-menu-item '("Apps" "Read Mail (MH)..."))
       (delete-menu-item '("Apps" "Send mail..."))

       (define-key cmail-summary-mode-map 'button2 'cmail-mouse-select)
;       (define-key cmail-summary-mode-map [double-mouse-2]
;	 'cmail-sum-mouse-selected-msg-menu)
       (define-key cmail-summary-mode-map 'button3 'cmail-sum-mouse-folder-menu)
;       (define-key cmail-summary-mode-map [double-mouse-3]
;	 'cmail-sum-mouse-folder-menu)
       
       (add-hook 'cmail-summary-mode-hook
             '(lambda ()
		 (set-buffer-menubar current-menubar)
		 (add-submenu nil cmail-summary-mode-menu-spec)
		 (if cmail-use-toolbar
		     (save-excursion
		       (set-buffer *cmail-summary-buffer)
		       (set-specifier default-toolbar
				      (cons (current-buffer) cmail-summary-toolbar))))))

       (add-hook 'cmail-folders-mode-hook
	     '(lambda ()
		 (set-buffer-menubar current-menubar)
		 (add-submenu nil cmail-folders-mode-menu-spec)
		 (if cmail-use-toolbar
		     (save-excursion
		       (set-buffer *cmail-folders-buffer)
		       (set-specifier default-toolbar
				      (cons (current-buffer) cmail-folders-toolbar))))))))

;; mouse-event
(defun cmail-mouse-select (event)
  (interactive "e")
  (mouse-set-point event)
  (cmail-read-contents (cmail-get-page-number-from-summary)))

(defun cmail-sum-mouse-folder-menu (event)
  "Pop up menu for folder in the cmail summary."
  (interactive "e")
  (let ((selection
	 (popup-menu
	  (append
	   (list (format "Current Folder: %s" cmail-current-folder)
		 "---")
	   cmail-sum-pop-up-menu-1))))
    (if selection
	(call-interactively selection))))

(defun cmail-sum-mouse-expand ()
  (interactive)
  (delete-other-windows)
  (recenter))

