/* Authors:  Jens Peter Secher (jpsecher@diku.dk)
 * Content:  C-Mix system: Literal strings used by all output functions.
 *
 * Copyright  1998. The TOPPS group at DIKU, U of Copenhagen.
 * Redistribution and modification are allowed under certain
 * terms; see the file COPYING.cmix for details.
 */

#include "strings.h"

// TYPES
const char* str_void = "void";          
const char* str_char = "char";
const char* str_schar = "signed char";
const char* str_uchar = "unsigned char"; 
const char* str_short = "short";         
const char* str_ushort = "unsigned short";
const char* str_int = "int";           
const char* str_uint = "unsigned int";      
const char* str_long = "long";          
const char* str_ulong = "unsigned long"; 
const char* str_float = "float";         
const char* str_double = "double";        
const char* str_ldouble = "long double";   

// STRUCTURES
const char* str_struct = "struct";
const char* str_enum = "enum";
const char* str_union = "union";

// OPERATORS
const char* str_addr = "&";
const char* str_plus = "+";
const char* str_minus = "-";
const char* str_neg = "~";
const char* str_bang = "!";
const char* str_mul = "*";
const char* str_div = "/";
const char* str_mod = "%";
const char* str_lshift = "<<";
const char* str_rshift = ">>";
const char* str_less = "<";
const char* str_greater = ">";
const char* str_lesseq = "<=";
const char* str_greatereq = ">=";
const char* str_equal = "==";
const char* str_notequal = "!=";
const char* str_bxor = "^";
const char* str_bor = "|";
const char* str_and = "&&";
const char* str_or = "||";

// DELIMITERS
const char* str_blank = " ";
const char* str_is = "=";
const char* str_dot = ".";
const char* str_lparen = "(";
const char* str_rparen = ")";
const char* str_comma = ",";
const char* str_semi = ";";
const char* str_lbrace = "{";
const char* str_rbrace = "}";
const char* str_lbracket = "[";
const char* str_rbracket = "]";
const char* str_colon = ":";
const char* str_rarrow = "->";
const char* str_question = "?";
const char* str_tilde = "~";

// MODIFIERS
const char* str_const = "const";
const char* str_vol = "volatile";
const char* str_static = "static";
const char* str_extern = "extern";

// KEYWORDS
const char* str_if = "if";
const char* str_else = "else";
const char* str_case = "case";
const char* str_switch = "switch";
const char* str_for = "for";
const char* str_do = "do";
const char* str_while = "while";
const char* str_goto = "goto";
const char* str_return = "return";
const char* str_malloc = "malloc";
const char* str_calloc = "calloc";
const char* str_length = "length";
const char* str_sizeof = "sizeof";
const char* str_free = "free";

const char* str_typedef = "typedef";
const char* str_default = "default";
const char* str_break = "break";
const char* str_continue = "continue";
const char* str_anything_but = "anything but";
