/*****************************************************************
*
*   version.c
*
*     Copyright (c) 2000,2001  Kam Tik <kamtik@kamtik.net>
*
*      http://debian.kamtik.net
*
*     This program is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with this program; if not, write to the Free Software
*     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
*
******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "msg_client.h"

extern gint version_port;
extern gchar version_server_name[STR_BUFFER_SIZE];

gboolean if_version_newer(void)
{
	gint ver_major;
	gchar str_major[3];
	gint ver_minor;
	gchar str_minor[3];
	gint ver_micro;
	gchar str_micro[3];

	gint c;
	gchar *ptr;

	gchar online_version[10];

	/* query the server for the latest version number */
	strcpy(online_version, query_server_msg(version_port,version_server_name));

	if(strcasecmp(online_version,"0"))
	{
	c = 0;
	while(online_version[c]!='.') c++;
	online_version[c] = '\0';
	strcpy(str_major,online_version);
	ver_major = atoi(str_major);

	c++;
	ptr = (online_version+c);
	while(online_version[c]!='.') c++;
	online_version[c] = '\0';
	strcpy(str_minor,ptr);
	ver_minor = atoi(str_minor);

	c++;
	ptr = (online_version+c);
	strcpy(str_micro,ptr);
	ver_micro = atoi(str_micro);

	if(ver_major > VERSION_MAJOR)
		return 1;
	else if(ver_minor > VERSION_MINOR)
		return 1;
	else if(ver_micro > VERSION_MICRO)
		return 1;
	else
		return 0;
	}
	else
		return 0;
}

void update_notice_dialog(void)
{
	GtkWidget *dialog;
	GtkWidget *button;
	GtkWidget *label;
	gchar str[STR_BUFFER_SIZE];


	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog),_("Update"));
	sprintf(str,_("CPanel version %s is now available!\nDo you want to update now?"),query_server_msg(version_port,version_server_name));
	label = gtk_label_new(str);

	gtk_container_set_border_width(GTK_CONTAINER(dialog),10);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,0);

	button = gtk_button_new_with_label(_("Yes, please"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_process),"cpanel");
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),dialog);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,FALSE,FALSE,0);
	
	gtk_widget_grab_default(button);

	button = gtk_button_new_with_label(_("No, thanks"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),dialog);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,FALSE,FALSE,0);

	gtk_widget_show_all(dialog);
}
