// Generated by makeDynGL.pl
//
// Description: Wrappers for dynamically loaded GL functions
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//

#ifndef __GLPP__HPP__
#define __GLPP__HPP__

#ifdef WIN32
#include <windows.h>
#include <wingdi.h>
#endif

#include <GL/gl.h>

#ifndef GLintptrARB
# if defined(_WIN64)
	typedef __int64 GLintptrARB;
	typedef __int64 GLsizeiptrARB;
# elif defined(__ia64__) || defined(__x86_64__)
	typedef long int GLintptrARB;
	typedef long int GLsizeiptrARB;
# else
	typedef int GLintptrARB;
	typedef int GLsizeiptrARB;
# endif
#endif

#ifndef GLhalf
	typedef unsigned short GLhalf;
#endif

#ifdef CONFIG_GL_NAMESPACE
namespace GL
{
#endif

#ifndef DYNAMIC_GL
	static inline bool init( const char *) { return true; }
#else
	extern bool init( const char *path);
	extern void (*DYN_glAccum) (GLenum op, GLfloat value);
	inline void glAccum (GLenum op, GLfloat value) {
		return DYN_glAccum (op,value);
	}
	extern void (*DYN_glActiveStencilFaceEXT) (GLenum face);
	inline void glActiveStencilFaceEXT (GLenum face) {
		return DYN_glActiveStencilFaceEXT (face);
	}
	extern void (*DYN_glActiveTexture) (GLenum texture);
	inline void glActiveTexture (GLenum texture) {
		return DYN_glActiveTexture (texture);
	}
	extern void (*DYN_glActiveTextureARB) (GLenum texture);
	inline void glActiveTextureARB (GLenum texture) {
		return DYN_glActiveTextureARB (texture);
	}
	extern void (*DYN_glAddSwapHintRectWIN) (GLint x, GLint y, GLsizei width, GLsizei height);
	inline void glAddSwapHintRectWIN (GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glAddSwapHintRectWIN (x,y,width,height);
	}
	extern void (*DYN_glAlphaFunc) (GLenum func, GLclampf ref);
	inline void glAlphaFunc (GLenum func, GLclampf ref) {
		return DYN_glAlphaFunc (func,ref);
	}
	extern GLboolean (*DYN_glAreProgramsResidentNV) (GLsizei n, const GLuint *programs, GLboolean *residences);
	inline GLboolean glAreProgramsResidentNV (GLsizei n, const GLuint *programs, GLboolean *residences) {
		return DYN_glAreProgramsResidentNV (n,programs,residences);
	}
	extern GLboolean (*DYN_glAreTexturesResident) (GLsizei n, const GLuint *textures, GLboolean *residences);
	inline GLboolean glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences) {
		return DYN_glAreTexturesResident (n,textures,residences);
	}
	extern GLboolean (*DYN_glAreTexturesResidentEXT) (GLsizei n, const GLuint *textures, GLboolean *residences);
	inline GLboolean glAreTexturesResidentEXT (GLsizei n, const GLuint *textures, GLboolean *residences) {
		return DYN_glAreTexturesResidentEXT (n,textures,residences);
	}
	extern void (*DYN_glArrayElement) (GLint i);
	inline void glArrayElement (GLint i) {
		return DYN_glArrayElement (i);
	}
	extern void (*DYN_glArrayElementEXT) (GLint i);
	inline void glArrayElementEXT (GLint i) {
		return DYN_glArrayElementEXT (i);
	}
	extern void (*DYN_glBegin) (GLenum mode);
	inline void glBegin (GLenum mode) {
		return DYN_glBegin (mode);
	}
	extern void (*DYN_glBeginOcclusionQueryNV) (GLuint id);
	inline void glBeginOcclusionQueryNV (GLuint id) {
		return DYN_glBeginOcclusionQueryNV (id);
	}
	extern void (*DYN_glBindBufferARB) (GLenum target, GLuint buffer);
	inline void glBindBufferARB (GLenum target, GLuint buffer) {
		return DYN_glBindBufferARB (target,buffer);
	}
	extern void (*DYN_glBindProgramARB) (GLenum target, GLuint program);
	inline void glBindProgramARB (GLenum target, GLuint program) {
		return DYN_glBindProgramARB (target,program);
	}
	extern void (*DYN_glBindProgramNV) (GLenum target, GLuint id);
	inline void glBindProgramNV (GLenum target, GLuint id) {
		return DYN_glBindProgramNV (target,id);
	}
	extern void (*DYN_glBindTexture) (GLenum target, GLuint texture);
	inline void glBindTexture (GLenum target, GLuint texture) {
		return DYN_glBindTexture (target,texture);
	}
	extern void (*DYN_glBindTextureEXT) (GLenum target, GLuint texture);
	inline void glBindTextureEXT (GLenum target, GLuint texture) {
		return DYN_glBindTextureEXT (target,texture);
	}
	extern void (*DYN_glBitmap) (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
	inline void glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) {
		return DYN_glBitmap (width,height,xorig,yorig,xmove,ymove,bitmap);
	}
	extern void (*DYN_glBlendColor) (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
	inline void glBlendColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) {
		return DYN_glBlendColor (red,green,blue,alpha);
	}
	extern void (*DYN_glBlendColorEXT) (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
	inline void glBlendColorEXT (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) {
		return DYN_glBlendColorEXT (red,green,blue,alpha);
	}
	extern void (*DYN_glBlendEquation) (GLenum mode);
	inline void glBlendEquation (GLenum mode) {
		return DYN_glBlendEquation (mode);
	}
	extern void (*DYN_glBlendEquationEXT) (GLenum mode);
	inline void glBlendEquationEXT (GLenum mode) {
		return DYN_glBlendEquationEXT (mode);
	}
	extern void (*DYN_glBlendFunc) (GLenum sfactor, GLenum dfactor);
	inline void glBlendFunc (GLenum sfactor, GLenum dfactor) {
		return DYN_glBlendFunc (sfactor,dfactor);
	}
	extern void (*DYN_glBlendFuncSeparate) (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
	inline void glBlendFuncSeparate (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) {
		return DYN_glBlendFuncSeparate (sfactorRGB,dfactorRGB,sfactorAlpha,dfactorAlpha);
	}
	extern void (*DYN_glBlendFuncSeparateEXT) (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
	inline void glBlendFuncSeparateEXT (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) {
		return DYN_glBlendFuncSeparateEXT (sfactorRGB,dfactorRGB,sfactorAlpha,dfactorAlpha);
	}
	extern void (*DYN_glBufferDataARB) (GLenum target, GLsizeiptrARB size, const GLvoid *data, GLenum usage);
	inline void glBufferDataARB (GLenum target, GLsizeiptrARB size, const GLvoid *data, GLenum usage) {
		return DYN_glBufferDataARB (target,size,data,usage);
	}
	extern void (*DYN_glBufferSubDataARB) (GLenum target, GLintptrARB offset, GLsizeiptrARB size, const GLvoid *data);
	inline void glBufferSubDataARB (GLenum target, GLintptrARB offset, GLsizeiptrARB size, const GLvoid *data) {
		return DYN_glBufferSubDataARB (target,offset,size,data);
	}
	extern void (*DYN_glCallList) (GLuint list);
	inline void glCallList (GLuint list) {
		return DYN_glCallList (list);
	}
	extern void (*DYN_glCallLists) (GLsizei n, GLenum type, const GLvoid *lists);
	inline void glCallLists (GLsizei n, GLenum type, const GLvoid *lists) {
		return DYN_glCallLists (n,type,lists);
	}
	extern void (*DYN_glClear) (GLbitfield mask);
	inline void glClear (GLbitfield mask) {
		return DYN_glClear (mask);
	}
	extern void (*DYN_glClearAccum) (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	inline void glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
		return DYN_glClearAccum (red,green,blue,alpha);
	}
	extern void (*DYN_glClearColor) (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
	inline void glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) {
		return DYN_glClearColor (red,green,blue,alpha);
	}
	extern void (*DYN_glClearDepth) (GLclampd depth);
	inline void glClearDepth (GLclampd depth) {
		return DYN_glClearDepth (depth);
	}
	extern void (*DYN_glClearIndex) (GLfloat c);
	inline void glClearIndex (GLfloat c) {
		return DYN_glClearIndex (c);
	}
	extern void (*DYN_glClearStencil) (GLint s);
	inline void glClearStencil (GLint s) {
		return DYN_glClearStencil (s);
	}
	extern void (*DYN_glClientActiveTexture) (GLenum texture);
	inline void glClientActiveTexture (GLenum texture) {
		return DYN_glClientActiveTexture (texture);
	}
	extern void (*DYN_glClientActiveTextureARB) (GLenum texture);
	inline void glClientActiveTextureARB (GLenum texture) {
		return DYN_glClientActiveTextureARB (texture);
	}
	extern void (*DYN_glClipPlane) (GLenum plane, const GLdouble *equation);
	inline void glClipPlane (GLenum plane, const GLdouble *equation) {
		return DYN_glClipPlane (plane,equation);
	}
	extern void (*DYN_glColor3b) (GLbyte red, GLbyte green, GLbyte blue);
	inline void glColor3b (GLbyte red, GLbyte green, GLbyte blue) {
		return DYN_glColor3b (red,green,blue);
	}
	extern void (*DYN_glColor3bv) (const GLbyte *v);
	inline void glColor3bv (const GLbyte *v) {
		return DYN_glColor3bv (v);
	}
	extern void (*DYN_glColor3d) (GLdouble red, GLdouble green, GLdouble blue);
	inline void glColor3d (GLdouble red, GLdouble green, GLdouble blue) {
		return DYN_glColor3d (red,green,blue);
	}
	extern void (*DYN_glColor3dv) (const GLdouble *v);
	inline void glColor3dv (const GLdouble *v) {
		return DYN_glColor3dv (v);
	}
	extern void (*DYN_glColor3f) (GLfloat red, GLfloat green, GLfloat blue);
	inline void glColor3f (GLfloat red, GLfloat green, GLfloat blue) {
		return DYN_glColor3f (red,green,blue);
	}
	extern void (*DYN_glColor3fv) (const GLfloat *v);
	inline void glColor3fv (const GLfloat *v) {
		return DYN_glColor3fv (v);
	}
	extern void (*DYN_glColor3hNV) (GLhalf red, GLhalf green, GLhalf blue);
	inline void glColor3hNV (GLhalf red, GLhalf green, GLhalf blue) {
		return DYN_glColor3hNV (red,green,blue);
	}
	extern void (*DYN_glColor3hvNV) (const GLhalf *v);
	inline void glColor3hvNV (const GLhalf *v) {
		return DYN_glColor3hvNV (v);
	}
	extern void (*DYN_glColor3i) (GLint red, GLint green, GLint blue);
	inline void glColor3i (GLint red, GLint green, GLint blue) {
		return DYN_glColor3i (red,green,blue);
	}
	extern void (*DYN_glColor3iv) (const GLint *v);
	inline void glColor3iv (const GLint *v) {
		return DYN_glColor3iv (v);
	}
	extern void (*DYN_glColor3s) (GLshort red, GLshort green, GLshort blue);
	inline void glColor3s (GLshort red, GLshort green, GLshort blue) {
		return DYN_glColor3s (red,green,blue);
	}
	extern void (*DYN_glColor3sv) (const GLshort *v);
	inline void glColor3sv (const GLshort *v) {
		return DYN_glColor3sv (v);
	}
	extern void (*DYN_glColor3ub) (GLubyte red, GLubyte green, GLubyte blue);
	inline void glColor3ub (GLubyte red, GLubyte green, GLubyte blue) {
		return DYN_glColor3ub (red,green,blue);
	}
	extern void (*DYN_glColor3ubv) (const GLubyte *v);
	inline void glColor3ubv (const GLubyte *v) {
		return DYN_glColor3ubv (v);
	}
	extern void (*DYN_glColor3ui) (GLuint red, GLuint green, GLuint blue);
	inline void glColor3ui (GLuint red, GLuint green, GLuint blue) {
		return DYN_glColor3ui (red,green,blue);
	}
	extern void (*DYN_glColor3uiv) (const GLuint *v);
	inline void glColor3uiv (const GLuint *v) {
		return DYN_glColor3uiv (v);
	}
	extern void (*DYN_glColor3us) (GLushort red, GLushort green, GLushort blue);
	inline void glColor3us (GLushort red, GLushort green, GLushort blue) {
		return DYN_glColor3us (red,green,blue);
	}
	extern void (*DYN_glColor3usv) (const GLushort *v);
	inline void glColor3usv (const GLushort *v) {
		return DYN_glColor3usv (v);
	}
	extern void (*DYN_glColor4b) (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
	inline void glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) {
		return DYN_glColor4b (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4bv) (const GLbyte *v);
	inline void glColor4bv (const GLbyte *v) {
		return DYN_glColor4bv (v);
	}
	extern void (*DYN_glColor4d) (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
	inline void glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) {
		return DYN_glColor4d (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4dv) (const GLdouble *v);
	inline void glColor4dv (const GLdouble *v) {
		return DYN_glColor4dv (v);
	}
	extern void (*DYN_glColor4f) (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	inline void glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
		return DYN_glColor4f (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4fv) (const GLfloat *v);
	inline void glColor4fv (const GLfloat *v) {
		return DYN_glColor4fv (v);
	}
	extern void (*DYN_glColor4hNV) (GLhalf red, GLhalf green, GLhalf blue, GLhalf alpha);
	inline void glColor4hNV (GLhalf red, GLhalf green, GLhalf blue, GLhalf alpha) {
		return DYN_glColor4hNV (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4hvNV) (const GLhalf *v);
	inline void glColor4hvNV (const GLhalf *v) {
		return DYN_glColor4hvNV (v);
	}
	extern void (*DYN_glColor4i) (GLint red, GLint green, GLint blue, GLint alpha);
	inline void glColor4i (GLint red, GLint green, GLint blue, GLint alpha) {
		return DYN_glColor4i (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4iv) (const GLint *v);
	inline void glColor4iv (const GLint *v) {
		return DYN_glColor4iv (v);
	}
	extern void (*DYN_glColor4s) (GLshort red, GLshort green, GLshort blue, GLshort alpha);
	inline void glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha) {
		return DYN_glColor4s (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4sv) (const GLshort *v);
	inline void glColor4sv (const GLshort *v) {
		return DYN_glColor4sv (v);
	}
	extern void (*DYN_glColor4ub) (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
	inline void glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) {
		return DYN_glColor4ub (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4ubv) (const GLubyte *v);
	inline void glColor4ubv (const GLubyte *v) {
		return DYN_glColor4ubv (v);
	}
	extern void (*DYN_glColor4ui) (GLuint red, GLuint green, GLuint blue, GLuint alpha);
	inline void glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha) {
		return DYN_glColor4ui (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4uiv) (const GLuint *v);
	inline void glColor4uiv (const GLuint *v) {
		return DYN_glColor4uiv (v);
	}
	extern void (*DYN_glColor4us) (GLushort red, GLushort green, GLushort blue, GLushort alpha);
	inline void glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha) {
		return DYN_glColor4us (red,green,blue,alpha);
	}
	extern void (*DYN_glColor4usv) (const GLushort *v);
	inline void glColor4usv (const GLushort *v) {
		return DYN_glColor4usv (v);
	}
	extern void (*DYN_glColorMask) (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
	inline void glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) {
		return DYN_glColorMask (red,green,blue,alpha);
	}
	extern void (*DYN_glColorMaterial) (GLenum face, GLenum mode);
	inline void glColorMaterial (GLenum face, GLenum mode) {
		return DYN_glColorMaterial (face,mode);
	}
	extern void (*DYN_glColorPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glColorPointer (size,type,stride,pointer);
	}
	extern void (*DYN_glColorPointerEXT) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
	inline void glColorPointerEXT (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer) {
		return DYN_glColorPointerEXT (size,type,stride,count,pointer);
	}
	extern void (*DYN_glColorSubTable) (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data);
	inline void glColorSubTable (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data) {
		return DYN_glColorSubTable (target,start,count,format,type,data);
	}
	extern void (*DYN_glColorSubTableEXT) (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *table);
	inline void glColorSubTableEXT (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *table) {
		return DYN_glColorSubTableEXT (target,start,count,format,type,table);
	}
	extern void (*DYN_glColorTable) (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);
	inline void glColorTable (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table) {
		return DYN_glColorTable (target,internalformat,width,format,type,table);
	}
	extern void (*DYN_glColorTableEXT) (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);
	inline void glColorTableEXT (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table) {
		return DYN_glColorTableEXT (target,internalformat,width,format,type,table);
	}
	extern void (*DYN_glColorTableParameterfv) (GLenum target, GLenum pname, const GLfloat *params);
	inline void glColorTableParameterfv (GLenum target, GLenum pname, const GLfloat *params) {
		return DYN_glColorTableParameterfv (target,pname,params);
	}
	extern void (*DYN_glColorTableParameteriv) (GLenum target, GLenum pname, const GLint *params);
	inline void glColorTableParameteriv (GLenum target, GLenum pname, const GLint *params) {
		return DYN_glColorTableParameteriv (target,pname,params);
	}
	extern void (*DYN_glCombinerInputNV) (GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
	inline void glCombinerInputNV (GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage) {
		return DYN_glCombinerInputNV (stage,portion,variable,input,mapping,componentUsage);
	}
	extern void (*DYN_glCombinerOutputNV) (GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum);
	inline void glCombinerOutputNV (GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum) {
		return DYN_glCombinerOutputNV (stage,portion,abOutput,cdOutput,sumOutput,scale,bias,abDotProduct,cdDotProduct,muxSum);
	}
	extern void (*DYN_glCombinerParameterfNV) (GLenum pname, GLfloat param);
	inline void glCombinerParameterfNV (GLenum pname, GLfloat param) {
		return DYN_glCombinerParameterfNV (pname,param);
	}
	extern void (*DYN_glCombinerParameterfvNV) (GLenum pname, const GLfloat *params);
	inline void glCombinerParameterfvNV (GLenum pname, const GLfloat *params) {
		return DYN_glCombinerParameterfvNV (pname,params);
	}
	extern void (*DYN_glCombinerParameteriNV) (GLenum pname, GLint param);
	inline void glCombinerParameteriNV (GLenum pname, GLint param) {
		return DYN_glCombinerParameteriNV (pname,param);
	}
	extern void (*DYN_glCombinerParameterivNV) (GLenum pname, const GLint *params);
	inline void glCombinerParameterivNV (GLenum pname, const GLint *params) {
		return DYN_glCombinerParameterivNV (pname,params);
	}
	extern void (*DYN_glCombinerStageParameterfvNV) (GLenum stage, GLenum pname, const GLfloat *params);
	inline void glCombinerStageParameterfvNV (GLenum stage, GLenum pname, const GLfloat *params) {
		return DYN_glCombinerStageParameterfvNV (stage,pname,params);
	}
	extern void (*DYN_glCompressedTexImage1D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexImage1D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexImage1D (target,level,internalformat,width,border,imageSize,data);
	}
	extern void (*DYN_glCompressedTexImage1DARB) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexImage1DARB (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexImage1DARB (target,level,internalformat,width,border,imageSize,data);
	}
	extern void (*DYN_glCompressedTexImage2D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexImage2D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexImage2D (target,level,internalformat,width,height,border,imageSize,data);
	}
	extern void (*DYN_glCompressedTexImage2DARB) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexImage2DARB (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexImage2DARB (target,level,internalformat,width,height,border,imageSize,data);
	}
	extern void (*DYN_glCompressedTexImage3D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexImage3D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexImage3D (target,level,internalformat,width,height,depth,border,imageSize,data);
	}
	extern void (*DYN_glCompressedTexImage3DARB) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexImage3DARB (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexImage3DARB (target,level,internalformat,width,height,depth,border,imageSize,data);
	}
	extern void (*DYN_glCompressedTexSubImage1D) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexSubImage1D (target,level,xoffset,width,format,imageSize,data);
	}
	extern void (*DYN_glCompressedTexSubImage1DARB) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexSubImage1DARB (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexSubImage1DARB (target,level,xoffset,width,format,imageSize,data);
	}
	extern void (*DYN_glCompressedTexSubImage2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexSubImage2D (target,level,xoffset,yoffset,width,height,format,imageSize,data);
	}
	extern void (*DYN_glCompressedTexSubImage2DARB) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexSubImage2DARB (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexSubImage2DARB (target,level,xoffset,yoffset,width,height,format,imageSize,data);
	}
	extern void (*DYN_glCompressedTexSubImage3D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexSubImage3D (target,level,xoffset,yoffset,zoffset,width,height,depth,format,imageSize,data);
	}
	extern void (*DYN_glCompressedTexSubImage3DARB) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
	inline void glCompressedTexSubImage3DARB (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data) {
		return DYN_glCompressedTexSubImage3DARB (target,level,xoffset,yoffset,zoffset,width,height,depth,format,imageSize,data);
	}
	extern void (*DYN_glConvolutionFilter1D) (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image);
	inline void glConvolutionFilter1D (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image) {
		return DYN_glConvolutionFilter1D (target,internalformat,width,format,type,image);
	}
	extern void (*DYN_glConvolutionFilter2D) (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image);
	inline void glConvolutionFilter2D (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image) {
		return DYN_glConvolutionFilter2D (target,internalformat,width,height,format,type,image);
	}
	extern void (*DYN_glConvolutionParameterf) (GLenum target, GLenum pname, GLfloat params);
	inline void glConvolutionParameterf (GLenum target, GLenum pname, GLfloat params) {
		return DYN_glConvolutionParameterf (target,pname,params);
	}
	extern void (*DYN_glConvolutionParameterfv) (GLenum target, GLenum pname, const GLfloat *params);
	inline void glConvolutionParameterfv (GLenum target, GLenum pname, const GLfloat *params) {
		return DYN_glConvolutionParameterfv (target,pname,params);
	}
	extern void (*DYN_glConvolutionParameteri) (GLenum target, GLenum pname, GLint params);
	inline void glConvolutionParameteri (GLenum target, GLenum pname, GLint params) {
		return DYN_glConvolutionParameteri (target,pname,params);
	}
	extern void (*DYN_glConvolutionParameteriv) (GLenum target, GLenum pname, const GLint *params);
	inline void glConvolutionParameteriv (GLenum target, GLenum pname, const GLint *params) {
		return DYN_glConvolutionParameteriv (target,pname,params);
	}
	extern void (*DYN_glCopyColorSubTable) (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
	inline void glCopyColorSubTable (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) {
		return DYN_glCopyColorSubTable (target,start,x,y,width);
	}
	extern void (*DYN_glCopyColorTable) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
	inline void glCopyColorTable (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) {
		return DYN_glCopyColorTable (target,internalformat,x,y,width);
	}
	extern void (*DYN_glCopyConvolutionFilter1D) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
	inline void glCopyConvolutionFilter1D (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) {
		return DYN_glCopyConvolutionFilter1D (target,internalformat,x,y,width);
	}
	extern void (*DYN_glCopyConvolutionFilter2D) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
	inline void glCopyConvolutionFilter2D (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glCopyConvolutionFilter2D (target,internalformat,x,y,width,height);
	}
	extern void (*DYN_glCopyPixels) (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
	inline void glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type) {
		return DYN_glCopyPixels (x,y,width,height,type);
	}
	extern void (*DYN_glCopyTexImage1D) (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
	inline void glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) {
		return DYN_glCopyTexImage1D (target,level,internalformat,x,y,width,border);
	}
	extern void (*DYN_glCopyTexImage2D) (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
	inline void glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
		return DYN_glCopyTexImage2D (target,level,internalformat,x,y,width,height,border);
	}
	extern void (*DYN_glCopyTexSubImage1D) (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
	inline void glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) {
		return DYN_glCopyTexSubImage1D (target,level,xoffset,x,y,width);
	}
	extern void (*DYN_glCopyTexSubImage2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	inline void glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glCopyTexSubImage2D (target,level,xoffset,yoffset,x,y,width,height);
	}
	extern void (*DYN_glCopyTexSubImage3D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	inline void glCopyTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glCopyTexSubImage3D (target,level,xoffset,yoffset,zoffset,x,y,width,height);
	}
	extern void (*DYN_glCopyTexSubImage3DEXT) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	inline void glCopyTexSubImage3DEXT (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glCopyTexSubImage3DEXT (target,level,xoffset,yoffset,zoffset,x,y,width,height);
	}
	extern void (*DYN_glCullFace) (GLenum mode);
	inline void glCullFace (GLenum mode) {
		return DYN_glCullFace (mode);
	}
	extern void (*DYN_glDeleteBuffersARB) (GLsizei n, const GLuint *buffers);
	inline void glDeleteBuffersARB (GLsizei n, const GLuint *buffers) {
		return DYN_glDeleteBuffersARB (n,buffers);
	}
	extern void (*DYN_glDeleteFencesNV) (GLsizei n, const GLuint *fences);
	inline void glDeleteFencesNV (GLsizei n, const GLuint *fences) {
		return DYN_glDeleteFencesNV (n,fences);
	}
	extern void (*DYN_glDeleteLists) (GLuint list, GLsizei range);
	inline void glDeleteLists (GLuint list, GLsizei range) {
		return DYN_glDeleteLists (list,range);
	}
	extern void (*DYN_glDeleteOcclusionQueriesNV) (GLsizei n, const GLuint *ids);
	inline void glDeleteOcclusionQueriesNV (GLsizei n, const GLuint *ids) {
		return DYN_glDeleteOcclusionQueriesNV (n,ids);
	}
	extern void (*DYN_glDeleteProgramsARB) (GLsizei n, const GLuint *programs);
	inline void glDeleteProgramsARB (GLsizei n, const GLuint *programs) {
		return DYN_glDeleteProgramsARB (n,programs);
	}
	extern void (*DYN_glDeleteProgramsNV) (GLsizei n, const GLuint *programs);
	inline void glDeleteProgramsNV (GLsizei n, const GLuint *programs) {
		return DYN_glDeleteProgramsNV (n,programs);
	}
	extern void (*DYN_glDeleteTextures) (GLsizei n, const GLuint *textures);
	inline void glDeleteTextures (GLsizei n, const GLuint *textures) {
		return DYN_glDeleteTextures (n,textures);
	}
	extern void (*DYN_glDeleteTexturesEXT) (GLsizei n, const GLuint *textures);
	inline void glDeleteTexturesEXT (GLsizei n, const GLuint *textures) {
		return DYN_glDeleteTexturesEXT (n,textures);
	}
	extern void (*DYN_glDepthBoundsEXT) (GLclampd zmin, GLclampd zmax);
	inline void glDepthBoundsEXT (GLclampd zmin, GLclampd zmax) {
		return DYN_glDepthBoundsEXT (zmin,zmax);
	}
	extern void (*DYN_glDepthFunc) (GLenum func);
	inline void glDepthFunc (GLenum func) {
		return DYN_glDepthFunc (func);
	}
	extern void (*DYN_glDepthMask) (GLboolean flag);
	inline void glDepthMask (GLboolean flag) {
		return DYN_glDepthMask (flag);
	}
	extern void (*DYN_glDepthRange) (GLclampd zNear, GLclampd zFar);
	inline void glDepthRange (GLclampd zNear, GLclampd zFar) {
		return DYN_glDepthRange (zNear,zFar);
	}
	extern void (*DYN_glDisable) (GLenum cap);
	inline void glDisable (GLenum cap) {
		return DYN_glDisable (cap);
	}
	extern void (*DYN_glDisableClientState) (GLenum array);
	inline void glDisableClientState (GLenum array) {
		return DYN_glDisableClientState (array);
	}
	extern void (*DYN_glDisableVertexAttribArrayARB) (GLuint index);
	inline void glDisableVertexAttribArrayARB (GLuint index) {
		return DYN_glDisableVertexAttribArrayARB (index);
	}
	extern void (*DYN_glDrawArrays) (GLenum mode, GLint first, GLsizei count);
	inline void glDrawArrays (GLenum mode, GLint first, GLsizei count) {
		return DYN_glDrawArrays (mode,first,count);
	}
	extern void (*DYN_glDrawArraysEXT) (GLenum mode, GLint first, GLsizei count);
	inline void glDrawArraysEXT (GLenum mode, GLint first, GLsizei count) {
		return DYN_glDrawArraysEXT (mode,first,count);
	}
	extern void (*DYN_glDrawBuffer) (GLenum mode);
	inline void glDrawBuffer (GLenum mode) {
		return DYN_glDrawBuffer (mode);
	}
	extern void (*DYN_glDrawElements) (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
	inline void glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices) {
		return DYN_glDrawElements (mode,count,type,indices);
	}
	extern void (*DYN_glDrawMeshNV) (GLenum mode, GLsizei count, GLenum type, GLsizei stride, const GLvoid *indicesTexCoord, const GLvoid *indicesNormal, const GLvoid *indicesVertex);
	inline void glDrawMeshNV (GLenum mode, GLsizei count, GLenum type, GLsizei stride, const GLvoid *indicesTexCoord, const GLvoid *indicesNormal, const GLvoid *indicesVertex) {
		return DYN_glDrawMeshNV (mode,count,type,stride,indicesTexCoord,indicesNormal,indicesVertex);
	}
	extern void (*DYN_glDrawPixels) (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glDrawPixels (width,height,format,type,pixels);
	}
	extern void (*DYN_glDrawRangeElements) (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
	inline void glDrawRangeElements (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices) {
		return DYN_glDrawRangeElements (mode,start,end,count,type,indices);
	}
	extern void (*DYN_glDrawRangeElementsEXT) (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
	inline void glDrawRangeElementsEXT (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices) {
		return DYN_glDrawRangeElementsEXT (mode,start,end,count,type,indices);
	}
	extern void (*DYN_glEdgeFlag) (GLboolean flag);
	inline void glEdgeFlag (GLboolean flag) {
		return DYN_glEdgeFlag (flag);
	}
	extern void (*DYN_glEdgeFlagPointer) (GLsizei stride, const GLboolean *pointer);
	inline void glEdgeFlagPointer (GLsizei stride, const GLboolean *pointer) {
		return DYN_glEdgeFlagPointer (stride,pointer);
	}
	extern void (*DYN_glEdgeFlagPointerEXT) (GLsizei stride, GLsizei count, const GLboolean *pointer);
	inline void glEdgeFlagPointerEXT (GLsizei stride, GLsizei count, const GLboolean *pointer) {
		return DYN_glEdgeFlagPointerEXT (stride,count,pointer);
	}
	extern void (*DYN_glEdgeFlagv) (const GLboolean *flag);
	inline void glEdgeFlagv (const GLboolean *flag) {
		return DYN_glEdgeFlagv (flag);
	}
	extern void (*DYN_glEnable) (GLenum cap);
	inline void glEnable (GLenum cap) {
		return DYN_glEnable (cap);
	}
	extern void (*DYN_glEnableClientState) (GLenum array);
	inline void glEnableClientState (GLenum array) {
		return DYN_glEnableClientState (array);
	}
	extern void (*DYN_glEnableVertexAttribArrayARB) (GLuint index);
	inline void glEnableVertexAttribArrayARB (GLuint index) {
		return DYN_glEnableVertexAttribArrayARB (index);
	}
	extern void (*DYN_glEnd) (void);
	inline void glEnd (void) {
		return DYN_glEnd ();
	}
	extern void (*DYN_glEndList) (void);
	inline void glEndList (void) {
		return DYN_glEndList ();
	}
	extern void (*DYN_glEndOcclusionQueryNV) (void);
	inline void glEndOcclusionQueryNV (void) {
		return DYN_glEndOcclusionQueryNV ();
	}
	extern void (*DYN_glEvalCoord1d) (GLdouble u);
	inline void glEvalCoord1d (GLdouble u) {
		return DYN_glEvalCoord1d (u);
	}
	extern void (*DYN_glEvalCoord1dv) (const GLdouble *u);
	inline void glEvalCoord1dv (const GLdouble *u) {
		return DYN_glEvalCoord1dv (u);
	}
	extern void (*DYN_glEvalCoord1f) (GLfloat u);
	inline void glEvalCoord1f (GLfloat u) {
		return DYN_glEvalCoord1f (u);
	}
	extern void (*DYN_glEvalCoord1fv) (const GLfloat *u);
	inline void glEvalCoord1fv (const GLfloat *u) {
		return DYN_glEvalCoord1fv (u);
	}
	extern void (*DYN_glEvalCoord2d) (GLdouble u, GLdouble v);
	inline void glEvalCoord2d (GLdouble u, GLdouble v) {
		return DYN_glEvalCoord2d (u,v);
	}
	extern void (*DYN_glEvalCoord2dv) (const GLdouble *u);
	inline void glEvalCoord2dv (const GLdouble *u) {
		return DYN_glEvalCoord2dv (u);
	}
	extern void (*DYN_glEvalCoord2f) (GLfloat u, GLfloat v);
	inline void glEvalCoord2f (GLfloat u, GLfloat v) {
		return DYN_glEvalCoord2f (u,v);
	}
	extern void (*DYN_glEvalCoord2fv) (const GLfloat *u);
	inline void glEvalCoord2fv (const GLfloat *u) {
		return DYN_glEvalCoord2fv (u);
	}
	extern void (*DYN_glEvalMesh1) (GLenum mode, GLint i1, GLint i2);
	inline void glEvalMesh1 (GLenum mode, GLint i1, GLint i2) {
		return DYN_glEvalMesh1 (mode,i1,i2);
	}
	extern void (*DYN_glEvalMesh2) (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
	inline void glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2) {
		return DYN_glEvalMesh2 (mode,i1,i2,j1,j2);
	}
	extern void (*DYN_glEvalPoint1) (GLint i);
	inline void glEvalPoint1 (GLint i) {
		return DYN_glEvalPoint1 (i);
	}
	extern void (*DYN_glEvalPoint2) (GLint i, GLint j);
	inline void glEvalPoint2 (GLint i, GLint j) {
		return DYN_glEvalPoint2 (i,j);
	}
	extern void (*DYN_glExecuteProgramNV) (GLenum target, GLuint id, const GLfloat *params);
	inline void glExecuteProgramNV (GLenum target, GLuint id, const GLfloat *params) {
		return DYN_glExecuteProgramNV (target,id,params);
	}
	extern void (*DYN_glFeedbackBuffer) (GLsizei size, GLenum type, GLfloat *buffer);
	inline void glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer) {
		return DYN_glFeedbackBuffer (size,type,buffer);
	}
	extern void (*DYN_glFinalCombinerInputNV) (GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
	inline void glFinalCombinerInputNV (GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage) {
		return DYN_glFinalCombinerInputNV (variable,input,mapping,componentUsage);
	}
	extern void (*DYN_glFinish) (void);
	inline void glFinish (void) {
		return DYN_glFinish ();
	}
	extern void (*DYN_glFinishFenceNV) (GLuint fence);
	inline void glFinishFenceNV (GLuint fence) {
		return DYN_glFinishFenceNV (fence);
	}
	extern void (*DYN_glFlush) (void);
	inline void glFlush (void) {
		return DYN_glFlush ();
	}
	extern GLuint (*DYN_glFlushHold) (void);
	inline GLuint glFlushHold (void) {
		return DYN_glFlushHold ();
	}
	extern void (*DYN_glFlushPixelDataRangeNV) (GLenum target);
	inline void glFlushPixelDataRangeNV (GLenum target) {
		return DYN_glFlushPixelDataRangeNV (target);
	}
	extern void (*DYN_glFlushVertexArrayRangeNV) (void);
	inline void glFlushVertexArrayRangeNV (void) {
		return DYN_glFlushVertexArrayRangeNV ();
	}
	extern void (*DYN_glFogCoordPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glFogCoordPointer (GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glFogCoordPointer (type,stride,pointer);
	}
	extern void (*DYN_glFogCoordPointerEXT) (GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glFogCoordPointerEXT (GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glFogCoordPointerEXT (type,stride,pointer);
	}
	extern void (*DYN_glFogCoordd) (GLdouble fog);
	inline void glFogCoordd (GLdouble fog) {
		return DYN_glFogCoordd (fog);
	}
	extern void (*DYN_glFogCoorddEXT) (GLdouble fog);
	inline void glFogCoorddEXT (GLdouble fog) {
		return DYN_glFogCoorddEXT (fog);
	}
	extern void (*DYN_glFogCoorddv) (const GLdouble *fog);
	inline void glFogCoorddv (const GLdouble *fog) {
		return DYN_glFogCoorddv (fog);
	}
	extern void (*DYN_glFogCoorddvEXT) (const GLdouble *fog);
	inline void glFogCoorddvEXT (const GLdouble *fog) {
		return DYN_glFogCoorddvEXT (fog);
	}
	extern void (*DYN_glFogCoordf) (GLfloat fog);
	inline void glFogCoordf (GLfloat fog) {
		return DYN_glFogCoordf (fog);
	}
	extern void (*DYN_glFogCoordfEXT) (GLfloat fog);
	inline void glFogCoordfEXT (GLfloat fog) {
		return DYN_glFogCoordfEXT (fog);
	}
	extern void (*DYN_glFogCoordfv) (const GLfloat *fog);
	inline void glFogCoordfv (const GLfloat *fog) {
		return DYN_glFogCoordfv (fog);
	}
	extern void (*DYN_glFogCoordfvEXT) (const GLfloat *fog);
	inline void glFogCoordfvEXT (const GLfloat *fog) {
		return DYN_glFogCoordfvEXT (fog);
	}
	extern void (*DYN_glFogCoordhNV) (GLhalf fog);
	inline void glFogCoordhNV (GLhalf fog) {
		return DYN_glFogCoordhNV (fog);
	}
	extern void (*DYN_glFogCoordhvNV) (const GLhalf *fog);
	inline void glFogCoordhvNV (const GLhalf *fog) {
		return DYN_glFogCoordhvNV (fog);
	}
	extern void (*DYN_glFogf) (GLenum pname, GLfloat param);
	inline void glFogf (GLenum pname, GLfloat param) {
		return DYN_glFogf (pname,param);
	}
	extern void (*DYN_glFogfv) (GLenum pname, const GLfloat *params);
	inline void glFogfv (GLenum pname, const GLfloat *params) {
		return DYN_glFogfv (pname,params);
	}
	extern void (*DYN_glFogi) (GLenum pname, GLint param);
	inline void glFogi (GLenum pname, GLint param) {
		return DYN_glFogi (pname,param);
	}
	extern void (*DYN_glFogiv) (GLenum pname, const GLint *params);
	inline void glFogiv (GLenum pname, const GLint *params) {
		return DYN_glFogiv (pname,params);
	}
	extern void (*DYN_glFrontFace) (GLenum mode);
	inline void glFrontFace (GLenum mode) {
		return DYN_glFrontFace (mode);
	}
	extern void (*DYN_glFrustum) (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
	inline void glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) {
		return DYN_glFrustum (left,right,bottom,top,zNear,zFar);
	}
	extern void (*DYN_glGenBuffersARB) (GLsizei n, GLuint *buffers);
	inline void glGenBuffersARB (GLsizei n, GLuint *buffers) {
		return DYN_glGenBuffersARB (n,buffers);
	}
	extern void (*DYN_glGenFencesNV) (GLsizei n, GLuint *fences);
	inline void glGenFencesNV (GLsizei n, GLuint *fences) {
		return DYN_glGenFencesNV (n,fences);
	}
	extern GLuint (*DYN_glGenLists) (GLsizei range);
	inline GLuint glGenLists (GLsizei range) {
		return DYN_glGenLists (range);
	}
	extern void (*DYN_glGenOcclusionQueriesNV) (GLsizei n, GLuint *ids);
	inline void glGenOcclusionQueriesNV (GLsizei n, GLuint *ids) {
		return DYN_glGenOcclusionQueriesNV (n,ids);
	}
	extern void (*DYN_glGenProgramsARB) (GLsizei n, GLuint *programs);
	inline void glGenProgramsARB (GLsizei n, GLuint *programs) {
		return DYN_glGenProgramsARB (n,programs);
	}
	extern void (*DYN_glGenProgramsNV) (GLsizei n, GLuint *programs);
	inline void glGenProgramsNV (GLsizei n, GLuint *programs) {
		return DYN_glGenProgramsNV (n,programs);
	}
	extern void (*DYN_glGenTextures) (GLsizei n, GLuint *textures);
	inline void glGenTextures (GLsizei n, GLuint *textures) {
		return DYN_glGenTextures (n,textures);
	}
	extern void (*DYN_glGenTexturesEXT) (GLsizei n, GLuint *textures);
	inline void glGenTexturesEXT (GLsizei n, GLuint *textures) {
		return DYN_glGenTexturesEXT (n,textures);
	}
	extern void (*DYN_glGetBooleanv) (GLenum pname, GLboolean *params);
	inline void glGetBooleanv (GLenum pname, GLboolean *params) {
		return DYN_glGetBooleanv (pname,params);
	}
	extern void (*DYN_glGetBufferParameterivARB) (GLenum target, GLenum pname, GLint *params);
	inline void glGetBufferParameterivARB (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetBufferParameterivARB (target,pname,params);
	}
	extern void (*DYN_glGetBufferPointervARB) (GLenum target, GLenum pname, GLvoid* *params);
	inline void glGetBufferPointervARB (GLenum target, GLenum pname, GLvoid* *params) {
		return DYN_glGetBufferPointervARB (target,pname,params);
	}
	extern void (*DYN_glGetBufferSubDataARB) (GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data);
	inline void glGetBufferSubDataARB (GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data) {
		return DYN_glGetBufferSubDataARB (target,offset,size,data);
	}
	extern void (*DYN_glGetClipPlane) (GLenum plane, GLdouble *equation);
	inline void glGetClipPlane (GLenum plane, GLdouble *equation) {
		return DYN_glGetClipPlane (plane,equation);
	}
	extern void (*DYN_glGetColorTable) (GLenum target, GLenum format, GLenum type, GLvoid *table);
	inline void glGetColorTable (GLenum target, GLenum format, GLenum type, GLvoid *table) {
		return DYN_glGetColorTable (target,format,type,table);
	}
	extern void (*DYN_glGetColorTableEXT) (GLenum target, GLenum format, GLenum type, GLvoid *table);
	inline void glGetColorTableEXT (GLenum target, GLenum format, GLenum type, GLvoid *table) {
		return DYN_glGetColorTableEXT (target,format,type,table);
	}
	extern void (*DYN_glGetColorTableParameterfv) (GLenum target, GLenum pname, GLfloat *params);
	inline void glGetColorTableParameterfv (GLenum target, GLenum pname, GLfloat *params) {
		return DYN_glGetColorTableParameterfv (target,pname,params);
	}
	extern void (*DYN_glGetColorTableParameterfvEXT) (GLenum target, GLenum pname, GLfloat *params);
	inline void glGetColorTableParameterfvEXT (GLenum target, GLenum pname, GLfloat *params) {
		return DYN_glGetColorTableParameterfvEXT (target,pname,params);
	}
	extern void (*DYN_glGetColorTableParameteriv) (GLenum target, GLenum pname, GLint *params);
	inline void glGetColorTableParameteriv (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetColorTableParameteriv (target,pname,params);
	}
	extern void (*DYN_glGetColorTableParameterivEXT) (GLenum target, GLenum pname, GLint *params);
	inline void glGetColorTableParameterivEXT (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetColorTableParameterivEXT (target,pname,params);
	}
	extern void (*DYN_glGetCombinerInputParameterfvNV) (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params);
	inline void glGetCombinerInputParameterfvNV (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params) {
		return DYN_glGetCombinerInputParameterfvNV (stage,portion,variable,pname,params);
	}
	extern void (*DYN_glGetCombinerInputParameterivNV) (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params);
	inline void glGetCombinerInputParameterivNV (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params) {
		return DYN_glGetCombinerInputParameterivNV (stage,portion,variable,pname,params);
	}
	extern void (*DYN_glGetCombinerOutputParameterfvNV) (GLenum stage, GLenum portion, GLenum pname, GLfloat *params);
	inline void glGetCombinerOutputParameterfvNV (GLenum stage, GLenum portion, GLenum pname, GLfloat *params) {
		return DYN_glGetCombinerOutputParameterfvNV (stage,portion,pname,params);
	}
	extern void (*DYN_glGetCombinerOutputParameterivNV) (GLenum stage, GLenum portion, GLenum pname, GLint *params);
	inline void glGetCombinerOutputParameterivNV (GLenum stage, GLenum portion, GLenum pname, GLint *params) {
		return DYN_glGetCombinerOutputParameterivNV (stage,portion,pname,params);
	}
	extern void (*DYN_glGetCombinerStageParameterfvNV) (GLenum stage, GLenum pname, GLfloat *params);
	inline void glGetCombinerStageParameterfvNV (GLenum stage, GLenum pname, GLfloat *params) {
		return DYN_glGetCombinerStageParameterfvNV (stage,pname,params);
	}
	extern void (*DYN_glGetCompressedTexImage) (GLenum target, GLint lod, GLvoid *img);
	inline void glGetCompressedTexImage (GLenum target, GLint lod, GLvoid *img) {
		return DYN_glGetCompressedTexImage (target,lod,img);
	}
	extern void (*DYN_glGetCompressedTexImageARB) (GLenum target, GLint lod, GLvoid *img);
	inline void glGetCompressedTexImageARB (GLenum target, GLint lod, GLvoid *img) {
		return DYN_glGetCompressedTexImageARB (target,lod,img);
	}
	extern void (*DYN_glGetConvolutionFilter) (GLenum target, GLenum format, GLenum type, GLvoid *image);
	inline void glGetConvolutionFilter (GLenum target, GLenum format, GLenum type, GLvoid *image) {
		return DYN_glGetConvolutionFilter (target,format,type,image);
	}
	extern void (*DYN_glGetConvolutionParameterfv) (GLenum target, GLenum pname, GLfloat *params);
	inline void glGetConvolutionParameterfv (GLenum target, GLenum pname, GLfloat *params) {
		return DYN_glGetConvolutionParameterfv (target,pname,params);
	}
	extern void (*DYN_glGetConvolutionParameteriv) (GLenum target, GLenum pname, GLint *params);
	inline void glGetConvolutionParameteriv (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetConvolutionParameteriv (target,pname,params);
	}
	extern void (*DYN_glGetDoublev) (GLenum pname, GLdouble *params);
	inline void glGetDoublev (GLenum pname, GLdouble *params) {
		return DYN_glGetDoublev (pname,params);
	}
	extern GLenum (*DYN_glGetError) (void);
	inline GLenum glGetError (void) {
		return DYN_glGetError ();
	}
	extern void (*DYN_glGetFenceivNV) (GLuint fence, GLenum pname, GLint *params);
	inline void glGetFenceivNV (GLuint fence, GLenum pname, GLint *params) {
		return DYN_glGetFenceivNV (fence,pname,params);
	}
	extern void (*DYN_glGetFinalCombinerInputParameterfvNV) (GLenum variable, GLenum pname, GLfloat *params);
	inline void glGetFinalCombinerInputParameterfvNV (GLenum variable, GLenum pname, GLfloat *params) {
		return DYN_glGetFinalCombinerInputParameterfvNV (variable,pname,params);
	}
	extern void (*DYN_glGetFinalCombinerInputParameterivNV) (GLenum variable, GLenum pname, GLint *params);
	inline void glGetFinalCombinerInputParameterivNV (GLenum variable, GLenum pname, GLint *params) {
		return DYN_glGetFinalCombinerInputParameterivNV (variable,pname,params);
	}
	extern void (*DYN_glGetFloatv) (GLenum pname, GLfloat *params);
	inline void glGetFloatv (GLenum pname, GLfloat *params) {
		return DYN_glGetFloatv (pname,params);
	}
	extern void (*DYN_glGetHistogram) (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
	inline void glGetHistogram (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) {
		return DYN_glGetHistogram (target,reset,format,type,values);
	}
	extern void (*DYN_glGetHistogramParameterfv) (GLenum target, GLenum pname, GLfloat *params);
	inline void glGetHistogramParameterfv (GLenum target, GLenum pname, GLfloat *params) {
		return DYN_glGetHistogramParameterfv (target,pname,params);
	}
	extern void (*DYN_glGetHistogramParameteriv) (GLenum target, GLenum pname, GLint *params);
	inline void glGetHistogramParameteriv (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetHistogramParameteriv (target,pname,params);
	}
	extern void (*DYN_glGetIntegerv) (GLenum pname, GLint *params);
	inline void glGetIntegerv (GLenum pname, GLint *params) {
		return DYN_glGetIntegerv (pname,params);
	}
	extern void (*DYN_glGetLightfv) (GLenum light, GLenum pname, GLfloat *params);
	inline void glGetLightfv (GLenum light, GLenum pname, GLfloat *params) {
		return DYN_glGetLightfv (light,pname,params);
	}
	extern void (*DYN_glGetLightiv) (GLenum light, GLenum pname, GLint *params);
	inline void glGetLightiv (GLenum light, GLenum pname, GLint *params) {
		return DYN_glGetLightiv (light,pname,params);
	}
	extern void (*DYN_glGetMapdv) (GLenum target, GLenum query, GLdouble *v);
	inline void glGetMapdv (GLenum target, GLenum query, GLdouble *v) {
		return DYN_glGetMapdv (target,query,v);
	}
	extern void (*DYN_glGetMapfv) (GLenum target, GLenum query, GLfloat *v);
	inline void glGetMapfv (GLenum target, GLenum query, GLfloat *v) {
		return DYN_glGetMapfv (target,query,v);
	}
	extern void (*DYN_glGetMapiv) (GLenum target, GLenum query, GLint *v);
	inline void glGetMapiv (GLenum target, GLenum query, GLint *v) {
		return DYN_glGetMapiv (target,query,v);
	}
	extern void (*DYN_glGetMaterialfv) (GLenum face, GLenum pname, GLfloat *params);
	inline void glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params) {
		return DYN_glGetMaterialfv (face,pname,params);
	}
	extern void (*DYN_glGetMaterialiv) (GLenum face, GLenum pname, GLint *params);
	inline void glGetMaterialiv (GLenum face, GLenum pname, GLint *params) {
		return DYN_glGetMaterialiv (face,pname,params);
	}
	extern void (*DYN_glGetMinmax) (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
	inline void glGetMinmax (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) {
		return DYN_glGetMinmax (target,reset,format,type,values);
	}
	extern void (*DYN_glGetMinmaxParameterfv) (GLenum target, GLenum pname, GLfloat *params);
	inline void glGetMinmaxParameterfv (GLenum target, GLenum pname, GLfloat *params) {
		return DYN_glGetMinmaxParameterfv (target,pname,params);
	}
	extern void (*DYN_glGetMinmaxParameteriv) (GLenum target, GLenum pname, GLint *params);
	inline void glGetMinmaxParameteriv (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetMinmaxParameteriv (target,pname,params);
	}
	extern void (*DYN_glGetOcclusionQueryivNV) (GLuint id, GLenum pname, GLint *params);
	inline void glGetOcclusionQueryivNV (GLuint id, GLenum pname, GLint *params) {
		return DYN_glGetOcclusionQueryivNV (id,pname,params);
	}
	extern void (*DYN_glGetOcclusionQueryuivNV) (GLuint id, GLenum pname, GLuint *params);
	inline void glGetOcclusionQueryuivNV (GLuint id, GLenum pname, GLuint *params) {
		return DYN_glGetOcclusionQueryuivNV (id,pname,params);
	}
	extern void (*DYN_glGetPixelMapfv) (GLenum map, GLfloat *values);
	inline void glGetPixelMapfv (GLenum map, GLfloat *values) {
		return DYN_glGetPixelMapfv (map,values);
	}
	extern void (*DYN_glGetPixelMapuiv) (GLenum map, GLuint *values);
	inline void glGetPixelMapuiv (GLenum map, GLuint *values) {
		return DYN_glGetPixelMapuiv (map,values);
	}
	extern void (*DYN_glGetPixelMapusv) (GLenum map, GLushort *values);
	inline void glGetPixelMapusv (GLenum map, GLushort *values) {
		return DYN_glGetPixelMapusv (map,values);
	}
	extern void (*DYN_glGetPointerv) (GLenum pname, GLvoid* *params);
	inline void glGetPointerv (GLenum pname, GLvoid* *params) {
		return DYN_glGetPointerv (pname,params);
	}
	extern void (*DYN_glGetPointervEXT) (GLenum pname, GLvoid* *params);
	inline void glGetPointervEXT (GLenum pname, GLvoid* *params) {
		return DYN_glGetPointervEXT (pname,params);
	}
	extern void (*DYN_glGetPolygonStipple) (GLubyte *mask);
	inline void glGetPolygonStipple (GLubyte *mask) {
		return DYN_glGetPolygonStipple (mask);
	}
	extern void (*DYN_glGetProgramEnvParameterdvARB) (GLenum target, GLuint index, GLdouble *params);
	inline void glGetProgramEnvParameterdvARB (GLenum target, GLuint index, GLdouble *params) {
		return DYN_glGetProgramEnvParameterdvARB (target,index,params);
	}
	extern void (*DYN_glGetProgramEnvParameterfvARB) (GLenum target, GLuint index, GLfloat *params);
	inline void glGetProgramEnvParameterfvARB (GLenum target, GLuint index, GLfloat *params) {
		return DYN_glGetProgramEnvParameterfvARB (target,index,params);
	}
	extern void (*DYN_glGetProgramLocalParameterdvARB) (GLenum target, GLuint index, GLdouble *params);
	inline void glGetProgramLocalParameterdvARB (GLenum target, GLuint index, GLdouble *params) {
		return DYN_glGetProgramLocalParameterdvARB (target,index,params);
	}
	extern void (*DYN_glGetProgramLocalParameterfvARB) (GLenum target, GLuint index, GLfloat *params);
	inline void glGetProgramLocalParameterfvARB (GLenum target, GLuint index, GLfloat *params) {
		return DYN_glGetProgramLocalParameterfvARB (target,index,params);
	}
	extern void (*DYN_glGetProgramNamedParameterdvNV) (GLuint id, GLsizei len, const GLubyte *name, GLdouble *params);
	inline void glGetProgramNamedParameterdvNV (GLuint id, GLsizei len, const GLubyte *name, GLdouble *params) {
		return DYN_glGetProgramNamedParameterdvNV (id,len,name,params);
	}
	extern void (*DYN_glGetProgramNamedParameterfvNV) (GLuint id, GLsizei len, const GLubyte *name, GLfloat *params);
	inline void glGetProgramNamedParameterfvNV (GLuint id, GLsizei len, const GLubyte *name, GLfloat *params) {
		return DYN_glGetProgramNamedParameterfvNV (id,len,name,params);
	}
	extern void (*DYN_glGetProgramParameterdvNV) (GLenum target, GLuint index, GLenum pname, GLdouble *params);
	inline void glGetProgramParameterdvNV (GLenum target, GLuint index, GLenum pname, GLdouble *params) {
		return DYN_glGetProgramParameterdvNV (target,index,pname,params);
	}
	extern void (*DYN_glGetProgramParameterfvNV) (GLenum target, GLuint index, GLenum pname, GLfloat *params);
	inline void glGetProgramParameterfvNV (GLenum target, GLuint index, GLenum pname, GLfloat *params) {
		return DYN_glGetProgramParameterfvNV (target,index,pname,params);
	}
	extern void (*DYN_glGetProgramStringARB) (GLenum target, GLenum pname, GLvoid *string);
	inline void glGetProgramStringARB (GLenum target, GLenum pname, GLvoid *string) {
		return DYN_glGetProgramStringARB (target,pname,string);
	}
	extern void (*DYN_glGetProgramStringNV) (GLuint id, GLenum pname, GLubyte *program);
	inline void glGetProgramStringNV (GLuint id, GLenum pname, GLubyte *program) {
		return DYN_glGetProgramStringNV (id,pname,program);
	}
	extern void (*DYN_glGetProgramivARB) (GLenum target, GLenum pname, GLint *params);
	inline void glGetProgramivARB (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetProgramivARB (target,pname,params);
	}
	extern void (*DYN_glGetProgramivNV) (GLuint id, GLenum pname, GLint *params);
	inline void glGetProgramivNV (GLuint id, GLenum pname, GLint *params) {
		return DYN_glGetProgramivNV (id,pname,params);
	}
	extern void (*DYN_glGetSeparableFilter) (GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span);
	inline void glGetSeparableFilter (GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span) {
		return DYN_glGetSeparableFilter (target,format,type,row,column,span);
	}
	extern const GLubyte * (*DYN_glGetString) (GLenum name);
	inline const GLubyte * glGetString (GLenum name) {
		return DYN_glGetString (name);
	}
	extern void (*DYN_glGetTexEnvfv) (GLenum target, GLenum pname, GLfloat *params);
	inline void glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params) {
		return DYN_glGetTexEnvfv (target,pname,params);
	}
	extern void (*DYN_glGetTexEnviv) (GLenum target, GLenum pname, GLint *params);
	inline void glGetTexEnviv (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetTexEnviv (target,pname,params);
	}
	extern void (*DYN_glGetTexGendv) (GLenum coord, GLenum pname, GLdouble *params);
	inline void glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params) {
		return DYN_glGetTexGendv (coord,pname,params);
	}
	extern void (*DYN_glGetTexGenfv) (GLenum coord, GLenum pname, GLfloat *params);
	inline void glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params) {
		return DYN_glGetTexGenfv (coord,pname,params);
	}
	extern void (*DYN_glGetTexGeniv) (GLenum coord, GLenum pname, GLint *params);
	inline void glGetTexGeniv (GLenum coord, GLenum pname, GLint *params) {
		return DYN_glGetTexGeniv (coord,pname,params);
	}
	extern void (*DYN_glGetTexImage) (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
	inline void glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels) {
		return DYN_glGetTexImage (target,level,format,type,pixels);
	}
	extern void (*DYN_glGetTexLevelParameterfv) (GLenum target, GLint level, GLenum pname, GLfloat *params);
	inline void glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params) {
		return DYN_glGetTexLevelParameterfv (target,level,pname,params);
	}
	extern void (*DYN_glGetTexLevelParameteriv) (GLenum target, GLint level, GLenum pname, GLint *params);
	inline void glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params) {
		return DYN_glGetTexLevelParameteriv (target,level,pname,params);
	}
	extern void (*DYN_glGetTexParameterfv) (GLenum target, GLenum pname, GLfloat *params);
	inline void glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params) {
		return DYN_glGetTexParameterfv (target,pname,params);
	}
	extern void (*DYN_glGetTexParameteriv) (GLenum target, GLenum pname, GLint *params);
	inline void glGetTexParameteriv (GLenum target, GLenum pname, GLint *params) {
		return DYN_glGetTexParameteriv (target,pname,params);
	}
	extern void (*DYN_glGetTrackMatrixivNV) (GLenum target, GLuint address, GLenum pname, GLint *params);
	inline void glGetTrackMatrixivNV (GLenum target, GLuint address, GLenum pname, GLint *params) {
		return DYN_glGetTrackMatrixivNV (target,address,pname,params);
	}
	extern void (*DYN_glGetVertexAttribPointervARB) (GLuint index, GLenum pname, GLvoid* *pointer);
	inline void glGetVertexAttribPointervARB (GLuint index, GLenum pname, GLvoid* *pointer) {
		return DYN_glGetVertexAttribPointervARB (index,pname,pointer);
	}
	extern void (*DYN_glGetVertexAttribPointervNV) (GLuint index, GLenum pname, GLvoid* *pointer);
	inline void glGetVertexAttribPointervNV (GLuint index, GLenum pname, GLvoid* *pointer) {
		return DYN_glGetVertexAttribPointervNV (index,pname,pointer);
	}
	extern void (*DYN_glGetVertexAttribdvARB) (GLuint index, GLenum pname, GLdouble *params);
	inline void glGetVertexAttribdvARB (GLuint index, GLenum pname, GLdouble *params) {
		return DYN_glGetVertexAttribdvARB (index,pname,params);
	}
	extern void (*DYN_glGetVertexAttribdvNV) (GLuint index, GLenum pname, GLdouble *params);
	inline void glGetVertexAttribdvNV (GLuint index, GLenum pname, GLdouble *params) {
		return DYN_glGetVertexAttribdvNV (index,pname,params);
	}
	extern void (*DYN_glGetVertexAttribfvARB) (GLuint index, GLenum pname, GLfloat *params);
	inline void glGetVertexAttribfvARB (GLuint index, GLenum pname, GLfloat *params) {
		return DYN_glGetVertexAttribfvARB (index,pname,params);
	}
	extern void (*DYN_glGetVertexAttribfvNV) (GLuint index, GLenum pname, GLfloat *params);
	inline void glGetVertexAttribfvNV (GLuint index, GLenum pname, GLfloat *params) {
		return DYN_glGetVertexAttribfvNV (index,pname,params);
	}
	extern void (*DYN_glGetVertexAttribivARB) (GLuint index, GLenum pname, GLint *params);
	inline void glGetVertexAttribivARB (GLuint index, GLenum pname, GLint *params) {
		return DYN_glGetVertexAttribivARB (index,pname,params);
	}
	extern void (*DYN_glGetVertexAttribivNV) (GLuint index, GLenum pname, GLint *params);
	inline void glGetVertexAttribivNV (GLuint index, GLenum pname, GLint *params) {
		return DYN_glGetVertexAttribivNV (index,pname,params);
	}
	extern void (*DYN_glHint) (GLenum target, GLenum mode);
	inline void glHint (GLenum target, GLenum mode) {
		return DYN_glHint (target,mode);
	}
	extern void (*DYN_glHistogram) (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
	inline void glHistogram (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) {
		return DYN_glHistogram (target,width,internalformat,sink);
	}
	extern void (*DYN_glIndexMask) (GLuint mask);
	inline void glIndexMask (GLuint mask) {
		return DYN_glIndexMask (mask);
	}
	extern void (*DYN_glIndexPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glIndexPointer (type,stride,pointer);
	}
	extern void (*DYN_glIndexPointerEXT) (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
	inline void glIndexPointerEXT (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer) {
		return DYN_glIndexPointerEXT (type,stride,count,pointer);
	}
	extern void (*DYN_glIndexd) (GLdouble c);
	inline void glIndexd (GLdouble c) {
		return DYN_glIndexd (c);
	}
	extern void (*DYN_glIndexdv) (const GLdouble *c);
	inline void glIndexdv (const GLdouble *c) {
		return DYN_glIndexdv (c);
	}
	extern void (*DYN_glIndexf) (GLfloat c);
	inline void glIndexf (GLfloat c) {
		return DYN_glIndexf (c);
	}
	extern void (*DYN_glIndexfv) (const GLfloat *c);
	inline void glIndexfv (const GLfloat *c) {
		return DYN_glIndexfv (c);
	}
	extern void (*DYN_glIndexi) (GLint c);
	inline void glIndexi (GLint c) {
		return DYN_glIndexi (c);
	}
	extern void (*DYN_glIndexiv) (const GLint *c);
	inline void glIndexiv (const GLint *c) {
		return DYN_glIndexiv (c);
	}
	extern void (*DYN_glIndexs) (GLshort c);
	inline void glIndexs (GLshort c) {
		return DYN_glIndexs (c);
	}
	extern void (*DYN_glIndexsv) (const GLshort *c);
	inline void glIndexsv (const GLshort *c) {
		return DYN_glIndexsv (c);
	}
	extern void (*DYN_glIndexub) (GLubyte c);
	inline void glIndexub (GLubyte c) {
		return DYN_glIndexub (c);
	}
	extern void (*DYN_glIndexubv) (const GLubyte *c);
	inline void glIndexubv (const GLubyte *c) {
		return DYN_glIndexubv (c);
	}
	extern void (*DYN_glInitNames) (void);
	inline void glInitNames (void) {
		return DYN_glInitNames ();
	}
	extern void (*DYN_glInterleavedArrays) (GLenum format, GLsizei stride, const GLvoid *pointer);
	inline void glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer) {
		return DYN_glInterleavedArrays (format,stride,pointer);
	}
	extern GLboolean (*DYN_glIsBufferARB) (GLuint buffer);
	inline GLboolean glIsBufferARB (GLuint buffer) {
		return DYN_glIsBufferARB (buffer);
	}
	extern GLboolean (*DYN_glIsEnabled) (GLenum cap);
	inline GLboolean glIsEnabled (GLenum cap) {
		return DYN_glIsEnabled (cap);
	}
	extern GLboolean (*DYN_glIsFenceNV) (GLuint fence);
	inline GLboolean glIsFenceNV (GLuint fence) {
		return DYN_glIsFenceNV (fence);
	}
	extern GLboolean (*DYN_glIsList) (GLuint list);
	inline GLboolean glIsList (GLuint list) {
		return DYN_glIsList (list);
	}
	extern GLboolean (*DYN_glIsOcclusionQueryNV) (GLuint id);
	inline GLboolean glIsOcclusionQueryNV (GLuint id) {
		return DYN_glIsOcclusionQueryNV (id);
	}
	extern GLboolean (*DYN_glIsProgramARB) (GLuint program);
	inline GLboolean glIsProgramARB (GLuint program) {
		return DYN_glIsProgramARB (program);
	}
	extern GLboolean (*DYN_glIsProgramNV) (GLuint id);
	inline GLboolean glIsProgramNV (GLuint id) {
		return DYN_glIsProgramNV (id);
	}
	extern GLboolean (*DYN_glIsTexture) (GLuint texture);
	inline GLboolean glIsTexture (GLuint texture) {
		return DYN_glIsTexture (texture);
	}
	extern GLboolean (*DYN_glIsTextureEXT) (GLuint texture);
	inline GLboolean glIsTextureEXT (GLuint texture) {
		return DYN_glIsTextureEXT (texture);
	}
	extern void (*DYN_glLightModelf) (GLenum pname, GLfloat param);
	inline void glLightModelf (GLenum pname, GLfloat param) {
		return DYN_glLightModelf (pname,param);
	}
	extern void (*DYN_glLightModelfv) (GLenum pname, const GLfloat *params);
	inline void glLightModelfv (GLenum pname, const GLfloat *params) {
		return DYN_glLightModelfv (pname,params);
	}
	extern void (*DYN_glLightModeli) (GLenum pname, GLint param);
	inline void glLightModeli (GLenum pname, GLint param) {
		return DYN_glLightModeli (pname,param);
	}
	extern void (*DYN_glLightModeliv) (GLenum pname, const GLint *params);
	inline void glLightModeliv (GLenum pname, const GLint *params) {
		return DYN_glLightModeliv (pname,params);
	}
	extern void (*DYN_glLightf) (GLenum light, GLenum pname, GLfloat param);
	inline void glLightf (GLenum light, GLenum pname, GLfloat param) {
		return DYN_glLightf (light,pname,param);
	}
	extern void (*DYN_glLightfv) (GLenum light, GLenum pname, const GLfloat *params);
	inline void glLightfv (GLenum light, GLenum pname, const GLfloat *params) {
		return DYN_glLightfv (light,pname,params);
	}
	extern void (*DYN_glLighti) (GLenum light, GLenum pname, GLint param);
	inline void glLighti (GLenum light, GLenum pname, GLint param) {
		return DYN_glLighti (light,pname,param);
	}
	extern void (*DYN_glLightiv) (GLenum light, GLenum pname, const GLint *params);
	inline void glLightiv (GLenum light, GLenum pname, const GLint *params) {
		return DYN_glLightiv (light,pname,params);
	}
	extern void (*DYN_glLineStipple) (GLint factor, GLushort pattern);
	inline void glLineStipple (GLint factor, GLushort pattern) {
		return DYN_glLineStipple (factor,pattern);
	}
	extern void (*DYN_glLineWidth) (GLfloat width);
	inline void glLineWidth (GLfloat width) {
		return DYN_glLineWidth (width);
	}
	extern void (*DYN_glListBase) (GLuint base);
	inline void glListBase (GLuint base) {
		return DYN_glListBase (base);
	}
	extern void (*DYN_glLoadIdentity) (void);
	inline void glLoadIdentity (void) {
		return DYN_glLoadIdentity ();
	}
	extern void (*DYN_glLoadMatrixd) (const GLdouble *m);
	inline void glLoadMatrixd (const GLdouble *m) {
		return DYN_glLoadMatrixd (m);
	}
	extern void (*DYN_glLoadMatrixf) (const GLfloat *m);
	inline void glLoadMatrixf (const GLfloat *m) {
		return DYN_glLoadMatrixf (m);
	}
	extern void (*DYN_glLoadName) (GLuint name);
	inline void glLoadName (GLuint name) {
		return DYN_glLoadName (name);
	}
	extern void (*DYN_glLoadProgramNV) (GLenum target, GLuint id, GLsizei len, const GLubyte *program);
	inline void glLoadProgramNV (GLenum target, GLuint id, GLsizei len, const GLubyte *program) {
		return DYN_glLoadProgramNV (target,id,len,program);
	}
	extern void (*DYN_glLoadTransposeMatrixd) (const GLdouble *m);
	inline void glLoadTransposeMatrixd (const GLdouble *m) {
		return DYN_glLoadTransposeMatrixd (m);
	}
	extern void (*DYN_glLoadTransposeMatrixdARB) (const GLdouble *m);
	inline void glLoadTransposeMatrixdARB (const GLdouble *m) {
		return DYN_glLoadTransposeMatrixdARB (m);
	}
	extern void (*DYN_glLoadTransposeMatrixf) (const GLfloat *m);
	inline void glLoadTransposeMatrixf (const GLfloat *m) {
		return DYN_glLoadTransposeMatrixf (m);
	}
	extern void (*DYN_glLoadTransposeMatrixfARB) (const GLfloat *m);
	inline void glLoadTransposeMatrixfARB (const GLfloat *m) {
		return DYN_glLoadTransposeMatrixfARB (m);
	}
	extern void (*DYN_glLockArraysEXT) (GLint first, GLsizei count);
	inline void glLockArraysEXT (GLint first, GLsizei count) {
		return DYN_glLockArraysEXT (first,count);
	}
	extern void (*DYN_glLogicOp) (GLenum opcode);
	inline void glLogicOp (GLenum opcode) {
		return DYN_glLogicOp (opcode);
	}
	extern void (*DYN_glMap1d) (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
	inline void glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points) {
		return DYN_glMap1d (target,u1,u2,stride,order,points);
	}
	extern void (*DYN_glMap1f) (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
	inline void glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points) {
		return DYN_glMap1f (target,u1,u2,stride,order,points);
	}
	extern void (*DYN_glMap2d) (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
	inline void glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points) {
		return DYN_glMap2d (target,u1,u2,ustride,uorder,v1,v2,vstride,vorder,points);
	}
	extern void (*DYN_glMap2f) (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
	inline void glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points) {
		return DYN_glMap2f (target,u1,u2,ustride,uorder,v1,v2,vstride,vorder,points);
	}
	extern GLvoid* (*DYN_glMapBufferARB) (GLenum target, GLenum access);
	inline GLvoid* glMapBufferARB (GLenum target, GLenum access) {
		return DYN_glMapBufferARB (target,access);
	}
	extern void (*DYN_glMapGrid1d) (GLint un, GLdouble u1, GLdouble u2);
	inline void glMapGrid1d (GLint un, GLdouble u1, GLdouble u2) {
		return DYN_glMapGrid1d (un,u1,u2);
	}
	extern void (*DYN_glMapGrid1f) (GLint un, GLfloat u1, GLfloat u2);
	inline void glMapGrid1f (GLint un, GLfloat u1, GLfloat u2) {
		return DYN_glMapGrid1f (un,u1,u2);
	}
	extern void (*DYN_glMapGrid2d) (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
	inline void glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2) {
		return DYN_glMapGrid2d (un,u1,u2,vn,v1,v2);
	}
	extern void (*DYN_glMapGrid2f) (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
	inline void glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2) {
		return DYN_glMapGrid2f (un,u1,u2,vn,v1,v2);
	}
	extern void (*DYN_glMaterialf) (GLenum face, GLenum pname, GLfloat param);
	inline void glMaterialf (GLenum face, GLenum pname, GLfloat param) {
		return DYN_glMaterialf (face,pname,param);
	}
	extern void (*DYN_glMaterialfv) (GLenum face, GLenum pname, const GLfloat *params);
	inline void glMaterialfv (GLenum face, GLenum pname, const GLfloat *params) {
		return DYN_glMaterialfv (face,pname,params);
	}
	extern void (*DYN_glMateriali) (GLenum face, GLenum pname, GLint param);
	inline void glMateriali (GLenum face, GLenum pname, GLint param) {
		return DYN_glMateriali (face,pname,param);
	}
	extern void (*DYN_glMaterialiv) (GLenum face, GLenum pname, const GLint *params);
	inline void glMaterialiv (GLenum face, GLenum pname, const GLint *params) {
		return DYN_glMaterialiv (face,pname,params);
	}
	extern void (*DYN_glMatrixMode) (GLenum mode);
	inline void glMatrixMode (GLenum mode) {
		return DYN_glMatrixMode (mode);
	}
	extern void (*DYN_glMinmax) (GLenum target, GLenum internalformat, GLboolean sink);
	inline void glMinmax (GLenum target, GLenum internalformat, GLboolean sink) {
		return DYN_glMinmax (target,internalformat,sink);
	}
	extern void (*DYN_glMultMatrixd) (const GLdouble *m);
	inline void glMultMatrixd (const GLdouble *m) {
		return DYN_glMultMatrixd (m);
	}
	extern void (*DYN_glMultMatrixf) (const GLfloat *m);
	inline void glMultMatrixf (const GLfloat *m) {
		return DYN_glMultMatrixf (m);
	}
	extern void (*DYN_glMultTransposeMatrixd) (const GLdouble *m);
	inline void glMultTransposeMatrixd (const GLdouble *m) {
		return DYN_glMultTransposeMatrixd (m);
	}
	extern void (*DYN_glMultTransposeMatrixdARB) (const GLdouble *m);
	inline void glMultTransposeMatrixdARB (const GLdouble *m) {
		return DYN_glMultTransposeMatrixdARB (m);
	}
	extern void (*DYN_glMultTransposeMatrixf) (const GLfloat *m);
	inline void glMultTransposeMatrixf (const GLfloat *m) {
		return DYN_glMultTransposeMatrixf (m);
	}
	extern void (*DYN_glMultTransposeMatrixfARB) (const GLfloat *m);
	inline void glMultTransposeMatrixfARB (const GLfloat *m) {
		return DYN_glMultTransposeMatrixfARB (m);
	}
	extern void (*DYN_glMultiDrawArrays) (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount);
	inline void glMultiDrawArrays (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount) {
		return DYN_glMultiDrawArrays (mode,first,count,primcount);
	}
	extern void (*DYN_glMultiDrawArraysEXT) (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount);
	inline void glMultiDrawArraysEXT (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount) {
		return DYN_glMultiDrawArraysEXT (mode,first,count,primcount);
	}
	extern void (*DYN_glMultiDrawElements) (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount);
	inline void glMultiDrawElements (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount) {
		return DYN_glMultiDrawElements (mode,count,type,indices,primcount);
	}
	extern void (*DYN_glMultiDrawElementsEXT) (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount);
	inline void glMultiDrawElementsEXT (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount) {
		return DYN_glMultiDrawElementsEXT (mode,count,type,indices,primcount);
	}
	extern void (*DYN_glMultiTexCoord1d) (GLenum target, GLdouble s);
	inline void glMultiTexCoord1d (GLenum target, GLdouble s) {
		return DYN_glMultiTexCoord1d (target,s);
	}
	extern void (*DYN_glMultiTexCoord1dARB) (GLenum target, GLdouble s);
	inline void glMultiTexCoord1dARB (GLenum target, GLdouble s) {
		return DYN_glMultiTexCoord1dARB (target,s);
	}
	extern void (*DYN_glMultiTexCoord1dSGIS) (GLenum target, GLdouble s);
	inline void glMultiTexCoord1dSGIS (GLenum target, GLdouble s) {
		return DYN_glMultiTexCoord1dSGIS (target,s);
	}
	extern void (*DYN_glMultiTexCoord1dv) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord1dv (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord1dv (target,v);
	}
	extern void (*DYN_glMultiTexCoord1dvARB) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord1dvARB (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord1dvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord1dvSGIS) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord1dvSGIS (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord1dvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord1f) (GLenum target, GLfloat s);
	inline void glMultiTexCoord1f (GLenum target, GLfloat s) {
		return DYN_glMultiTexCoord1f (target,s);
	}
	extern void (*DYN_glMultiTexCoord1fARB) (GLenum target, GLfloat s);
	inline void glMultiTexCoord1fARB (GLenum target, GLfloat s) {
		return DYN_glMultiTexCoord1fARB (target,s);
	}
	extern void (*DYN_glMultiTexCoord1fSGIS) (GLenum target, GLfloat s);
	inline void glMultiTexCoord1fSGIS (GLenum target, GLfloat s) {
		return DYN_glMultiTexCoord1fSGIS (target,s);
	}
	extern void (*DYN_glMultiTexCoord1fv) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord1fv (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord1fv (target,v);
	}
	extern void (*DYN_glMultiTexCoord1fvARB) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord1fvARB (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord1fvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord1fvSGIS) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord1fvSGIS (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord1fvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord1hNV) (GLenum target, GLhalf s);
	inline void glMultiTexCoord1hNV (GLenum target, GLhalf s) {
		return DYN_glMultiTexCoord1hNV (target,s);
	}
	extern void (*DYN_glMultiTexCoord1hvNV) (GLenum target, const GLhalf *v);
	inline void glMultiTexCoord1hvNV (GLenum target, const GLhalf *v) {
		return DYN_glMultiTexCoord1hvNV (target,v);
	}
	extern void (*DYN_glMultiTexCoord1i) (GLenum target, GLint s);
	inline void glMultiTexCoord1i (GLenum target, GLint s) {
		return DYN_glMultiTexCoord1i (target,s);
	}
	extern void (*DYN_glMultiTexCoord1iARB) (GLenum target, GLint s);
	inline void glMultiTexCoord1iARB (GLenum target, GLint s) {
		return DYN_glMultiTexCoord1iARB (target,s);
	}
	extern void (*DYN_glMultiTexCoord1iSGIS) (GLenum target, GLint s);
	inline void glMultiTexCoord1iSGIS (GLenum target, GLint s) {
		return DYN_glMultiTexCoord1iSGIS (target,s);
	}
	extern void (*DYN_glMultiTexCoord1iv) (GLenum target, const GLint *v);
	inline void glMultiTexCoord1iv (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord1iv (target,v);
	}
	extern void (*DYN_glMultiTexCoord1ivARB) (GLenum target, const GLint *v);
	inline void glMultiTexCoord1ivARB (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord1ivARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord1ivSGIS) (GLenum target, const GLint *v);
	inline void glMultiTexCoord1ivSGIS (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord1ivSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord1s) (GLenum target, GLshort s);
	inline void glMultiTexCoord1s (GLenum target, GLshort s) {
		return DYN_glMultiTexCoord1s (target,s);
	}
	extern void (*DYN_glMultiTexCoord1sARB) (GLenum target, GLshort s);
	inline void glMultiTexCoord1sARB (GLenum target, GLshort s) {
		return DYN_glMultiTexCoord1sARB (target,s);
	}
	extern void (*DYN_glMultiTexCoord1sSGIS) (GLenum target, GLshort s);
	inline void glMultiTexCoord1sSGIS (GLenum target, GLshort s) {
		return DYN_glMultiTexCoord1sSGIS (target,s);
	}
	extern void (*DYN_glMultiTexCoord1sv) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord1sv (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord1sv (target,v);
	}
	extern void (*DYN_glMultiTexCoord1svARB) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord1svARB (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord1svARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord1svSGIS) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord1svSGIS (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord1svSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord2d) (GLenum target, GLdouble s, GLdouble t);
	inline void glMultiTexCoord2d (GLenum target, GLdouble s, GLdouble t) {
		return DYN_glMultiTexCoord2d (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2dARB) (GLenum target, GLdouble s, GLdouble t);
	inline void glMultiTexCoord2dARB (GLenum target, GLdouble s, GLdouble t) {
		return DYN_glMultiTexCoord2dARB (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2dSGIS) (GLenum target, GLdouble s, GLdouble t);
	inline void glMultiTexCoord2dSGIS (GLenum target, GLdouble s, GLdouble t) {
		return DYN_glMultiTexCoord2dSGIS (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2dv) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord2dv (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord2dv (target,v);
	}
	extern void (*DYN_glMultiTexCoord2dvARB) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord2dvARB (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord2dvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord2dvSGIS) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord2dvSGIS (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord2dvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord2f) (GLenum target, GLfloat s, GLfloat t);
	inline void glMultiTexCoord2f (GLenum target, GLfloat s, GLfloat t) {
		return DYN_glMultiTexCoord2f (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2fARB) (GLenum target, GLfloat s, GLfloat t);
	inline void glMultiTexCoord2fARB (GLenum target, GLfloat s, GLfloat t) {
		return DYN_glMultiTexCoord2fARB (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2fSGIS) (GLenum target, GLfloat s, GLfloat t);
	inline void glMultiTexCoord2fSGIS (GLenum target, GLfloat s, GLfloat t) {
		return DYN_glMultiTexCoord2fSGIS (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2fv) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord2fv (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord2fv (target,v);
	}
	extern void (*DYN_glMultiTexCoord2fvARB) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord2fvARB (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord2fvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord2fvSGIS) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord2fvSGIS (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord2fvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord2hNV) (GLenum target, GLhalf s, GLhalf t);
	inline void glMultiTexCoord2hNV (GLenum target, GLhalf s, GLhalf t) {
		return DYN_glMultiTexCoord2hNV (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2hvNV) (GLenum target, const GLhalf *v);
	inline void glMultiTexCoord2hvNV (GLenum target, const GLhalf *v) {
		return DYN_glMultiTexCoord2hvNV (target,v);
	}
	extern void (*DYN_glMultiTexCoord2i) (GLenum target, GLint s, GLint t);
	inline void glMultiTexCoord2i (GLenum target, GLint s, GLint t) {
		return DYN_glMultiTexCoord2i (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2iARB) (GLenum target, GLint s, GLint t);
	inline void glMultiTexCoord2iARB (GLenum target, GLint s, GLint t) {
		return DYN_glMultiTexCoord2iARB (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2iSGIS) (GLenum target, GLint s, GLint t);
	inline void glMultiTexCoord2iSGIS (GLenum target, GLint s, GLint t) {
		return DYN_glMultiTexCoord2iSGIS (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2iv) (GLenum target, const GLint *v);
	inline void glMultiTexCoord2iv (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord2iv (target,v);
	}
	extern void (*DYN_glMultiTexCoord2ivARB) (GLenum target, const GLint *v);
	inline void glMultiTexCoord2ivARB (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord2ivARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord2ivSGIS) (GLenum target, const GLint *v);
	inline void glMultiTexCoord2ivSGIS (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord2ivSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord2s) (GLenum target, GLshort s, GLshort t);
	inline void glMultiTexCoord2s (GLenum target, GLshort s, GLshort t) {
		return DYN_glMultiTexCoord2s (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2sARB) (GLenum target, GLshort s, GLshort t);
	inline void glMultiTexCoord2sARB (GLenum target, GLshort s, GLshort t) {
		return DYN_glMultiTexCoord2sARB (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2sSGIS) (GLenum target, GLshort s, GLshort t);
	inline void glMultiTexCoord2sSGIS (GLenum target, GLshort s, GLshort t) {
		return DYN_glMultiTexCoord2sSGIS (target,s,t);
	}
	extern void (*DYN_glMultiTexCoord2sv) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord2sv (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord2sv (target,v);
	}
	extern void (*DYN_glMultiTexCoord2svARB) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord2svARB (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord2svARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord2svSGIS) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord2svSGIS (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord2svSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord3d) (GLenum target, GLdouble s, GLdouble t, GLdouble r);
	inline void glMultiTexCoord3d (GLenum target, GLdouble s, GLdouble t, GLdouble r) {
		return DYN_glMultiTexCoord3d (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3dARB) (GLenum target, GLdouble s, GLdouble t, GLdouble r);
	inline void glMultiTexCoord3dARB (GLenum target, GLdouble s, GLdouble t, GLdouble r) {
		return DYN_glMultiTexCoord3dARB (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3dSGIS) (GLenum target, GLdouble s, GLdouble t, GLdouble r);
	inline void glMultiTexCoord3dSGIS (GLenum target, GLdouble s, GLdouble t, GLdouble r) {
		return DYN_glMultiTexCoord3dSGIS (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3dv) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord3dv (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord3dv (target,v);
	}
	extern void (*DYN_glMultiTexCoord3dvARB) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord3dvARB (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord3dvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord3dvSGIS) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord3dvSGIS (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord3dvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord3f) (GLenum target, GLfloat s, GLfloat t, GLfloat r);
	inline void glMultiTexCoord3f (GLenum target, GLfloat s, GLfloat t, GLfloat r) {
		return DYN_glMultiTexCoord3f (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3fARB) (GLenum target, GLfloat s, GLfloat t, GLfloat r);
	inline void glMultiTexCoord3fARB (GLenum target, GLfloat s, GLfloat t, GLfloat r) {
		return DYN_glMultiTexCoord3fARB (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3fSGIS) (GLenum target, GLfloat s, GLfloat t, GLfloat r);
	inline void glMultiTexCoord3fSGIS (GLenum target, GLfloat s, GLfloat t, GLfloat r) {
		return DYN_glMultiTexCoord3fSGIS (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3fv) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord3fv (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord3fv (target,v);
	}
	extern void (*DYN_glMultiTexCoord3fvARB) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord3fvARB (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord3fvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord3fvSGIS) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord3fvSGIS (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord3fvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord3hNV) (GLenum target, GLhalf s, GLhalf t, GLhalf r);
	inline void glMultiTexCoord3hNV (GLenum target, GLhalf s, GLhalf t, GLhalf r) {
		return DYN_glMultiTexCoord3hNV (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3hvNV) (GLenum target, const GLhalf *v);
	inline void glMultiTexCoord3hvNV (GLenum target, const GLhalf *v) {
		return DYN_glMultiTexCoord3hvNV (target,v);
	}
	extern void (*DYN_glMultiTexCoord3i) (GLenum target, GLint s, GLint t, GLint r);
	inline void glMultiTexCoord3i (GLenum target, GLint s, GLint t, GLint r) {
		return DYN_glMultiTexCoord3i (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3iARB) (GLenum target, GLint s, GLint t, GLint r);
	inline void glMultiTexCoord3iARB (GLenum target, GLint s, GLint t, GLint r) {
		return DYN_glMultiTexCoord3iARB (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3iSGIS) (GLenum target, GLint s, GLint t, GLint r);
	inline void glMultiTexCoord3iSGIS (GLenum target, GLint s, GLint t, GLint r) {
		return DYN_glMultiTexCoord3iSGIS (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3iv) (GLenum target, const GLint *v);
	inline void glMultiTexCoord3iv (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord3iv (target,v);
	}
	extern void (*DYN_glMultiTexCoord3ivARB) (GLenum target, const GLint *v);
	inline void glMultiTexCoord3ivARB (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord3ivARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord3ivSGIS) (GLenum target, const GLint *v);
	inline void glMultiTexCoord3ivSGIS (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord3ivSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord3s) (GLenum target, GLshort s, GLshort t, GLshort r);
	inline void glMultiTexCoord3s (GLenum target, GLshort s, GLshort t, GLshort r) {
		return DYN_glMultiTexCoord3s (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3sARB) (GLenum target, GLshort s, GLshort t, GLshort r);
	inline void glMultiTexCoord3sARB (GLenum target, GLshort s, GLshort t, GLshort r) {
		return DYN_glMultiTexCoord3sARB (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3sSGIS) (GLenum target, GLshort s, GLshort t, GLshort r);
	inline void glMultiTexCoord3sSGIS (GLenum target, GLshort s, GLshort t, GLshort r) {
		return DYN_glMultiTexCoord3sSGIS (target,s,t,r);
	}
	extern void (*DYN_glMultiTexCoord3sv) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord3sv (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord3sv (target,v);
	}
	extern void (*DYN_glMultiTexCoord3svARB) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord3svARB (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord3svARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord3svSGIS) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord3svSGIS (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord3svSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord4d) (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
	inline void glMultiTexCoord4d (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
		return DYN_glMultiTexCoord4d (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4dARB) (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
	inline void glMultiTexCoord4dARB (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
		return DYN_glMultiTexCoord4dARB (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4dSGIS) (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
	inline void glMultiTexCoord4dSGIS (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
		return DYN_glMultiTexCoord4dSGIS (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4dv) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord4dv (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord4dv (target,v);
	}
	extern void (*DYN_glMultiTexCoord4dvARB) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord4dvARB (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord4dvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord4dvSGIS) (GLenum target, const GLdouble *v);
	inline void glMultiTexCoord4dvSGIS (GLenum target, const GLdouble *v) {
		return DYN_glMultiTexCoord4dvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord4f) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
	inline void glMultiTexCoord4f (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
		return DYN_glMultiTexCoord4f (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4fARB) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
	inline void glMultiTexCoord4fARB (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
		return DYN_glMultiTexCoord4fARB (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4fSGIS) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
	inline void glMultiTexCoord4fSGIS (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
		return DYN_glMultiTexCoord4fSGIS (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4fv) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord4fv (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord4fv (target,v);
	}
	extern void (*DYN_glMultiTexCoord4fvARB) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord4fvARB (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord4fvARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord4fvSGIS) (GLenum target, const GLfloat *v);
	inline void glMultiTexCoord4fvSGIS (GLenum target, const GLfloat *v) {
		return DYN_glMultiTexCoord4fvSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord4hNV) (GLenum target, GLhalf s, GLhalf t, GLhalf r, GLhalf q);
	inline void glMultiTexCoord4hNV (GLenum target, GLhalf s, GLhalf t, GLhalf r, GLhalf q) {
		return DYN_glMultiTexCoord4hNV (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4hvNV) (GLenum target, const GLhalf *v);
	inline void glMultiTexCoord4hvNV (GLenum target, const GLhalf *v) {
		return DYN_glMultiTexCoord4hvNV (target,v);
	}
	extern void (*DYN_glMultiTexCoord4i) (GLenum target, GLint s, GLint t, GLint r, GLint q);
	inline void glMultiTexCoord4i (GLenum target, GLint s, GLint t, GLint r, GLint q) {
		return DYN_glMultiTexCoord4i (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4iARB) (GLenum target, GLint s, GLint t, GLint r, GLint q);
	inline void glMultiTexCoord4iARB (GLenum target, GLint s, GLint t, GLint r, GLint q) {
		return DYN_glMultiTexCoord4iARB (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4iSGIS) (GLenum target, GLint s, GLint t, GLint r, GLint q);
	inline void glMultiTexCoord4iSGIS (GLenum target, GLint s, GLint t, GLint r, GLint q) {
		return DYN_glMultiTexCoord4iSGIS (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4iv) (GLenum target, const GLint *v);
	inline void glMultiTexCoord4iv (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord4iv (target,v);
	}
	extern void (*DYN_glMultiTexCoord4ivARB) (GLenum target, const GLint *v);
	inline void glMultiTexCoord4ivARB (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord4ivARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord4ivSGIS) (GLenum target, const GLint *v);
	inline void glMultiTexCoord4ivSGIS (GLenum target, const GLint *v) {
		return DYN_glMultiTexCoord4ivSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoord4s) (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
	inline void glMultiTexCoord4s (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) {
		return DYN_glMultiTexCoord4s (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4sARB) (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
	inline void glMultiTexCoord4sARB (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) {
		return DYN_glMultiTexCoord4sARB (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4sSGIS) (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
	inline void glMultiTexCoord4sSGIS (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) {
		return DYN_glMultiTexCoord4sSGIS (target,s,t,r,q);
	}
	extern void (*DYN_glMultiTexCoord4sv) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord4sv (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord4sv (target,v);
	}
	extern void (*DYN_glMultiTexCoord4svARB) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord4svARB (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord4svARB (target,v);
	}
	extern void (*DYN_glMultiTexCoord4svSGIS) (GLenum target, const GLshort *v);
	inline void glMultiTexCoord4svSGIS (GLenum target, const GLshort *v) {
		return DYN_glMultiTexCoord4svSGIS (target,v);
	}
	extern void (*DYN_glMultiTexCoordPointerSGIS) (GLenum target, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glMultiTexCoordPointerSGIS (GLenum target, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glMultiTexCoordPointerSGIS (target,size,type,stride,pointer);
	}
	extern void (*DYN_glNewList) (GLuint list, GLenum mode);
	inline void glNewList (GLuint list, GLenum mode) {
		return DYN_glNewList (list,mode);
	}
	extern void (*DYN_glNormal3b) (GLbyte nx, GLbyte ny, GLbyte nz);
	inline void glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz) {
		return DYN_glNormal3b (nx,ny,nz);
	}
	extern void (*DYN_glNormal3bv) (const GLbyte *v);
	inline void glNormal3bv (const GLbyte *v) {
		return DYN_glNormal3bv (v);
	}
	extern void (*DYN_glNormal3d) (GLdouble nx, GLdouble ny, GLdouble nz);
	inline void glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz) {
		return DYN_glNormal3d (nx,ny,nz);
	}
	extern void (*DYN_glNormal3dv) (const GLdouble *v);
	inline void glNormal3dv (const GLdouble *v) {
		return DYN_glNormal3dv (v);
	}
	extern void (*DYN_glNormal3f) (GLfloat nx, GLfloat ny, GLfloat nz);
	inline void glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz) {
		return DYN_glNormal3f (nx,ny,nz);
	}
	extern void (*DYN_glNormal3fv) (const GLfloat *v);
	inline void glNormal3fv (const GLfloat *v) {
		return DYN_glNormal3fv (v);
	}
	extern void (*DYN_glNormal3hNV) (GLhalf nx, GLhalf ny, GLhalf nz);
	inline void glNormal3hNV (GLhalf nx, GLhalf ny, GLhalf nz) {
		return DYN_glNormal3hNV (nx,ny,nz);
	}
	extern void (*DYN_glNormal3hvNV) (const GLhalf *v);
	inline void glNormal3hvNV (const GLhalf *v) {
		return DYN_glNormal3hvNV (v);
	}
	extern void (*DYN_glNormal3i) (GLint nx, GLint ny, GLint nz);
	inline void glNormal3i (GLint nx, GLint ny, GLint nz) {
		return DYN_glNormal3i (nx,ny,nz);
	}
	extern void (*DYN_glNormal3iv) (const GLint *v);
	inline void glNormal3iv (const GLint *v) {
		return DYN_glNormal3iv (v);
	}
	extern void (*DYN_glNormal3s) (GLshort nx, GLshort ny, GLshort nz);
	inline void glNormal3s (GLshort nx, GLshort ny, GLshort nz) {
		return DYN_glNormal3s (nx,ny,nz);
	}
	extern void (*DYN_glNormal3sv) (const GLshort *v);
	inline void glNormal3sv (const GLshort *v) {
		return DYN_glNormal3sv (v);
	}
	extern void (*DYN_glNormalPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glNormalPointer (type,stride,pointer);
	}
	extern void (*DYN_glNormalPointerEXT) (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
	inline void glNormalPointerEXT (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer) {
		return DYN_glNormalPointerEXT (type,stride,count,pointer);
	}
	extern void (*DYN_glOrtho) (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
	inline void glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) {
		return DYN_glOrtho (left,right,bottom,top,zNear,zFar);
	}
	extern void (*DYN_glPassThrough) (GLfloat token);
	inline void glPassThrough (GLfloat token) {
		return DYN_glPassThrough (token);
	}
	extern void (*DYN_glPixelDataRangeNV) (GLenum target, GLsizei size, const GLvoid *pointer);
	inline void glPixelDataRangeNV (GLenum target, GLsizei size, const GLvoid *pointer) {
		return DYN_glPixelDataRangeNV (target,size,pointer);
	}
	extern void (*DYN_glPixelMapfv) (GLenum map, GLint mapsize, const GLfloat *values);
	inline void glPixelMapfv (GLenum map, GLint mapsize, const GLfloat *values) {
		return DYN_glPixelMapfv (map,mapsize,values);
	}
	extern void (*DYN_glPixelMapuiv) (GLenum map, GLint mapsize, const GLuint *values);
	inline void glPixelMapuiv (GLenum map, GLint mapsize, const GLuint *values) {
		return DYN_glPixelMapuiv (map,mapsize,values);
	}
	extern void (*DYN_glPixelMapusv) (GLenum map, GLint mapsize, const GLushort *values);
	inline void glPixelMapusv (GLenum map, GLint mapsize, const GLushort *values) {
		return DYN_glPixelMapusv (map,mapsize,values);
	}
	extern void (*DYN_glPixelStoref) (GLenum pname, GLfloat param);
	inline void glPixelStoref (GLenum pname, GLfloat param) {
		return DYN_glPixelStoref (pname,param);
	}
	extern void (*DYN_glPixelStorei) (GLenum pname, GLint param);
	inline void glPixelStorei (GLenum pname, GLint param) {
		return DYN_glPixelStorei (pname,param);
	}
	extern void (*DYN_glPixelTransferf) (GLenum pname, GLfloat param);
	inline void glPixelTransferf (GLenum pname, GLfloat param) {
		return DYN_glPixelTransferf (pname,param);
	}
	extern void (*DYN_glPixelTransferi) (GLenum pname, GLint param);
	inline void glPixelTransferi (GLenum pname, GLint param) {
		return DYN_glPixelTransferi (pname,param);
	}
	extern void (*DYN_glPixelZoom) (GLfloat xfactor, GLfloat yfactor);
	inline void glPixelZoom (GLfloat xfactor, GLfloat yfactor) {
		return DYN_glPixelZoom (xfactor,yfactor);
	}
	extern void (*DYN_glPointParameterf) (GLenum pname, GLfloat param);
	inline void glPointParameterf (GLenum pname, GLfloat param) {
		return DYN_glPointParameterf (pname,param);
	}
	extern void (*DYN_glPointParameterfARB) (GLenum pname, GLfloat param);
	inline void glPointParameterfARB (GLenum pname, GLfloat param) {
		return DYN_glPointParameterfARB (pname,param);
	}
	extern void (*DYN_glPointParameterfEXT) (GLenum pname, GLfloat param);
	inline void glPointParameterfEXT (GLenum pname, GLfloat param) {
		return DYN_glPointParameterfEXT (pname,param);
	}
	extern void (*DYN_glPointParameterfv) (GLenum pname, const GLfloat *params);
	inline void glPointParameterfv (GLenum pname, const GLfloat *params) {
		return DYN_glPointParameterfv (pname,params);
	}
	extern void (*DYN_glPointParameterfvARB) (GLenum pname, const GLfloat *params);
	inline void glPointParameterfvARB (GLenum pname, const GLfloat *params) {
		return DYN_glPointParameterfvARB (pname,params);
	}
	extern void (*DYN_glPointParameterfvEXT) (GLenum pname, const GLfloat *params);
	inline void glPointParameterfvEXT (GLenum pname, const GLfloat *params) {
		return DYN_glPointParameterfvEXT (pname,params);
	}
	extern void (*DYN_glPointParameteri) (GLenum pname, GLint param);
	inline void glPointParameteri (GLenum pname, GLint param) {
		return DYN_glPointParameteri (pname,param);
	}
	extern void (*DYN_glPointParameteriNV) (GLenum pname, GLint param);
	inline void glPointParameteriNV (GLenum pname, GLint param) {
		return DYN_glPointParameteriNV (pname,param);
	}
	extern void (*DYN_glPointParameteriv) (GLenum pname, const GLint *params);
	inline void glPointParameteriv (GLenum pname, const GLint *params) {
		return DYN_glPointParameteriv (pname,params);
	}
	extern void (*DYN_glPointParameterivNV) (GLenum pname, const GLint *params);
	inline void glPointParameterivNV (GLenum pname, const GLint *params) {
		return DYN_glPointParameterivNV (pname,params);
	}
	extern void (*DYN_glPointSize) (GLfloat size);
	inline void glPointSize (GLfloat size) {
		return DYN_glPointSize (size);
	}
	extern void (*DYN_glPolygonMode) (GLenum face, GLenum mode);
	inline void glPolygonMode (GLenum face, GLenum mode) {
		return DYN_glPolygonMode (face,mode);
	}
	extern void (*DYN_glPolygonOffset) (GLfloat factor, GLfloat units);
	inline void glPolygonOffset (GLfloat factor, GLfloat units) {
		return DYN_glPolygonOffset (factor,units);
	}
	extern void (*DYN_glPolygonStipple) (const GLubyte *mask);
	inline void glPolygonStipple (const GLubyte *mask) {
		return DYN_glPolygonStipple (mask);
	}
	extern void (*DYN_glPopAttrib) (void);
	inline void glPopAttrib (void) {
		return DYN_glPopAttrib ();
	}
	extern void (*DYN_glPopClientAttrib) (void);
	inline void glPopClientAttrib (void) {
		return DYN_glPopClientAttrib ();
	}
	extern void (*DYN_glPopMatrix) (void);
	inline void glPopMatrix (void) {
		return DYN_glPopMatrix ();
	}
	extern void (*DYN_glPopName) (void);
	inline void glPopName (void) {
		return DYN_glPopName ();
	}
	extern void (*DYN_glPrimitiveRestartIndexNV) (GLuint index);
	inline void glPrimitiveRestartIndexNV (GLuint index) {
		return DYN_glPrimitiveRestartIndexNV (index);
	}
	extern void (*DYN_glPrimitiveRestartNV) (void);
	inline void glPrimitiveRestartNV (void) {
		return DYN_glPrimitiveRestartNV ();
	}
	extern void (*DYN_glPrioritizeTextures) (GLsizei n, const GLuint *textures, const GLclampf *priorities);
	inline void glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities) {
		return DYN_glPrioritizeTextures (n,textures,priorities);
	}
	extern void (*DYN_glPrioritizeTexturesEXT) (GLsizei n, const GLuint *textures, const GLclampf *priorities);
	inline void glPrioritizeTexturesEXT (GLsizei n, const GLuint *textures, const GLclampf *priorities) {
		return DYN_glPrioritizeTexturesEXT (n,textures,priorities);
	}
	extern void (*DYN_glProgramEnvParameter4dARB) (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glProgramEnvParameter4dARB (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glProgramEnvParameter4dARB (target,index,x,y,z,w);
	}
	extern void (*DYN_glProgramEnvParameter4dvARB) (GLenum target, GLuint index, const GLdouble *params);
	inline void glProgramEnvParameter4dvARB (GLenum target, GLuint index, const GLdouble *params) {
		return DYN_glProgramEnvParameter4dvARB (target,index,params);
	}
	extern void (*DYN_glProgramEnvParameter4fARB) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glProgramEnvParameter4fARB (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glProgramEnvParameter4fARB (target,index,x,y,z,w);
	}
	extern void (*DYN_glProgramEnvParameter4fvARB) (GLenum target, GLuint index, const GLfloat *params);
	inline void glProgramEnvParameter4fvARB (GLenum target, GLuint index, const GLfloat *params) {
		return DYN_glProgramEnvParameter4fvARB (target,index,params);
	}
	extern void (*DYN_glProgramLocalParameter4dARB) (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glProgramLocalParameter4dARB (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glProgramLocalParameter4dARB (target,index,x,y,z,w);
	}
	extern void (*DYN_glProgramLocalParameter4dvARB) (GLenum target, GLuint index, const GLdouble *params);
	inline void glProgramLocalParameter4dvARB (GLenum target, GLuint index, const GLdouble *params) {
		return DYN_glProgramLocalParameter4dvARB (target,index,params);
	}
	extern void (*DYN_glProgramLocalParameter4fARB) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glProgramLocalParameter4fARB (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glProgramLocalParameter4fARB (target,index,x,y,z,w);
	}
	extern void (*DYN_glProgramLocalParameter4fvARB) (GLenum target, GLuint index, const GLfloat *params);
	inline void glProgramLocalParameter4fvARB (GLenum target, GLuint index, const GLfloat *params) {
		return DYN_glProgramLocalParameter4fvARB (target,index,params);
	}
	extern void (*DYN_glProgramNamedParameter4dNV) (GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glProgramNamedParameter4dNV (GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glProgramNamedParameter4dNV (id,len,name,x,y,z,w);
	}
	extern void (*DYN_glProgramNamedParameter4dvNV) (GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v);
	inline void glProgramNamedParameter4dvNV (GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v) {
		return DYN_glProgramNamedParameter4dvNV (id,len,name,v);
	}
	extern void (*DYN_glProgramNamedParameter4fNV) (GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glProgramNamedParameter4fNV (GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glProgramNamedParameter4fNV (id,len,name,x,y,z,w);
	}
	extern void (*DYN_glProgramNamedParameter4fvNV) (GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v);
	inline void glProgramNamedParameter4fvNV (GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v) {
		return DYN_glProgramNamedParameter4fvNV (id,len,name,v);
	}
	extern void (*DYN_glProgramParameter4dNV) (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glProgramParameter4dNV (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glProgramParameter4dNV (target,index,x,y,z,w);
	}
	extern void (*DYN_glProgramParameter4dvNV) (GLenum target, GLuint index, const GLdouble *v);
	inline void glProgramParameter4dvNV (GLenum target, GLuint index, const GLdouble *v) {
		return DYN_glProgramParameter4dvNV (target,index,v);
	}
	extern void (*DYN_glProgramParameter4fNV) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glProgramParameter4fNV (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glProgramParameter4fNV (target,index,x,y,z,w);
	}
	extern void (*DYN_glProgramParameter4fvNV) (GLenum target, GLuint index, const GLfloat *v);
	inline void glProgramParameter4fvNV (GLenum target, GLuint index, const GLfloat *v) {
		return DYN_glProgramParameter4fvNV (target,index,v);
	}
	extern void (*DYN_glProgramParameters4dvNV) (GLenum target, GLuint index, GLsizei count, const GLdouble *v);
	inline void glProgramParameters4dvNV (GLenum target, GLuint index, GLsizei count, const GLdouble *v) {
		return DYN_glProgramParameters4dvNV (target,index,count,v);
	}
	extern void (*DYN_glProgramParameters4fvNV) (GLenum target, GLuint index, GLsizei count, const GLfloat *v);
	inline void glProgramParameters4fvNV (GLenum target, GLuint index, GLsizei count, const GLfloat *v) {
		return DYN_glProgramParameters4fvNV (target,index,count,v);
	}
	extern void (*DYN_glProgramStringARB) (GLenum target, GLenum format, GLsizei len, const GLvoid *string);
	inline void glProgramStringARB (GLenum target, GLenum format, GLsizei len, const GLvoid *string) {
		return DYN_glProgramStringARB (target,format,len,string);
	}
	extern void (*DYN_glPushAttrib) (GLbitfield mask);
	inline void glPushAttrib (GLbitfield mask) {
		return DYN_glPushAttrib (mask);
	}
	extern void (*DYN_glPushClientAttrib) (GLbitfield mask);
	inline void glPushClientAttrib (GLbitfield mask) {
		return DYN_glPushClientAttrib (mask);
	}
	extern void (*DYN_glPushMatrix) (void);
	inline void glPushMatrix (void) {
		return DYN_glPushMatrix ();
	}
	extern void (*DYN_glPushName) (GLuint name);
	inline void glPushName (GLuint name) {
		return DYN_glPushName (name);
	}
	extern void (*DYN_glRasterPos2d) (GLdouble x, GLdouble y);
	inline void glRasterPos2d (GLdouble x, GLdouble y) {
		return DYN_glRasterPos2d (x,y);
	}
	extern void (*DYN_glRasterPos2dv) (const GLdouble *v);
	inline void glRasterPos2dv (const GLdouble *v) {
		return DYN_glRasterPos2dv (v);
	}
	extern void (*DYN_glRasterPos2f) (GLfloat x, GLfloat y);
	inline void glRasterPos2f (GLfloat x, GLfloat y) {
		return DYN_glRasterPos2f (x,y);
	}
	extern void (*DYN_glRasterPos2fv) (const GLfloat *v);
	inline void glRasterPos2fv (const GLfloat *v) {
		return DYN_glRasterPos2fv (v);
	}
	extern void (*DYN_glRasterPos2i) (GLint x, GLint y);
	inline void glRasterPos2i (GLint x, GLint y) {
		return DYN_glRasterPos2i (x,y);
	}
	extern void (*DYN_glRasterPos2iv) (const GLint *v);
	inline void glRasterPos2iv (const GLint *v) {
		return DYN_glRasterPos2iv (v);
	}
	extern void (*DYN_glRasterPos2s) (GLshort x, GLshort y);
	inline void glRasterPos2s (GLshort x, GLshort y) {
		return DYN_glRasterPos2s (x,y);
	}
	extern void (*DYN_glRasterPos2sv) (const GLshort *v);
	inline void glRasterPos2sv (const GLshort *v) {
		return DYN_glRasterPos2sv (v);
	}
	extern void (*DYN_glRasterPos3d) (GLdouble x, GLdouble y, GLdouble z);
	inline void glRasterPos3d (GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glRasterPos3d (x,y,z);
	}
	extern void (*DYN_glRasterPos3dv) (const GLdouble *v);
	inline void glRasterPos3dv (const GLdouble *v) {
		return DYN_glRasterPos3dv (v);
	}
	extern void (*DYN_glRasterPos3f) (GLfloat x, GLfloat y, GLfloat z);
	inline void glRasterPos3f (GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glRasterPos3f (x,y,z);
	}
	extern void (*DYN_glRasterPos3fv) (const GLfloat *v);
	inline void glRasterPos3fv (const GLfloat *v) {
		return DYN_glRasterPos3fv (v);
	}
	extern void (*DYN_glRasterPos3i) (GLint x, GLint y, GLint z);
	inline void glRasterPos3i (GLint x, GLint y, GLint z) {
		return DYN_glRasterPos3i (x,y,z);
	}
	extern void (*DYN_glRasterPos3iv) (const GLint *v);
	inline void glRasterPos3iv (const GLint *v) {
		return DYN_glRasterPos3iv (v);
	}
	extern void (*DYN_glRasterPos3s) (GLshort x, GLshort y, GLshort z);
	inline void glRasterPos3s (GLshort x, GLshort y, GLshort z) {
		return DYN_glRasterPos3s (x,y,z);
	}
	extern void (*DYN_glRasterPos3sv) (const GLshort *v);
	inline void glRasterPos3sv (const GLshort *v) {
		return DYN_glRasterPos3sv (v);
	}
	extern void (*DYN_glRasterPos4d) (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glRasterPos4d (x,y,z,w);
	}
	extern void (*DYN_glRasterPos4dv) (const GLdouble *v);
	inline void glRasterPos4dv (const GLdouble *v) {
		return DYN_glRasterPos4dv (v);
	}
	extern void (*DYN_glRasterPos4f) (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glRasterPos4f (x,y,z,w);
	}
	extern void (*DYN_glRasterPos4fv) (const GLfloat *v);
	inline void glRasterPos4fv (const GLfloat *v) {
		return DYN_glRasterPos4fv (v);
	}
	extern void (*DYN_glRasterPos4i) (GLint x, GLint y, GLint z, GLint w);
	inline void glRasterPos4i (GLint x, GLint y, GLint z, GLint w) {
		return DYN_glRasterPos4i (x,y,z,w);
	}
	extern void (*DYN_glRasterPos4iv) (const GLint *v);
	inline void glRasterPos4iv (const GLint *v) {
		return DYN_glRasterPos4iv (v);
	}
	extern void (*DYN_glRasterPos4s) (GLshort x, GLshort y, GLshort z, GLshort w);
	inline void glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w) {
		return DYN_glRasterPos4s (x,y,z,w);
	}
	extern void (*DYN_glRasterPos4sv) (const GLshort *v);
	inline void glRasterPos4sv (const GLshort *v) {
		return DYN_glRasterPos4sv (v);
	}
	extern void (*DYN_glReadBuffer) (GLenum mode);
	inline void glReadBuffer (GLenum mode) {
		return DYN_glReadBuffer (mode);
	}
	extern void (*DYN_glReadPixels) (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
	inline void glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels) {
		return DYN_glReadPixels (x,y,width,height,format,type,pixels);
	}
	extern void (*DYN_glRectd) (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
	inline void glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) {
		return DYN_glRectd (x1,y1,x2,y2);
	}
	extern void (*DYN_glRectdv) (const GLdouble *v1, const GLdouble *v2);
	inline void glRectdv (const GLdouble *v1, const GLdouble *v2) {
		return DYN_glRectdv (v1,v2);
	}
	extern void (*DYN_glRectf) (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
	inline void glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) {
		return DYN_glRectf (x1,y1,x2,y2);
	}
	extern void (*DYN_glRectfv) (const GLfloat *v1, const GLfloat *v2);
	inline void glRectfv (const GLfloat *v1, const GLfloat *v2) {
		return DYN_glRectfv (v1,v2);
	}
	extern void (*DYN_glRecti) (GLint x1, GLint y1, GLint x2, GLint y2);
	inline void glRecti (GLint x1, GLint y1, GLint x2, GLint y2) {
		return DYN_glRecti (x1,y1,x2,y2);
	}
	extern void (*DYN_glRectiv) (const GLint *v1, const GLint *v2);
	inline void glRectiv (const GLint *v1, const GLint *v2) {
		return DYN_glRectiv (v1,v2);
	}
	extern void (*DYN_glRects) (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
	inline void glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2) {
		return DYN_glRects (x1,y1,x2,y2);
	}
	extern void (*DYN_glRectsv) (const GLshort *v1, const GLshort *v2);
	inline void glRectsv (const GLshort *v1, const GLshort *v2) {
		return DYN_glRectsv (v1,v2);
	}
	extern GLenum (*DYN_glReleaseFlushHold) (GLuint id);
	inline GLenum glReleaseFlushHold (GLuint id) {
		return DYN_glReleaseFlushHold (id);
	}
	extern GLint (*DYN_glRenderMode) (GLenum mode);
	inline GLint glRenderMode (GLenum mode) {
		return DYN_glRenderMode (mode);
	}
	extern void (*DYN_glRequestResidentProgramsNV) (GLsizei n, const GLuint *programs);
	inline void glRequestResidentProgramsNV (GLsizei n, const GLuint *programs) {
		return DYN_glRequestResidentProgramsNV (n,programs);
	}
	extern void (*DYN_glResetHistogram) (GLenum target);
	inline void glResetHistogram (GLenum target) {
		return DYN_glResetHistogram (target);
	}
	extern void (*DYN_glResetMinmax) (GLenum target);
	inline void glResetMinmax (GLenum target) {
		return DYN_glResetMinmax (target);
	}
	extern void (*DYN_glRotated) (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
	inline void glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glRotated (angle,x,y,z);
	}
	extern void (*DYN_glRotatef) (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
	inline void glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glRotatef (angle,x,y,z);
	}
	extern void (*DYN_glSampleCoverage) (GLclampf value, GLboolean invert);
	inline void glSampleCoverage (GLclampf value, GLboolean invert) {
		return DYN_glSampleCoverage (value,invert);
	}
	extern void (*DYN_glSampleCoverageARB) (GLclampf value, GLboolean invert);
	inline void glSampleCoverageARB (GLclampf value, GLboolean invert) {
		return DYN_glSampleCoverageARB (value,invert);
	}
	extern void (*DYN_glScaled) (GLdouble x, GLdouble y, GLdouble z);
	inline void glScaled (GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glScaled (x,y,z);
	}
	extern void (*DYN_glScalef) (GLfloat x, GLfloat y, GLfloat z);
	inline void glScalef (GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glScalef (x,y,z);
	}
	extern void (*DYN_glScissor) (GLint x, GLint y, GLsizei width, GLsizei height);
	inline void glScissor (GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glScissor (x,y,width,height);
	}
	extern void (*DYN_glSecondaryColor3b) (GLbyte red, GLbyte green, GLbyte blue);
	inline void glSecondaryColor3b (GLbyte red, GLbyte green, GLbyte blue) {
		return DYN_glSecondaryColor3b (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3bEXT) (GLbyte red, GLbyte green, GLbyte blue);
	inline void glSecondaryColor3bEXT (GLbyte red, GLbyte green, GLbyte blue) {
		return DYN_glSecondaryColor3bEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3bv) (const GLbyte *v);
	inline void glSecondaryColor3bv (const GLbyte *v) {
		return DYN_glSecondaryColor3bv (v);
	}
	extern void (*DYN_glSecondaryColor3bvEXT) (const GLbyte *v);
	inline void glSecondaryColor3bvEXT (const GLbyte *v) {
		return DYN_glSecondaryColor3bvEXT (v);
	}
	extern void (*DYN_glSecondaryColor3d) (GLdouble red, GLdouble green, GLdouble blue);
	inline void glSecondaryColor3d (GLdouble red, GLdouble green, GLdouble blue) {
		return DYN_glSecondaryColor3d (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3dEXT) (GLdouble red, GLdouble green, GLdouble blue);
	inline void glSecondaryColor3dEXT (GLdouble red, GLdouble green, GLdouble blue) {
		return DYN_glSecondaryColor3dEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3dv) (const GLdouble *v);
	inline void glSecondaryColor3dv (const GLdouble *v) {
		return DYN_glSecondaryColor3dv (v);
	}
	extern void (*DYN_glSecondaryColor3dvEXT) (const GLdouble *v);
	inline void glSecondaryColor3dvEXT (const GLdouble *v) {
		return DYN_glSecondaryColor3dvEXT (v);
	}
	extern void (*DYN_glSecondaryColor3f) (GLfloat red, GLfloat green, GLfloat blue);
	inline void glSecondaryColor3f (GLfloat red, GLfloat green, GLfloat blue) {
		return DYN_glSecondaryColor3f (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3fEXT) (GLfloat red, GLfloat green, GLfloat blue);
	inline void glSecondaryColor3fEXT (GLfloat red, GLfloat green, GLfloat blue) {
		return DYN_glSecondaryColor3fEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3fv) (const GLfloat *v);
	inline void glSecondaryColor3fv (const GLfloat *v) {
		return DYN_glSecondaryColor3fv (v);
	}
	extern void (*DYN_glSecondaryColor3fvEXT) (const GLfloat *v);
	inline void glSecondaryColor3fvEXT (const GLfloat *v) {
		return DYN_glSecondaryColor3fvEXT (v);
	}
	extern void (*DYN_glSecondaryColor3hNV) (GLhalf red, GLhalf green, GLhalf blue);
	inline void glSecondaryColor3hNV (GLhalf red, GLhalf green, GLhalf blue) {
		return DYN_glSecondaryColor3hNV (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3hvNV) (const GLhalf *v);
	inline void glSecondaryColor3hvNV (const GLhalf *v) {
		return DYN_glSecondaryColor3hvNV (v);
	}
	extern void (*DYN_glSecondaryColor3i) (GLint red, GLint green, GLint blue);
	inline void glSecondaryColor3i (GLint red, GLint green, GLint blue) {
		return DYN_glSecondaryColor3i (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3iEXT) (GLint red, GLint green, GLint blue);
	inline void glSecondaryColor3iEXT (GLint red, GLint green, GLint blue) {
		return DYN_glSecondaryColor3iEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3iv) (const GLint *v);
	inline void glSecondaryColor3iv (const GLint *v) {
		return DYN_glSecondaryColor3iv (v);
	}
	extern void (*DYN_glSecondaryColor3ivEXT) (const GLint *v);
	inline void glSecondaryColor3ivEXT (const GLint *v) {
		return DYN_glSecondaryColor3ivEXT (v);
	}
	extern void (*DYN_glSecondaryColor3s) (GLshort red, GLshort green, GLshort blue);
	inline void glSecondaryColor3s (GLshort red, GLshort green, GLshort blue) {
		return DYN_glSecondaryColor3s (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3sEXT) (GLshort red, GLshort green, GLshort blue);
	inline void glSecondaryColor3sEXT (GLshort red, GLshort green, GLshort blue) {
		return DYN_glSecondaryColor3sEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3sv) (const GLshort *v);
	inline void glSecondaryColor3sv (const GLshort *v) {
		return DYN_glSecondaryColor3sv (v);
	}
	extern void (*DYN_glSecondaryColor3svEXT) (const GLshort *v);
	inline void glSecondaryColor3svEXT (const GLshort *v) {
		return DYN_glSecondaryColor3svEXT (v);
	}
	extern void (*DYN_glSecondaryColor3ub) (GLubyte red, GLubyte green, GLubyte blue);
	inline void glSecondaryColor3ub (GLubyte red, GLubyte green, GLubyte blue) {
		return DYN_glSecondaryColor3ub (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3ubEXT) (GLubyte red, GLubyte green, GLubyte blue);
	inline void glSecondaryColor3ubEXT (GLubyte red, GLubyte green, GLubyte blue) {
		return DYN_glSecondaryColor3ubEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3ubv) (const GLubyte *v);
	inline void glSecondaryColor3ubv (const GLubyte *v) {
		return DYN_glSecondaryColor3ubv (v);
	}
	extern void (*DYN_glSecondaryColor3ubvEXT) (const GLubyte *v);
	inline void glSecondaryColor3ubvEXT (const GLubyte *v) {
		return DYN_glSecondaryColor3ubvEXT (v);
	}
	extern void (*DYN_glSecondaryColor3ui) (GLuint red, GLuint green, GLuint blue);
	inline void glSecondaryColor3ui (GLuint red, GLuint green, GLuint blue) {
		return DYN_glSecondaryColor3ui (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3uiEXT) (GLuint red, GLuint green, GLuint blue);
	inline void glSecondaryColor3uiEXT (GLuint red, GLuint green, GLuint blue) {
		return DYN_glSecondaryColor3uiEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3uiv) (const GLuint *v);
	inline void glSecondaryColor3uiv (const GLuint *v) {
		return DYN_glSecondaryColor3uiv (v);
	}
	extern void (*DYN_glSecondaryColor3uivEXT) (const GLuint *v);
	inline void glSecondaryColor3uivEXT (const GLuint *v) {
		return DYN_glSecondaryColor3uivEXT (v);
	}
	extern void (*DYN_glSecondaryColor3us) (GLushort red, GLushort green, GLushort blue);
	inline void glSecondaryColor3us (GLushort red, GLushort green, GLushort blue) {
		return DYN_glSecondaryColor3us (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3usEXT) (GLushort red, GLushort green, GLushort blue);
	inline void glSecondaryColor3usEXT (GLushort red, GLushort green, GLushort blue) {
		return DYN_glSecondaryColor3usEXT (red,green,blue);
	}
	extern void (*DYN_glSecondaryColor3usv) (const GLushort *v);
	inline void glSecondaryColor3usv (const GLushort *v) {
		return DYN_glSecondaryColor3usv (v);
	}
	extern void (*DYN_glSecondaryColor3usvEXT) (const GLushort *v);
	inline void glSecondaryColor3usvEXT (const GLushort *v) {
		return DYN_glSecondaryColor3usvEXT (v);
	}
	extern void (*DYN_glSecondaryColorPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glSecondaryColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glSecondaryColorPointer (size,type,stride,pointer);
	}
	extern void (*DYN_glSecondaryColorPointerEXT) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glSecondaryColorPointerEXT (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glSecondaryColorPointerEXT (size,type,stride,pointer);
	}
	extern void (*DYN_glSelectBuffer) (GLsizei size, GLuint *buffer);
	inline void glSelectBuffer (GLsizei size, GLuint *buffer) {
		return DYN_glSelectBuffer (size,buffer);
	}
	extern void (*DYN_glSelectTextureCoordSetSGIS) (GLenum target);
	inline void glSelectTextureCoordSetSGIS (GLenum target) {
		return DYN_glSelectTextureCoordSetSGIS (target);
	}
	extern void (*DYN_glSelectTextureSGIS) (GLenum target);
	inline void glSelectTextureSGIS (GLenum target) {
		return DYN_glSelectTextureSGIS (target);
	}
	extern void (*DYN_glSeparableFilter2D) (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column);
	inline void glSeparableFilter2D (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column) {
		return DYN_glSeparableFilter2D (target,internalformat,width,height,format,type,row,column);
	}
	extern void (*DYN_glSetFenceNV) (GLuint fence, GLenum condition);
	inline void glSetFenceNV (GLuint fence, GLenum condition) {
		return DYN_glSetFenceNV (fence,condition);
	}
	extern void (*DYN_glSetWindowStereoModeNV) (GLboolean displayMode);
	inline void glSetWindowStereoModeNV (GLboolean displayMode) {
		return DYN_glSetWindowStereoModeNV (displayMode);
	}
	extern void (*DYN_glShadeModel) (GLenum mode);
	inline void glShadeModel (GLenum mode) {
		return DYN_glShadeModel (mode);
	}
	extern void (*DYN_glStencilFunc) (GLenum func, GLint ref, GLuint mask);
	inline void glStencilFunc (GLenum func, GLint ref, GLuint mask) {
		return DYN_glStencilFunc (func,ref,mask);
	}
	extern void (*DYN_glStencilMask) (GLuint mask);
	inline void glStencilMask (GLuint mask) {
		return DYN_glStencilMask (mask);
	}
	extern void (*DYN_glStencilOp) (GLenum fail, GLenum zfail, GLenum zpass);
	inline void glStencilOp (GLenum fail, GLenum zfail, GLenum zpass) {
		return DYN_glStencilOp (fail,zfail,zpass);
	}
	extern void (*DYN_glTbufferMask3DFX) (GLuint mask);
	inline void glTbufferMask3DFX (GLuint mask) {
		return DYN_glTbufferMask3DFX (mask);
	}
	extern GLboolean (*DYN_glTestFenceNV) (GLuint fence);
	inline GLboolean glTestFenceNV (GLuint fence) {
		return DYN_glTestFenceNV (fence);
	}
	extern void (*DYN_glTexCoord1d) (GLdouble s);
	inline void glTexCoord1d (GLdouble s) {
		return DYN_glTexCoord1d (s);
	}
	extern void (*DYN_glTexCoord1dv) (const GLdouble *v);
	inline void glTexCoord1dv (const GLdouble *v) {
		return DYN_glTexCoord1dv (v);
	}
	extern void (*DYN_glTexCoord1f) (GLfloat s);
	inline void glTexCoord1f (GLfloat s) {
		return DYN_glTexCoord1f (s);
	}
	extern void (*DYN_glTexCoord1fv) (const GLfloat *v);
	inline void glTexCoord1fv (const GLfloat *v) {
		return DYN_glTexCoord1fv (v);
	}
	extern void (*DYN_glTexCoord1hNV) (GLhalf s);
	inline void glTexCoord1hNV (GLhalf s) {
		return DYN_glTexCoord1hNV (s);
	}
	extern void (*DYN_glTexCoord1hvNV) (const GLhalf *v);
	inline void glTexCoord1hvNV (const GLhalf *v) {
		return DYN_glTexCoord1hvNV (v);
	}
	extern void (*DYN_glTexCoord1i) (GLint s);
	inline void glTexCoord1i (GLint s) {
		return DYN_glTexCoord1i (s);
	}
	extern void (*DYN_glTexCoord1iv) (const GLint *v);
	inline void glTexCoord1iv (const GLint *v) {
		return DYN_glTexCoord1iv (v);
	}
	extern void (*DYN_glTexCoord1s) (GLshort s);
	inline void glTexCoord1s (GLshort s) {
		return DYN_glTexCoord1s (s);
	}
	extern void (*DYN_glTexCoord1sv) (const GLshort *v);
	inline void glTexCoord1sv (const GLshort *v) {
		return DYN_glTexCoord1sv (v);
	}
	extern void (*DYN_glTexCoord2d) (GLdouble s, GLdouble t);
	inline void glTexCoord2d (GLdouble s, GLdouble t) {
		return DYN_glTexCoord2d (s,t);
	}
	extern void (*DYN_glTexCoord2dv) (const GLdouble *v);
	inline void glTexCoord2dv (const GLdouble *v) {
		return DYN_glTexCoord2dv (v);
	}
	extern void (*DYN_glTexCoord2f) (GLfloat s, GLfloat t);
	inline void glTexCoord2f (GLfloat s, GLfloat t) {
		return DYN_glTexCoord2f (s,t);
	}
	extern void (*DYN_glTexCoord2fv) (const GLfloat *v);
	inline void glTexCoord2fv (const GLfloat *v) {
		return DYN_glTexCoord2fv (v);
	}
	extern void (*DYN_glTexCoord2hNV) (GLhalf s, GLhalf t);
	inline void glTexCoord2hNV (GLhalf s, GLhalf t) {
		return DYN_glTexCoord2hNV (s,t);
	}
	extern void (*DYN_glTexCoord2hvNV) (const GLhalf *v);
	inline void glTexCoord2hvNV (const GLhalf *v) {
		return DYN_glTexCoord2hvNV (v);
	}
	extern void (*DYN_glTexCoord2i) (GLint s, GLint t);
	inline void glTexCoord2i (GLint s, GLint t) {
		return DYN_glTexCoord2i (s,t);
	}
	extern void (*DYN_glTexCoord2iv) (const GLint *v);
	inline void glTexCoord2iv (const GLint *v) {
		return DYN_glTexCoord2iv (v);
	}
	extern void (*DYN_glTexCoord2s) (GLshort s, GLshort t);
	inline void glTexCoord2s (GLshort s, GLshort t) {
		return DYN_glTexCoord2s (s,t);
	}
	extern void (*DYN_glTexCoord2sv) (const GLshort *v);
	inline void glTexCoord2sv (const GLshort *v) {
		return DYN_glTexCoord2sv (v);
	}
	extern void (*DYN_glTexCoord3d) (GLdouble s, GLdouble t, GLdouble r);
	inline void glTexCoord3d (GLdouble s, GLdouble t, GLdouble r) {
		return DYN_glTexCoord3d (s,t,r);
	}
	extern void (*DYN_glTexCoord3dv) (const GLdouble *v);
	inline void glTexCoord3dv (const GLdouble *v) {
		return DYN_glTexCoord3dv (v);
	}
	extern void (*DYN_glTexCoord3f) (GLfloat s, GLfloat t, GLfloat r);
	inline void glTexCoord3f (GLfloat s, GLfloat t, GLfloat r) {
		return DYN_glTexCoord3f (s,t,r);
	}
	extern void (*DYN_glTexCoord3fv) (const GLfloat *v);
	inline void glTexCoord3fv (const GLfloat *v) {
		return DYN_glTexCoord3fv (v);
	}
	extern void (*DYN_glTexCoord3hNV) (GLhalf s, GLhalf t, GLhalf r);
	inline void glTexCoord3hNV (GLhalf s, GLhalf t, GLhalf r) {
		return DYN_glTexCoord3hNV (s,t,r);
	}
	extern void (*DYN_glTexCoord3hvNV) (const GLhalf *v);
	inline void glTexCoord3hvNV (const GLhalf *v) {
		return DYN_glTexCoord3hvNV (v);
	}
	extern void (*DYN_glTexCoord3i) (GLint s, GLint t, GLint r);
	inline void glTexCoord3i (GLint s, GLint t, GLint r) {
		return DYN_glTexCoord3i (s,t,r);
	}
	extern void (*DYN_glTexCoord3iv) (const GLint *v);
	inline void glTexCoord3iv (const GLint *v) {
		return DYN_glTexCoord3iv (v);
	}
	extern void (*DYN_glTexCoord3s) (GLshort s, GLshort t, GLshort r);
	inline void glTexCoord3s (GLshort s, GLshort t, GLshort r) {
		return DYN_glTexCoord3s (s,t,r);
	}
	extern void (*DYN_glTexCoord3sv) (const GLshort *v);
	inline void glTexCoord3sv (const GLshort *v) {
		return DYN_glTexCoord3sv (v);
	}
	extern void (*DYN_glTexCoord4d) (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
	inline void glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
		return DYN_glTexCoord4d (s,t,r,q);
	}
	extern void (*DYN_glTexCoord4dv) (const GLdouble *v);
	inline void glTexCoord4dv (const GLdouble *v) {
		return DYN_glTexCoord4dv (v);
	}
	extern void (*DYN_glTexCoord4f) (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
	inline void glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
		return DYN_glTexCoord4f (s,t,r,q);
	}
	extern void (*DYN_glTexCoord4fv) (const GLfloat *v);
	inline void glTexCoord4fv (const GLfloat *v) {
		return DYN_glTexCoord4fv (v);
	}
	extern void (*DYN_glTexCoord4hNV) (GLhalf s, GLhalf t, GLhalf r, GLhalf q);
	inline void glTexCoord4hNV (GLhalf s, GLhalf t, GLhalf r, GLhalf q) {
		return DYN_glTexCoord4hNV (s,t,r,q);
	}
	extern void (*DYN_glTexCoord4hvNV) (const GLhalf *v);
	inline void glTexCoord4hvNV (const GLhalf *v) {
		return DYN_glTexCoord4hvNV (v);
	}
	extern void (*DYN_glTexCoord4i) (GLint s, GLint t, GLint r, GLint q);
	inline void glTexCoord4i (GLint s, GLint t, GLint r, GLint q) {
		return DYN_glTexCoord4i (s,t,r,q);
	}
	extern void (*DYN_glTexCoord4iv) (const GLint *v);
	inline void glTexCoord4iv (const GLint *v) {
		return DYN_glTexCoord4iv (v);
	}
	extern void (*DYN_glTexCoord4s) (GLshort s, GLshort t, GLshort r, GLshort q);
	inline void glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q) {
		return DYN_glTexCoord4s (s,t,r,q);
	}
	extern void (*DYN_glTexCoord4sv) (const GLshort *v);
	inline void glTexCoord4sv (const GLshort *v) {
		return DYN_glTexCoord4sv (v);
	}
	extern void (*DYN_glTexCoordPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glTexCoordPointer (size,type,stride,pointer);
	}
	extern void (*DYN_glTexCoordPointerEXT) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
	inline void glTexCoordPointerEXT (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer) {
		return DYN_glTexCoordPointerEXT (size,type,stride,count,pointer);
	}
	extern void (*DYN_glTexEnvf) (GLenum target, GLenum pname, GLfloat param);
	inline void glTexEnvf (GLenum target, GLenum pname, GLfloat param) {
		return DYN_glTexEnvf (target,pname,param);
	}
	extern void (*DYN_glTexEnvfv) (GLenum target, GLenum pname, const GLfloat *params);
	inline void glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params) {
		return DYN_glTexEnvfv (target,pname,params);
	}
	extern void (*DYN_glTexEnvi) (GLenum target, GLenum pname, GLint param);
	inline void glTexEnvi (GLenum target, GLenum pname, GLint param) {
		return DYN_glTexEnvi (target,pname,param);
	}
	extern void (*DYN_glTexEnviv) (GLenum target, GLenum pname, const GLint *params);
	inline void glTexEnviv (GLenum target, GLenum pname, const GLint *params) {
		return DYN_glTexEnviv (target,pname,params);
	}
	extern void (*DYN_glTexGend) (GLenum coord, GLenum pname, GLdouble param);
	inline void glTexGend (GLenum coord, GLenum pname, GLdouble param) {
		return DYN_glTexGend (coord,pname,param);
	}
	extern void (*DYN_glTexGendv) (GLenum coord, GLenum pname, const GLdouble *params);
	inline void glTexGendv (GLenum coord, GLenum pname, const GLdouble *params) {
		return DYN_glTexGendv (coord,pname,params);
	}
	extern void (*DYN_glTexGenf) (GLenum coord, GLenum pname, GLfloat param);
	inline void glTexGenf (GLenum coord, GLenum pname, GLfloat param) {
		return DYN_glTexGenf (coord,pname,param);
	}
	extern void (*DYN_glTexGenfv) (GLenum coord, GLenum pname, const GLfloat *params);
	inline void glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params) {
		return DYN_glTexGenfv (coord,pname,params);
	}
	extern void (*DYN_glTexGeni) (GLenum coord, GLenum pname, GLint param);
	inline void glTexGeni (GLenum coord, GLenum pname, GLint param) {
		return DYN_glTexGeni (coord,pname,param);
	}
	extern void (*DYN_glTexGeniv) (GLenum coord, GLenum pname, const GLint *params);
	inline void glTexGeniv (GLenum coord, GLenum pname, const GLint *params) {
		return DYN_glTexGeniv (coord,pname,params);
	}
	extern void (*DYN_glTexImage1D) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexImage1D (target,level,internalformat,width,border,format,type,pixels);
	}
	extern void (*DYN_glTexImage2D) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexImage2D (target,level,internalformat,width,height,border,format,type,pixels);
	}
	extern void (*DYN_glTexImage3D) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexImage3D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexImage3D (target,level,internalformat,width,height,depth,border,format,type,pixels);
	}
	extern void (*DYN_glTexImage3DEXT) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexImage3DEXT (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexImage3DEXT (target,level,internalformat,width,height,depth,border,format,type,pixels);
	}
	extern void (*DYN_glTexParameterf) (GLenum target, GLenum pname, GLfloat param);
	inline void glTexParameterf (GLenum target, GLenum pname, GLfloat param) {
		return DYN_glTexParameterf (target,pname,param);
	}
	extern void (*DYN_glTexParameterfv) (GLenum target, GLenum pname, const GLfloat *params);
	inline void glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params) {
		return DYN_glTexParameterfv (target,pname,params);
	}
	extern void (*DYN_glTexParameteri) (GLenum target, GLenum pname, GLint param);
	inline void glTexParameteri (GLenum target, GLenum pname, GLint param) {
		return DYN_glTexParameteri (target,pname,param);
	}
	extern void (*DYN_glTexParameteriv) (GLenum target, GLenum pname, const GLint *params);
	inline void glTexParameteriv (GLenum target, GLenum pname, const GLint *params) {
		return DYN_glTexParameteriv (target,pname,params);
	}
	extern void (*DYN_glTexSubImage1D) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexSubImage1D (target,level,xoffset,width,format,type,pixels);
	}
	extern void (*DYN_glTexSubImage2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexSubImage2D (target,level,xoffset,yoffset,width,height,format,type,pixels);
	}
	extern void (*DYN_glTexSubImage3D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexSubImage3D (target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,pixels);
	}
	extern void (*DYN_glTexSubImage3DEXT) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
	inline void glTexSubImage3DEXT (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels) {
		return DYN_glTexSubImage3DEXT (target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,pixels);
	}
	extern void (*DYN_glTextureColorMaskSGIS) (GLboolean r, GLboolean g, GLboolean b, GLboolean a);
	inline void glTextureColorMaskSGIS (GLboolean r, GLboolean g, GLboolean b, GLboolean a) {
		return DYN_glTextureColorMaskSGIS (r,g,b,a);
	}
	extern void (*DYN_glTrackMatrixNV) (GLenum target, GLuint address, GLenum matrix, GLenum transform);
	inline void glTrackMatrixNV (GLenum target, GLuint address, GLenum matrix, GLenum transform) {
		return DYN_glTrackMatrixNV (target,address,matrix,transform);
	}
	extern void (*DYN_glTranslated) (GLdouble x, GLdouble y, GLdouble z);
	inline void glTranslated (GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glTranslated (x,y,z);
	}
	extern void (*DYN_glTranslatef) (GLfloat x, GLfloat y, GLfloat z);
	inline void glTranslatef (GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glTranslatef (x,y,z);
	}
	extern void (*DYN_glUnlockArraysEXT) (void);
	inline void glUnlockArraysEXT (void) {
		return DYN_glUnlockArraysEXT ();
	}
	extern GLboolean (*DYN_glUnmapBufferARB) (GLenum target);
	inline GLboolean glUnmapBufferARB (GLenum target) {
		return DYN_glUnmapBufferARB (target);
	}
	extern GLboolean (*DYN_glValidBackBufferHintAutodesk) (GLint x, GLint y, GLsizei width, GLsizei height);
	inline GLboolean glValidBackBufferHintAutodesk (GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glValidBackBufferHintAutodesk (x,y,width,height);
	}
	extern void (*DYN_glVertex2d) (GLdouble x, GLdouble y);
	inline void glVertex2d (GLdouble x, GLdouble y) {
		return DYN_glVertex2d (x,y);
	}
	extern void (*DYN_glVertex2dv) (const GLdouble *v);
	inline void glVertex2dv (const GLdouble *v) {
		return DYN_glVertex2dv (v);
	}
	extern void (*DYN_glVertex2f) (GLfloat x, GLfloat y);
	inline void glVertex2f (GLfloat x, GLfloat y) {
		return DYN_glVertex2f (x,y);
	}
	extern void (*DYN_glVertex2fv) (const GLfloat *v);
	inline void glVertex2fv (const GLfloat *v) {
		return DYN_glVertex2fv (v);
	}
	extern void (*DYN_glVertex2hNV) (GLhalf x, GLhalf y);
	inline void glVertex2hNV (GLhalf x, GLhalf y) {
		return DYN_glVertex2hNV (x,y);
	}
	extern void (*DYN_glVertex2hvNV) (const GLhalf *v);
	inline void glVertex2hvNV (const GLhalf *v) {
		return DYN_glVertex2hvNV (v);
	}
	extern void (*DYN_glVertex2i) (GLint x, GLint y);
	inline void glVertex2i (GLint x, GLint y) {
		return DYN_glVertex2i (x,y);
	}
	extern void (*DYN_glVertex2iv) (const GLint *v);
	inline void glVertex2iv (const GLint *v) {
		return DYN_glVertex2iv (v);
	}
	extern void (*DYN_glVertex2s) (GLshort x, GLshort y);
	inline void glVertex2s (GLshort x, GLshort y) {
		return DYN_glVertex2s (x,y);
	}
	extern void (*DYN_glVertex2sv) (const GLshort *v);
	inline void glVertex2sv (const GLshort *v) {
		return DYN_glVertex2sv (v);
	}
	extern void (*DYN_glVertex3d) (GLdouble x, GLdouble y, GLdouble z);
	inline void glVertex3d (GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glVertex3d (x,y,z);
	}
	extern void (*DYN_glVertex3dv) (const GLdouble *v);
	inline void glVertex3dv (const GLdouble *v) {
		return DYN_glVertex3dv (v);
	}
	extern void (*DYN_glVertex3f) (GLfloat x, GLfloat y, GLfloat z);
	inline void glVertex3f (GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glVertex3f (x,y,z);
	}
	extern void (*DYN_glVertex3fv) (const GLfloat *v);
	inline void glVertex3fv (const GLfloat *v) {
		return DYN_glVertex3fv (v);
	}
	extern void (*DYN_glVertex3hNV) (GLhalf x, GLhalf y, GLhalf z);
	inline void glVertex3hNV (GLhalf x, GLhalf y, GLhalf z) {
		return DYN_glVertex3hNV (x,y,z);
	}
	extern void (*DYN_glVertex3hvNV) (const GLhalf *v);
	inline void glVertex3hvNV (const GLhalf *v) {
		return DYN_glVertex3hvNV (v);
	}
	extern void (*DYN_glVertex3i) (GLint x, GLint y, GLint z);
	inline void glVertex3i (GLint x, GLint y, GLint z) {
		return DYN_glVertex3i (x,y,z);
	}
	extern void (*DYN_glVertex3iv) (const GLint *v);
	inline void glVertex3iv (const GLint *v) {
		return DYN_glVertex3iv (v);
	}
	extern void (*DYN_glVertex3s) (GLshort x, GLshort y, GLshort z);
	inline void glVertex3s (GLshort x, GLshort y, GLshort z) {
		return DYN_glVertex3s (x,y,z);
	}
	extern void (*DYN_glVertex3sv) (const GLshort *v);
	inline void glVertex3sv (const GLshort *v) {
		return DYN_glVertex3sv (v);
	}
	extern void (*DYN_glVertex4d) (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glVertex4d (x,y,z,w);
	}
	extern void (*DYN_glVertex4dv) (const GLdouble *v);
	inline void glVertex4dv (const GLdouble *v) {
		return DYN_glVertex4dv (v);
	}
	extern void (*DYN_glVertex4f) (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glVertex4f (x,y,z,w);
	}
	extern void (*DYN_glVertex4fv) (const GLfloat *v);
	inline void glVertex4fv (const GLfloat *v) {
		return DYN_glVertex4fv (v);
	}
	extern void (*DYN_glVertex4hNV) (GLhalf x, GLhalf y, GLhalf z, GLhalf w);
	inline void glVertex4hNV (GLhalf x, GLhalf y, GLhalf z, GLhalf w) {
		return DYN_glVertex4hNV (x,y,z,w);
	}
	extern void (*DYN_glVertex4hvNV) (const GLhalf *v);
	inline void glVertex4hvNV (const GLhalf *v) {
		return DYN_glVertex4hvNV (v);
	}
	extern void (*DYN_glVertex4i) (GLint x, GLint y, GLint z, GLint w);
	inline void glVertex4i (GLint x, GLint y, GLint z, GLint w) {
		return DYN_glVertex4i (x,y,z,w);
	}
	extern void (*DYN_glVertex4iv) (const GLint *v);
	inline void glVertex4iv (const GLint *v) {
		return DYN_glVertex4iv (v);
	}
	extern void (*DYN_glVertex4s) (GLshort x, GLshort y, GLshort z, GLshort w);
	inline void glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w) {
		return DYN_glVertex4s (x,y,z,w);
	}
	extern void (*DYN_glVertex4sv) (const GLshort *v);
	inline void glVertex4sv (const GLshort *v) {
		return DYN_glVertex4sv (v);
	}
	extern void (*DYN_glVertexArrayRangeNV) (GLsizei size, const GLvoid *pointer);
	inline void glVertexArrayRangeNV (GLsizei size, const GLvoid *pointer) {
		return DYN_glVertexArrayRangeNV (size,pointer);
	}
	extern void (*DYN_glVertexAttrib1dARB) (GLuint index, GLdouble x);
	inline void glVertexAttrib1dARB (GLuint index, GLdouble x) {
		return DYN_glVertexAttrib1dARB (index,x);
	}
	extern void (*DYN_glVertexAttrib1dNV) (GLuint index, GLdouble x);
	inline void glVertexAttrib1dNV (GLuint index, GLdouble x) {
		return DYN_glVertexAttrib1dNV (index,x);
	}
	extern void (*DYN_glVertexAttrib1dvARB) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib1dvARB (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib1dvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib1dvNV) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib1dvNV (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib1dvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib1fARB) (GLuint index, GLfloat x);
	inline void glVertexAttrib1fARB (GLuint index, GLfloat x) {
		return DYN_glVertexAttrib1fARB (index,x);
	}
	extern void (*DYN_glVertexAttrib1fNV) (GLuint index, GLfloat x);
	inline void glVertexAttrib1fNV (GLuint index, GLfloat x) {
		return DYN_glVertexAttrib1fNV (index,x);
	}
	extern void (*DYN_glVertexAttrib1fvARB) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib1fvARB (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib1fvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib1fvNV) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib1fvNV (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib1fvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib1hNV) (GLuint index, GLhalf x);
	inline void glVertexAttrib1hNV (GLuint index, GLhalf x) {
		return DYN_glVertexAttrib1hNV (index,x);
	}
	extern void (*DYN_glVertexAttrib1hvNV) (GLuint index, const GLhalf *v);
	inline void glVertexAttrib1hvNV (GLuint index, const GLhalf *v) {
		return DYN_glVertexAttrib1hvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib1sARB) (GLuint index, GLshort x);
	inline void glVertexAttrib1sARB (GLuint index, GLshort x) {
		return DYN_glVertexAttrib1sARB (index,x);
	}
	extern void (*DYN_glVertexAttrib1sNV) (GLuint index, GLshort x);
	inline void glVertexAttrib1sNV (GLuint index, GLshort x) {
		return DYN_glVertexAttrib1sNV (index,x);
	}
	extern void (*DYN_glVertexAttrib1svARB) (GLuint index, const GLshort *v);
	inline void glVertexAttrib1svARB (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib1svARB (index,v);
	}
	extern void (*DYN_glVertexAttrib1svNV) (GLuint index, const GLshort *v);
	inline void glVertexAttrib1svNV (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib1svNV (index,v);
	}
	extern void (*DYN_glVertexAttrib2dARB) (GLuint index, GLdouble x, GLdouble y);
	inline void glVertexAttrib2dARB (GLuint index, GLdouble x, GLdouble y) {
		return DYN_glVertexAttrib2dARB (index,x,y);
	}
	extern void (*DYN_glVertexAttrib2dNV) (GLuint index, GLdouble x, GLdouble y);
	inline void glVertexAttrib2dNV (GLuint index, GLdouble x, GLdouble y) {
		return DYN_glVertexAttrib2dNV (index,x,y);
	}
	extern void (*DYN_glVertexAttrib2dvARB) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib2dvARB (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib2dvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib2dvNV) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib2dvNV (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib2dvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib2fARB) (GLuint index, GLfloat x, GLfloat y);
	inline void glVertexAttrib2fARB (GLuint index, GLfloat x, GLfloat y) {
		return DYN_glVertexAttrib2fARB (index,x,y);
	}
	extern void (*DYN_glVertexAttrib2fNV) (GLuint index, GLfloat x, GLfloat y);
	inline void glVertexAttrib2fNV (GLuint index, GLfloat x, GLfloat y) {
		return DYN_glVertexAttrib2fNV (index,x,y);
	}
	extern void (*DYN_glVertexAttrib2fvARB) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib2fvARB (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib2fvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib2fvNV) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib2fvNV (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib2fvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib2hNV) (GLuint index, GLhalf x, GLhalf y);
	inline void glVertexAttrib2hNV (GLuint index, GLhalf x, GLhalf y) {
		return DYN_glVertexAttrib2hNV (index,x,y);
	}
	extern void (*DYN_glVertexAttrib2hvNV) (GLuint index, const GLhalf *v);
	inline void glVertexAttrib2hvNV (GLuint index, const GLhalf *v) {
		return DYN_glVertexAttrib2hvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib2sARB) (GLuint index, GLshort x, GLshort y);
	inline void glVertexAttrib2sARB (GLuint index, GLshort x, GLshort y) {
		return DYN_glVertexAttrib2sARB (index,x,y);
	}
	extern void (*DYN_glVertexAttrib2sNV) (GLuint index, GLshort x, GLshort y);
	inline void glVertexAttrib2sNV (GLuint index, GLshort x, GLshort y) {
		return DYN_glVertexAttrib2sNV (index,x,y);
	}
	extern void (*DYN_glVertexAttrib2svARB) (GLuint index, const GLshort *v);
	inline void glVertexAttrib2svARB (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib2svARB (index,v);
	}
	extern void (*DYN_glVertexAttrib2svNV) (GLuint index, const GLshort *v);
	inline void glVertexAttrib2svNV (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib2svNV (index,v);
	}
	extern void (*DYN_glVertexAttrib3dARB) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
	inline void glVertexAttrib3dARB (GLuint index, GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glVertexAttrib3dARB (index,x,y,z);
	}
	extern void (*DYN_glVertexAttrib3dNV) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
	inline void glVertexAttrib3dNV (GLuint index, GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glVertexAttrib3dNV (index,x,y,z);
	}
	extern void (*DYN_glVertexAttrib3dvARB) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib3dvARB (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib3dvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib3dvNV) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib3dvNV (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib3dvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib3fARB) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
	inline void glVertexAttrib3fARB (GLuint index, GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glVertexAttrib3fARB (index,x,y,z);
	}
	extern void (*DYN_glVertexAttrib3fNV) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
	inline void glVertexAttrib3fNV (GLuint index, GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glVertexAttrib3fNV (index,x,y,z);
	}
	extern void (*DYN_glVertexAttrib3fvARB) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib3fvARB (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib3fvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib3fvNV) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib3fvNV (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib3fvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib3hNV) (GLuint index, GLhalf x, GLhalf y, GLhalf z);
	inline void glVertexAttrib3hNV (GLuint index, GLhalf x, GLhalf y, GLhalf z) {
		return DYN_glVertexAttrib3hNV (index,x,y,z);
	}
	extern void (*DYN_glVertexAttrib3hvNV) (GLuint index, const GLhalf *v);
	inline void glVertexAttrib3hvNV (GLuint index, const GLhalf *v) {
		return DYN_glVertexAttrib3hvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib3sARB) (GLuint index, GLshort x, GLshort y, GLshort z);
	inline void glVertexAttrib3sARB (GLuint index, GLshort x, GLshort y, GLshort z) {
		return DYN_glVertexAttrib3sARB (index,x,y,z);
	}
	extern void (*DYN_glVertexAttrib3sNV) (GLuint index, GLshort x, GLshort y, GLshort z);
	inline void glVertexAttrib3sNV (GLuint index, GLshort x, GLshort y, GLshort z) {
		return DYN_glVertexAttrib3sNV (index,x,y,z);
	}
	extern void (*DYN_glVertexAttrib3svARB) (GLuint index, const GLshort *v);
	inline void glVertexAttrib3svARB (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib3svARB (index,v);
	}
	extern void (*DYN_glVertexAttrib3svNV) (GLuint index, const GLshort *v);
	inline void glVertexAttrib3svNV (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib3svNV (index,v);
	}
	extern void (*DYN_glVertexAttrib4NbvARB) (GLuint index, const GLbyte *v);
	inline void glVertexAttrib4NbvARB (GLuint index, const GLbyte *v) {
		return DYN_glVertexAttrib4NbvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4NivARB) (GLuint index, const GLint *v);
	inline void glVertexAttrib4NivARB (GLuint index, const GLint *v) {
		return DYN_glVertexAttrib4NivARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4NsvARB) (GLuint index, const GLshort *v);
	inline void glVertexAttrib4NsvARB (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib4NsvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4NubARB) (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
	inline void glVertexAttrib4NubARB (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) {
		return DYN_glVertexAttrib4NubARB (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4NubvARB) (GLuint index, const GLubyte *v);
	inline void glVertexAttrib4NubvARB (GLuint index, const GLubyte *v) {
		return DYN_glVertexAttrib4NubvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4NuivARB) (GLuint index, const GLuint *v);
	inline void glVertexAttrib4NuivARB (GLuint index, const GLuint *v) {
		return DYN_glVertexAttrib4NuivARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4NusvARB) (GLuint index, const GLushort *v);
	inline void glVertexAttrib4NusvARB (GLuint index, const GLushort *v) {
		return DYN_glVertexAttrib4NusvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4bvARB) (GLuint index, const GLbyte *v);
	inline void glVertexAttrib4bvARB (GLuint index, const GLbyte *v) {
		return DYN_glVertexAttrib4bvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4dARB) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glVertexAttrib4dARB (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glVertexAttrib4dARB (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4dNV) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	inline void glVertexAttrib4dNV (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
		return DYN_glVertexAttrib4dNV (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4dvARB) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib4dvARB (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib4dvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4dvNV) (GLuint index, const GLdouble *v);
	inline void glVertexAttrib4dvNV (GLuint index, const GLdouble *v) {
		return DYN_glVertexAttrib4dvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib4fARB) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glVertexAttrib4fARB (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glVertexAttrib4fARB (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4fNV) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	inline void glVertexAttrib4fNV (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
		return DYN_glVertexAttrib4fNV (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4fvARB) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib4fvARB (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib4fvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4fvNV) (GLuint index, const GLfloat *v);
	inline void glVertexAttrib4fvNV (GLuint index, const GLfloat *v) {
		return DYN_glVertexAttrib4fvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib4hNV) (GLuint index, GLhalf x, GLhalf y, GLhalf z, GLhalf w);
	inline void glVertexAttrib4hNV (GLuint index, GLhalf x, GLhalf y, GLhalf z, GLhalf w) {
		return DYN_glVertexAttrib4hNV (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4hvNV) (GLuint index, const GLhalf *v);
	inline void glVertexAttrib4hvNV (GLuint index, const GLhalf *v) {
		return DYN_glVertexAttrib4hvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib4ivARB) (GLuint index, const GLint *v);
	inline void glVertexAttrib4ivARB (GLuint index, const GLint *v) {
		return DYN_glVertexAttrib4ivARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4sARB) (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
	inline void glVertexAttrib4sARB (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) {
		return DYN_glVertexAttrib4sARB (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4sNV) (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
	inline void glVertexAttrib4sNV (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) {
		return DYN_glVertexAttrib4sNV (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4svARB) (GLuint index, const GLshort *v);
	inline void glVertexAttrib4svARB (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib4svARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4svNV) (GLuint index, const GLshort *v);
	inline void glVertexAttrib4svNV (GLuint index, const GLshort *v) {
		return DYN_glVertexAttrib4svNV (index,v);
	}
	extern void (*DYN_glVertexAttrib4ubNV) (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
	inline void glVertexAttrib4ubNV (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) {
		return DYN_glVertexAttrib4ubNV (index,x,y,z,w);
	}
	extern void (*DYN_glVertexAttrib4ubvARB) (GLuint index, const GLubyte *v);
	inline void glVertexAttrib4ubvARB (GLuint index, const GLubyte *v) {
		return DYN_glVertexAttrib4ubvARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4ubvNV) (GLuint index, const GLubyte *v);
	inline void glVertexAttrib4ubvNV (GLuint index, const GLubyte *v) {
		return DYN_glVertexAttrib4ubvNV (index,v);
	}
	extern void (*DYN_glVertexAttrib4uivARB) (GLuint index, const GLuint *v);
	inline void glVertexAttrib4uivARB (GLuint index, const GLuint *v) {
		return DYN_glVertexAttrib4uivARB (index,v);
	}
	extern void (*DYN_glVertexAttrib4usvARB) (GLuint index, const GLushort *v);
	inline void glVertexAttrib4usvARB (GLuint index, const GLushort *v) {
		return DYN_glVertexAttrib4usvARB (index,v);
	}
	extern void (*DYN_glVertexAttribPointerARB) (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
	inline void glVertexAttribPointerARB (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer) {
		return DYN_glVertexAttribPointerARB (index,size,type,normalized,stride,pointer);
	}
	extern void (*DYN_glVertexAttribPointerNV) (GLuint index, GLint fsize, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glVertexAttribPointerNV (GLuint index, GLint fsize, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glVertexAttribPointerNV (index,fsize,type,stride,pointer);
	}
	extern void (*DYN_glVertexAttribs1dvNV) (GLuint index, GLsizei count, const GLdouble *v);
	inline void glVertexAttribs1dvNV (GLuint index, GLsizei count, const GLdouble *v) {
		return DYN_glVertexAttribs1dvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs1fvNV) (GLuint index, GLsizei count, const GLfloat *v);
	inline void glVertexAttribs1fvNV (GLuint index, GLsizei count, const GLfloat *v) {
		return DYN_glVertexAttribs1fvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs1hvNV) (GLuint index, GLsizei count, const GLhalf *v);
	inline void glVertexAttribs1hvNV (GLuint index, GLsizei count, const GLhalf *v) {
		return DYN_glVertexAttribs1hvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs1svNV) (GLuint index, GLsizei count, const GLshort *v);
	inline void glVertexAttribs1svNV (GLuint index, GLsizei count, const GLshort *v) {
		return DYN_glVertexAttribs1svNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs2dvNV) (GLuint index, GLsizei count, const GLdouble *v);
	inline void glVertexAttribs2dvNV (GLuint index, GLsizei count, const GLdouble *v) {
		return DYN_glVertexAttribs2dvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs2fvNV) (GLuint index, GLsizei count, const GLfloat *v);
	inline void glVertexAttribs2fvNV (GLuint index, GLsizei count, const GLfloat *v) {
		return DYN_glVertexAttribs2fvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs2hvNV) (GLuint index, GLsizei count, const GLhalf *v);
	inline void glVertexAttribs2hvNV (GLuint index, GLsizei count, const GLhalf *v) {
		return DYN_glVertexAttribs2hvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs2svNV) (GLuint index, GLsizei count, const GLshort *v);
	inline void glVertexAttribs2svNV (GLuint index, GLsizei count, const GLshort *v) {
		return DYN_glVertexAttribs2svNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs3dvNV) (GLuint index, GLsizei count, const GLdouble *v);
	inline void glVertexAttribs3dvNV (GLuint index, GLsizei count, const GLdouble *v) {
		return DYN_glVertexAttribs3dvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs3fvNV) (GLuint index, GLsizei count, const GLfloat *v);
	inline void glVertexAttribs3fvNV (GLuint index, GLsizei count, const GLfloat *v) {
		return DYN_glVertexAttribs3fvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs3hvNV) (GLuint index, GLsizei count, const GLhalf *v);
	inline void glVertexAttribs3hvNV (GLuint index, GLsizei count, const GLhalf *v) {
		return DYN_glVertexAttribs3hvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs3svNV) (GLuint index, GLsizei count, const GLshort *v);
	inline void glVertexAttribs3svNV (GLuint index, GLsizei count, const GLshort *v) {
		return DYN_glVertexAttribs3svNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs4dvNV) (GLuint index, GLsizei count, const GLdouble *v);
	inline void glVertexAttribs4dvNV (GLuint index, GLsizei count, const GLdouble *v) {
		return DYN_glVertexAttribs4dvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs4fvNV) (GLuint index, GLsizei count, const GLfloat *v);
	inline void glVertexAttribs4fvNV (GLuint index, GLsizei count, const GLfloat *v) {
		return DYN_glVertexAttribs4fvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs4hvNV) (GLuint index, GLsizei count, const GLhalf *v);
	inline void glVertexAttribs4hvNV (GLuint index, GLsizei count, const GLhalf *v) {
		return DYN_glVertexAttribs4hvNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs4svNV) (GLuint index, GLsizei count, const GLshort *v);
	inline void glVertexAttribs4svNV (GLuint index, GLsizei count, const GLshort *v) {
		return DYN_glVertexAttribs4svNV (index,count,v);
	}
	extern void (*DYN_glVertexAttribs4ubvNV) (GLuint index, GLsizei count, const GLubyte *v);
	inline void glVertexAttribs4ubvNV (GLuint index, GLsizei count, const GLubyte *v) {
		return DYN_glVertexAttribs4ubvNV (index,count,v);
	}
	extern void (*DYN_glVertexPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glVertexPointer (size,type,stride,pointer);
	}
	extern void (*DYN_glVertexPointerEXT) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
	inline void glVertexPointerEXT (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer) {
		return DYN_glVertexPointerEXT (size,type,stride,count,pointer);
	}
	extern void (*DYN_glVertexWeightPointerEXT) (GLsizei size, GLenum type, GLsizei stride, const GLvoid *pointer);
	inline void glVertexWeightPointerEXT (GLsizei size, GLenum type, GLsizei stride, const GLvoid *pointer) {
		return DYN_glVertexWeightPointerEXT (size,type,stride,pointer);
	}
	extern void (*DYN_glVertexWeightfEXT) (GLfloat weight);
	inline void glVertexWeightfEXT (GLfloat weight) {
		return DYN_glVertexWeightfEXT (weight);
	}
	extern void (*DYN_glVertexWeightfvEXT) (const GLfloat *weight);
	inline void glVertexWeightfvEXT (const GLfloat *weight) {
		return DYN_glVertexWeightfvEXT (weight);
	}
	extern void (*DYN_glVertexWeighthNV) (GLhalf weight);
	inline void glVertexWeighthNV (GLhalf weight) {
		return DYN_glVertexWeighthNV (weight);
	}
	extern void (*DYN_glVertexWeighthvNV) (const GLhalf *weight);
	inline void glVertexWeighthvNV (const GLhalf *weight) {
		return DYN_glVertexWeighthvNV (weight);
	}
	extern void (*DYN_glViewport) (GLint x, GLint y, GLsizei width, GLsizei height);
	inline void glViewport (GLint x, GLint y, GLsizei width, GLsizei height) {
		return DYN_glViewport (x,y,width,height);
	}
	extern void (*DYN_glWindowBackBufferHintAutodesk) (void);
	inline void glWindowBackBufferHintAutodesk (void) {
		return DYN_glWindowBackBufferHintAutodesk ();
	}
	extern void (*DYN_glWindowPos2d) (GLdouble x, GLdouble y);
	inline void glWindowPos2d (GLdouble x, GLdouble y) {
		return DYN_glWindowPos2d (x,y);
	}
	extern void (*DYN_glWindowPos2dARB) (GLdouble x, GLdouble y);
	inline void glWindowPos2dARB (GLdouble x, GLdouble y) {
		return DYN_glWindowPos2dARB (x,y);
	}
	extern void (*DYN_glWindowPos2dv) (const GLdouble *p);
	inline void glWindowPos2dv (const GLdouble *p) {
		return DYN_glWindowPos2dv (p);
	}
	extern void (*DYN_glWindowPos2dvARB) (const GLdouble *p);
	inline void glWindowPos2dvARB (const GLdouble *p) {
		return DYN_glWindowPos2dvARB (p);
	}
	extern void (*DYN_glWindowPos2f) (GLfloat x, GLfloat y);
	inline void glWindowPos2f (GLfloat x, GLfloat y) {
		return DYN_glWindowPos2f (x,y);
	}
	extern void (*DYN_glWindowPos2fARB) (GLfloat x, GLfloat y);
	inline void glWindowPos2fARB (GLfloat x, GLfloat y) {
		return DYN_glWindowPos2fARB (x,y);
	}
	extern void (*DYN_glWindowPos2fv) (const GLfloat *p);
	inline void glWindowPos2fv (const GLfloat *p) {
		return DYN_glWindowPos2fv (p);
	}
	extern void (*DYN_glWindowPos2fvARB) (const GLfloat *p);
	inline void glWindowPos2fvARB (const GLfloat *p) {
		return DYN_glWindowPos2fvARB (p);
	}
	extern void (*DYN_glWindowPos2i) (GLint x, GLint y);
	inline void glWindowPos2i (GLint x, GLint y) {
		return DYN_glWindowPos2i (x,y);
	}
	extern void (*DYN_glWindowPos2iARB) (GLint x, GLint y);
	inline void glWindowPos2iARB (GLint x, GLint y) {
		return DYN_glWindowPos2iARB (x,y);
	}
	extern void (*DYN_glWindowPos2iv) (const GLint *p);
	inline void glWindowPos2iv (const GLint *p) {
		return DYN_glWindowPos2iv (p);
	}
	extern void (*DYN_glWindowPos2ivARB) (const GLint *p);
	inline void glWindowPos2ivARB (const GLint *p) {
		return DYN_glWindowPos2ivARB (p);
	}
	extern void (*DYN_glWindowPos2s) (GLshort x, GLshort y);
	inline void glWindowPos2s (GLshort x, GLshort y) {
		return DYN_glWindowPos2s (x,y);
	}
	extern void (*DYN_glWindowPos2sARB) (GLshort x, GLshort y);
	inline void glWindowPos2sARB (GLshort x, GLshort y) {
		return DYN_glWindowPos2sARB (x,y);
	}
	extern void (*DYN_glWindowPos2sv) (const GLshort *p);
	inline void glWindowPos2sv (const GLshort *p) {
		return DYN_glWindowPos2sv (p);
	}
	extern void (*DYN_glWindowPos2svARB) (const GLshort *p);
	inline void glWindowPos2svARB (const GLshort *p) {
		return DYN_glWindowPos2svARB (p);
	}
	extern void (*DYN_glWindowPos3d) (GLdouble x, GLdouble y, GLdouble z);
	inline void glWindowPos3d (GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glWindowPos3d (x,y,z);
	}
	extern void (*DYN_glWindowPos3dARB) (GLdouble x, GLdouble y, GLdouble z);
	inline void glWindowPos3dARB (GLdouble x, GLdouble y, GLdouble z) {
		return DYN_glWindowPos3dARB (x,y,z);
	}
	extern void (*DYN_glWindowPos3dv) (const GLdouble *p);
	inline void glWindowPos3dv (const GLdouble *p) {
		return DYN_glWindowPos3dv (p);
	}
	extern void (*DYN_glWindowPos3dvARB) (const GLdouble *p);
	inline void glWindowPos3dvARB (const GLdouble *p) {
		return DYN_glWindowPos3dvARB (p);
	}
	extern void (*DYN_glWindowPos3f) (GLfloat x, GLfloat y, GLfloat z);
	inline void glWindowPos3f (GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glWindowPos3f (x,y,z);
	}
	extern void (*DYN_glWindowPos3fARB) (GLfloat x, GLfloat y, GLfloat z);
	inline void glWindowPos3fARB (GLfloat x, GLfloat y, GLfloat z) {
		return DYN_glWindowPos3fARB (x,y,z);
	}
	extern void (*DYN_glWindowPos3fv) (const GLfloat *p);
	inline void glWindowPos3fv (const GLfloat *p) {
		return DYN_glWindowPos3fv (p);
	}
	extern void (*DYN_glWindowPos3fvARB) (const GLfloat *p);
	inline void glWindowPos3fvARB (const GLfloat *p) {
		return DYN_glWindowPos3fvARB (p);
	}
	extern void (*DYN_glWindowPos3i) (GLint x, GLint y, GLint z);
	inline void glWindowPos3i (GLint x, GLint y, GLint z) {
		return DYN_glWindowPos3i (x,y,z);
	}
	extern void (*DYN_glWindowPos3iARB) (GLint x, GLint y, GLint z);
	inline void glWindowPos3iARB (GLint x, GLint y, GLint z) {
		return DYN_glWindowPos3iARB (x,y,z);
	}
	extern void (*DYN_glWindowPos3iv) (const GLint *p);
	inline void glWindowPos3iv (const GLint *p) {
		return DYN_glWindowPos3iv (p);
	}
	extern void (*DYN_glWindowPos3ivARB) (const GLint *p);
	inline void glWindowPos3ivARB (const GLint *p) {
		return DYN_glWindowPos3ivARB (p);
	}
	extern void (*DYN_glWindowPos3s) (GLshort x, GLshort y, GLshort z);
	inline void glWindowPos3s (GLshort x, GLshort y, GLshort z) {
		return DYN_glWindowPos3s (x,y,z);
	}
	extern void (*DYN_glWindowPos3sARB) (GLshort x, GLshort y, GLshort z);
	inline void glWindowPos3sARB (GLshort x, GLshort y, GLshort z) {
		return DYN_glWindowPos3sARB (x,y,z);
	}
	extern void (*DYN_glWindowPos3sv) (const GLshort *p);
	inline void glWindowPos3sv (const GLshort *p) {
		return DYN_glWindowPos3sv (p);
	}
	extern void (*DYN_glWindowPos3svARB) (const GLshort *p);
	inline void glWindowPos3svARB (const GLshort *p) {
		return DYN_glWindowPos3svARB (p);
	}

#endif // DYNAMIC_GL
#ifdef CONFIG_GL_NAMESPACE
}
#endif
#endif // __GLPP__HPP__
