.\" $Header: /home/amb/cxref/doc/RCS/README.man 1.14 2004/06/16 18:39:17 amb Exp $
.\"
.\"  C Cross Referencing & Documenting tool - Version 1.6.
.\"
.\"  Manual page for cxref
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1996,97,98,99,2000,01,02,03,04 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH cxref 1 "June 15 2004"
.SH NAME
cxref - C Cross Referencing & Documenting tool.

.SH SYNOPSIS
.B  cxref
.I  filename \ [ \ ... \ filename]
.BI [\-O dirname ]
.BI [\-N basename ]
.BI [\-R basename ]
.B  [\-all\-comments] [\-no\-comments]
.B  [\-verbatim\-comments] [\-block\-comments]
.B  [\-xref[\-all][\-file][\-func][\-var][\-type]]
.B  [\-warn[\-all][\-comment][\-xref]]
.B  [\-index[\-all][\-file][\-func][\-var][\-type]]
.B  [\-raw]
.B  [\-latex]
.B  [\-html[\-src]]
.B  [\-rtf]
.B  [\-sgml]
.BI [\-I dirname ]
.BI [\-D define ]
.BI [\-U define ]
.BI [\-CPP \ cpp_program]
.BI [\-\- \ cpp_args \ ... \ cpp_args]
.LP
.B  cxref
.I  filename \ [ \ ... \ filename]
.B  \-delete
.BI [\-O dirname ]
.BI [\-N basename ]
.BI [\-R basename ]

.SH DESCRIPTION
A program that can automatically generate documentation and cross references for
a C program.

The input is any C program with appropriate comments and the output is LaTeX,
HTML, RTF or SGML files.

.SH OPTIONS

.TP
.BR filename
The name of the file to document, any number of files may be
documented at a time.
.TP
.BR \-delete
The files named are to be deleted from the output directory and
their entries in the cross reference database and main output
files are to be removed.
.TP
.BR \-Odirname
The name of a directory to use for the output latex files and
the location of the cross reference files that are created.
.TP
.BR \-Nbasename
The name to use for the first part of the output and cross
reference files instead of cxref, the file extensions remain
the same.
.TP
.BR \-Rdirname
When the source files are in more than one directory, set
dirname to the name of the root directory of the source tree
(use relative path if easier e.g. `-R../..').  This will then
run cxref from that root directory and the `-Odirname' must be
relative to that directory.
.TP
.BR \-all\-comments
In case you think that the existing comments might work,
(see above for description of special comments).
[Danger! This option can produce weird results.]
.TP
.BR \-no\-comments
Ignores all comments, useful if you just want the cross
references and not the documentation.
.TP
.BR \-verbatim\-comments
When the comments that you have in the code are formatted
in a predetermined style that you want to preserve on the
output, this option will force them not to be reformatted.
[Note, this is for file and function comments only.]
.TP
.BR \-block\-comments
When the comments in the program are formatted in the `block'
style (with a leading '*' character on every line), this option
will remove that character from the output.
[Works for a single `*', `+', `|' or `:' on each line.]
.TP
.BR \-xref
Produce cross referencing information (see below).
 -all    All cross references.
 -file   Cross references for files.
 -func   Cross references for functions.
 -var    Cross references for variables.
 -type   Cross references for types.
.TP
.BR \-warn
Produce warnings, the options must be concatenated together:
 -all       All warnings.
 -comment   Warn of missing comments.
 -xref      Warn of missing cross references.
.TP
.BR \-index
Produce a cross reference index, the options must be
concatenated together:
 -all    All indexes.
 -file   Index of files.
 -func   Index of functions.
 -var    Index of variables.
 -type   Index of types.
.TP
.BR \-raw
Produce a raw form of output, not really of much use except
with -warn.
.TP
.BR \-latex
Produce a LaTeX file to document each of the source files and
also an extra file that includes each of these files.
.TP
.BR \-html
Produce an HTML 4.01 file to document each of the source files
and a main file to reference each of these files.
.TP
.BR \-html-src
Produce the HTML output and an HTML version of the source file
with links into it.
.TP
.BR \-rtf
Produce a Rich Text Format (RTF) file to document the source
file.
.TP
.BR \-sgml
Produce an SGML file to document the source file.  (Using the
LinuxDoc DTD).
.TP
.BR \-Idirname
GCC option to specify the path for include files.
.TP
.BR \-Ddefine
GCC option to define a pre-processor symbol.
.TP
.BR \-Udefine
GCC option to undefine a pre-processor symbol.
.TP
.BR \-CPP \ program
The name of the program to use instead of the compile time
default. The program must be able to perform all of the actions
that `gcc -E -C -dD' does to work.  If the program takes
arguments then the whole thing needs to be in quotes so that it
is interpreted as a single argument to cxref.
.TP
.BR \-\- arg \ ... \ arg
Extra arguments to be passed to the pre-processor can be placed
after the `--' separator.

.SS C Compiler Replacement cxref-cc

To simplify using cxref on existing source code, there is now a shell script
that will call the C compiler and then call cxref to process the source file.
This means that it can be used as a drop in replacement for CC in Makefiles and
the like.

Usage: cxref-cc [usual cc options]

The name of the source file is extracted from the list of options as well as the
`-D*', `-I*', `-U*' flags and when the C compiler exits succesfully cxref will
be called.  The name of the C compiler to use is controlled by the CXREFCC
environment variable, or if this is not set then the CC environment variable, or
failing this just gcc.

Using this script requires the use of a `.cxref' configuration file to contain
the options since there is nowhere to put the options on the command line for
the C compiler.

This will only cross-reference and document the C source files since they are
the only ones that are compiled, but it will make sure that they are
cross-referenced with the correct options etc.

.SS Cxref Configuration File

These command line arguments can also be put into a file named `.cxref' instead
of on the command line.  When cxref is run the arguments to the program are
interpreted in the following order.

(1) Those on the command line.
(2) Those in the `.cxref' file in the current directory.
(3) Those in the `.cxref' file in the source tree root specified by `-R'.

This means that in a multi-directory source tree, each sub-directory can have a
`.cxref' file containing just the line `-R..' or appropriate.  The main
directory can have a `.cxref' file containing the remainder of the options.
This removes completely the need to have any options on the command line apart
from the source file names.

The format of the `.cxref' file is any number of lines, each one containing a
single command line argument (equivalent to one of the argv).  The only options
that cannot be used are the names of source files themselves and the `-delete'
option.  Blank lines are ignored and lines starting with a '#' are comments.

.SS Program Documentation Comments

The documentation for the program is produced from comments in the code that are
appropriately formatted.  The cross referencing comes from the code itself and
requires no extra work.

The special comments are `/**** ****/' (for a file) and `/*++++ ++++*/' (for a
data object) any number of `*' or `+' can be used inside of the standard `/*'
and `*/' comment delimiters in the comments, they are ignored.

If a comment line starts with whitespace and is followed by `+html+' then the
rest of the line is included only in the HTML output, and is not processed so it
can include HTML markup, `-html-' means that the rest of the line is included in
all except the HTML output.  The same also applies to the other output formats,
`+none+' can be used for lines not to appear in any output.  The exception to
this is that the raw output does not do any checking and will output all lines.

In any situation where a comment follows a `,', `;' or `)' separated only by
spaces and tabs, the comment is pushed to before the punctuation to apply to
object there.

The program is implemented using a full ANSI C grammar parser with some GCC
extensions, this means that the style of the code is unimportant, only the
content and comments.

.SS Cross Referencing

The cross referencing is performed for the following items

Files
 The files that the current file is included in
 (even when included via other files).

#includes
 Files included in the current file.
 Files included by these files etc.

Variables
 The location of the definition of external variables.
 The files that have visibility of global variables.
 The files / functions that use the variable.

Functions
 The file that the function is prototyped in.
 The functions that the function calls.
 The functions that call the function.
 The files and functions that reference the function.
 The variables that are used in the function.

Each of these items is cross referenced in the output.

The cross referencing uses files `cxref.variable', `cxref.function',
`cxref.include' and `cxref.typedef' in the output directory.
These are a complete list of the function and variable usage in the program and
could be used to generate a function call hierarchy or variable usage diagram
for example.
Two cxref passes of each file is needed, the first to build up the cross
referencing files and the second to use them.

(The file names are different if the `-N' option is used.)

.SS LaTeX Output

The default LaTeX output is a file for each of the source files with one extra
file `cxref.tex' that includes each of the other files.  This is to allow a
makefile to only update the changed files (although the references may require
all of the files to be checked again).  When the cxref.tex file has been written
it can be modified by the user, any new files that are added are added at the
end of the source code section, the rest of the file being unchanged.

The index is written to a file called `cxref.apdx.tex' and cxref.tex is updated
to refer to it.

Also written out are three LaTeX style files `page.sty', `fonts.sty' and
`cxref.sty'.  These set up the page to use a smaller margin and smaller fonts to
allow more to appear on a page and also define the new commands for typesetting
the cxref output.

(The file names `cxref.tex' and `cxref.apdx.tex' are different if the `-N'
option is used.)

.SS HTML Output

The default HTML output is a file for each of the source files with one extra
file `cxref.html' that includes each of the other files.  This is to allow a
makefile to only update the changed files (although the references may require
all of the files to be checked again).  When the cxref.html file has been
written it can be modified by the user, any new files that are added are added
at the end before the table of contents, the rest of the file being unchanged.

The index is written to a file called `cxref.apdx.html' and cxref.html is
updated to refer to it.

(The file names `cxref.html' and `cxref.apdx.html' are different if the `-N'
option is used.)

The HTML output uses the HTML 4.01 standard and all pages validate correctly.

.SS RTF Output

Rich Text Format is a fairly low level page description format devised by
Microsoft.  It is not a well defined and easy to understand standard as are the
other formats, but it is popular for document exchange.

There is a single output file for each of the source files and an index file.

.SS SGML Output

Since SGML is a meta-language it is necessary to define the layout elements as
well as provide the information.  The cxref output uses the LinuxDoc document
format and is designed for use with the SGMLtools programs
(http://www.sgmltools.org/).

There is a single output file for each of the source files and an index file.

.SH SEE ALSO

The files that come with the cxref source code distribution give more information.
The README file gives examples of how to use the comments in source code.
There is a list of frequently asked questions and their answers for the cxref
program in the FAQ file.  A list of improvements planned for future versions of
the program are listed in the file TODO.

More up-to-date information can be found on the World Wide Web at the cxref
homepage, reached via the author's homepage http://www.gedanken.demon.co.uk/.

.SH BUGS
If you wish to submit bug reports or other comments about the program then email
the author amb@gedanken.demon.co.uk and put cxref in the subject line.

.SH AUTHOR
The cxref program was written by Andrew M. Bishop in 1995-2004.

The cxref program is copyright Andrew M. Bishop 1995-2004.

The cxref-cpp program is copyright Free Software Foundation, Inc.

The cxref and cxref-cpp programs can be freely distributed according to the
terms of the GNU General Public License (see the file `COPYING').
