/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xalan.res.XSLMessages;

final class ChunkedIntArray {
    final int slotsize = 4;
    static final int lowbits = 10;
    static final int chunkalloc = 1024;
    static final int lowmask = 1023;
    ChunksVector chunks = new ChunksVector();
    final int[] fastArray = new int[1024];
    int lastUsed = 0;

    ChunkedIntArray(int n) {
        if (n > 4) {
            throw new ArrayIndexOutOfBoundsException(XSLMessages.createMessage(157, new Object[]{Integer.toString(n)}));
        }
        if (n < 4) {
            System.out.println("*****WARNING: ChunkedIntArray(" + n + ") wasting " + (4 - n) + " words per slot");
        }
        this.chunks.addElement(this.fastArray);
    }

    int appendSlot(int n, int n2, int n3, int n4) {
        int n5 = 4;
        int n6 = (this.lastUsed + 1) * 4;
        int n7 = n6 >> 10;
        int n8 = n6 & 0x3FF;
        if (n7 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray = this.chunks.elementAt(n7);
        nArray[n8] = n;
        nArray[n8 + 1] = n2;
        nArray[n8 + 2] = n3;
        nArray[n8 + 3] = n4;
        return ++this.lastUsed;
    }

    void discardLast() {
        --this.lastUsed;
    }

    int readEntry(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 >= 4) {
            throw new ArrayIndexOutOfBoundsException(XSLMessages.createMessage(158, null));
        }
        int n3 = (n *= 4) >> 10;
        int n4 = n & 0x3FF;
        int[] nArray = this.chunks.elementAt(n3);
        return nArray[n4 + n2];
    }

    void readSlot(int n, int[] nArray) {
        int n2 = (n *= 4) >> 10;
        int n3 = n & 0x3FF;
        if (n2 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray2 = this.chunks.elementAt(n2);
        System.arraycopy(nArray2, n3, nArray, 0, 4);
    }

    int slotsUsed() {
        return this.lastUsed;
    }

    int specialFind(int n, int n2) {
        int n3 = n;
        while (n3 > 0) {
            int n4 = (n3 *= 4) >> 10;
            int n5 = n3 & 0x3FF;
            int[] nArray = this.chunks.elementAt(n4);
            n3 = nArray[n5 + 1];
            if (n3 == n2) break;
        }
        if (n3 <= 0) {
            return n2;
        }
        return -1;
    }

    void writeEntry(int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 >= 4) {
            throw new ArrayIndexOutOfBoundsException(XSLMessages.createMessage(158, null));
        }
        int n4 = (n *= 4) >> 10;
        int n5 = n & 0x3FF;
        int[] nArray = this.chunks.elementAt(n4);
        nArray[n5 + n2] = n3;
    }

    void writeSlot(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n *= 4) >> 10;
        int n7 = n & 0x3FF;
        if (n6 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray = this.chunks.elementAt(n6);
        nArray[n7] = n2;
        nArray[n7 + 1] = n3;
        nArray[n7 + 2] = n4;
        nArray[n7 + 3] = n5;
    }

    class ChunksVector {
        final int BLOCKSIZE = 64;
        int[][] m_map = new int[64][];
        int m_mapSize = 64;
        int pos = 0;

        ChunksVector() {
        }

        void addElement(int[] nArray) {
            if (this.pos >= this.m_mapSize) {
                int n = this.m_mapSize;
                while (this.pos >= this.m_mapSize) {
                    this.m_mapSize += 64;
                }
                int[][] nArray2 = new int[this.m_mapSize][];
                System.arraycopy(this.m_map, 0, nArray2, 0, n);
                this.m_map = nArray2;
            }
            this.m_map[this.pos] = nArray;
            ++this.pos;
        }

        final int[] elementAt(int n) {
            return this.m_map[n];
        }

        final int size() {
            return this.pos;
        }
    }
}

