<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="org.apache.xalan.lib.Redirect"
    extension-element-prefixes="redirect">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:output method="html"/>
  <xsl:param name="DashboardPath"/>
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:param name="PreviousDashboardStamp" select="string('')"/>
  <xsl:param name="CreationDate" select="string('')"/>
  <xsl:variable name="DashboardDir" select="concat('../', $DashboardStamp)"/>
  <xsl:variable name="IconDir" select="string('../../Icons')"/>

  <xsl:include href="DashboardConfig.xsl"/>
  <xsl:param name="BuildTestOverview" />

  <!-- Index the file so that we can access all the builds that ran a 
       particular test quickly -->
  <xsl:key name="TestNames" match="Test" use="FullName"/>
  <xsl:variable name="TestNames" select="/Dashboard/BuildStamp/Testing/Tests/Test[count(.|key('TestNames', FullName)[1]) = 1]"/>
  <xsl:variable name="NumberOfTests" select="count($TestNames)"/>
 
  <!-- Index the file so that we can access test/sitename combinations
       quickly -->
  <xsl:key name="TestCrossReference" match="Test" 
           use="concat(../../SiteName,'::',../../BuildName,'::',../../BuildStamp,'::',FullName)"/>

  <xsl:template match="/Dashboard">
    <xsl:if test="$BuildTestOverview='ON'">
        <xsl:call-template name="TestOverview"/>
    </xsl:if>
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Dashboard - <xsl:value-of select="$CreationDate"/></xsl:with-param>
      <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      <xsl:with-param name="UseCalendar">1</xsl:with-param>
    </xsl:call-template>
    <xsl:choose>
      <xsl:when test="count(BuildStamp/Site/DashboardNotes)">
	<xsl:call-template name="Notes"/>
      </xsl:when>
    </xsl:choose>
    <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa"><tr class="table-heading"><td>
    <h3>
      <xsl:choose>
        <xsl:when test="Update/ChangedFileCount != ''">
          <a href="Update.html">
            <xsl:value-of select="Update/ChangedFileCount"/> Files Changed
          </a>
          by <xsl:value-of select="Update/AuthorCount"/> Authors
          as of <xsl:value-of select="Update/StartDateTime"/>
        </xsl:when>
        <xsl:otherwise>
          No Update information available!
        </xsl:otherwise>
      </xsl:choose>
    </h3>
    </td></tr></table>
    <br/>

    <xsl:if test="$BuildDoxygen='ON'">
    <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa"><tr class="table-heading"><td>
    <h3>
      <xsl:choose>
        <xsl:when test="string-length(Doxygen/StartDateTime) != 0">
          <a href="Doxygen.html">
            Doxygen:
          </a>
          <xsl:value-of select="Doxygen/ErrorCount"/> Errors
          and <xsl:value-of select="Doxygen/WarningCount"/> Warnings
        </xsl:when>
        <xsl:otherwise>
          No Doxygen information available!
        </xsl:otherwise>
      </xsl:choose>
    </h3>
    </td></tr></table>
    <br/>
    </xsl:if>
     
    <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
    <xsl:choose>
      <xsl:when test="count(BuildStamp/Build/BuildStamp[contains(node(),'Nightly')]) or count(BuildStamp/Update/BuildStamp[contains(node(),'Nightly')]) or count(BuildStamp/MissingBuild)">
        <tr class="table-heading"><td colspan="11" valign="middle"><h3>Nightly Builds</h3></td></tr>
        <xsl:call-template name="BuildTableHeader"/>
        <xsl:for-each select="BuildStamp">
          <xsl:sort select="*/SiteName"/>
          <xsl:sort select="*/BuildName"/>
          <xsl:choose>
            <xsl:when test="count(MissingBuild)">
                <xsl:call-template name="MissingBuild"/>
            </xsl:when>
            <xsl:when test="contains(Build/BuildStamp,'Nightly') or contains(Testing/BuildStamp,'Nightly') or contains(Update/BuildStamp,'Nightly')">
                <xsl:call-template name="BuildStamp"/>
            </xsl:when>
          </xsl:choose>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <tr class="table-heading"><td colspan="11"><h3>No Nightly Builds</h3></td></tr>
      </xsl:otherwise>        
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="count(BuildStamp/Build/BuildStamp[contains(node(),'Continuous')]) or count(BuildStamp/Update/BuildStamp[contains(node(),'Continuous')])">
        <tr class="table-heading"><td colspan="11" valign="middle"><h3>Continuous Builds</h3></td></tr>
          <xsl:call-template name="BuildTableHeader"/>
          <xsl:for-each select="BuildStamp">
            <xsl:sort select="*/BuildStamp" order="descending"/>
            <xsl:sort select="*/SiteName"/>
            <xsl:sort select="*/BuildName"/>
            <xsl:if test="contains(Build/BuildStamp,'Continuous') or contains(Testing/BuildStamp,'Continuous') or contains(Update/BuildStamp,'Continuous')">
              <xsl:call-template name="BuildStamp"/>
            </xsl:if>
          </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <tr class="table-heading"><td colspan="11"><h3>No Continuous Builds</h3></td></tr>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="count(BuildStamp/Build/BuildStamp[not(contains(node(),'Nightly') or contains(node(), 'Continuous'))]) or count(BuildStamp/Update/BuildStamp[not(contains(node(),'Nightly') or contains(node(), 'Continuous'))])">
        <tr class="table-heading"><td colspan="11" valign="middle"><h3>Experimental Builds</h3></td></tr>
          <xsl:call-template name="BuildTableHeader"/>
          <xsl:for-each select="BuildStamp">
            <xsl:sort select="*/BuildStamp" order="descending"/>
            <xsl:sort select="*/SiteName"/>
            <xsl:sort select="*/BuildName"/>
            <xsl:if test="not ( contains(Build/BuildStamp,'Nightly') or contains(Testing/BuildStamp,'Nightly') or contains(Update/BuildStamp,'Nightly') or contains(Build/BuildStamp,'Continuous') or contains(Testing/BuildStamp,'Continuous') or contains(Update/BuildStamp,'Continuous') ) and count(Build/SiteName | Testing/Sitename | Update/SiteName)">
              <xsl:call-template name="BuildStamp"/>
            </xsl:if>
          </xsl:for-each>
      
      </xsl:when>
      <xsl:otherwise>
        <tr class="table-heading"><td colspan="11"><h3>No Experimental Builds</h3></td></tr>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="count(BuildStamp/Build/BuildStamp)">
      <tr>
        <td align="left" bgcolor="#ffffff">
          Totals
        </td>
        <td align="center" bgcolor="#ffffff">
          <b><xsl:value-of select="count(BuildStamp/Build/BuildStamp)"/> Builds</b>
        </td>
        <td bgcolor="#ffffff"><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></td>
        <td align="right">
          <xsl:choose>
            <xsl:when test="sum(/Dashboard/BuildStamp/Build/ErrorCount) &gt; 0">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="sum(/Dashboard/BuildStamp/Build/ErrorCount)"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td align="right">
          <xsl:choose>
            <xsl:when test="sum(/Dashboard/BuildStamp/Build/WarningCount) &gt; 0">
              <xsl:attribute name="class">warning</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="sum(/Dashboard/BuildStamp/Build/WarningCount)"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td align="right">
          <xsl:choose>
            <xsl:when test="sum(/Dashboard/BuildStamp/Testing/NotRunCount) &gt; 0">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="sum(/Dashboard/BuildStamp/Testing/NotRunCount)"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td align="right">
          <xsl:choose>
            <xsl:when test="sum(/Dashboard/BuildStamp/Testing/FailedCount) &gt; 0">
              <xsl:attribute name="class">warning</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="sum(/Dashboard/BuildStamp/Testing/FailedCount)"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td align="right">
          <xsl:choose>
            <xsl:when test="sum(/Dashboard/BuildStamp/Testing/FailedCount) + sum(/Dashboard/BuildStamp/Testing/NotRunCount) &gt; 0">
              <xsl:attribute name="class">warning</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="sum(/Dashboard/BuildStamp/Testing/PassedCount)"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td bgcolor="#ffffff"/><td bgcolor="#ffffff"/><td bgcolor="#ffffff"/>
      </tr>
    </xsl:if>

        </table>
        <br/>    
        <xsl:choose>
          <xsl:when test="count(BuildStamp/Coverage)">
            <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
              <tr class="table-heading"><td colspan="7">
	        <h3>Coverage</h3>
	      </td></tr>
              <tr class="table-heading">
                <th align="center" >Site</th>
                <th align="center" >Build Name</th>
                <th align="center" width="80">Percentage</th>
                <th align="center" >Passed</th>
                <th align="center" >Failed</th>
                <th align="center" >Date</th>
                <th align="center" >Submission Date</th>
              </tr>
                    <!--
                         Loop over each instance
                         -->
                    <xsl:for-each select="BuildStamp">
                      <xsl:sort select="Build/SiteName"/>
                      <xsl:sort select="Build/BuildName"/>
                      <xsl:if test="Coverage/LOC != ''">
                        <xsl:variable name="URLBase">../../Sites/<xsl:value-of select="Coverage/SiteName"/>/<xsl:value-of select="Coverage/BuildName"/>/<xsl:value-of select="Coverage/BuildStamp"/></xsl:variable>
                        <tr>
                          <td align="left" bgcolor="#ffffff">
                           <xsl:call-template name="SoftHyphenStringAtDot">
                 	     <xsl:with-param name="src">
		                <xsl:value-of select="Coverage/SiteName"/>
		             </xsl:with-param>
	                   </xsl:call-template>
                          </td>
                          <td align="left" bgcolor="#ffffff"><xsl:value-of select="Coverage/BuildName"/></td>
                          <td align="center">
                            <xsl:choose>
                              <xsl:when test="Coverage/PercentCoverage &lt; 70">
                                <xsl:attribute name="class">warning</xsl:attribute>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:attribute name="class">normal</xsl:attribute>
                              </xsl:otherwise>
                            </xsl:choose>
                            <a>
                              <xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/CoverageByName.html</xsl:attribute><b><xsl:value-of select="Coverage/PercentCoverage"/>%</b>
                            </a>
                          </td>
                          <td align="right" bgcolor="#ffffff">
                            <b><xsl:value-of select="Coverage/Passed"/></b>
                          </td>
                          <td align="right" bgcolor="#ffffff">
                            <b><xsl:value-of select="Coverage/Failed"/></b>
                          </td>
                          <td align="left" bgcolor="#ffffff"><xsl:value-of select="Coverage/StartDateTime"/></td>
                          <td align="left" bgcolor="#ffffff"><xsl:value-of select="CoverageSubmissionDateTime"/></td>
                        </tr>
                      </xsl:if>
                    </xsl:for-each>
                  </table>
	          <br/>    
                </xsl:when>
                <xsl:otherwise>
         	  <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
	            <tr class="table-heading"><td>
                      <h3>No coverage information</h3>
	            </td></tr>
                  </table>
		  <br/>
                </xsl:otherwise>
              </xsl:choose>

        <xsl:choose>
          <xsl:when test="count(BuildStamp/Purify)">
            <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
              <tr class="table-heading"><td colspan="5">
                <h3>Purify</h3>
	      </td></tr>
              <tr class="table-heading">
                <th align="center" >Site</th>
                <th align="center" >Build Name</th>
                <th align="center" >Defect Count</th>
                <th align="center" >Date</th>
                <th align="center" >Submission Date</th>
              </tr>
              <!--
                   Loop over each instance
                   -->
              <xsl:for-each select="BuildStamp">
                <xsl:sort select="Purify/SiteName"/>
                <xsl:sort select="Purify/BuildName"/>
                <xsl:variable name="URLBase">../../Sites/<xsl:value-of select="Purify/SiteName"/>/<xsl:value-of select="Purify/BuildName"/>/<xsl:value-of select="Purify/BuildStamp"/></xsl:variable>
                <xsl:if test="Purify/SiteName != ''">
                  <tr>
                    <td align="left" bgcolor="#ffffff">
                      <xsl:call-template name="SoftHyphenStringAtDot">
                 	 <xsl:with-param name="src">
		           <xsl:value-of select="Purify/SiteName"/>
		         </xsl:with-param>
	              </xsl:call-template>
                    </td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="Purify/BuildName"/></td>
                    <td align="center">
                      <xsl:choose>
                        <xsl:when test="Purify/DefectCount != 0">
                          <xsl:attribute name="class">warning</xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:attribute name="class">normal</xsl:attribute>
                        </xsl:otherwise>
                      </xsl:choose>
                      <a>
                        <xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/Purify.html</xsl:attribute><b><xsl:value-of select="Purify/DefectCount"/></b>
                      </a>
                    </td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="Purify/StartDateTime"/></td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="PurifySubmissionDateTime"/></td>
                  </tr>
                </xsl:if>
              </xsl:for-each>
            </table>
            <br/>    
          </xsl:when>
          <xsl:otherwise>
	    <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
	      <tr class="table-heading"><td>
                <h3>No purify information</h3>
	      </td></tr>
            </table>
	    <br/>
          </xsl:otherwise>
        </xsl:choose>

              <xsl:call-template name="DashboardFooter"/>
  </xsl:template>


  <xsl:template name="BuildStamp">
    <xsl:variable name="URLBase">../../Sites/<xsl:value-of select="Build/SiteName"/>/<xsl:value-of select="Build/BuildName"/>/<xsl:value-of select="Build/BuildStamp"/></xsl:variable>
    <xsl:variable name="UpdateURLBase">../../Sites/<xsl:value-of select="Update/SiteName"/>/<xsl:value-of select="Update/BuildName"/>/<xsl:value-of select="Update/BuildStamp"/></xsl:variable>

    <tr>
      <td align="left" bgcolor="#ffffff">
        <xsl:if test="contains(., 'Nightly') and @expected='no'">
           <img alt="Unexpected nightly build submission" align="ABSMIDDLE"><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/New.gif</xsl:attribute></img><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
        </xsl:if>
        <xsl:choose>
          <xsl:when test="count(Update/SiteName)">
            <xsl:call-template name="SoftHyphenStringAtDot">
		<xsl:with-param name="src">
		   <xsl:value-of select="Update/SiteName"/>
		</xsl:with-param>
	    </xsl:call-template>
          </xsl:when>
          <xsl:when test="count(Build/SiteName)">
            <xsl:call-template name="SoftHyphenStringAtDot">
		<xsl:with-param name="src">
		   <xsl:value-of select="Build/SiteName"/>
		</xsl:with-param>
	    </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="SoftHyphenStringAtDot">
		<xsl:with-param name="src">
		   <xsl:value-of select="Testing/SiteName"/>
		</xsl:with-param>
	    </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td align="left" bgcolor="#ffffff">
        <xsl:choose>
          <xsl:when test="count(Update/BuildName)">
            <xsl:call-template name="SoftHyphenStringAtUnderscore">
		<xsl:with-param name="src">
                  <xsl:call-template name="SoftHyphenStringAtDot">
	             <xsl:with-param name="src">
		       <xsl:value-of select="Update/BuildName"/>
		     </xsl:with-param>
                  </xsl:call-template>
                </xsl:with-param>
	    </xsl:call-template>
          </xsl:when>
          <xsl:when test="count(Build/BuildName)">
            <xsl:call-template name="SoftHyphenStringAtUnderscore">
		<xsl:with-param name="src">
                  <xsl:call-template name="SoftHyphenStringAtDot">
	             <xsl:with-param name="src">
		       <xsl:value-of select="Build/BuildName"/>
		     </xsl:with-param>
                  </xsl:call-template>
                </xsl:with-param>
	    </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="SoftHyphenStringAtUnderscore">
		<xsl:with-param name="src">
                  <xsl:call-template name="SoftHyphenStringAtDot">
	             <xsl:with-param name="src">
		       <xsl:value-of select="Testing/BuildName"/>
		     </xsl:with-param>
                  </xsl:call-template>
                </xsl:with-param>
	    </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
	<xsl:choose>
	  <xsl:when test="count(Notes)">
             <xsl:text disable-output-escaping="yes"> &amp;nbsp;&amp;nbsp;</xsl:text>
	     <a><xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/Notes.html</xsl:attribute><img><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Document.gif</xsl:attribute><xsl:attribute name="ALT">Notes</xsl:attribute><xsl:attribute name="border">0</xsl:attribute></img></a>
	  </xsl:when>
	</xsl:choose>
      </td>
      <td align="right" bgcolor="#ffffff">
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$UpdateURLBase"/>/Update.html</xsl:attribute><xsl:value-of select="Update/ChangedFileCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="Build/ErrorCount > 0">
            <xsl:attribute name="class">error</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/BuildError.html</xsl:attribute><xsl:value-of select="Build/ErrorCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="Build/WarningCount > 0">
            <xsl:attribute name="class">warning</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/BuildWarning.html</xsl:attribute><xsl:value-of select="Build/WarningCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>

      <td align="right">
        <xsl:choose>
          <xsl:when test="Testing/NotRunCount > 0">
            <xsl:attribute name="class">error</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/Test.html</xsl:attribute><xsl:value-of select="Testing/NotRunCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="Testing/FailedCount > 0">
            <xsl:attribute name="class">warning</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/Test.html</xsl:attribute><xsl:value-of select="Testing/FailedCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="(Testing/NotRunCount + Testing/FailedCount) > 0">
            <xsl:attribute name="class">warning</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/Test.html</xsl:attribute><xsl:value-of select="Testing/PassedCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:attribute name="class">na</xsl:attribute>
	<xsl:choose>
	  <xsl:when test="(Testing/NotRunCount + Testing/FailedCount + Testing/PassedCount) > 0">
            <b><a><xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/Test.html</xsl:attribute><xsl:value-of select="$NumberOfTests - Testing/PassedCount - Testing/FailedCount - Testing/NotRunCount"/></a></b>
          </xsl:when>
          <xsl:otherwise>
	    <b><xsl:value-of select="$NumberOfTests"/></b>
	  </xsl:otherwise>
	</xsl:choose>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td bgcolor="#ffffff">
        <xsl:choose>
          <xsl:when test="count(Build/StartDateTime)">
            <xsl:value-of select="Build/StartDateTime"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="Testing/StartDateTime"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td bgcolor="#ffffff">
        <xsl:choose>
          <xsl:when test="count(TestSubmissionDateTime)">
	    <xsl:value-of select="TestSubmissionDateTime"/>
          </xsl:when>
          <xsl:otherwise>
	    <xsl:value-of select="BuildSubmissionDateTime"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    
  </xsl:template>

  <xsl:template name="MissingBuild">
    <tr>
      <td align="left" bgcolor="#ffffff">
        <xsl:call-template name="SoftHyphenStringAtDot">
             <xsl:with-param name="src">
                 <xsl:value-of select="MissingBuild/SiteName"/>
	     </xsl:with-param>
	</xsl:call-template>
      </td>
      <td align="left" bgcolor="#ffffff">
        <xsl:call-template name="SoftHyphenStringAtUnderscore">
             <xsl:with-param name="src">
                <xsl:call-template name="SoftHyphenStringAtDot">
	           <xsl:with-param name="src">
		      <xsl:value-of select="MissingBuild/BuildName"/>
       	           </xsl:with-param>
                </xsl:call-template>
              </xsl:with-param>
	 </xsl:call-template>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="center">
        <xsl:attribute name="class">warning</xsl:attribute>
        <b>No submission</b>
      </td>
    </tr>

  </xsl:template>


  
  <xsl:template name="BuildTableHeader">
    <tr class="table-heading">
      <th align="center" rowspan="2">Site</th>
      <th align="center" rowspan="2">Build Name</th>
      <th align="center" rowspan="2">Update</th>
      <th align="center" colspan="2">Build</th>
      <th align="center" colspan="4">Test</th>
      <th align="center" rowspan="2">Build Date</th>
      <th align="center" rowspan="2">Submission Date</th>
    </tr>
    <tr class="table-heading">
      <th align="center">Errors</th>
      <th align="center">Warnings</th>
      <th align="center">NotRun</th>
      <th align="center">Failed</th>
      <th align="center">Passed</th>
      <th align="center">NA</th>
    </tr>
  </xsl:template>

  <xsl:template name="TestOverview">
    <redirect:write select="concat ( string('{$DashboardPath}'), '/TestOverview.xml' )">
      <TestOverview>
        <xsl:variable name="BuildStamps" select="BuildStamp"/>
        <xsl:for-each select="$BuildStamps/Testing/Tests/Test[count(. | key('TestNames', FullName)[1]) = 1]">
          <xsl:sort select="FullName"/>
            <xsl:variable name="TestName" select="FullName"/>
            <Test>
              <Name><xsl:value-of select="$TestName"/></Name>
              <xsl:for-each select="$BuildStamps/Testing">
                <xsl:variable name="Test"
                              select="key('TestCrossReference', concat(SiteName, '::', BuildName, '::', BuildStamp, '::', $TestName))"/>
                <Result>
                   <xsl:copy-of select="SiteName"/>
                   <xsl:copy-of select="BuildName"/>
                   <xsl:copy-of select="BuildStamp"/>
                   <xsl:choose>
                      <xsl:when test="$Test">
                         <xsl:copy-of select="$Test/Status"/>
                         <xsl:copy-of select="$Test/CompletionStatus"/>
                         <xsl:copy-of select="$Test/ExitCode"/>
                      </xsl:when>
                      <xsl:otherwise><Status>na</Status></xsl:otherwise>
                   </xsl:choose>
                </Result>
              </xsl:for-each>
            </Test>
        </xsl:for-each>
      </TestOverview>
    </redirect:write>
  </xsl:template>

<xsl:template name="Notes">
<xsl:for-each select="BuildStamp/Site/DashboardNotes/Note">
   <p>
   <img><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Alert.gif</xsl:attribute><xsl:attribute name="ALT">Notes</xsl:attribute><xsl:attribute name="border">0</xsl:attribute><xsl:attribute name="ALIGN">texttop</xsl:attribute></img><xsl:text disable-output-escaping="yes"> &amp;nbsp;&amp;nbsp;</xsl:text>
   <b><xsl:value-of select="DateTime"/></b><br/>
   <xsl:value-of select="Text"/>
   </p>	
</xsl:for-each>
</xsl:template>

  
</xsl:stylesheet>
