package DBIShell::Gtk::conn;

use strict;

use Gtk;
use Gtk::Atoms;
use Gtk::Icon;

use DBIShell qw(:const);
use DBIShell::UTIL qw(:readmode TRUE FALSE);

use Gtk::Symbols (':func'          ,
		  ':gdk_win_type'  ,
		  ':gdk_ev_type'   ,
		  ':attach_opts'   ,
		 );

use constant WINDOW_LABEL => 'connect';

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);

@ISA         = qw(DBIShell::Gtk);
@EXPORT      = ();
@EXPORT_OK   = ();
%EXPORT_TAGS = ();
$VERSION     = 0.00_01;

sub panel ($;$)
{
    my %conn;
    my $y = 0;
    my $sh     = $_[0];
    my $return = $_[1] || $sh->{OPT};

#   my $label0 = Gtk::Label ->new( WINDOW_LABEL          );
    my $window = Gtk::Window->new( GDK_WIN_TYPE_TOPLEVEL );
#   my $vbox_0 = Gtk::HBox  ->new( FALSE, FALSE          );
    my $table0 = Gtk::Table ->new( 2, 1, FALSE           );

    $window->border_width  ( 0 );
    $window->set_policy    ( TRUE, TRUE, TRUE );
    $window->set_title     ( WINDOW_LABEL . " 2 " );
    $window->signal_connect( GDK_EV_TYPE_DESTROY, GTK__TRUE  );
    $window->signal_connect( GDK_EV_TYPE_DELETE,  GTK__FALSE );

    $table0->set_row_spacings( 2 );
    $table0->set_col_spacings( 2 );
    $table0->border_width    ( 2 );

#    $window->add( $vbox_0 );
#    $vbox_0->pack_start( $table0, TRUE , TRUE , FALSE );

    $table0->show();
    $window->add( $table0 );
#    $vbox_0->show();

    $conn{driver} = Gtk::Combo->new();

  CONN_OPT:
    foreach ( DBI_OPT_SPEC )
    {
	my $name = $_->[ DBIOPT_NAME ];
	my $prmt = $_->[ DBIOPT_PRMT ];
	my $mode = $_->[ DBIOPT_MODE ];

	$prmt =~ s/:.*/:/;

	if( !$conn{$name} )
	{
	    $conn{$name} = Gtk::Entry->new();

	    if( $mode == READMODE_NOECHO )
	    {
		$conn{$name}->set_visibility( FALSE );
	    }
	}
	elsif( ref( $conn{$name} ) eq 'Gtk::Combo' )
	{
	    if( $name ne 'driver' )
	    {
		warn("Unknown option '$name'\n");
		next CONN_OPT;
	    }

	    $conn{$name}->set_popdown_strings( DBI->available_drivers() );
	}
	else
	{
	    warn("Unknown option '$name'\n");
	    next CONN_OPT;
	}

	my $label  = Gtk::Label->new( $prmt );

	$table0->resize( 2, $y + 1 );

	$table0->attach( $label,
			 0, 1,
			 $y, $y + 1,
			 ATTACH_OPTS_SHRINK,
			 ATTACH_OPTS_SHRINK,
			 0, 0
		       );


	$table0->attach( $conn{$name},
			 1, 2,
			 $y, $y + 1,
			 ATTACH_OPTS_SHRINK,
			 ATTACH_OPTS_SHRINK,
			 0, 0
		       );

	$label      ->show();
	$conn{$name}->show();
	$y++;
    };

    $window->show();
}



