/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * misc_gtk.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: misc_gtk.c,v 1.3 2004/01/16 18:38:54 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "misc_gtk.h"
#include "main.h"

/***************************************************************************/
/* take the string contained in the gtk_entry having the name "entry_name" */
/* and compare it to array.                                                */
/***************************************************************************/
/* output: index of the entry_name content string into array       */
/*         on error or when the string is not found, 0 is returned */
/*******************************************************************/
int gtk_entry_to_number(char *entry_name, const char *array[])
{
	GtkWidget *w;
	int i;
	const char *param;

	w=get_widget_by_widget_name(main_window,entry_name);
	if(w==NULL)
	{
		printf("%s not found\n",entry_name);
		return 0;
	}

	param=gtk_entry_get_text(GTK_ENTRY(w));
	i=0;
	while(array[i]!=NULL)
	{
		if(!strcmp(array[i],param))
			return i;
		i++;
	}
	printf("%s (in %s) not found\n",param,entry_name);
	return 0;
}

/***************************************************************************/
/* take the string contained in the gtk_entry having the name "entry_name" */
/* and compare it to array.                                                */
/***************************************************************************/
/* output: index of the entry_name content string into array        */
/*         on error or when the string is not found, -1 is returned */
/********************************************************************/
int gtk_entry_to_number_wo_default(char *entry_name, const char *array[])
{
	GtkWidget *w;
	int i;
	const char *param;

	w=get_widget_by_widget_name(main_window,entry_name);
	if(w==NULL)
	{
		printf("%s not found\n",entry_name);
		return -1;
	}

	param=gtk_entry_get_text(GTK_ENTRY(w));
	i=0;
	while(array[i]!=NULL)
	{
		if(!strcmp(array[i],param))
			return i;
		i++;
	}
	return -1;
}
