/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * dctc_com.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dctc_com.c,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <glib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "dctc_com.h"
#include "userinfo.h"
#include "lmp.h"
#include "main.h"
#include "dctc_process.h"

/**********************************************************/
/* allocate a new DCTC_COM structure for the given socket */
/**********************************************************/
/* running_base_path = "$HOME/.dctc/dctc-xxxxxxxx-ip" */
/******************************************************/
DCTC_COM *create_new_dctc_com(int sock_fd, const char *running_base_path)
{
	DCTC_COM *cm;

	cm=malloc(sizeof(DCTC_COM));
	if(cm==NULL)
		return NULL;

	cm->dctc_fd=sock_fd;
	cm->dctc_sock_path=strdup(running_base_path);
	cm->tag_read=-1;
	cm->tag_write=-1;
	cm->write_q=g_ptr_array_new();
	cm->incoming_data=g_string_new("");

	{	/* create userinfo LMP filename "base_path" + ".userinfo" */
		gchar *userinfo_lmp_path=g_strconcat(running_base_path,".userinfo",NULL);
		cm->user_info_lmp=lmp_new(userinfo_lmp_path,sizeof(LMP_UINFO));
		g_free(userinfo_lmp_path);
	}

	cm->user_info_nb_records_sync_last_state=0;
	cm->user_info_lmp_sync_last_state=NULL;
	return cm;
}

/*************************************************************************/
/* close the socket of a com_struct and reopenit on the same destination */
/*************************************************************************/
void reconnect_dctc_com(DCTC_COM *cm)
{
	struct sockaddr_un name;
	int a;

	if(cm->dctc_fd!=-1)
	{
		shutdown(cm->dctc_fd,SHUT_RDWR);
		cm->dctc_fd=socket(AF_UNIX,SOCK_STREAM,0);
		if(cm->dctc_fd==-1)
		{
			perror("reconnect_dctc_com - socket");
			return;
		}
	}

	name.sun_family=AF_UNIX;
	strcpy(name.sun_path,cm->dctc_sock_path);
	a=connect(current_dctc->dctc_fd,(void *)&name,sizeof(struct sockaddr_un));
	if(a==-1)
	{
		perror("reconnect_dctc_com - connect fails");
	}
	else
	{
		if(cm->tag_read!=-1)
		{
			gdk_input_remove(cm->tag_read);
			current_dctc->tag_read=gdk_input_add(current_dctc->dctc_fd, GDK_INPUT_READ, process_data_from_dctc, &current_dctc);
		}

		if(cm->tag_write!=-1)
		{
			gdk_input_remove(cm->tag_write);
			cm->tag_write=-1;
		}
	}
}

/***************************************************/
/* close socket and free memory used by a DCTC_COM */
/***************************************************/
void close_and_free_dctc_com(DCTC_COM *cm)
{
	if(cm==NULL)
		return;

	shutdown(cm->dctc_fd,2);
	close(cm->dctc_fd);
	if(cm->tag_read!=-1)
	{
		gdk_input_remove(cm->tag_read);
		cm->tag_read=-1;
	}
	if(cm->tag_write!=-1)
	{
		gdk_input_remove(cm->tag_write);
		cm->tag_write=-1;
	}

	if(cm->write_q)
	{
		int i;
		for(i=0;i<cm->write_q->len;i++)
		{
			char *str;

			str=g_ptr_array_index(cm->write_q,i);
			if(str)
				free(str);
		}
		g_ptr_array_free(cm->write_q,TRUE);
		cm->write_q=NULL;
	}

	if(cm->incoming_data)
	{
		g_string_free(cm->incoming_data,TRUE);
		cm->incoming_data=NULL;
	}

	if(cm->user_info_lmp)
	{
		lmp_close(cm->user_info_lmp);
		cm->user_info_lmp=NULL;
	}

	if(cm->user_info_lmp_sync_last_state)
	{
		g_free(cm->user_info_lmp_sync_last_state);
		cm->user_info_lmp_sync_last_state=NULL;
	}
	free(cm);
}

/**********************************************************/
/* destroy the given DCTC_COM and set its pointer to NULL */
/**********************************************************/
void close_dctc_com(DCTC_COM **cm)
{
	if(*cm==NULL)
		return;
	close_and_free_dctc_com(*cm);
	*cm=NULL;
}


