/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * global_user.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: global_user.h,v 1.13 2003/12/28 09:29:32 uid68112 Exp $
*/

#ifndef __GLOBAL_USER_H__
#define __GLOBAL_USER_H__

typedef struct
{
	GtkTreeModel *gtm;
	GtkTreeRowReference *gtrr;		/* to check with gtk_tree_row_reference_valid */
} GLOB_USER_REF;

/************************************************************/
/* this structure contains all informations links to a user */
/* including GtkTreeModel and Iter where they are displayed */
/************************************************************/
typedef struct
{
	/* unformatted values */
	gchar *unfmt_nick;		/* MUST BE THE FIRST field of the struct due to cast conversion from GLOB_USER to char * in the hash function */
									/* MUST NOT BE CHANGED AFTER INSERTION INTO HASH TABLE */
	gchar *unfmt_email;
	gchar *unfmt_desc;
	guint64 unfmt_size;
	gboolean is_op;
	const gchar *cnx_type;
	guint flags;		/* away, fast, ... */
	gboolean is_connected;	/* for green/transparent background */

	/* formatted values (GTK2 ready to use value) */
	gchar *fmt_nick;				/* never NULL */
	gchar *fmt_email;				/* can be NULL */
	gchar *fmt_desc;				/* can be NULL */
	gchar *fmt_size;				/* can be NULL */
	const gchar *front_color;	/* can be NULL (modified by is_op) */
	const gchar *back_color;	/* can be NULL (modified by flags (here/away)) */
	const gchar *fast_color;	/* can be NULL (modified by flags (fast)) */
	const gchar *back_present_color;	/* can be NULL (modified by is_connected) */
	
	GArray *gu_ref;		/* reference where the entry is displayed */
	gboolean dirty;		/* something as "visually" (formatted) changed in the structure */
								/* note: this is used to know if a row update signal was sent */
								/*       it should not be used by refresh function to know if an update is required */
} GLOB_USER;

/**********************************/
/* return the structure of a user */
/**********************************/
GLOB_USER *gu_get_user(const char *nickname);

/***********************************************************/
/* return the structure of a user or create it if required */
/*********************************************************************************/
/* input: nickname to find/add                                                   */
/*        if with_creation is TRUE, when a nick is not found, it is created      */
/* output: GLOB_USER (always !=NULL)                                             */
/*         if was_created is not NULL, it is set to TRUE if the user was created */
/*********************************************************************************/
GLOB_USER *gu_add_user(const char *unfmt_nick, gboolean with_creation, gboolean *was_created);

/*********************************************************/
/* modify a GLOB_USER entry with possible display update */
/*********************************************************/
/* output: TRUE=the variable was updated */
/*****************************************/
/* unfmt_email can be NULL */
gboolean gu_set_email(GLOB_USER *gu, const char *unfmt_email, gboolean with_display_update);
/* unfmt_desc can be NULL */
gboolean gu_set_desc(GLOB_USER *gu, const char *unfmt_desc, gboolean with_display_update);
gboolean gu_set_size(GLOB_USER *gu, const guint64 unfmt_size, gboolean with_display_update);
gboolean gu_set_op_flag(GLOB_USER *gu, const gboolean is_op, gboolean with_display_update);
gboolean gu_set_cnx_type(GLOB_USER *gu, const char *cnx_type, gboolean with_display_update);
gboolean gu_set_flags(GLOB_USER *gu, const guint flags, gboolean with_display_update);
gboolean gu_set_is_connected(GLOB_USER *gu, const gboolean is_connected, gboolean with_display_update);

/***************************************/
/* force a redisplay of the given user */
/***************************************/
void gu_do_user_row_update(GLOB_USER *gu);

/*********************************/
/* reference a new displayed row */
/********************************************/
/* input: the GtkTreeRowReference is stolen */
/********************************************/
void gu_ref(GLOB_USER *gu, GtkTreeModel *gtm, GtkTreeRowReference *gtrr);

/************************************************/
/* reference a new displayed row using its iter */
/************************************************/
void gu_ref_from_iter(GLOB_USER *gu, GtkTreeModel *gtm, GtkTreeIter *giter);

/***********************************/
/* unreference a new displayed row */
/***********************************/
void gu_unref(GLOB_USER *gu, GtkTreeModel *gtm, GtkTreeRowReference *gtrr);

/**************************************************/
/* unreference a new displayed row using its iter */
/**************************************************/
void gu_unref_from_iter(GLOB_USER *gu, GtkTreeModel *gtm, GtkTreeIter *iter);

/*******************************************************************/
/* search inside the given user for a reference on the given model */
/*******************************************************************/
/* output: NULL= not found else a TreePath (to free) */
/*****************************************************/
GtkTreePath *gu_user_get_path_for_model(GLOB_USER *gu, GtkTreeModel *gtm);

/*******************************************************************/
/* search inside the given user for a reference on the given model */
/*******************************************************************/
/* output: TRUE if the iter is valid and "giter" is populated */
/**************************************************************/
gboolean gu_user_get_iter_for_model(GLOB_USER *gu, GtkTreeModel *gtm, GtkTreeIter *iter);

/*******************************************************************/
/* search inside the given user for a reference on the given model */
/***********************************************************************/
/* output: NULL= not found else a TreeRowReference (must not be freed) */
/***********************************************************************/
GtkTreeRowReference *gu_user_get_reference_for_model(GLOB_USER *gu, GtkTreeModel *gtm);

/*********************************************/
/* purge GLOB_USER entries without reference */
/*********************************************/
void gu_purge(void);

/************************************************/
/* remove all reference to a model on all users */
/************************************************/
/* useful after/before a gtk_store_clear() */
/*******************************************/
void gu_unref_model(GtkTreeModel *gtm);

/************************************************/
/* remove all reference to a model on all users */
/* and mark updated user as disconnected        */
/************************************************/
/* useful before a gtk_store_clear() */
/*************************************/
void gu_unref_model_and_disconnect(GtkTreeModel *gtm);

/*********************************************/
/* clear dirty flag of all GLOB_USER entries */
/*********************************************/
void gu_clear_dirty_flags(void);

/************************************************************/
/* compute the number of online users and their shared size */
/************************************************************/
guint32 compute_online_nb_users_and_share_size(guint64 *share_size);

#endif
