<?php
/*
 * $Id: class.boChecklists.inc.php,v 1.2.4.2 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');
LoadStringResource('chk');

class boChecklists
{
	function GetChklstPath($id, $bCreate = false)
	{
		global $dcl_info;

		$filePath = $dcl_info['DCL_FILE_PATH'] . '/checklists';
		$dir[1] = $id % 10; // last digit
		$dir[2] = ($id - $dir[1]) % 100;
		$dir[3] = ($id - $dir[2] - $dir[1]) % 1000;
		$dir[4] = ($id - $dir[3] - $dir[2] - $dir[1]) % 10000;
		$dir[5] = ($id - $dir[4] - $dir[3] - $dir[2] - $dir[1]) % 100000;

		// make directories and build path as needed, except for last one ;-)
		for ($i = 5; $i > 2; $i--)
		{
			$filePath .= '/' . $dir[$i];
			if ($bCreate && !is_dir($filePath))
				mkdir($filePath, 0755);
		}

		$filePath .= '/' . $id . '.xml';

		return $filePath;
	}

	function show()
	{
		commonHeader();
		
		$filterStatus = '';
		$filterType = '';
		if (IsSet($GLOBALS['filterStatus']))
			$filterStatus = $GLOBALS['filterStatus'];
		if (IsSet($GLOBALS['filterType']))
			$filterType = $GLOBALS['filterType'];

		$oView = CreateObject('dcl.boView');
		$o = CreateObject('dcl.dbChklst');

		$oView->table = 'dcl_chklst';
		$oView->style = 'report';
		$oView->title = STR_CHK_INITIATEDCHECKLISTS;
		$oView->AddDef('columnhdrs', '', array(STR_CMMN_ID, STR_CHK_SUMMARY, STR_CHK_STATUS));
		$oView->AddDef('columns', '', array('dcl_chklst_id', 'dcl_chklst_summary', 'dcl_chklst_status'));
		if ($filterStatus != '')
			$oView->AddDef('filter', 'dcl_chklst_status', $filterStatus);
		if ($filterType != '')
			$oView->AddDef('filter', 'dcl_chklst_tpl_id', $filterType);

		$oHtml = CreateObject('dcl.htmlChecklistsView');
		$oHtml->Render($oView);
	}

	function add()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
		{
			PrintPermissionDenied();
			return;
		}
		$o = CreateObject('dcl.dbChklstTpl');
		$o->Connect();
		if ($o->Load($GLOBALS['dcl_chklst_tpl_id']) != -1)
		{
			$t = CreateTemplate(array('hForm' => 'htmlNewChecklist.tpl'));
			$t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
			$t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
			$t->set_var('VAL_FORMACTION', menuLink());
			$t->set_var('BTN_SAVE', STR_CMMN_SAVE);
			$t->set_var('BTN_RESET', STR_CMMN_RESET);
			$t->set_var('VAL_TPLID', $GLOBALS['dcl_chklst_tpl_id']);
			$t->set_var('VAL_TPLNAME', $o->dcl_chklst_tpl_name);
			$t->set_var('TXT_TITLE', STR_CHK_INITIATECHECKLIST);
			$t->set_var('TXT_TEMPLATE', STR_CHK_TEMPLATE);
			$t->set_var('TXT_SUMMARY', STR_CHK_SUMMARY);
			$t->set_var('VAL_SUMMARY', '');

			$hiddenvars = GetHiddenVar('menuAction', 'boChecklists.dbadd');
			$hiddenvars .= GetHiddenVar('dcl_chklst_tpl_id', $o->dcl_chklst_tpl_id);
			$t->set_var('HIDDEN_VARS', $hiddenvars);

			$t->pparse('out', 'hForm');
		}
		else
			printf(STR_CHK_ERRLOADINGTPLID, $GLOBALS['dcl_chklst_tpl_id']);
	}

	function SetAutoValue(&$oXML, $sElement, $sAttribute, $sAttributeValue, $sValue)
	{
		$oXML->ClearList();
		$oXML->ListNodes($oXML->root, $sElement, $sAttribute, $sAttributeValue);
		if (count($oXML->nodes) > 0)
		{
			for ($i = 0; $i < count($oXML->nodes); $i++)
			{
				$oNode = &$oXML->nodes[$i];
				$oXML->FindChildNode($oNode, 'Value');
				if ($oXML->currentNode != NULL)
				{
					$oXML->currentNode->data = $sValue;
				}
				else
				{
					$nextID = count($oNode->childNodes);
					$oNode->childNodes[$nextID] = &CreateObject('dcl.xmlNode');
					$oNode->childNodes[$nextID]->name = 'Values';
					$oNode->childNodes[$nextID]->childNodes[0] = &CreateObject('dcl.xmlNode');
					$oNode->childNodes[$nextID]->childNodes[0]->name = 'Value';
					$oNode->childNodes[$nextID]->childNodes[0]->data = $sValue;
				}
			}
		}
	}

	function SetNodeValue(&$oXML, $sNodeName, $sNodeValue)
	{
		$oXML->FindChildNode($oXML->root, $sNodeName);
		if ($oXML->currentNode != NULL)
			$oXML->currentNode->data = $sNodeValue;
	}

	function dbadd()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
		{
			PrintPermissionDenied();
			return;
		}

		$tpl = CreateObject('dcl.boChecklistTpl');
		$tplFilePath = $tpl->GetTplPath($GLOBALS['dcl_chklst_tpl_id']);
		$oXML = CreateObject('dcl.xmlDoc');
		$oXML->ParseFile($tplFilePath);
		$oXML->FindChildNode($oXML->root, 'CurrentState');

		$oTpl = CreateObject('dcl.dbChklstTpl');
		$oTpl->Connect();
		if ($oTpl->Load($GLOBALS['dcl_chklst_tpl_id']) == -1)
			return;

		if ($oTpl->dcl_chklst_tpl_active != 'Y')
		{
			print(STR_CHK_TEMPLATEISINACTIVE);
			return;
		}

		$o = CreateObject('dcl.dbChklst');
		$o->Connect();
		$o->dcl_chklst_tpl_id = $GLOBALS['dcl_chklst_tpl_id'];
		$o->dcl_chklst_summary = $o->GPCStripSlashes($GLOBALS['dcl_chklst_summary']);
		$o->dcl_chklst_createby = $GLOBALS['DCLID'];
		if ($oXML->currentNode != NULL)
			$o->dcl_chklst_status = $oXML->currentNode->data;

		$o->Add();
		if ($o->dcl_chklst_id > 0)
		{
			$this->SetAutoValue($oXML, 'Field', 'type', 'createby', $GLOBALS['DCLNAME']);
			$this->SetAutoValue($oXML, 'Field', 'type', 'createdate', date('Y-m-d'));
			$this->SetAutoValue($oXML, 'Field', 'type', 'autoincrement', $o->dcl_chklst_id);
			$this->SetNodeValue($oXML, 'InitiatedBy', $GLOBALS['DCLNAME']);
			$this->SetNodeValue($oXML, 'InitiatedOn', date('Y-m-d'));

			$initFilePath = $this->GetChklstPath($o->dcl_chklst_id, true);
			if ($oXML->ToFile($initFilePath))
			{
				$this->showform($o->dcl_chklst_id);
			}
			else
			{
				// couldn't copy it, so remove the record...
				$o->Delete();
				print(STR_CHK_COULDNOTCOPYTPL);
			}
		}
		else
			print(STR_CHK_ERRORDATABASEENTRY);
	}

	function modify()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_ADD_WO']))
		{
			PrintPermissionDenied();
			return;
		}
		$this->showform($GLOBALS['dcl_chklst_id']);
	}

	function showform($id, $bIsView = false)
	{
		$oCL = CreateObject('dcl.htmlChecklistForm');
		$oCL->show($id, $this->GetChklstPath($id), $bIsView);
	}

	function dbmodify()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
		{
			PrintPermissionDenied();
			return;
		}
		$oCL = CreateObject('dcl.htmlChecklistForm');
		$sFilePath = $this->GetChklstPath($GLOBALS['dcl_chklst_id']);
		$oCL->xml = CreateObject('dcl.xmlDoc');
		$oCL->xml->ParseFile($sFilePath);
		$oCL->UpdateNodes($oCL->xml->root);
		$this->AddChange($oCL->xml, $GLOBALS['DCLNAME'], date('Y-m-d'), $GLOBALS['dcl_chklst_state']);
		$this->SetNodeValue($oCL->xml, 'CurrentState', $GLOBALS['dcl_chklst_status']);
		$oCL->xml->ToFile($sFilePath);

		$o = CreateObject('dcl.dbChklst');
		$o->Connect();
		if ($o->Load($GLOBALS['dcl_chklst_id']) != -1)
		{
			$o->dcl_chklst_modifyby = $GLOBALS['DCLID'];
			$o->dcl_chklst_modifyon = date($dcl_info['DCL_TIMESTAMP_FORMAT_DB']);
			$o->dcl_chklst_status = $GLOBALS['dcl_chklst_status'];
			$o->Edit();
		}

		$this->show();
	}

	function delete()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
		{
			PrintPermissionDenied();
			return;
		}
		$o = CreateObject('dcl.dbChklst');
		$o->Connect();
		if ($o->Load($GLOBALS['dcl_chklst_id']) != -1)
			ShowDeleteYesNo('Checklist', 'boChecklists.dbdelete', $o->dcl_chklst_id, $o->dcl_chklst_summary, false, 'dcl_chklst_id');
	}

	function dbdelete()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
		{
			PrintPermissionDenied();
			return;
		}

		$o = CreateObject('dcl.dbChklst');
		$o->Connect();
		$o->dcl_chklst_id = $GLOBALS['dcl_chklst_id'];
		$o->Delete();
		$filePath = $this->GetChklstPath($GLOBALS['dcl_chklst_id']);
		if (is_file($filePath) && is_readable($filePath))
			unlink($filePath);

		$this->show();
	}

	function view()
	{
		commonHeader();
		$this->showform($GLOBALS['dcl_chklst_id'], true);
	}

	function AddChange(&$oXML, $sBy, $sOn, $sState)
	{
		$oXML->FindChildNode($oXML->root, 'Changes');
		if ($oXML->currentNode != NULL)
		{
			$a = array('ChangeBy' => $sBy, 'ChangeOn' => $sOn, 'ChangeState' => $sState);
			$o = CreateObject('dcl.xmlNode');
			$o->name = 'Change';
			$nextid = 0;
			while (list($k, $v) = each($a))
			{
				$o->childNodes[$nextid] = &CreateObject('dcl.xmlNode');
				$o->childNodes[$nextid]->name = $k;
				$o->childNodes[$nextid]->data = $v;
				$nextid++;
			}
			$oXML->currentNode->childNodes[] = &$o;
		}
	}
}
?>
