<?php
/*
 * $Id: class.boTimecards.inc.php,v 1.4.2.2.2.4 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');

class boTimecards
{
	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlTimeCardForm');
		$obj->Show($GLOBALS['jcn'], $GLOBALS['seq']);

		$objWO = CreateObject('dcl.htmlWorkOrderDetail');
		$objWO->Show($GLOBALS['jcn'], $GLOBALS['seq']);
	}

	function dbadd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$objTimecard = CreateObject('dcl.dbTimeCards');
		$objWorkorder = CreateObject('dcl.dbWorkorders');
		$oStatus = CreateObject('dcl.dbStatuses');

		$objTimecard->Connect();
		$objTimecard->InitFromGlobals();
		$objWorkorder->Connect();
		$objWorkorder->Load($objTimecard->jcn, $objTimecard->seq);
		$status = $objWorkorder->status;
		$objTimecard->Add();
		$notify = '4';
		if ($status != $objTimecard->status)
		{
			$notify .= ',3';
			if ($oStatus->GetStatusType($objTimecard->status) == 2)
				$notify .= ',2';
			elseif ($oStatus->GetStatusType($objTimecard->status) == 1)
				$notify .= ',1';
		}

		$objWtch = CreateObject('dcl.boWatches');
		// Reload before sending since time card modifies the work order
		$objWorkorder->Load($objTimecard->jcn, $objTimecard->seq);
		$objWtch->sendNotification($objWorkorder, $notify);

		$objWO = CreateObject('dcl.htmlWorkOrderDetail');
		$objWO->Show($objTimecard->jcn, $objTimecard->seq);
	}

	function batchadd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		if (IsSet($GLOBALS['selected']) && is_array($GLOBALS['selected']) && count($GLOBALS['selected']) > 0)
		{
			$objTC = CreateObject('dcl.htmlTimeCardForm');
			$objTC->Show(-1, -1, '', $GLOBALS['selected']);

			$obj = CreateObject('dcl.htmlTimeCards');
			$obj->ShowBatchWO();
		}
		else
		{
			if (EvaluateReturnTo())
				return;

			$objView = CreateObject('dcl.boView');
			$objView->SetFromURL();
			$objH = CreateObject('dcl.htmlWorkOrderResults');
			$objH->Render($objView);
		}
	}

	function dbbatchadd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
		{
			PrintPermissionDenied();
			return EvaluateReturnTo();
		}

		$objTimecard = CreateObject('dcl.dbTimeCards');
		$objTimecard->Connect();
		$objTimecard->InitFromGlobals();
		$objWorkorder = CreateObject('dcl.dbWorkorders');
		$objWorkorder->Connect();
		$objWtch = CreateObject('dcl.boWatches');
		if (IsSet($GLOBALS['selected']) && is_array($GLOBALS['selected']) && count($GLOBALS['selected']) > 0)
		{
			while (list($key, $val) = each($GLOBALS['selected']))
			{
				list($objTimecard->jcn, $objTimecard->seq) = explode('.', $val);
				$objWorkorder->Load($objTimecard->jcn, $objTimecard->seq);
				$status = $objWorkorder->status;
				$objTimecard->Add();
				$notify = '4';
				if ($status != $objTimecard->status)
				{
					$notify .= ',3';
					$oStatus = CreateObject('dcl.dbStatuses');
					$oStatus->Connect();
					if ($oStatus->GetStatusType($objTimecard->status) == 2)
						$notify .= ',2';
					elseif ($oStatus->GetStatusType($objTimecard->status) == 1)
						$notify .= ',1';
				}

				// Reload before sending since time card modifies the work order
				$objWorkorder->Load($objTimecard->jcn, $objTimecard->seq);
				$objWtch->sendNotification($objWorkorder, $notify, false);
			}
		}

		if (EvaluateReturnTo())
			return;

		$objView = CreateObject('dcl.boView');
		$objView->SetFromURL();
		$objH = CreateObject('dcl.htmlWorkOrderResults');
		$objH->Render($objView);
	}

	function modify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$objTC = CreateObject('dcl.dbTimeCards');
		$objTC->Connect();
		$objTC->Load($GLOBALS['id']);

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($objTC->jcn, $objTC->seq, $objTC->id);
	}

	function dbmodify()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$objTC = CreateObject('dcl.dbTimeCards');
		$objTC->Connect();
		$objOldTC = CreateObject('dcl.dbTimeCards');
		$objOldTC->Connect($objTC->conn);
		$objTC->InitFromGlobals();
		$objOldTC->Load($objTC->id);

		// If the hours change, we'll need to adjust the workorder
		$hoursDiff = $objTC->hours - $objOldTC->hours;

		$objWO = CreateObject('dcl.dbWorkorders');
		$objWO->Connect($objTC->conn);
		$objWO->Load($objTC->jcn, $objTC->seq);
		$woChanged = false;
		$lastWO = false;

		// See if any time cards were issued after this one.  If not, assume
		// that this time card was the last one entered and affected the work order
		// status when input.  In other words, adjust as needed.
		$objQueryTC = CreateObject('dcl.dbTimeCards');
		$objQueryTC->Connect($objTC->conn);
		if ($objQueryTC->Query(sprintf('SELECT id FROM timecards WHERE id > %d AND jcn=%d AND seq=%d', $objTC->id, $objTC->jcn, $objTC->seq)) != -1)
		{
			$lastWO = !($objQueryTC->next_record());
		}

		$notify = '4';

		$oStatus = CreateObject('dcl.dbStatuses');
		$oStatus->Connect();

		if ($objTC->status != $objOldTC->status)
		{
			$notify .= ',3';

			if ($lastWO)
			{
				// We're the last one!  This does (of course) assume that time cards
				// are entered sequentially in correct chronological order.
				if ($objTC->status != $objWO->status)
				{
					$objWO->status = $objTC->status;
					$objWO->statuson = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
					$woChanged = true;
					if ($oStatus->GetStatusType($objTC->status) == 2)
					{
						$objWO->closedby = $objTC->actionby;
						$objWO->closedon = $objTC->actionon;
						$objWO->etchours = 0.0;

						$notify .= ',2';
					}
				}
			}
			else
			{
				// Don't allow status change if more are left.  Last time card controls status of WO
				$objTC->status = $objOldTC->status;
			}
		}

		if ($hoursDiff != 0)
		{
			$objWO->totalhours += $hoursDiff;
			$woChanged = true;
		}

		// Only look at it if it is the last time card.  The last time card controls etc for the WO
		if ($lastWO && $objWO->etchours != $GLOBALS['etchours'])
		{
			$woChanged = true;
			if ($oStatus->GetStatusType($objWO->status) != 2) // Only change it if it is not closed
				$objWO->etchours = $GLOBALS['etchours'];
			else
				$objWO->etchours = 0.0;
		}

		if ($woChanged)
			$objTC->BeginTransaction();

		$objTC->Edit();

		if ($woChanged)
		{
			$objWO->edit();
			$objTC->EndTransaction();
		}

		$objWtch = CreateObject('dcl.boWatches');
		$objWtch->sendNotification($objWO, $notify);

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($objTC->jcn, $objTC->seq);
	}

	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		$objTC = CreateObject('dcl.dbTimeCards');
		$objTC->Connect();
		$objTC->Load($GLOBALS['id']);

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($objTC->jcn, $objTC->seq, $objTC->id, true);
	}

	function dbdelete()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		$objTC = CreateObject('dcl.dbTimeCards');
		$objTC->Connect();
		$objTC->Load($GLOBALS['id']);

		$objWO = CreateObject('dcl.dbWorkorders');
		$objWO->Connect($objTC->conn);
		$objWO->Load($objTC->jcn, $objTC->seq);

           // Get the next time card issued after this one.  If not, assume
           // that this time card was the last one entered and affected the work order
           // status when input.
		$objQueryTC = CreateObject('dcl.dbTimeCards');
		$objQueryTC->Connect($objTC->conn);
		$query = sprintf('SELECT min(id) FROM timecards WHERE id > %d AND jcn=%d AND seq=%d', $objTC->id, $objTC->jcn, $objTC->seq);
		if ($objQueryTC->Query($query) != -1)
		{
			$objQueryTC->next_record();
			if (!is_array($objQueryTC->Record) || $objQueryTC->IsFieldNull(0) || $objQueryTC->f(0) < 1)
			{
				// OK, we're the last time card input, therefore we control status.
				// See if any time cards were input before this one.  If so,
				// try to revert to the previous time card status.  Otherwise, open it.
				if ($objQueryTC->Query(sprintf('SELECT max(id) FROM timecards WHERE id < %d AND jcn=%d AND seq=%d', $objTC->id, $objTC->jcn, $objTC->seq)) != -1)
				{
					$objQueryTC->next_record();
					if (is_array($objQueryTC->Record) && $objQueryTC->IsFieldNull(0) == false && $objQueryTC->f(0) > 0)
					{
						$objQueryTC->Load($objQueryTC->f(0));
						if ($objQueryTC->status != $objWO->status)
						{
							$objWO->statuson = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
							$oStatus = CreateObject('dcl.dbStatuses');
							$oStatus->Connect();
							if ($oStatus->GetStatusType($objQueryTC->status) == 2 && $oStatus->GetStatusType($objWO->status) != 2)
							{
								$objWO->closedby = $objQueryTC->actionby;
								$objWO->closedon = $objQueryTC->actionon;
								$objWO->etchours = 0.0;
							}
							else if ($oStatus->GetStatusType($objWO->status) == 2)
							{
								$objWO->closedby = 0;
								$objWO->closedon = '';
							}

							$objWO->status = $objQueryTC->status;
						}
					}
					else
					{
						$objWO->status = $dcl_info['DCL_DEF_STATUS_ASSIGN_WO']; // Open it
						$objWO->statuson = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
						$objWO->closedby = 0;
						$objWO->closedon = '';
						$objWO->lastactionon = '';
						$objWO->etchours = $objWO->esthours;
					}
				}
			}
			else
			{
				$objQueryTC->Load($objQueryTC->f(0));
				$objWO->starton = $objQueryTC->actionon;
			}
		}

		$objWO->totalhours -= $objTC->hours;

		$objTC->BeginTransaction();
		$objTC->Delete();
		$objWO->Edit();
		$objTC->EndTransaction();

		print('<center>');
		PrintWithChocoFont(sprintf(STR_BO_TIMECARDDELETED, $objTC->id, $objWO->jcn, $objWO->seq));
		print('</center>');

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($objTC->jcn, $objTC->seq);
	}
}
?>
