<?php
/*
 * $Id: class.dbWiki.inc.php,v 1.1.2.3 2003/08/11 01:51:04 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class dbWiki extends dclDB
{
	var $dcl_entity_type_id;
	var $dcl_entity_id;
	var $dcl_entity_id2;
	var $page_name;
	var $page_text;
	var $page_date;
	var $page_ip;
	var $table;

	function dbWiki()
	{
           // Table Fields
		$this->fieldArray = array(
				'dcl_entity_type_id',
				'dcl_entity_id',
				'dcl_entity_id2',
				'page_name',
				'page_text',
				'page_date',
				'page_ip'
			);

		$this->table = 'dcl_wiki';

           // Foreign Keys
		$this->foreignKeys = array();

		$this->cacheEnabled = true;
		$this->dclDB();
	}

	function Add()
	{
		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$query  = 'INSERT INTO ' . $this->table . " (dcl_entity_type_id, dcl_entity_id, dcl_entity_id2, page_name, page_text, page_date, page_ip) Values (";
		$query .= $this->dcl_entity_type_id . ',';
		if ($this->dcl_entity_type_id == DCL_ENTITY_GLOBAL)
		{
			$query .= '0,0,';
		}
		else
		{
			$query .= $this->dcl_entity_id . ',';
			if ($this->dcl_entity_type_id == DCL_ENTITY_WORKORDER)
				$query .= $this->dcl_entity_id2 . ',';
			else
				$query .= '0,';
		}

		$query .= "'" . $this->DBAddSlashes($this->page_name) . "','";
		$query .= $this->DBAddSlashes($this->page_text) . "',";
		$query .= $this->GetDateSQL() . ",'";
		$query .= $this->DBAddSlashes($this->page_ip) . "')";

		if ($this->Insert($query) == -1)
		{
			print(sprintf('Could not add new wiki page! %s', $query));
			return -1;
		}

		return 0;
	}

	function Edit()
	{
		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$query  = 'UPDATE ' . $this->table . ' SET ';
		$query .= 'page_text=\'' . $this->DBAddSlashes($this->page_text);
		$query .= "', page_date=" . $this->GetDateSQL();
		$query .= ", page_ip='" . $this->DBAddSlashes($this->page_ip) . "'";
		$query .= " Where page_name = '" . $this->DBAddSlashes($this->page_name);
		$query .= "' And dcl_entity_type_id = " . $this->dcl_entity_type_id;
		if ($this->dcl_entity_type_id != DCL_ENTITY_GLOBAL)
		{
			// Is specific to an entity, not global
			$query .= " And dcl_entity_id = " . $this->dcl_entity_id;

			// Work orders will have another ID
			if ($this->dcl_entity_type_id == DCL_ENTITY_WORKORDER)
				$query .= " And dcl_entity_id2 = " . $this->dcl_entity_id2;
		}

		return $this->Execute($query);
	}

	function Delete()
	{
		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$query = 'delete from ' . $this->table . " where page_name='";
		$query .= $this->DBAddSlashes($this->page_name);
		$query .= "' And dcl_entity_type_id = " . $this->dcl_entity_type_id;
		if ($this->dcl_entity_type_id != DCL_ENTITY_GLOBAL)
		{
			// Is specific to an entity, not global
			$query .= " And dcl_entity_id = " . $this->dcl_entity_id;

			// Work orders will have another ID
			if ($this->dcl_entity_type_id == DCL_ENTITY_WORKORDER)
				$query .= " And dcl_entity_id2 = " . $this->dcl_entity_id2;
		}

		$this->Execute($query);
	}

	function GetRow()
	{
		$this->Clear();

		if (!$this->res || count($this->Record) < 1)
			return -1;

		$this->dcl_entity_type_id = $this->f('dcl_entity_type_id');
		$this->dcl_entity_id = $this->f('dcl_entity_id');
		$this->dcl_entity_id2 = $this->f('dcl_entity_id2');
		$this->page_name = $this->f('page_name');
		$this->page_text = $this->f('page_text');
		$this->page_date = $this->FormatTimestampForDisplay($this->f('page_date'));
		$this->page_ip = $this->f('page_ip');
	}

	function Load($iType = DCL_ENTITY_GLOBAL, $iID = 0, $iID2 = 0, $sName = 'FrontPage')
	{
		global $dcl_info, $dcl_domain, $dcl_domain_info;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT dcl_entity_type_id, dcl_entity_id, dcl_entity_id2, page_name, page_text, ';
		$sql .= $this->ConvertTimestamp('page_date', 'page_date');
		$sql .= ', page_ip From ' . $this->table . " Where page_name='$sName'";
		$sql .= " AND dcl_entity_type_id = $iType";
		if ($iType != DCL_ENTITY_GLOBAL)
		{
			$sql .= " AND dcl_entity_id = $iID";
			if ($iType == DCL_ENTITY_WORKORDER)
				$sql .= " AND dcl_entity_id2 = $iID2";
		}

		if (!$this->Query($sql))
			return -1;

		if ($this->next_record())
			return $this->GetRow();

		return -1;
	}

	function ListRecentChanges($iType = DCL_ENTITY_GLOBAL, $iID = 0, $iID2 = 0)
	{
		$query = sprintf('SELECT page_name, %s, page_ip FROM %s Where dcl_entity_type_id = %d',
							$this->ConvertTimestamp('page_date', 'page_date'), $this->table, $iType);
		if ($iType != DCL_ENTITY_GLOBAL)
		{
			$query .= " AND dcl_entity_id = $iID";
			if ($iType == DCL_ENTITY_WORKORDER)
				$query .= " AND dcl_entity_id2 = $iID2";
		}

		$query .= ' ORDER BY page_date DESC';
		return $this->Query($query);
	}

	function Clear()
	{
		$this->dcl_entity_type_id = 0;
		$this->dcl_entity_id = 0;
		$this->dcl_entity_id2 = 0;
		$this->page_name = '';
		$this->page_text = '';
		$this->page_date = '';
		$this->page_ip = '';
	}
}
?>
