#ifndef __symboltable_h__
#define __symboltable_h__


#include "dictionary.h"
#include "stack.h"


/** Maximum number of symbols. */
#define SYMBOLS 256

/** Maximum number of parameters. */
#define PARAMETERS 4

/** This symbol is a method. */
#define METHOD 0x2000

/** This symbol is an array. */
#define ARRAY 0x4000


/** Decaf symbol. */
typedef struct {
	/** Block in which this symbol was defined. */
	int block;

	/** Type of this symbol. Top element is the definition currently
	 * in scope (if any). */
	Stack type;

	/** Number of parameters this method takes. */
	int count;

	/** Types of parameters. */
	int parameters[PARAMETERS];
} Symbol;


/** Table of Decaf symbols. */
typedef struct {
	/** Symbol table. */
	Dictionary dictionary;

	/** Symbol definitions. */
	Symbol symbols[SYMBOLS];
} SymbolTable;


void clear_symboltable( SymbolTable* table);
void add_symbol( SymbolTable* table, const char* name,
		int depth, int type);
void remove_symbol( SymbolTable* table, const char* name);
Symbol* find_symbol( SymbolTable* table, const char* name);


#endif
