#ifndef __dictionary_h__
#define __dictionary_h__


/** Key-ID pair. */
typedef struct Entry {
	/** Key. */
	const char* key;

	/** Value. */
	int id;
} Entry;


/** Dictionary. */
typedef struct {
	/** Number of entries allocated. */
	int max;

	/** Number of entries. */
	int count;

	/** Dictionary sorted by keys. */
	struct Entry* entries;

	/** Dictionary sorted by values. */
	const char** keys;
} Dictionary;


void print_dictionary( const Dictionary* dictionary);
void clear_dictionary( Dictionary* dictionary);
void destroy_dictionary( Dictionary* dictionary);
int find( const Dictionary* dictionary, const char* key);
int insert( Dictionary* dictionary, const char* key);
const char* get_key( const Dictionary* dictionary, int id);


#endif
#ifndef __tree_h__
#define __tree_h__


/** Maximum number of children per node. */
#define MAX_CHILDREN 16


/** Parse tree. */
typedef struct Tree {
	/** Data. */
	int data;
	/** Number of children. */
	int count;
	/** Children. */
	struct Tree* children[MAX_CHILDREN];
} Tree;


Tree* create_node( int data);
void destroy_tree( Tree* tree);
void print_tree( Tree* tree);


#endif
#ifndef __parsetree_h__
#define __parsetree_h__


#ifndef __dictionary_h__
# include "dictionary.h"
#endif

#ifndef __tree_h__
# include "tree.h"
#endif

#include <stdio.h>


/** Token of this node. */
#define $token tree->data

/** Length of the right-hand-side of this production. */
#define $length tree->count

/** Lexeme associated with this terminal. */
#define $lexeme ((char*)(tree->children[0]->data))

/** Synthesised attribute of this node. */
#define $$(f) (f(tree,in))

/** Synthesised value of the nth child. */
#define $(child,f) (f(tree->children[child-1],in))

/** Calls the specified function for all children. */
#define $all(f) { int i; for( i = 1; i <= $length; i++) $(i,f); }

/** Returns the sum of all the synthesied values. */
#define $sum(f) ({ int i, sum = 0; for( i = 1; i <= $length; i++) \
	sum += $(i,f); sum; })

/** Returns the max of all the synthesied values. */
#define $max(f) ({ int i, best = 0; for( i = 1; i <= $length; i++) { \
	int tmp = $(i,f); if( tmp > best) best = tmp; } best; })

void destroy_parse_tree( Tree* tree);
void print_parse_tree( const Tree* tree, const Dictionary* symbols);
Tree* read_parse_tree( FILE* file, const Dictionary* symbols);
void print_lexemes( const Tree* tree);


/** Returns this token. */
static inline int
token( const Tree* tree, const void* in)
{
	(void)in;
	return tree->data;
}


/** Returns this lexeme. */
static inline const char*
lexeme( const Tree* tree, const void* in)
{
	(void)in;
	return (char*)tree->children[0]->data;
}


#endif
