/* utils.h
 * Header file for functions useful across the different modules of
 * drawing and non-drawing code.
 *
 * also includes useful constants
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller
 */

#include <gtk/gtk.h>
#include <denemo/denemo.h>

#define LINE_SPACE 10
#define HALF_LINE_SPACE 5
#define NO_OF_LINES 5
#define STAFF_HEIGHT LINE_SPACE * (NO_OF_LINES - 1)
#define MID_STAFF_HEIGHT 2*LINE_SPACE
#define LEFT_MARGIN 20
#define KEY_MARGIN (LEFT_MARGIN+35)
#define SPACE_FOR_TIME 30
#define RIGHT_MARGIN 20
#define SPACE_FOR_BARLINE 10
#define HALF_BARLINE_SPACE 5
#define WHOLE_NUMTICKS 1536

/* Wrapper macro for creating bitmaps */

#define bitmaphelper(widget, name) \
   gdk_bitmap_create_from_data (NULL, \
                                (gchar *) name##_bits, \
                                name##_width, name##_height)

/* Adds a callback that processes the "activate" signal coming from
 * a widget */

#define processenter(entry, callback,  cbdata, dialog)\
  gtk_signal_connect(GTK_OBJECT(entry), "activate", \
		     GTK_SIGNAL_FUNC(callback), \
		     &cbdata); \
  if (dialog) \
    gtk_signal_connect_object (GTK_OBJECT (entry), "activate", \
	  		       GTK_SIGNAL_FUNC(gtk_widget_destroy), \
			       GTK_OBJECT (dialog))
  

void
drawbitmapinverse (GdkPixmap *pixmap, GdkGC *gc, GdkBitmap *mask,
		   gint x, gint y, gint width, gint height);

/* Gives space after a note or rest */

gint
space_after (gint numticks, gint wholenotewidth);

/* Returns height of a note based on what the note is and and the current
 * clef context */

gint
calculateheight (gint mid_c_offset, gint dclef);

/* Translates a mid_c_offset into 0 (c) through 6 (b). Useful for
 * getting accidentals to persist */

gint
offsettonumber (gint n);

gchar
mid_c_offsettoname (gint mid_c_offset);

gint
mid_c_offsettooctave (gint mid_c_offset);

void 
set_grace_numticks(mudelaobject *theobj, gint multiplier);

void
set_tuplefied_numticks (mudelaobject *theobj, gint numerator,
			 gint denominator);

void
set_basic_numticks (mudelaobject *theobj);

void
setpixelmin (mudelaobject *theobj);

void
freeit (gpointer data, gpointer user_data);
