/******************************************************************************
*									      *
*	File:     statusmsg.c						      *
*	Author:   Wolfgang Rupprecht <wolfgang@capsicum.wsrcc.com>	      *
*	Created:  Tue Aug 24 12:40:49 PDT 1999				      *
*	Contents: process status_msgs                                         *
*									      *
*	Copyright (c) 1999 Wolfgang Rupprecht.				      *
*	All rights reserved.						      *
*									      *
*	$Id: statusmsg.c,v 1.2 1999/08/24 20:58:26 wolfgang Exp $								      *
******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "config.h"
#include "rtcm.h"

void
status_byte(u_char b)
{
    static u_char   buffer[32];
    static u_char  *ptr = buffer;

    /*    printf("-\tstatus\t-\t%d 0x%x\n", b, b); */

    if (ptr >= (buffer + sizeof(buffer))) {	/* overflowing? roll buffer */
	ptr = buffer;
    }
    *ptr++ = b;
    switch (*buffer) {
    case 0xc1:
	if ((ptr - buffer) >= 6) {/* 6-byte request confirmation */
	    u_int           freq;
	    u_int           baud;

	    freq = ((buffer[1] & 0x3f) << 6) | (buffer[2] & 0x3f);
	    switch (buffer[3]) {
	    case 0xd4:
		baud = 25;
		break;
	    case 0xd5:
		baud = 50;
		break;
	    case 0xd6:
		baud = 100;
		break;
	    case 0xd7:
		baud = 200;
		break;
	    default:
		baud = 0;
		break;
	    }
	    printf("f\t%d\t%d\n", freq, baud);
	    ptr = buffer;	/* reset buffer */
	}
	break;
    case 0xc8:
	if ((ptr - buffer) >= 4) {/* 4-byte request status */
	    u_int           stren;
	    u_int           snr;

	    stren = ((buffer[1] & 0x3f) << 6) | (buffer[2] & 0x3f);
	    snr = buffer[3] & 0x3f;
	    printf("s\t%d\t%d\n", stren, snr);
	    ptr = buffer;	/* reset buffer */
	}
	break;
    default:			/* unknown -- punt */
#ifdef DEBUG
	printf("-\tstatus\t-\t%d\t0x%x\n", b, b);
#endif
	ptr = buffer;		/* reset buffer */
	break;
    }
}
