/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

enum e_librerias {LX11=0,
					LGETTEXT,
					LGLIB2, //all libraries that are no configured with pkg-config must be before here. LGLIB2 must be the first librarie after them.
					LGTK2,
					LGOBJECT2,
					LGMODULE2,
					LGTHREAD2,
					LESD,
					LAUDIOFILE,
					LXML2,
					LGNOME2,
					LGNOMEUI2,
					LBONOBO2,
					LBONOBOUI2,
					LBONOBO_ACTIVATION2,
					LGNOMEPRINT2,
					LGNOMEPRINTUI2,
					LGNOME_MIME_DATA2,
					LPANGO,
					LPANGOXFT,
					LPANGOFT2,
					LGNOME_VFS2,
					LGNOME_VFS_MODULE2,
					LORBIT2,
					LORBIT_COSNAMING2,
					LLINC,
					LGDK2,
					LGDK_X112,
					LGDK_PIXBUF2,
					LGDK_PIXBUF_XLIB2,
					LATK,
					LGCONF2,
					LGNOMECANVAS2,
					LLIBART2,
					LLIBGLADE2,
					LGTK_X112,
					LIMLIB,
					LIMLIBGDK,
					LPANGOX,
					LTOTALES,
					LELECTRIC_FENCE}; // only this lib can go after LTOTALES, any other lib must go before LTOTALES

struct s_proyecto
{
	xmlDocPtr xml;
	xmlDocPtr xml_viejo;
	gchar *archivo;
};

enum e_encoding {	UTF8= 0,
						LOCALE};

//*******************************************************************

struct s_proyecto proyecto;
GtkWidget *ventana_propiedades_proyecto;
GtkWidget *ventana_seleccion_proyecto;
gboolean pro_forzando_librerias;
gchar *pro_proyecto_cargar;
gboolean pro_dependencias_librerias[LTOTALES][LTOTALES];
gchar *pro_nombre_librerias_xml[LTOTALES];
gchar *pro_nombre_botones_librerias[LTOTALES];
gchar *pro_nombre_librerias_autoconf[LTOTALES];
gchar *pro_nombre_librerias[LTOTALES];
gboolean project_has_glade_file;

//*******************************************************************

void pro_inicializar(void);

void pro_crear(void);

void pro_actualizar(GtkWidget *widget);

void pro_mostrar(GtkWidget *widget);

void pro_guardar(void);

gint pro_abrir(void);

void pro_anadir(gchar *nombre);

gchar *pro_nombre(gint encoding);

gchar *pro_fuentes(xmlNodePtr *xmlnode, gint encoding);

gchar *pro_cabeceras(xmlNodePtr *xmlnode, gint encoding);

gchar *pro_otros(xmlNodePtr *xmlnode, gint encoding);

gchar *pro_nombre_completo_archivo(gchar *nombre,gboolean cambiar_directorio, gint encoding);

gchar *pro_librerias_lincado(void);

gchar *pro_opciones_compilacion(void);

void pro_eliminar(gchar *nombre);

gboolean pro_existe_archivo(gchar *nombre);

gchar *pro_version(void);

gchar *pro_lenguaje(void);

gchar *pro_librerias_usuario(void);

gchar *pro_opciones_cflags(void);

gchar *pro_includes(void);

gchar *pro_warnings(void);

gchar *pro_srcdir(gint encoding);

gchar *pro_prodir(gint encoding);

gchar *pro_pixdir(gint encoding);

gchar *pro_datadir(gint encoding);

gchar *pro_docdir(gint encoding);

gchar *pro_glade_file(gint encoding);

gchar *pro_ejecutable(gint encoding);

gchar *pro_cabecera_gnu(void);

gboolean pro_crear_h(void);

gboolean pro_defines(void);

void pro_actualizar_librerias_lincado(GtkWidget *widget);

void pro_mostrar_librerias_lincado(GtkWidget *widget);

void pro_modificar_dependencias_librerias(gint libreria);

gchar *pro_idiomas(void);

gint pro_update_open_tabs (void);

gchar *pro_cvsroot(void);

gchar *pro_compresion_cvs(void);

gchar *pro_modulo_cvs(void);

gboolean pro_autoupdate_cvs(void);

gboolean pro_autoaddremove_cvs(void);

gboolean pro_cvs_activo(void);
