# ZCTEST 1.0
# $Id: nameserver.rb,v 1.1.1.1 2004/08/11 18:51:04 sdalu Exp $

# 
# CONTACT     : http://www.dnsdoctor.org/
# AUTHOR      : Stephane D'Alu <sdalu@nic.fr>
#
# CREATED     : 2002/08/02 13:58:17
# REVISION    : $Revision: 1.1.1.1 $ 
# DATE        : $Date: 2004/08/11 18:51:04 $
#
# CONTRIBUTORS: (see also CREDITS file)
#
#
# LICENSE     : GPL v2
# COPYRIGHT   : AFNIC (c) 2003
#
# This file is part of DNSdoctor.
#
# DNSdoctor is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DNSdoctor is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DNSdoctor; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

require 'framework'

module CheckNameServer
    ##
    ## Check accessibility of nameserver
    ## 
    ## - these tests are performed without contacting the nameserver
    ##   (see modules CheckNetworkAddress for that)
    ##
    class ServerAccess < Test
	with_msgcat 'test/nameserver.%s'

	BOGON_IP = Address::IPv4::create('127.0.0.2')

	#-- Initialization ------------------------------------------
	def initialize(*args)
	    super(*args)

	    @cache.create(:ip)
	end

	#-- Shortcuts -----------------------------------------------
	def ip(ns)
	    @cache.use(:ip, ns) {
		@domain.ns.assoc(ns)[1] }
	end

	#-- Checks --------------------------------------------------
	# DESC: Nameserver IP addresses should be public!
	def chk_ip_private(ns)
	    ip(ns).each { |addr| return false if addr.private? }
	    true
	end

	# DESC:
	def chk_ip_bogon(ns)
	    bogon = []
	    ip(ns).each { |addr|
		bname = NResolv::DNS::Name::create(addr.to_dnsform +
						   '.bogons.cymru.com.')
		begin
		    case addr
		    when Address::IPv4
			@cm[nil].addresses(bname).each { |baddr|
			    if baddr == BOGON_IP
				bogon << addr 
				break
			    end
			}
		    end
		rescue NResolv::DNS::ReplyError => e
		    case e.code
		    when NResolv::DNS::RCode::NXDOMAIN
		    else raise
		    end
		end
	    }
	    return true if bogon.empty?
	    { 'addresses' => bogon.join(', ') }
	end
    end
end
