import re
import cgi
import urllib
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class Achewood(BasicComicModule):
    latestUrl = 'http://www.achewood.com/'
    imageUrl = 'http://www.achewood.com/index.php?date=%s'
    imageSearch = re.compile(r'<img src="(/comic\.php\?date=\d{8})"')
    prevSearch = re.compile(r'<a href="(/index\.php\?date=\d{8})"[^>]*>&lt;-</a>')
    help = 'Index format: mmddyyyy'

    def getFilename(self, imageUrl, pageUrl):
        queryString = urllib.splitquery(imageUrl)[1]
        attribs = cgi.parse_qs(queryString)
        return attribs['date'][0]
