/* ------------------------------------------------------------------------- */
/* ean13.c                                                                 

Author:  
	Jim Westveer <jwest@netnw.com> 
         (many parts of code modeled from here and there ;-)

References:  
	Guidelines for Supply Chain Identification, Issue 2, November 1998
	http://www.hp.com/HP-COMP/barcode/sg  
        http://www.uc-council.com/old_files/d36-g.htm
	and other references 

ToDo:
	Add version to output
	Add help and man pages
	Add additional command line parser
	Improve .cgi (web) interface

Availability:
	Packaged for Debian. See http://www.debian.org

This program will generate a EAN13 barcode in xbm file format             
                                                                           
  - usage:  ean13 x12-digits [> outfile]                                 
    the check-bit (13 digit) will be calculated         

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.

   THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
   EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
   DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
   ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
   CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

----- Description of EAN13 barcode -----

left guard bars   101

Second flag char

	first 2 digits are flag char identifying country of origin  
		if x use these char sets for these data positionsi

        First flag char  Using same code as second flag char (A)
	NO bars PRINTED,,,just the ascii !!!! on the outside !!!


	Second flag char from the following table	
		  first flag  second flag   data-char
                  number      use-char-set  use-char-set in position
		                            1  2  3  4  5
                   0               A        A  A  A  A  A
                   1               A        A  B  A  B  B
		   2               A        A  B  B  A  B
                   3               A        A  B  B  B  A
                   4               A        B  A  A  B  B
                   5               A        B  B  A  A  B
                   6               A        B  B  B  A  A
                   7               A        B  A  B  A  B
                   8               A        B  A  B  B  A
                   9               A        B  B  A  B  A    

first 5 data char  use A or B dependant upon first flag char 
                   Value   Left Code-A	left Code-B 

                    0          0001101      0100111
                    1          0011001      0110011
                    2          0010011      0011011
                    3          0111101      0100001
                    4          0100011      0011101
                    5          0110001      0111001
                    6          0101111      0000101
                    7          0111011      0010001
                    8          0110111      0001001
                    9          0001011      0010111

Center guard char 01010 

last 5 char encoded as (right code)

                   Value      Right Code         
                                                                                
                    0          1110010           
                    1          1100110           
                    2          1101100           
                    3          1000010           
                    4          1011100           
                    5          1001110           
                    6          1010000           
                    7          1000100           
                    8          1001000           
                    9          1110100

Check character  (Right code) mod 10 on company and part#  NOT country!???
	
right right hand guard 101

So, lets build a 14 character wide graphic, the first position
we will use for ascii numbers, and the first 13 characters will be 
the barcode. 

*/
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*                                                                           */
/* define includes                                                           */
/*                                                                           */
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "ean13.include-1"

#include "version.c"

/*                                                                           */
/* define size of output                                                     */
/*                                                                           */
#define WIDTH (114) /* 107 */
#define HEIGHT (60) /* 60 */
#define WIDTH_BYTES (15)

/*                                                                           */
/* define working buffers                                                    */
/*                                                                           */ 
unsigned char buf[HEIGHT][WIDTH_BYTES];
unsigned char country_code;

char *clist = "0123456789-";
char **ctables[] = {_0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _dash};

/* in octal - non inverted -- as lefthand bits -- invert for righthand ! */     
unsigned int eanBitsA[] = { 015, 031, 023, 075, 043, 061, 057, 073, 067, 013 }; 
unsigned int eanBitsB[] = { 047, 063, 033, 041, 035, 071, 005, 021, 011, 027 }; 

/* country_code bitcode table */                                                
char what_bit_table[]= { 'a','a','a','a','a','a',
                         'a','a','b','a','b','b',
                         'a','a','b','b','a','b',
                         'a','a','b','b','b','a',
                         'a','b','a','a','b','b',
                         'a','b','b','a','a','b',
                         'a','b','b','b','a','a',
                         'a','b','a','b','a','b',
                         'a','b','a','b','b','a',
                         'a','b','b','a','b','a' };

#include "ean13.include-2"
#include "ean13.include-3"
/* ------------------------------------------------------------------------- */
/* ------------------------------------------------------------------------- */


int main (int argc, char **argv)
{
  int aflag = 0;
  int bflag = 0;
  char *cvalue = NULL;
  int index;
  int c;
  char *stringx;

  opterr = 0;

  while ((c = getopt (argc, argv, "abc:")) != -1)
    switch (c)
      {
      case 'a':			/* set flag -a */
        aflag = 1;
        break;
      case 'b':			/* set flag -b */
        bflag = 1;
        break;
      case 'c':			/* set flag -c(value) */
        cvalue = optarg;
        break;
      default:
        if (isprint (optopt)) {
          fprintf (stderr, "Unknown option `-%c'.\n", optopt);
	  printUsage ();	/* print command summary for user */            
	  return (-1);		/* and out of here - abort()? */
	}
      }

  if ( !argv[optind] ) {	/* check for value on command line */
	printUsage ();		/* print command summary for user */            
	return (-1);		/* gotta give us a number to work on! */
  }

/* printf ("aflag = %d, bflag = %d, cvalue = %s\n", aflag, bflag, cvalue); */

  for (index = optind; index < argc; index++) {
    stringx = argv[index];	/* use the string from the command line */      
    stringx[12] = 0;		/* dont let more than 12 digits be accepted */  
    /* printf ("Non-option argument %s\n", argv[index]); */
  }

    processEAN (stringx);       /* build the barcode */                         
    printEAN (stringx);		/* and output it to stdout */ 

  return 0;			/* Bye */
}


