#ifndef __FETCH_H__
#define __FETCH_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/
/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/

extern int fetch_got_mail;

/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern void fetch_init (void);
extern void fetch_free_resources (void);

extern void fetch_refresh (void);
extern void fetch_redraw (void);
extern void fetch_set_focus (void);
extern void fetch_unset_focus (void);

extern void fetch_show (void);
extern void fetch_hide (void);


/*+
  Before a window is opened, elmo fetches headers of messages,
  stored at a selected account.  You are then presented a list
  of messages, that you may fetch or delete.
  +*/
/** open window with message list */
extern void fetch_open (void);
/** close this window */
extern void fetch_close (void);
/** move on to the next position */
extern void fetch_next (void);
/** move to the previous position */
extern void fetch_prev (void);
/** move on to the next page */
extern void fetch_next_page (void);
/** move to the previous position */
extern void fetch_prev_page (void);
/** move to the first position */
extern void fetch_first (void);
/** move to the last position */
extern void fetch_last (void);
/*+
  This command clears a "delete" flag from all messages scheduled
  for deletion.  They may be fetched then.
  +*/
/** reset state of the connection */
extern void fetch_rset (void);
/*+
  This command schedules a message to be deleted, right after
  the connection is closed.  Such a message may not be fetched.
 +*/
/** delete selected message */
extern void fetch_del_mail (void);
/*+
  This command requests a selected message to be fetched.  However
  it may sometimes take some time for the message to arrive.
 +*/
/** fetch selected message */
extern void fetch_get_mail (void);
/** delete all messages on server */
extern void fetch_del_all (void);
/** fetch all messages from server */
extern void fetch_get_all (void);
/** this function is executed right before quitting POP3 connection */
extern void fetch_before_close (void);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER fetch.h
 *
 ****************************************************************************/
#endif
