#ifndef __MEMBLOCK_H__
#define __MEMBLOCK_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

#ifdef __GNUC__
# define FORMAT_2 __attribute__ ((format (printf, 2, 3)))
#else
# define FORMAT_2
#endif

/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

typedef struct memblock {
        struct memblock *next;
        char            *memptr;
        int              size;
        int              used;
        int              last;
        int              mark;
} memblock_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern memblock_t *memblock_create (int size);
extern void        memblock_destroy (memblock_t *block);
extern char       *memblock_strdup (memblock_t **block, const char *str);
extern void       *memblock_malloc (memblock_t **block, int size);
extern void        memblock_shrink_last (memblock_t *block, int size);
extern void        memblock_free_last (memblock_t *block);
extern void        memblock_set_mark (memblock_t *block);
extern void        memblock_free_marked (memblock_t **block);
extern char       *memblock_sprintf (memblock_t **block, const char *fmt,...)
        FORMAT_2;

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER memblock.h
 *
 ****************************************************************************/
#endif
