/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Author: Stéphane Démurget  <stephane.demurget@enst-bretagne.fr>
 */

#include "config.h"

#include <glib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <libgnomeui/libgnomeui.h>

#include "ef-utils.h"

void
display_help (const gchar *section)
{
	GError *error = NULL;

	gnome_help_display (PACKAGE, section, &error);

	if (error) {
		display_error (_("Error while displaying help."), error->message);

		g_error_free (error);
		error = NULL;
	}
}

void
display_error (const gchar *title,
	       const gchar *error_msg)
{
	GtkWidget *dialog;
	gchar *msg;

	if (title != NULL)
		msg = g_strconcat ("<span weight=\"bold\" size=\"larger\">", title, "</span>", "\n\n", error_msg, NULL); 
	else
		msg = g_strdup (error_msg); 

	dialog = gtk_message_dialog_new_with_markup (NULL, 
			GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
			msg);

	gtk_dialog_run (GTK_DIALOG (dialog));

	gtk_widget_destroy (dialog);
	g_free (msg);
}
