/*
		  Endeavour Browser Contents List
 */

#ifndef BROWSERCONTENTS_H
#define BROWSERCONTENTS_H

#include <gtk/gtk.h>
#include "browser.h"
#include "endeavour.h"


/* Selection */
extern GList *EDVBrowserContentsGetSelectedPaths(edv_browser_struct *browser);

/* Finding */
extern gint EDVBrowserContentsFindRowByPath(
	edv_browser_struct *browser, const gchar *path
);

/* Realize Listing */
extern void EDVBrowserContentsRealizeListing(edv_browser_struct *browser);

/* Get Listing */
extern void EDVBrowserContentsGetListing(
	edv_browser_struct *browser, const gchar *path,
	gboolean update_status_bar
);
extern void EDVBrowserContentsClear(edv_browser_struct *browser);

/* Opening */
extern void EDVBrowserContentsOpen(
	edv_browser_struct *browser, gint row, gint column, guint state
);
extern void EDVBrowserContentsOpenWith(
	edv_browser_struct *browser, gint row, gint column
);

/* Renaming */
extern void EDVBrowserContentsDoFPromptRename(
	edv_browser_struct *browser, gint row, gint column
);

/* Object Callbacks */
extern void EDVBrowserContentsObjectAddedNotify(
	edv_browser_struct *browser, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVBrowserContentsObjectModifiedNotify(
	edv_browser_struct *browser, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVBrowserContentsObjectRemovedNotify(
	edv_browser_struct *browser, const gchar *path
);

/* Mount Callbacks */
extern void EDVBrowserContentsMountNotify(
	edv_browser_struct *browser, edv_device_struct *dev,
	gboolean is_mounted
);


#endif	/* BROWSERCONTENTS_H */
