/*
	          Endeavour Devices List & Edit Window
 */

#ifndef DEVICESWIN_H
#define DEVICESWIN_H

#include <gtk/gtk.h>

#include "piechart.h"
#include "edvtypes.h"
#include "edvdevices.h"
#include "editclist.h"


typedef struct _edv_device_listwin_struct	edv_device_listwin_struct;
typedef struct _edv_device_editwin_struct	edv_device_editwin_struct;
typedef struct _edv_device_icon_picker_struct	edv_device_icon_picker_struct;


/*
 *	Device Edit Window Icon Picker:
 */
struct _edv_device_icon_picker_struct {

	GtkWidget	*toplevel,	/* GtkBox */
			*button,	/* Icon GtkButton */
			*gtk_pixmap,
			*left_btn, *right_btn, *state_label;

	GtkAdjustment	*adj;		/* State GtkAdjustment */

	gint		icon_width,
			icon_height;

	GdkPixmap	*pixmap[EDV_DEVICE_TOTAL_ICON_STATES];
	GdkBitmap	*mask[EDV_DEVICE_TOTAL_ICON_STATES];

	gchar		*path[EDV_DEVICE_TOTAL_ICON_STATES];

	edv_device_editwin_struct	*editwin;

};
#define EDV_DEVICE_ICON_PICKER(p)	((edv_device_icon_picker_struct *)(p)) 

/*
 *	Device Edit Window:
 */
struct _edv_device_editwin_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gboolean        processing;
	gint            busy_count,
			freeze_count;
	gpointer        core_ptr;

	edv_device_listwin_struct	*listwin;

	gboolean	has_changes;
	gchar		*title;

	GtkWidget       *main_vbox,
			*name_entry,
			*device_path_entry,
			*mount_path_entry,
			*fs_type_combo,
			*command_mount_entry,
			*command_unmount_entry,
			*command_eject_entry,
			*command_check_entry,
			*command_tools_entry,
			*command_format_entry,
			*no_unmount_check,
			*read_only_check,
			*unlisted_check,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;

	gint		dev_num;	/* Device being edited */

	/* Icon Pickers */
	edv_device_icon_picker_struct	*icon_small,
					*icon_medium,
					*icon_large;

};
#define EDV_DEVICE_EDITWIN(p)	((edv_device_editwin_struct *)(p))

/*
 *	Device List Window:
 */
struct _edv_device_listwin_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gboolean        processing;
	gint            busy_count,
			freeze_count;
	gpointer        core_ptr;

	GtkWidget	*main_vbox,
			*find_entry,
			*devices_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*display_parent,	/* GtkVBox */
			*display_client,	/* Parented to display_parent */
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi;

	/* Important widgets on display_client */
	GtkWidget	*dev_icon_pm,
			*dev_name_label,
			*dev_device_path_label,
			*dev_mount_path_label,
			*dev_mount_btn, *dev_eject_btn,	*dev_properties_btn,
			*dev_fsck_btn, *dev_tools_btn, *dev_format_btn;
	pie_chart_struct	*dev_pc;


	/* Device edit window */
	edv_device_editwin_struct	*editwin;

};
#define EDV_DEVICE_LISTWIN(p)	((edv_device_listwin_struct *)(p))


/* In devicesedit.c */
extern void EDVDevicesEditWinFetchValues(
	edv_device_editwin_struct *ew, gint dev_num
);
extern void EDVDevicesEditWinDeviceRemovedCB(
	edv_device_editwin_struct *ew, gint dev_num
);

extern edv_device_editwin_struct *EDVDevicesEditWinNew(
	gpointer core_ptr, gpointer listwin
);
extern void EDVDevicesEditWinResetHasChanges(
	edv_device_editwin_struct *ew, gboolean has_changes
);
extern void EDVDevicesEditWinUpdateMenus(edv_device_editwin_struct *ew);
extern gboolean EDVDevicesEditWinIsMapped(edv_device_editwin_struct *ew);
extern void EDVDevicesEditWinMap(edv_device_editwin_struct *ew);
extern void EDVDevicesEditWinUnmap(edv_device_editwin_struct *ew);
extern void EDVDevicesEditWinDelete(edv_device_editwin_struct *ew);


/* In deviceswin.c */
extern void EDVDevicesListWinSetRow(
	edv_device_listwin_struct *lw, gint row, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinFetchValues(edv_device_listwin_struct *lw);

extern void EDVDevicesListWinReconfiguredNotifyCB(
	edv_device_listwin_struct *lw
);
extern void EDVDevicesListWinMountNotifyCB(
	edv_device_listwin_struct *lw,
	gint dev_num, edv_device_struct *dev_ptr,
	gboolean is_mounted
);
extern void EDVDevicesListWinDeviceAddedCB(
	edv_device_listwin_struct *lw,
	gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinDeviceModifiedCB(
	edv_device_listwin_struct *lw,
	gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinDeviceRemovedCB(
	edv_device_listwin_struct *lw, gint dev_num
);

extern edv_device_listwin_struct *EDVDevicesListWinNew(
	gpointer core_ptr
);
extern void EDVDevicesListWinUpdateMenus(edv_device_listwin_struct *lw);
extern void EDVDevicesListSetBusy(
	edv_device_listwin_struct *lw, gboolean is_busy
);
extern gboolean EDVDevicesListWinIsMapped(edv_device_listwin_struct *lw);
extern void EDVDevicesListWinMap(edv_device_listwin_struct *lw);
extern void EDVDevicesListWinUnmap(edv_device_listwin_struct *lw);
extern void EDVDevicesListWinDelete(edv_device_listwin_struct *lw);


#endif	/* DEVICESWIN_H */
