/*
		  Endeavour Recycle Bin Operation Callbacks
 */

#ifndef RECBINOPCB_H
#define RECBINOPCB_H

#include <gtk/gtk.h>
#include "toolbar.h"
#include "findbar.h"
#include "recbin.h"


extern void EDVRecBinMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVRecBinMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVRecBinMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

extern void EDVRecBinOPCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVRecBinOPEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVRecBinOPLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
);

extern void EDVRecBinFindBarStartCB(edv_findbar_struct *fb, gpointer data);
extern void EDVRecBinFindBarEndCB(
	edv_findbar_struct *fb, gint total_matches, gpointer data
);
extern void EDVRecBinFindBarMatchCB(
	const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt, gint line_index,
	gpointer data
);

extern void EDVRecBinStatusMessageCB(const gchar *message, gpointer data);
extern void EDVRecBinStatusProgressCB(gfloat progress, gpointer data);

extern void EDVRecBinOPSyncDisks(edv_recbin_struct *recbin);
extern void EDVRecBinOPWriteProtect(edv_recbin_struct *recbin);

extern void EDVRecBinOPClose(edv_recbin_struct *recbin);
extern void EDVRecBinOPExit(edv_recbin_struct *recbin);

extern void EDVRecBinOPRecover(edv_recbin_struct *recbin);
extern void EDVRecBinOPPurge(edv_recbin_struct *recbin);
extern void EDVRecBinOPPurgeAll(edv_recbin_struct *recbin);
extern void EDVRecBinOPSelectAll(edv_recbin_struct *recbin);
extern void EDVRecBinOPUnselectAll(edv_recbin_struct *recbin);

extern void EDVRecBinOPRefresh(edv_recbin_struct *recbin);
extern void EDVRecBinOPRefreshAll(edv_recbin_struct *recbin);


#endif	/* RECBINOPCB_H */
