#include <gtk/gtk.h>
#include "../cdialog.h"
#include "../pdialog.h"

#include "../images/icon_security_20x20.xpm"

static gchar *PromptBrowseCB(gpointer p, gpointer data, gint n)
{
	return(NULL);
}

int main(int argc, char *argv[])
{
	gtk_init(&argc, &argv);
	CDialogInit();
	PDialogInit();

	while(TRUE)
	{
	    gchar **strv;
	    gint strc;
	    GList *glist;

	    PDialogDeleteAllPrompts();
	    PDialogAddPrompt(
		NULL, "Input 1:", NULL
	    );
	    PDialogAddPromptWithBrowse(
		NULL, "Input 2:", NULL, NULL, PromptBrowseCB
	    );
	    PDialogAddPromptPassword(
		(const guint8 **)icon_security_20x20_xpm, "Input 3:", NULL
	    );
	    PDialogAddPromptSpin(
		NULL, "Input 4:",
		0, 0, 100,
		1, 10,
		1.0, 0
	    );
	    PDialogAddPromptScale(
		NULL, "Input 5:",
		20, 0, 100,
		1, 10,
		TRUE, 0
	    );
	    glist = NULL;
	    glist = g_list_append(glist, "Value 1");
	    glist = g_list_append(glist, "Value 2");
	    glist = g_list_append(glist, "Value 3");
	    glist = g_list_append(glist, "Value 4");
	    glist = g_list_append(glist, "Value 5");
	    PDialogAddPromptCombo(
		NULL, "Input 6:",
		(const gchar *)glist->data, glist,
		FALSE, FALSE
	    );
	    g_list_free(glist);
	    glist = NULL;
	    glist = g_list_append(glist, "Value 1");
	    glist = g_list_append(glist, "Value 2");
	    glist = g_list_append(glist, "Value 3");
	    PDialogAddPromptRadio(NULL, "Input 7:", glist, 1);
	    g_list_free(glist);
	    PDialogAddPromptSeparator();
	    PDialogAddPromptLabel("This is a label (no input)");
	    PDialogSetSize(400, -1);
	    strv = PDialogGetResponse(
		"Input",
		"Please enter values below",
		NULL,
		PDIALOG_ICON_QUESTION,
		"OK", "Cancel",
		PDIALOG_BTNFLAG_SUBMIT | PDIALOG_BTNFLAG_CANCEL,
		PDIALOG_BTNFLAG_CANCEL,
		&strc
	    );
	    if((strv != NULL) && (strc > 0))
	    {
		gchar *buf = g_strdup_printf(
"Input value 1: \"%s\" (entry)\n\
Input value 2: \"%s\" (entry with browse)\n\
Input value 3: \"%s\" (password)\n\
Input value 4: \"%s\" (spin)\n\
Input value 5: \"%s\" (scale)\n\
Input value 6: \"%s\" (combo)\n\
Input value 7: \"%s\" (radio)\n\
Input value 8: \"%s\" (separator)\n\
Input value 9: \"%s\" (label)\n\
\n\
Continue entering new values?",
		    (strc > 0) ? strv[0] : "(null)",
		    (strc > 1) ? strv[1] : "(null)",
		    (strc > 2) ? strv[2] : "(null)",
		    (strc > 3) ? strv[3] : "(null)",
		    (strc > 4) ? strv[4] : "(null)",
		    (strc > 5) ? strv[5] : "(null)",
		    (strc > 6) ? strv[6] : "(null)",
                    (strc > 7) ? strv[7] : "(null)",
                    (strc > 8) ? strv[8] : "(null)"
		);
		gint response = CDialogGetResponse(
		    "Output", buf, NULL,
		    CDIALOG_ICON_INFO,
		    CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO,
		    CDIALOG_BTNFLAG_YES
		);
		g_free(buf);
		if((response == CDIALOG_RESPONSE_NOT_AVAILABLE) ||
		   (response == CDIALOG_RESPONSE_NO) ||
		   (response == CDIALOG_RESPONSE_CANCEL)
		)
		    break;
	    }
	    else
	    {
		break;
	    }
	}


	PDialogShutdown();
	CDialogShutdown();

	return(0);
}
