/*
 * Copyright (C) 2002,2003 Daniel Heck
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: system_unix.cc,v 1.3.2.1 2003/09/23 22:46:20 dheck Exp $
 */
#include "system.hh"
#include <cstdlib>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

using namespace std;
const char *sysdep::path_separator = "/";

string
sysdep::expand_path(const string &pth)
{
    string path = pth;
    string::size_type p=path.find("~");
    if (p != string::npos) {
        string home;
        if (char *h = getenv("HOME"))
            home = h;
        path.replace(p, 1, home);
    }
    return path;
}

bool
sysdep::FileExists(const std::string &fname)
{
    struct stat s;
    return (stat(fname.c_str(), &s)==0 && S_ISREG(s.st_mode));
}

time_t
sysdep::FileModTime(const std::string &fname)
{
    struct stat s;
    if (stat(fname.c_str(), &s) == 0) {
        return s.st_mtime;
    }

    return 0;                   // beginning of time
}

bool
sysdep::FolderExists(const std::string &fname)
{
    struct stat s;
    return (stat(fname.c_str(), &s)==0 && S_ISDIR(s.st_mode));
}
