#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

int main (int argc, char *argv[])
{
    int fd;
    int nread;
    unsigned char buf[1024];
    int done = 0;
    int i;
    int count = 0;
    
    if (argc != 2) {
	printf ("Usage: comp <filename>\n");
	exit (0);
    }


    fd = open (argv[1], O_RDONLY);
    if (fd < 0) {
	fprintf (stderr, "Unable to open file %s: %s\n", argv[1], strerror (errno));
	exit (1);
    }
  
    printf ("char compiler_bytecode[] = \n\"");
    do {
	nread = read (fd, buf, 1024);
	if (nread < 1024)
	    done = 1;

	for (i = 0; i < nread; i++) {
	    printf ("\\x%.2x", (unsigned int) buf[i]);
	    count++;
	    if (!(count % 20)) {
		printf ("\"\n\"");
	    }
	}
    } while (!done);
    printf ("\";\n\n");

    return (0);
}

    
