#include <stdlib.h>
#include "entity.h"
#include "SDL.h"

#include "sdl-common.h"



static gint
sdl_key_refresh (ENode * node, EBuf * attr, EBuf * value)
{
  Uint8 *keys;

  keys = SDL_GetKeyState(NULL);

  sdl_keys_call_sets (node, keys);

  return TRUE;
}

static void
sdl_keys_call_handler (ENode * user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onpress", NULL);

    if (function)
      enode_call_ignore_return (node, function, "");
}


/**sdl_keys_call_sets
 * Runs through the keys and calls all the "onpress" functions.
 *
 */
void
sdl_keys_call_sets (ENode * node, Uint8 * keys)
{
  char * val_str = NULL;
  int value = -1;

  /* Get value from the node attrib. */
  val_str = enode_attrib_str (node, "value", NULL);

  if (NULL == val_str)
    {
      fprintf (stderr, "bad val\n");
      return;
    }

  value = atoi (val_str);

  if ( value > -1 && keys[value] == SDL_PRESSED )
    {
      sdl_keys_call_handler (node);
    }
}


/**sdl_keys_setup
 * setup the keys.
 */
static void
sdl_keys_setup (ENode * node)
{

}


/**sdl_keys_destroy
 * Free the keys.
 */
static void
sdl_keys_destroy (ENode * node)
{

}


/**sdl_keys_register
 * Register the sdl key attributes. 
 */
void sdl_keys_register (void)
{
  Element *element;
  ElementAttr *e_attr;

  /* Register sdl-mouse. */
  element = g_new0 (Element, 1);
  element->render_func = sdl_keys_setup; 
  element->destroy_func = sdl_keys_destroy;
  element->parent_func = NULL;
  element->tag = "sdl-key";
  element->description = "Create a new SDL key callback.";
  element_register (element);

  /* Value of the key. */
  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "value";
  e_attr->description = "The value of the key we care about.  See libsdl docs.";
  e_attr->value_desc = "integer";
  e_attr->possible_values = "-1,*";
  element_register_attrib (element, e_attr);

  /* Onpress attribute. */
  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "onpress";
  e_attr->description = "Sets up a handler for keyboard press events";
  e_attr->value_desc = "function";
  e_attr->possible_values = "(caling_node)";
  element_register_attrib (element, e_attr);

  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "_refresh";
  e_attr->description = "A force refresh";
  e_attr->value_desc = "integer";
  e_attr->possible_values = "*";
  e_attr->set_attr_func = sdl_key_refresh;
  element_register_attrib (element, e_attr);
}
