# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#


"""
Module implementing a dialog for loading a script.
"""

from qt import *

from KdeQt import KQFileDialog

from LoadScriptForm import LoadScriptForm

class LoadScriptDialog(LoadScriptForm):
    """
    Class implementing a dialog for loading a script.
    """
    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param parent -- parent of this dialog (QWidget)
        @param name -- name of this dialog (string or QString)
        @param modal -- flag indicating a modal window (boolean)
        @param fl -- window flags
        """
        LoadScriptForm.__init__(self,parent,name,modal,fl)

    def handleFileSelection(self):
        """
        Private slot to handle the script file selection.
        """
        file = KQFileDialog.getOpenFileName(self.scriptFileEdit.text(),
            self.trUtf8("Script Files (*.py *.epy)"),
            self, None, self.trUtf8("Select script file"))
            
        if not file.isNull():
            self.scriptFileEdit.setText(QDir.convertSeparators(file))
        
    def getData(self):
        """
        Public method to retrieve the data entered into the dialog.
        
        @return tuple with the collected data (script name, script file,
            execute flag, delete flag) (string, string, boolean, boolean)
        """
        return (unicode(self.scriptNameEdit.text()), 
            unicode(self.scriptFileEdit.text()),
            self.executeCheckBox.isChecked(),
            self.deleteCheckBox.isChecked())
