# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Python re wizard.
"""

from qt import QDialog, SIGNAL

from KdeQt import KQMessageBox

from Wizards.WizardIFace import WizardIFace
from PyRegExpWizardDialog import PyRegExpWizardDialog

from UI.E3Action import E3Action

class PyRegExpWizard(WizardIFace):
    """
    Class implementing the Python re wizard.
    """
    def __init__(self, parent = None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        WizardIFace.__init__(self, parent)
        
    def callForm(self, editor):
        """
        Private method to display a dialog and get the code.
        
        @param editor reference to the current editor
        @return the generated code (string)
        """
        dlg = PyRegExpWizardDialog(None, 1)
        if dlg.exec_loop() == QDialog.Accepted:
            line, index = editor.getCursorPosition()
            indLevel = editor.indentation(line)/editor.indentationWidth()
            if editor.indentationsUseTabs():
                indString = '\t'
            else:
                indString = editor.indentationWidth() * ' '
            return (dlg.getCode(indLevel, indString), 1)
        else:
            return (None, 0)
        
    def handle(self):
        """
        Worker method associated with the wizard action 
        """
        editor = self.parent().getCurrentEditor()
        
        if editor == None:
                KQMessageBox.critical(None, 
                self.trUtf8('No current editor'),
                self.trUtf8('Please open or create a file first.'))

        else:
            code, ok = self.callForm(editor)
            if ok:
                line, index = editor.getCursorPosition()
                # It should be done on this way to allow undo
                editor.beginUndoAction()
                editor.insertAt(code, line, index)
                editor.endUndoAction()

    def initAction(self):
        """
        Public method to create the action associated with this class wizard. 
        
        @return the associated action
        """
        self.action = E3Action(self.trUtf8('Python re Wizard'),
             self.trUtf8('&Python re Wizard...'), 0, 0, self,
             'wizards_python_re')
        self.action.setStatusTip(self.trUtf8('Python re Wizard'))
        self.action.setWhatsThis(self.trUtf8(
            """<b>Python re Wizard</b>"""
            """<p>This wizard opens a dialog for entering all the parameters"""
            """ needed to create a Python re string. The generated code is inserted"""
            """ at the current cursor position.</p>"""
        ))
        self.action.connectIt(SIGNAL('activated()'), self.handle)
        return self.action
    
    def getAction(self):
        """
        Public method to get the action associated with this class wizard. 
        
        @return the associated action
        """
        return self.action
