/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:43:41 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_twiddle_c -simd -compact -variables 4 -n 5 -name t1bv_5 -include t1b.h -sign 1 */

/*
 * This function contains 20 FP additions, 14 FP multiplications,
 * (or, 17 additions, 11 multiplications, 3 fused multiply/add),
 * 20 stack variables, and 10 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_5(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 8)) {
	  V Tf, T5, Ta, Tc, Td, Tg;
	  Tf = LD(&(x[0]), dist, &(x[0]));
	  {
	       V T2, T9, T4, T7;
	       {
		    V T1, T8, T3, T6;
		    T1 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    T2 = BYTW(&(W[0]), T1);
		    T8 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTW(&(W[TWVL * 4]), T8);
		    T3 = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    T4 = BYTW(&(W[TWVL * 6]), T3);
		    T6 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    T7 = BYTW(&(W[TWVL * 2]), T6);
	       }
	       T5 = VSUB(T2, T4);
	       Ta = VSUB(T7, T9);
	       Tc = VADD(T2, T4);
	       Td = VADD(T7, T9);
	       Tg = VADD(Tc, Td);
	  }
	  ST(&(x[0]), VADD(Tf, Tg), dist, &(x[0]));
	  {
	       V Tb, Tj, Ti, Tk, Te, Th;
	       Tb = VBYI(VFMA(LDK(KP951056516), T5, VMUL(LDK(KP587785252), Ta)));
	       Tj = VBYI(VFNMS(LDK(KP951056516), Ta, VMUL(LDK(KP587785252), T5)));
	       Te = VMUL(LDK(KP559016994), VSUB(Tc, Td));
	       Th = VFNMS(LDK(KP250000000), Tg, Tf);
	       Ti = VADD(Te, Th);
	       Tk = VSUB(Th, Te);
	       ST(&(x[WS(ios, 1)]), VADD(Tb, Ti), dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 3)]), VSUB(Tk, Tj), dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 4)]), VSUB(Ti, Tb), dist, &(x[0]));
	       ST(&(x[WS(ios, 2)]), VADD(Tj, Tk), dist, &(x[0]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 5, "t1bv_5", twinstr, {17, 11, 3, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_5) (planner *p) {
     X(kdft_dit_register) (p, t1bv_5, &desc);
}
