/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:57:34 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_hc2hc -compact -variables 4 -twiddle-log3 -n 32 -dit -name hf2_32 -include hf.h */

/*
 * This function contains 488 FP additions, 280 FP multiplications,
 * (or, 376 additions, 168 multiplications, 112 fused multiply/add),
 * 204 stack variables, and 128 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.9 2003/04/17 19:25:50 athena Exp $
 */

#include "hf.h"

static const R *hf2_32(R *rio, R *iio, const R *W, stride ios, int m, int dist)
{
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     int i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 8) {
	  E T1, T3t, T4S, TQ, T3G, T49, T20, T2n, T4y, T1J, T43, T2w, T4z, T36, T4Z;
	  E TK, T8b, T40, T6l, T3U, T6k, T1h, T3L, T1D, T3V, T1s, T3X, T3E, T7E, T3O;
	  E T6h, T2k, T6w, T4i, T4x, T3q, T6I, T4O, T4P, T3w, T4T, T4R, T4U, Tm, To;
	  E TX, T4I, T3a, T3H, T31, T4Y, T3f, T4J, T2G, T4s, T4r, T2B, T4q, T4t, T27;
	  E T4a, T2M, T4m, T4n, T2P, T4l, T4o, T1U, T44, Tn, Tp, T7G;
	  T1 = rio[0];
	  {
	       E Tv, T3e, Tz, T3c, T39, TE, TI, T38, TN, T3v, TU, T1l, T3u, TW, T12;
	       E T35, T1f, T3m, T1b, T3o, T30, T2L, T16, T1k, T33, T2W, TP, T2J, T2D, T1w;
	       E T1z, T2A, T1B, T2z, T2F, T1u, T2N, T1q, T1I, T2O, T1o, T1G, T2m, T24, T1Z;
	       E T2r, T1X, T2v, T2l, T26, T2i, T1R, T1T, T2g, T2, Ti, T3, Tc, TF, TC;
	       E TG, TB, Tu, T1a, T15, Ty, T1t, T1Y, T1W, T1v, TH, T1y, T11, TD, T1A;
	       E T1e, T4g, T3k, T1n, T1p, T2e, T4M, TM, T1K, T1O, TO, T1L, T1N, Ta, Tb;
	       E T2t, Tk, T2o, Tf, Tg, T2s, Tj, T2p;
	       Tv = rio[WS(ios, 8)];
	       T3e = iio[-WS(ios, 8)];
	       Tz = iio[-WS(ios, 23)];
	       T3c = rio[WS(ios, 23)];
	       T39 = iio[-WS(ios, 24)];
	       TE = rio[WS(ios, 24)];
	       TI = iio[-WS(ios, 7)];
	       T38 = rio[WS(ios, 7)];
	       TN = rio[WS(ios, 4)];
	       T3v = iio[-WS(ios, 20)];
	       TU = rio[WS(ios, 20)];
	       T1l = iio[-WS(ios, 29)];
	       T3u = rio[WS(ios, 11)];
	       TW = iio[-WS(ios, 11)];
	       T12 = rio[WS(ios, 28)];
	       T35 = iio[-WS(ios, 16)];
	       T1f = iio[-WS(ios, 19)];
	       T3m = rio[WS(ios, 19)];
	       T1b = rio[WS(ios, 12)];
	       T3o = iio[-WS(ios, 12)];
	       T30 = iio[0];
	       T2L = iio[-WS(ios, 2)];
	       T16 = iio[-WS(ios, 3)];
	       T1k = rio[WS(ios, 2)];
	       T33 = rio[WS(ios, 15)];
	       T2W = rio[WS(ios, 31)];
	       TP = iio[-WS(ios, 27)];
	       T2J = rio[WS(ios, 29)];
	       T2D = rio[WS(ios, 21)];
	       T1w = iio[-WS(ios, 21)];
	       T1z = rio[WS(ios, 26)];
	       T2A = iio[-WS(ios, 26)];
	       T1B = iio[-WS(ios, 5)];
	       T2z = rio[WS(ios, 5)];
	       T2F = iio[-WS(ios, 10)];
	       T1u = rio[WS(ios, 10)];
	       T2N = rio[WS(ios, 13)];
	       T1q = iio[-WS(ios, 13)];
	       T1I = iio[-WS(ios, 1)];
	       T2O = iio[-WS(ios, 18)];
	       T1o = rio[WS(ios, 18)];
	       T1G = rio[WS(ios, 30)];
	       T2m = iio[-WS(ios, 22)];
	       T24 = rio[WS(ios, 22)];
	       T1Z = iio[-WS(ios, 25)];
	       T2r = rio[WS(ios, 25)];
	       T1X = rio[WS(ios, 6)];
	       T2v = iio[-WS(ios, 6)];
	       T2l = rio[WS(ios, 9)];
	       T26 = iio[-WS(ios, 9)];
	       T2i = iio[-WS(ios, 14)];
	       T1R = rio[WS(ios, 14)];
	       T1T = iio[-WS(ios, 17)];
	       T2g = rio[WS(ios, 17)];
	       {
		    E T2c, T2d, T3s, T3r, T3j, T3i, T4, T7, T5, T8, T6, T9, T14, T1d, Ts;
		    E T18, T19, T1c, Te, Td, Tt, Tw, T13, TZ, T10, Tx;
		    T2c = rio[WS(ios, 1)];
		    T2d = iio[-WS(ios, 30)];
		    T3s = iio[-WS(ios, 4)];
		    T3r = rio[WS(ios, 27)];
		    T3j = iio[-WS(ios, 28)];
		    T3i = rio[WS(ios, 3)];
		    T2 = W[6];
		    Ti = W[7];
		    T3 = W[4];
		    Tc = W[5];
		    T4 = W[2];
		    T7 = W[3];
		    T5 = W[0];
		    T8 = W[1];
		    T6 = T4 * T5;
		    T9 = T7 * T8;
		    T14 = Ti * T5;
		    T1d = Tc * T4;
		    Ts = T3 * T5;
		    T18 = T3 * T4;
		    T19 = Tc * T7;
		    T1c = T3 * T7;
		    Te = T7 * T5;
		    Td = T4 * T8;
		    Tt = Tc * T8;
		    Tw = T3 * T8;
		    TF = T2 * T7;
		    T13 = T2 * T8;
		    TC = Ti * T7;
		    TG = Ti * T4;
		    TZ = T2 * T5;
		    T10 = Ti * T8;
		    TB = T2 * T4;
		    Tx = Tc * T5;
		    Tu = Ts + Tt;
		    T1a = T18 - T19;
		    T15 = T13 + T14;
		    Ty = Tw - Tx;
		    T1t = Ts - Tt;
		    T1Y = T1c - T1d;
		    T1W = T18 + T19;
		    T1v = Tw + Tx;
		    TH = TF - TG;
		    T1y = TZ + T10;
		    T11 = TZ - T10;
		    TD = TB + TC;
		    T1A = T13 - T14;
		    T1e = T1c + T1d;
		    T3t = FMA(T2, T3r, Ti * T3s);
		    T4g = FNMS(T8, T2c, T5 * T2d);
		    T4S = FNMS(Ti, T3r, T2 * T3s);
		    T3k = FMA(T4, T3i, T7 * T3j);
		    T1n = FMA(T2, T3, Ti * Tc);
		    T1p = FNMS(Ti, T3, T2 * Tc);
		    T2e = FMA(T5, T2c, T8 * T2d);
		    T4M = FNMS(T7, T3i, T4 * T3j);
		    TM = T6 - T9;
		    T1K = T3 * TM;
		    T1O = Tc * TM;
		    TO = Td + Te;
		    T1L = Tc * TO;
		    T1N = T3 * TO;
		    Ta = T6 + T9;
		    Tb = T3 * Ta;
		    T2t = Ti * Ta;
		    Tk = Tc * Ta;
		    T2o = T2 * Ta;
		    Tf = Td - Te;
		    Tg = Tc * Tf;
		    T2s = T2 * Tf;
		    Tj = T3 * Tf;
		    T2p = Ti * Tf;
	       }
	       TQ = FMA(TM, TN, TO * TP);
	       T3G = FNMS(TO, TN, TM * TP);
	       T49 = FMA(T1Y, T1X, T1W * T1Z);
	       T20 = FNMS(T1Y, T1Z, T1W * T1X);
	       T2n = FMA(T3, T2l, Tc * T2m);
	       T4y = FNMS(Tc, T2l, T3 * T2m);
	       {
		    E T1F, T1H, TA, TJ;
		    T1F = TB - TC;
		    T1H = TF + TG;
		    T1J = FMA(T1F, T1G, T1H * T1I);
		    T43 = FNMS(T1H, T1G, T1F * T1I);
		    {
			 E T2q, T2u, T32, T34;
			 T2q = T2o - T2p;
			 T2u = T2s + T2t;
			 T2w = FMA(T2q, T2r, T2u * T2v);
			 T4z = FNMS(T2u, T2r, T2q * T2v);
			 T32 = FMA(T2, T1a, Ti * T1e);
			 T34 = FNMS(Ti, T1a, T2 * T1e);
			 T36 = FNMS(T34, T35, T32 * T33);
			 T4Z = FMA(T34, T33, T32 * T35);
		    }
		    TA = FNMS(Ty, Tz, Tu * Tv);
		    TJ = FNMS(TH, TI, TD * TE);
		    TK = TA + TJ;
		    T8b = TA - TJ;
		    {
			 E T3Y, T3Z, T3S, T3T;
			 T3Y = FNMS(T1v, T1u, T1t * T1w);
			 T3Z = FMA(T1A, T1z, T1y * T1B);
			 T40 = T3Y - T3Z;
			 T6l = T3Y + T3Z;
			 T3S = FMA(Tf, T1k, Ta * T1l);
			 T3T = FMA(T1p, T1o, T1n * T1q);
			 T3U = T3S - T3T;
			 T6k = T3S + T3T;
		    }
	       }
	       {
		    E T17, T1g, Th, Tl;
		    T17 = FMA(T11, T12, T15 * T16);
		    T1g = FMA(T1a, T1b, T1e * T1f);
		    T1h = T17 + T1g;
		    T3L = T17 - T1g;
		    {
			 E T1x, T1C, T1m, T1r;
			 T1x = FMA(T1t, T1u, T1v * T1w);
			 T1C = FNMS(T1A, T1B, T1y * T1z);
			 T1D = T1x + T1C;
			 T3V = T1x - T1C;
			 T1m = FNMS(Tf, T1l, Ta * T1k);
			 T1r = FNMS(T1p, T1q, T1n * T1o);
			 T1s = T1m + T1r;
			 T3X = T1m - T1r;
		    }
		    {
			 E T3C, T3D, T3M, T3N;
			 T3C = FMA(Ty, Tv, Tu * Tz);
			 T3D = FMA(TH, TE, TD * TI);
			 T3E = T3C - T3D;
			 T7E = T3C + T3D;
			 T3M = FNMS(T15, T12, T11 * T16);
			 T3N = FNMS(T1e, T1b, T1a * T1f);
			 T3O = T3M - T3N;
			 T6h = T3M + T3N;
			 {
			      E T2j, T4h, T2f, T2h;
			      T2f = FMA(T2, T1t, Ti * T1v);
			      T2h = FNMS(Ti, T1t, T2 * T1v);
			      T2j = FNMS(T2h, T2i, T2f * T2g);
			      T4h = FMA(T2h, T2g, T2f * T2i);
			      T2k = T2e + T2j;
			      T6w = T4g + T4h;
			      T4i = T4g - T4h;
			      T4x = T2e - T2j;
			 }
		    }
		    {
			 E T3p, T4N, T3l, T3n;
			 T3l = FNMS(Ti, Ty, T2 * Tu);
			 T3n = FMA(T2, Ty, Ti * Tu);
			 T3p = FMA(T3l, T3m, T3n * T3o);
			 T4N = FNMS(T3n, T3m, T3l * T3o);
			 T3q = T3k + T3p;
			 T6I = T4M + T4N;
			 T4O = T4M - T4N;
			 T4P = T3k - T3p;
		    }
		    Th = Tb + Tg;
		    Tl = Tj - Tk;
		    T3w = FNMS(Tl, T3v, Th * T3u);
		    T4T = FMA(Tl, T3u, Th * T3v);
		    T4R = T3t - T3w;
		    T4U = T4S - T4T;
		    Tm = FNMS(Ti, Tl, T2 * Th);
		    To = FMA(T2, Tl, Ti * Th);
		    {
			 E TR, TS, TT, TV;
			 TR = Tb - Tg;
			 TS = Tj + Tk;
			 TT = FMA(T2, TR, Ti * TS);
			 TV = FNMS(Ti, TR, T2 * TS);
			 TX = FNMS(TV, TW, TT * TU);
			 T4I = FNMS(TS, T38, TR * T39);
			 T3a = FMA(TR, T38, TS * T39);
			 T3H = FMA(TV, TU, TT * TW);
		    }
		    {
			 E T2V, T3b, T2Z, T3d;
			 {
			      E T2T, T2U, T2X, T2Y;
			      T2T = T2 * TM;
			      T2U = Ti * TO;
			      T2V = T2T - T2U;
			      T3b = T2T + T2U;
			      T2X = T2 * TO;
			      T2Y = Ti * TM;
			      T2Z = T2X + T2Y;
			      T3d = T2X - T2Y;
			 }
			 T31 = FMA(T2V, T2W, T2Z * T30);
			 T4Y = FNMS(T2Z, T2W, T2V * T30);
			 T3f = FNMS(T3d, T3e, T3b * T3c);
			 T4J = FMA(T3d, T3c, T3b * T3e);
		    }
		    {
			 E T23, T25, T1Q, T1S;
			 {
			      E T2C, T2E, T21, T22;
			      T2C = FNMS(Ti, T1Y, T2 * T1W);
			      T2E = FMA(T2, T1Y, Ti * T1W);
			      T2G = FMA(T2C, T2D, T2E * T2F);
			      T4s = FNMS(T2E, T2D, T2C * T2F);
			      T21 = T1K + T1L;
			      T22 = T1N - T1O;
			      T23 = FNMS(Ti, T22, T2 * T21);
			      T4r = FMA(T22, T2z, T21 * T2A);
			      T25 = FMA(T2, T22, Ti * T21);
			      T2B = FNMS(T22, T2A, T21 * T2z);
			 }
			 T4q = T2B - T2G;
			 T4t = T4r - T4s;
			 T27 = FMA(T23, T24, T25 * T26);
			 T4a = FNMS(T25, T24, T23 * T26);
			 {
			      E T2I, T2K, T1M, T1P;
			      T2I = T2o + T2p;
			      T2K = T2s - T2t;
			      T2M = FNMS(T2K, T2L, T2I * T2J);
			      T4m = FMA(T2K, T2J, T2I * T2L);
			      T1M = T1K - T1L;
			      T1P = T1N + T1O;
			      T1Q = FMA(T2, T1M, Ti * T1P);
			      T4n = FNMS(T1P, T2N, T1M * T2O);
			      T1S = FNMS(Ti, T1M, T2 * T1P);
			      T2P = FMA(T1M, T2N, T1P * T2O);
			 }
			 T4l = T2M - T2P;
			 T4o = T4m - T4n;
			 T1U = FNMS(T1S, T1T, T1Q * T1R);
			 T44 = FMA(T1S, T1R, T1Q * T1T);
		    }
	       }
	  }
	  Tn = rio[WS(ios, 16)];
	  Tp = iio[-WS(ios, 15)];
	  T7G = iio[-WS(ios, 31)];
	  {
	       E T1i, T7V, T6i, T7D, T42, T5e, T5A, T60, T6o, T6Y, TL, T6f, T3F, T5t, T7I;
	       E T8q, T7W, T8c, T3Q, T8p, T5w, T89, T4d, T61, T5f, T5D, T2a, T6t, T7O, T7C;
	       E T7g, T6Z, T4w, T64, T65, T4F, T5i, T5I, T5L, T5j, T2S, T7l, T7y, T6A, T6F;
	       E T73, T7i, T72, T4X, T67, T68, T56, T5l, T5P, T5S, T5m, T3z, T7q, T7z, T6L;
	       E T6Q, T76, T7n, T75;
	       {
		    E TY, T6g, T3W, T41;
		    TY = TQ + TX;
		    T1i = TY + T1h;
		    T7V = T1h - TY;
		    T6g = T3G + T3H;
		    T6i = T6g - T6h;
		    T7D = T6g + T6h;
		    T3W = T3U + T3V;
		    T41 = T3X - T40;
		    T42 = FNMS(KP923879532, T41, KP382683432 * T3W);
		    T5e = FMA(KP923879532, T3W, KP382683432 * T41);
	       }
	       {
		    E T5y, T5z, T6m, T6n;
		    T5y = T3U - T3V;
		    T5z = T3X + T40;
		    T5A = FNMS(KP382683432, T5z, KP923879532 * T5y);
		    T60 = FMA(KP382683432, T5y, KP923879532 * T5z);
		    T6m = T6k - T6l;
		    T6n = T1s - T1D;
		    T6o = T6m - T6n;
		    T6Y = T6n + T6m;
	       }
	       {
		    E Tr, T3B, Tq, T7H, T8a, T7F;
		    Tq = FMA(Tm, Tn, To * Tp);
		    Tr = T1 + Tq;
		    T3B = T1 - Tq;
		    TL = Tr + TK;
		    T6f = Tr - TK;
		    T3F = T3B - T3E;
		    T5t = T3B + T3E;
		    T7F = FNMS(To, Tn, Tm * Tp);
		    T7H = T7F + T7G;
		    T8a = T7G - T7F;
		    T7I = T7E + T7H;
		    T8q = T8b + T8a;
		    T7W = T7H - T7E;
		    T8c = T8a - T8b;
	       }
	       {
		    E T3P, T5v, T3K, T5u, T3I, T3J;
		    T3P = T3L + T3O;
		    T5v = T3L - T3O;
		    T3I = T3G - T3H;
		    T3J = TQ - TX;
		    T3K = T3I - T3J;
		    T5u = T3J + T3I;
		    T3Q = KP707106781 * (T3K - T3P);
		    T8p = KP707106781 * (T5v - T5u);
		    T5w = KP707106781 * (T5u + T5v);
		    T89 = KP707106781 * (T3K + T3P);
	       }
	       {
		    E T47, T5B, T4c, T5C;
		    {
			 E T45, T46, T48, T4b;
			 T45 = T43 - T44;
			 T46 = T20 - T27;
			 T47 = T45 + T46;
			 T5B = T45 - T46;
			 T48 = T1J - T1U;
			 T4b = T49 - T4a;
			 T4c = T48 - T4b;
			 T5C = T48 + T4b;
		    }
		    T4d = FMA(KP382683432, T47, KP923879532 * T4c);
		    T61 = FNMS(KP382683432, T5B, KP923879532 * T5C);
		    T5f = FNMS(KP923879532, T47, KP382683432 * T4c);
		    T5D = FMA(KP923879532, T5B, KP382683432 * T5C);
	       }
	       {
		    E T1E, T7e, T29, T6p, T6s, T7f;
		    T1E = T1s + T1D;
		    T7e = T6k + T6l;
		    {
			 E T1V, T28, T6q, T6r;
			 T1V = T1J + T1U;
			 T28 = T20 + T27;
			 T29 = T1V + T28;
			 T6p = T1V - T28;
			 T6q = T43 + T44;
			 T6r = T49 + T4a;
			 T6s = T6q - T6r;
			 T7f = T6q + T6r;
		    }
		    T2a = T1E + T29;
		    T6t = T6p + T6s;
		    T7O = T29 - T1E;
		    T7C = T7e + T7f;
		    T7g = T7e - T7f;
		    T6Z = T6p - T6s;
	       }
	       {
		    E T4k, T5J, T4B, T5G, T4v, T5H, T4E, T5K, T4j, T4A;
		    T4j = T2n - T2w;
		    T4k = T4i + T4j;
		    T5J = T4i - T4j;
		    T4A = T4y - T4z;
		    T4B = T4x - T4A;
		    T5G = T4x + T4A;
		    {
			 E T4p, T4u, T4C, T4D;
			 T4p = T4l - T4o;
			 T4u = T4q + T4t;
			 T4v = KP707106781 * (T4p - T4u);
			 T5H = KP707106781 * (T4u + T4p);
			 T4C = T4t - T4q;
			 T4D = T4l + T4o;
			 T4E = KP707106781 * (T4C - T4D);
			 T5K = KP707106781 * (T4C + T4D);
		    }
		    T4w = T4k - T4v;
		    T64 = T5G + T5H;
		    T65 = T5J + T5K;
		    T4F = T4B - T4E;
		    T5i = T4k + T4v;
		    T5I = T5G - T5H;
		    T5L = T5J - T5K;
		    T5j = T4B + T4E;
	       }
	       {
		    E T2y, T6B, T6y, T7j, T2R, T6z, T6E, T7k, T2x, T6x;
		    T2x = T2n + T2w;
		    T2y = T2k + T2x;
		    T6B = T2k - T2x;
		    T6x = T4y + T4z;
		    T6y = T6w - T6x;
		    T7j = T6w + T6x;
		    {
			 E T2H, T2Q, T6C, T6D;
			 T2H = T2B + T2G;
			 T2Q = T2M + T2P;
			 T2R = T2H + T2Q;
			 T6z = T2Q - T2H;
			 T6C = T4r + T4s;
			 T6D = T4m + T4n;
			 T6E = T6C - T6D;
			 T7k = T6C + T6D;
		    }
		    T2S = T2y + T2R;
		    T7l = T7j - T7k;
		    T7y = T7j + T7k;
		    T6A = T6y - T6z;
		    T6F = T6B - T6E;
		    T73 = T6B + T6E;
		    T7i = T2y - T2R;
		    T72 = T6y + T6z;
	       }
	       {
		    E T4L, T5N, T55, T5O, T4W, T5R, T52, T5Q;
		    {
			 E T4H, T4K, T53, T54;
			 T4H = T31 - T36;
			 T4K = T4I - T4J;
			 T4L = T4H - T4K;
			 T5N = T4H + T4K;
			 T53 = T4R - T4U;
			 T54 = T4P + T4O;
			 T55 = KP707106781 * (T53 - T54);
			 T5O = KP707106781 * (T54 + T53);
		    }
		    {
			 E T4Q, T4V, T50, T51;
			 T4Q = T4O - T4P;
			 T4V = T4R + T4U;
			 T4W = KP707106781 * (T4Q - T4V);
			 T5R = KP707106781 * (T4Q + T4V);
			 T50 = T4Y - T4Z;
			 T51 = T3a - T3f;
			 T52 = T50 + T51;
			 T5Q = T50 - T51;
		    }
		    T4X = T4L - T4W;
		    T67 = T5N + T5O;
		    T68 = T5Q + T5R;
		    T56 = T52 - T55;
		    T5l = T4L + T4W;
		    T5P = T5N - T5O;
		    T5S = T5Q - T5R;
		    T5m = T52 + T55;
	       }
	       {
		    E T3y, T6P, T6K, T7p, T3h, T6H, T6O, T7o, T3x, T6J;
		    T3x = T3t + T3w;
		    T3y = T3q + T3x;
		    T6P = T3x - T3q;
		    T6J = T4S + T4T;
		    T6K = T6I - T6J;
		    T7p = T6I + T6J;
		    {
			 E T37, T3g, T6M, T6N;
			 T37 = T31 + T36;
			 T3g = T3a + T3f;
			 T3h = T37 + T3g;
			 T6H = T37 - T3g;
			 T6M = T4Y + T4Z;
			 T6N = T4I + T4J;
			 T6O = T6M - T6N;
			 T7o = T6M + T6N;
		    }
		    T3z = T3h + T3y;
		    T7q = T7o - T7p;
		    T7z = T7o + T7p;
		    T6L = T6H - T6K;
		    T6Q = T6O - T6P;
		    T76 = T6O + T6P;
		    T7n = T3h - T3y;
		    T75 = T6H + T6K;
	       }
	       {
		    E T3A, T7A, T2b, T7x, T1j;
		    T3A = T2S + T3z;
		    T7A = T7y - T7z;
		    T1j = TL + T1i;
		    T2b = T1j + T2a;
		    T7x = T1j - T2a;
		    iio[-WS(ios, 16)] = T2b - T3A;
		    rio[WS(ios, 8)] = T7x + T7A;
		    rio[0] = T2b + T3A;
		    iio[-WS(ios, 24)] = T7x - T7A;
	       }
	       {
		    E T7B, T7L, T7K, T7M, T7J;
		    T7B = T7y + T7z;
		    T7L = T3z - T2S;
		    T7J = T7D + T7I;
		    T7K = T7C + T7J;
		    T7M = T7J - T7C;
		    rio[WS(ios, 16)] = T7B - T7K;
		    iio[-WS(ios, 8)] = T7L + T7M;
		    iio[0] = T7B + T7K;
		    rio[WS(ios, 24)] = T7L - T7M;
	       }
	       {
		    E T7h, T7t, T7Q, T7S, T7s, T7R, T7w, T7N, T7d, T7P;
		    T7d = TL - T1i;
		    T7h = T7d + T7g;
		    T7t = T7d - T7g;
		    T7P = T7I - T7D;
		    T7Q = T7O + T7P;
		    T7S = T7P - T7O;
		    {
			 E T7m, T7r, T7u, T7v;
			 T7m = T7i + T7l;
			 T7r = T7n - T7q;
			 T7s = KP707106781 * (T7m + T7r);
			 T7R = KP707106781 * (T7r - T7m);
			 T7u = T7l - T7i;
			 T7v = T7n + T7q;
			 T7w = KP707106781 * (T7u - T7v);
			 T7N = KP707106781 * (T7u + T7v);
		    }
		    iio[-WS(ios, 20)] = T7h - T7s;
		    rio[WS(ios, 20)] = T7N - T7Q;
		    rio[WS(ios, 4)] = T7h + T7s;
		    iio[-WS(ios, 4)] = T7N + T7Q;
		    iio[-WS(ios, 28)] = T7t - T7w;
		    rio[WS(ios, 28)] = T7R - T7S;
		    rio[WS(ios, 12)] = T7t + T7w;
		    iio[-WS(ios, 12)] = T7R + T7S;
	       }
	       {
		    E T71, T79, T7Y, T80, T78, T7Z, T7c, T7T;
		    {
			 E T6X, T70, T7U, T7X;
			 T6X = T6f + T6i;
			 T70 = KP707106781 * (T6Y + T6Z);
			 T71 = T6X + T70;
			 T79 = T6X - T70;
			 T7U = KP707106781 * (T6o + T6t);
			 T7X = T7V + T7W;
			 T7Y = T7U + T7X;
			 T80 = T7X - T7U;
		    }
		    {
			 E T74, T77, T7a, T7b;
			 T74 = FMA(KP382683432, T72, KP923879532 * T73);
			 T77 = FNMS(KP382683432, T76, KP923879532 * T75);
			 T78 = T74 + T77;
			 T7Z = T77 - T74;
			 T7a = FNMS(KP382683432, T73, KP923879532 * T72);
			 T7b = FMA(KP923879532, T76, KP382683432 * T75);
			 T7c = T7a - T7b;
			 T7T = T7a + T7b;
		    }
		    iio[-WS(ios, 18)] = T71 - T78;
		    rio[WS(ios, 18)] = T7T - T7Y;
		    rio[WS(ios, 2)] = T71 + T78;
		    iio[-WS(ios, 2)] = T7T + T7Y;
		    iio[-WS(ios, 26)] = T79 - T7c;
		    rio[WS(ios, 26)] = T7Z - T80;
		    rio[WS(ios, 10)] = T79 + T7c;
		    iio[-WS(ios, 10)] = T7Z + T80;
	       }
	       {
		    E T4f, T59, T8y, T8A, T58, T8z, T5c, T8v;
		    {
			 E T3R, T4e, T8w, T8x;
			 T3R = T3F - T3Q;
			 T4e = T42 - T4d;
			 T4f = T3R + T4e;
			 T59 = T3R - T4e;
			 T8w = T5f - T5e;
			 T8x = T8q - T8p;
			 T8y = T8w + T8x;
			 T8A = T8x - T8w;
		    }
		    {
			 E T4G, T57, T5a, T5b;
			 T4G = FMA(KP980785280, T4w, KP195090322 * T4F);
			 T57 = FNMS(KP980785280, T56, KP195090322 * T4X);
			 T58 = T4G + T57;
			 T8z = T57 - T4G;
			 T5a = FNMS(KP980785280, T4F, KP195090322 * T4w);
			 T5b = FMA(KP195090322, T56, KP980785280 * T4X);
			 T5c = T5a - T5b;
			 T8v = T5a + T5b;
		    }
		    iio[-WS(ios, 23)] = T4f - T58;
		    rio[WS(ios, 23)] = T8v - T8y;
		    rio[WS(ios, 7)] = T4f + T58;
		    iio[-WS(ios, 7)] = T8v + T8y;
		    iio[-WS(ios, 31)] = T59 - T5c;
		    rio[WS(ios, 31)] = T8z - T8A;
		    rio[WS(ios, 15)] = T59 + T5c;
		    iio[-WS(ios, 15)] = T8z + T8A;
	       }
	       {
		    E T5F, T5V, T8k, T8m, T5U, T8l, T5Y, T8h;
		    {
			 E T5x, T5E, T8i, T8j;
			 T5x = T5t - T5w;
			 T5E = T5A - T5D;
			 T5F = T5x + T5E;
			 T5V = T5x - T5E;
			 T8i = T61 - T60;
			 T8j = T8c - T89;
			 T8k = T8i + T8j;
			 T8m = T8j - T8i;
		    }
		    {
			 E T5M, T5T, T5W, T5X;
			 T5M = FMA(KP555570233, T5I, KP831469612 * T5L);
			 T5T = FNMS(KP831469612, T5S, KP555570233 * T5P);
			 T5U = T5M + T5T;
			 T8l = T5T - T5M;
			 T5W = FNMS(KP831469612, T5I, KP555570233 * T5L);
			 T5X = FMA(KP831469612, T5P, KP555570233 * T5S);
			 T5Y = T5W - T5X;
			 T8h = T5W + T5X;
		    }
		    iio[-WS(ios, 21)] = T5F - T5U;
		    rio[WS(ios, 21)] = T8h - T8k;
		    rio[WS(ios, 5)] = T5F + T5U;
		    iio[-WS(ios, 5)] = T8h + T8k;
		    iio[-WS(ios, 29)] = T5V - T5Y;
		    rio[WS(ios, 29)] = T8l - T8m;
		    rio[WS(ios, 13)] = T5V + T5Y;
		    iio[-WS(ios, 13)] = T8l + T8m;
	       }
	       {
		    E T6v, T6T, T84, T86, T6S, T85, T6W, T81;
		    {
			 E T6j, T6u, T82, T83;
			 T6j = T6f - T6i;
			 T6u = KP707106781 * (T6o - T6t);
			 T6v = T6j + T6u;
			 T6T = T6j - T6u;
			 T82 = KP707106781 * (T6Z - T6Y);
			 T83 = T7W - T7V;
			 T84 = T82 + T83;
			 T86 = T83 - T82;
		    }
		    {
			 E T6G, T6R, T6U, T6V;
			 T6G = FMA(KP923879532, T6A, KP382683432 * T6F);
			 T6R = FNMS(KP923879532, T6Q, KP382683432 * T6L);
			 T6S = T6G + T6R;
			 T85 = T6R - T6G;
			 T6U = FNMS(KP923879532, T6F, KP382683432 * T6A);
			 T6V = FMA(KP382683432, T6Q, KP923879532 * T6L);
			 T6W = T6U - T6V;
			 T81 = T6U + T6V;
		    }
		    iio[-WS(ios, 22)] = T6v - T6S;
		    rio[WS(ios, 22)] = T81 - T84;
		    rio[WS(ios, 6)] = T6v + T6S;
		    iio[-WS(ios, 6)] = T81 + T84;
		    iio[-WS(ios, 30)] = T6T - T6W;
		    rio[WS(ios, 30)] = T85 - T86;
		    rio[WS(ios, 14)] = T6T + T6W;
		    iio[-WS(ios, 14)] = T85 + T86;
	       }
	       {
		    E T5h, T5p, T8s, T8u, T5o, T8t, T5s, T8n;
		    {
			 E T5d, T5g, T8o, T8r;
			 T5d = T3F + T3Q;
			 T5g = T5e + T5f;
			 T5h = T5d + T5g;
			 T5p = T5d - T5g;
			 T8o = T42 + T4d;
			 T8r = T8p + T8q;
			 T8s = T8o + T8r;
			 T8u = T8r - T8o;
		    }
		    {
			 E T5k, T5n, T5q, T5r;
			 T5k = FMA(KP555570233, T5i, KP831469612 * T5j);
			 T5n = FNMS(KP555570233, T5m, KP831469612 * T5l);
			 T5o = T5k + T5n;
			 T8t = T5n - T5k;
			 T5q = FNMS(KP555570233, T5j, KP831469612 * T5i);
			 T5r = FMA(KP831469612, T5m, KP555570233 * T5l);
			 T5s = T5q - T5r;
			 T8n = T5q + T5r;
		    }
		    iio[-WS(ios, 19)] = T5h - T5o;
		    rio[WS(ios, 19)] = T8n - T8s;
		    rio[WS(ios, 3)] = T5h + T5o;
		    iio[-WS(ios, 3)] = T8n + T8s;
		    iio[-WS(ios, 27)] = T5p - T5s;
		    rio[WS(ios, 27)] = T8t - T8u;
		    rio[WS(ios, 11)] = T5p + T5s;
		    iio[-WS(ios, 11)] = T8t + T8u;
	       }
	       {
		    E T63, T6b, T8e, T8g, T6a, T8f, T6e, T87;
		    {
			 E T5Z, T62, T88, T8d;
			 T5Z = T5t + T5w;
			 T62 = T60 + T61;
			 T63 = T5Z + T62;
			 T6b = T5Z - T62;
			 T88 = T5A + T5D;
			 T8d = T89 + T8c;
			 T8e = T88 + T8d;
			 T8g = T8d - T88;
		    }
		    {
			 E T66, T69, T6c, T6d;
			 T66 = FMA(KP980785280, T64, KP195090322 * T65);
			 T69 = FNMS(KP195090322, T68, KP980785280 * T67);
			 T6a = T66 + T69;
			 T8f = T69 - T66;
			 T6c = FNMS(KP195090322, T64, KP980785280 * T65);
			 T6d = FMA(KP195090322, T67, KP980785280 * T68);
			 T6e = T6c - T6d;
			 T87 = T6c + T6d;
		    }
		    iio[-WS(ios, 17)] = T63 - T6a;
		    rio[WS(ios, 17)] = T87 - T8e;
		    rio[WS(ios, 1)] = T63 + T6a;
		    iio[-WS(ios, 1)] = T87 + T8e;
		    iio[-WS(ios, 25)] = T6b - T6e;
		    rio[WS(ios, 25)] = T8f - T8g;
		    rio[WS(ios, 9)] = T6b + T6e;
		    iio[-WS(ios, 9)] = T8f + T8g;
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_COS, 0, 1},
     {TW_SIN, 0, 1},
     {TW_COS, 0, 3},
     {TW_SIN, 0, 3},
     {TW_COS, 0, 9},
     {TW_SIN, 0, 9},
     {TW_COS, 0, 27},
     {TW_SIN, 0, 27},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hf2_32", twinstr, {376, 168, 112, 0}, &GENUS, 0, 0, 0 };

void X(codelet_hf2_32) (planner *p) {
     X(khc2hc_dit_register) (p, hf2_32, &desc);
}
