#ifndef FILELIST_H
#define FILELIST_H

#include <sys/stat.h>

#ifndef GNOME_H
#include <gnome.h>
#endif

#ifndef PROTOCOL_H
#include "protocol.h"
#endif

typedef struct {
  char *name;
  int size;
  char type[5],creator[5];
  unsigned int is_folder:1,is_selected:1;
} FileEntry;

typedef struct {
  Connection *c;
  GtkWidget *frame;
  GtkWidget *list;
  GtkWidget *path_menu,*path_widget;
  GtkWidget *toolbar[8];
  FileEntry **files;
  FileEntry *last_selected;
  unsigned short count_selected;
  unsigned short numfiles;
  char sortby;
  char is_remote;
  char numpaths;
  char **path;
  short viewpos[30];
  char view;
  gpointer data;
  struct _FLOps *flops;
} FileList;


typedef struct _FLOps {
  int is_remote;
  void (*change_selection)(FileList *,gpointer);
  void (*refresh)(FileList *,gpointer);
  void (*mkdir)(FileList *,char *name,gpointer);
  void (*start_transfer)(FileList *,FileEntry *which,gpointer);
  void (*delete)(FileList *,int which,gpointer);
  void (*chdir_to)(FileList *,int which,gpointer);
  void (*select_one)(FileList *,FileEntry *which,gpointer);
  void (*properties)(FileList *,FileEntry *which,gpointer);
} FLOps;

FileList *filelist_new(Connection *c,FLOps *,gpointer data);
void filelist_destroy(FileList *fl);
void filelist_clear(FileList *fl);
void filelist_set_contents(FileList *fl,int count, FileEntry **files);
void filelist_set_path(FileList *fl,char **path);
void filelist_deselect_all(gpointer dummy,FileList *fl);
void filelist_select_all(FileList *fl);
void filelist_start_transfer(FileList *fl);
void filelist_set_busy(FileList *);
void filelist_viewpush(FileList *, short);
void filelist_change_selection(FileList *);
void filelist_viewpopsel(FileList *);

FileEntry *fileentry_new_from_stat(char *name, struct stat *buf);
FileEntry *fileentry_new_from_object(HLObject *o);
void fileentry_free(FileEntry *fe);

#define FL_SETALLFILES(k, fl, field, value) for(k=0; k<fl->numfiles;k++) fl->files[k]->field=value
#define FL_DOALLSELECTED(i, fl, action)	    for(i = 0; i<fl->numfiles; i++){if(fl->files[i]->is_selected) {action;}}

#endif
