//   ___________		     _________		      _____  __
//   \_	  _____/______   ____   ____ \_   ___ \____________ _/ ____\/  |_
//    |    __) \_  __ \_/ __ \_/ __ \/    \  \/\_  __ \__  \\   __\\   __|
//    |     \   |  | \/\  ___/\  ___/\     \____|  | \// __ \|  |   |  |
//    \___  /   |__|    \___  >\___  >\______  /|__|  (____  /__|   |__|
//	  \/		    \/	   \/	     \/		   \/
//  ______________________                           ______________________
//			  T H E   W A R   B E G I N S
//   Utility for FreeCraft - A free fantasy real time strategy game engine
//
/**@name wartool.c	-	Extract files from war archives. */
//
//	(c) Copyright 1999-2003 by Lutz Sammer
//
//	FreeCraft is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published
//	by the Free Software Foundation; only version 2 of the License.
//
//	FreeCraft is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	$Id: wartool.c,v 1.83 2003/03/08 07:13:34 jsalmon3 Exp $

//@{

/*----------------------------------------------------------------------------
--	Includes
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef _MSC_VER
#include <fcntl.h>
#endif
#include <ctype.h>
#include <png.h>

#include "freecraft.h"
#include "iocompat.h"
#include "myendian.h"

#if defined(_MSC_VER) || defined(__MINGW32__) || defined(USE_BEOS)
typedef unsigned long u_int32_t;
#endif

//----------------------------------------------------------------------------
//	Config
//----------------------------------------------------------------------------

/**
**	Destination directory of the graphics
*/
char* Dir;

/**
**	Path to the tileset graphics. (default=$DIR/graphics/tilesets)
*/
#define TILESET_PATH	"graphics/tilesets"

/**
**	Path to the unit graphics. (default=$DIR/graphics)
*/
#define UNIT_PATH	"graphics"

/**
**	Path the pud files. (default=$DIR)
*/
#define PUD_PATH	"."

/**
**	Path the font files. (default=$DIR/graphics/ui/fonts)
*/
#define FONT_PATH	"graphics/ui/fonts"

/**
**	Path the cursor files. (default=$DIR/graphic/ui/)
*/
#define CURSOR_PATH	"graphics/ui"

/**
**	Path the graphic files. (default=$DIR/graphic)
*/
#define GRAPHIC_PATH	"graphics"

/**
**	Path the sound files. (default=$DIR/sounds)
*/
#define SOUND_PATH	"sounds"

/**
**	Path the sound files. (default=$DIR/music)
*/
#define MUSIC_PATH	"music"

/**
**	Path the text files. (default=$DIR/texts)
*/
#define TEXT_PATH	"campaigns"

/**
**	How much tiles are stored in a row.
*/
#define TILE_PER_ROW	16

//----------------------------------------------------------------------------

/**
**	Conversion control sturcture.
*/
typedef struct _control_ {
    int		Type;			/// Entry type
    int		Version;		/// Only in this version
    char*	File;			/// Save file
    int		Arg1;			/// Extra argument 1
    int		Arg2;			/// Extra argument 2
    int		Arg3;			/// Extra argument 3
    int		Arg4;			/// Extra argument 4
} Control;

/**
**	Palette N27, for credits cursor
*/
unsigned char* Pal27;

/**
**  True if arguments specified that we should treat the CD as a Mac one
*/
unsigned char UseMacCd;

/**
**	Original archive buffer.
*/
unsigned char* ArchiveBuffer;

/**
**	Offsets for each entry into original archive buffer.
*/
unsigned char** ArchiveOffsets;

/**
**	Possible entry types of archive file.
*/
enum _archive_type_ {
    S,			// Setup
    F,			// File				(name)
    T,			// Tileset			(name,pal,mega,mini,map)
    R,			// RGB -> gimp			(name,rgb)
    G,			// Graphics			(name,pal,gfx)
    U,			// Uncompressed Graphics	(name,pal,gfu)
    P,			// Pud				(name,idx)
    N,			// Font				(name,idx)
    I,			// Image			(name,pal,img)
    W,			// Wav				(name,wav)
    X,			// Text				(name,text,ofs)
    C,			// Cursor			(name,cursor)
    V,			// Video			(name)
#ifndef NO_IMPORT_CAMPAIGNS
    L,			// Campaign Levels		
#endif
};

char* ArchiveDir;

/**
**	What, where, how to extract.
**
**	FIXME: version alpha, demo, 1.00, 1.31, 1.40, 1.50 dependend!
*/
Control Todo[] = {
#define __	,0,0,0
#define _2	,0,0,

///////////////////////////////////////////////////////////////////////////////
//	TEXT	(must be done for all others!)
///////////////////////////////////////////////////////////////////////////////

#ifdef USE_BEOS
{F,0,"REZDAT.WAR",				3000 __},
#else
{F,0,"rezdat.war",				3000 __},
#endif
{I,0,"ui/Credits background",			27, 28 _2},

#ifdef USE_BEOS
{F,0,"STRDAT.WAR",				4000 __},
#else
{F,0,"strdat.war",				4000 __},
#endif
{S,0,"unit_names",						  1	__},
#ifndef NO_IMPORT_CAMPAIGNS
{L,0,"objectives",						 54 ,236	_2},
#else
{X,0,"objectives",                                               54     __},
#endif
{X,0,"human/dialog",						 55	__},
{X,0,"orc/dialog",						 56	__},
{X,0,"credits",							 58 ,4	_2},

{X,0,"human/level01h",						 65 ,4	_2},
{X,0,"orc/level01o",						 66 ,4	_2},
{X,0,"human/level02h",						 67 ,4	_2},
{X,0,"orc/level02o",						 68 ,4	_2},
{X,0,"human/level03h",						 69 ,4	_2},
{X,0,"orc/level03o",						 70 ,4	_2},
{X,0,"human/level04h",						 71 ,4	_2},
{X,0,"orc/level04o",						 72 ,4	_2},
{X,0,"human/level05h",						 73 ,4	_2},
{X,0,"orc/level05o",						 74 ,4	_2},
{X,0,"human/level06h",						 75 ,4	_2},
{X,0,"orc/level06o",						 76 ,4	_2},
{X,0,"human/level07h",						 77 ,4	_2},
{X,0,"orc/level07o",						 78 ,4	_2},
{X,0,"human/level08h",						 79 ,4	_2},
{X,0,"orc/level08o",						 80 ,4	_2},
{X,0,"human/level09h",						 81 ,4	_2},
{X,0,"orc/level09o",						 82 ,4	_2},
{X,0,"human/level10h",						 83 ,4	_2},
{X,0,"orc/level10o",						 84 ,4	_2},
{X,0,"human/level11h",						 85 ,4	_2},
{X,0,"orc/level11o",						 86 ,4	_2},
{X,0,"human/level12h",						 87 ,4	_2},
{X,0,"orc/level12o",						 88 ,4	_2},
{X,0,"human/level13h",						 89 ,4	_2},
{X,0,"orc/level13o",						 90 ,4	_2},
{X,0,"human/level14h",						 91 ,4	_2},
{X,0,"orc/level14o",						 92 ,4	_2},
{X,2,"human-exp/levelx01h",						 99 ,4	_2},
{X,2,"orc-exp/levelx01o",						100 ,4	_2},
{X,2,"human-exp/levelx02h",						101 ,4	_2},
{X,2,"orc-exp/levelx02o",						102 ,4	_2},
{X,2,"human-exp/levelx03h",						103 ,4	_2},
{X,2,"orc-exp/levelx03o",						104 ,4	_2},
{X,2,"human-exp/levelx04h",						105 ,4	_2},
{X,2,"orc-exp/levelx04o",						106 ,4	_2},
{X,2,"human-exp/levelx05h",						107 ,4	_2},
{X,2,"orc-exp/levelx05o",						108 ,4	_2},
{X,2,"human-exp/levelx06h",						109 ,4	_2},
{X,2,"orc-exp/levelx06o",						110 ,4	_2},
{X,2,"human-exp/levelx07h",						111 ,4	_2},
{X,2,"orc-exp/levelx07o",						112 ,4	_2},
{X,2,"human-exp/levelx08h",						113 ,4	_2},
{X,2,"orc-exp/levelx08o",						114 ,4	_2},
{X,2,"human-exp/levelx09h",						115 ,4	_2},
{X,2,"orc-exp/levelx09o",						116 ,4	_2},
{X,2,"human-exp/levelx10h",						117 ,4	_2},
{X,2,"orc-exp/levelx10o",						118 ,4	_2},
{X,2,"human-exp/levelx11h",						119 ,4	_2},
{X,2,"orc-exp/levelx11o",						120 ,4	_2},
{X,2,"human-exp/levelx12h",						121 ,4	_2},
{X,2,"orc-exp/levelx12o",						122 ,4	_2},
{X,2,"credits2",						123 ,4	_2},
{X,2,"credits-ext.txt",						124	__},

///////////////////////////////////////////////////////////////////////////////
//	MOST THINGS
///////////////////////////////////////////////////////////////////////////////

#ifdef USE_BEOS
{F,0,"MAINDAT.WAR",				1000 __},
#else
{F,0,"maindat.war",				1000 __},
#endif

{R,0,"summer/summer",						 2	__},
{T,0,"summer/terrain/summer",			 2,	 3,	 4,	 5 },
{R,0,"wasteland/wasteland",					10	__},
{T,0,"wasteland/terrain/wasteland",		10,	11,	12,	13 },
{R,0,"winter/winter",						18	__},
{T,0,"winter/terrain/winter",			18,	19,	20,	21 },

{G,0,"human/units/%16",						 2,  33	_2},
{G,0,"orc/units/%17",						 2,  34	_2},
{G,0,"human/units/%44",						 2,  35	_2},
{G,0,"orc/units/%45",						 2,  36	_2},
{G,0,"orc/units/%47",						 2,  37	_2},
{G,0,"human/units/%42",						 2,  38	_2},
{G,0,"human/units/%-30",					 2,  39	_2},
{G,0,"orc/units/%-31",						 2,  40	_2},
{G,0,"human/units/%34",						 2,  41	_2},
{G,0,"orc/units/%35",						 2,  42	_2},
{G,0,"human/units/%40",						 2,  43	_2},
{G,0,"orc/units/%41",						 2,  44	_2},
{G,0,"human/units/%2",						 2,  45	_2},
{G,0,"orc/units/%3",						 2,  46	_2},
{G,0,"human/units/%4",						 2,  47	_2},
{G,0,"orc/units/%5",						 2,  48	_2},
{G,0,"human/units/%6",						 2,  49	_2},
{G,0,"orc/units/%7",						 2,  50	_2},
{G,0,"human/units/%8",						 2,  51	_2},
{G,0,"orc/units/%9",						 2,  52	_2},
{G,0,"human/units/%10",						 2,  53	_2},
{G,0,"orc/units/%11",						 2,  54	_2},
{G,0,"human/units/%12",						 2,  55	_2},
{G,0,"orc/units/%13",						 2,  58	_2},
{G,0,"human/units/%-28 empty",					 2,  59	_2},
{G,0,"orc/units/%-29 empty",					 2,  60	_2},
{G,0,"human/units/%32",						 2,  61	_2},
{G,0,"orc/units/%33",						 2,  62	_2},
{G,0,"orc/units/%43",						 2,  63	_2},
{G,0,"tilesets/summer/neutral/units/%59",			 2,  64	_2},
{G,0,"tilesets/wasteland/neutral/units/%59",			10,  65	_2},
{G,0,"tilesets/winter/neutral/units/%59",			18,  66	_2},
{G,0,"neutral/units/%57",					 2,  69	_2},
{G,0,"neutral/units/%58",					 2,  70	_2},
// 71-79 unknown
{G,0,"tilesets/summer/human/buildings/%-98",			 2,  80	_2},
{G,0,"tilesets/summer/orc/buildings/%-99",			 2,  81	_2},
{G,0,"tilesets/summer/human/buildings/%-100",			 2,  82	_2},
{G,0,"tilesets/summer/orc/buildings/%-101",			 2,  83	_2},
{G,0,"tilesets/summer/human/buildings/%82",			 2,  84	_2},
{G,0,"tilesets/summer/orc/buildings/%83",			 2,  85	_2},
{G,0,"tilesets/summer/human/buildings/%90",			 2,  86	_2},
{G,0,"tilesets/summer/orc/buildings/%91",			 2,  87	_2},
{G,0,"tilesets/summer/human/buildings/%72",			 2,  88	_2},
{G,0,"tilesets/summer/orc/buildings/%73",			 2,  89	_2},
{G,0,"tilesets/summer/human/buildings/%70",			 2,  90	_2},
{G,0,"tilesets/summer/orc/buildings/%71",			 2,  91	_2},
{G,0,"tilesets/summer/human/buildings/%60",			 2,  92	_2},
{G,0,"tilesets/summer/orc/buildings/%61",			 2,  93	_2},
{G,0,"tilesets/summer/human/buildings/%-62",			 2,  94	_2},
{G,0,"tilesets/summer/orc/buildings/%-63",			 2,  95	_2},
{G,0,"tilesets/summer/human/buildings/%64",			 2,  96	_2},
{G,0,"tilesets/summer/orc/buildings/%65",			 2,  97	_2},
{G,0,"tilesets/summer/human/buildings/%66",			 2,  98	_2},
{G,0,"tilesets/summer/orc/buildings/%67",			 2,  99	_2},
{G,0,"tilesets/summer/human/buildings/%76",			 2, 100	_2},
{G,0,"tilesets/summer/orc/buildings/%77",			 2, 101	_2},
{G,0,"tilesets/summer/human/buildings/%78",			 2, 102	_2},
{G,0,"tilesets/summer/orc/buildings/%79",			 2, 103	_2},
{G,0,"tilesets/summer/human/buildings/%68",			 2, 104	_2},
{G,0,"tilesets/summer/orc/buildings/%69",			 2, 105	_2},
{G,0,"tilesets/summer/human/buildings/%-84",			 2, 106	_2},
{G,0,"tilesets/summer/orc/buildings/%-85",			 2, 107	_2},
{G,0,"tilesets/summer/human/buildings/%-74",			 2, 108	_2},
{G,0,"tilesets/summer/orc/buildings/%-75",			 2, 109	_2},
{G,0,"tilesets/summer/human/buildings/%-80",			 2, 110	_2},
{G,0,"tilesets/summer/orc/buildings/%-81",			 2, 111	_2},
{G,0,"tilesets/summer/human/buildings/%-86",			 2, 112	_2},
{G,0,"tilesets/summer/orc/buildings/%-87",			 2, 113	_2},
{G,0,"tilesets/summer/human/buildings/%-88",			 2, 114	_2},
{G,0,"tilesets/summer/orc/buildings/%-89",			 2, 115	_2},
{G,0,"tilesets/summer/human/buildings/%92",			 2, 116	_2},
{G,0,"tilesets/summer/orc/buildings/%93",			 2, 117	_2},
{G,0,"tilesets/summer/neutral/buildings/%95",			 2, 118	_2},
{G,0,"tilesets/summer/neutral/buildings/%94",			 2, 119	_2},
{G,0,"neutral/units/corpses",					 2, 120	_2},
{G,0,"tilesets/summer/neutral/buildings/destroyed site",	 2, 121	_2},
    // Hardcoded support for worker with resource repairing
{G,0,"human/units/%4 with wood",				 2, 122, 47, 25},
{G,0,"orc/units/%5 with wood",					 2, 123, 48, 25},
{G,0,"human/units/%4 with gold",				 2, 124, 47, 25},
{G,0,"orc/units/%5 with gold",					 2, 125, 48, 25},
{G,0,"human/units/%-28 full",					 2, 126	_2},
{G,0,"orc/units/%-29 full",					 2, 127	_2},
{G,0,"tilesets/winter/human/buildings/%90",			18, 128	_2},
{G,0,"tilesets/winter/orc/buildings/%91",			18, 129	_2},
{G,0,"tilesets/winter/human/buildings/%72",			18, 130	_2},
{G,0,"tilesets/winter/orc/buildings/%73",			18, 131	_2},
{G,0,"tilesets/winter/human/buildings/%70",			18, 132	_2},
{G,0,"tilesets/winter/orc/buildings/%71",			18, 133	_2},
{G,0,"tilesets/winter/human/buildings/%60",			18, 134	_2},
{G,0,"tilesets/winter/orc/buildings/%61",			18, 135	_2},
{G,0,"tilesets/winter/human/buildings/%-62",			18, 136	_2},
{G,0,"tilesets/winter/orc/buildings/%-63",			18, 137	_2},
{G,0,"tilesets/winter/human/buildings/%64",			18, 138	_2},
{G,0,"tilesets/winter/orc/buildings/%65",			18, 139	_2},
{G,0,"tilesets/winter/human/buildings/%66",			18, 140	_2},
{G,0,"tilesets/winter/orc/buildings/%67",			18, 141	_2},
{G,0,"tilesets/winter/human/buildings/%76",			18, 142	_2},
{G,0,"tilesets/winter/orc/buildings/%77",			18, 143	_2},
{G,0,"tilesets/winter/human/buildings/%78",			18, 144	_2},
{G,0,"tilesets/winter/orc/buildings/%79",			18, 145	_2},
{G,0,"tilesets/winter/human/buildings/%68",			18, 146	_2},
{G,0,"tilesets/winter/orc/buildings/%69",			18, 147	_2},
{G,0,"tilesets/winter/human/buildings/%-84",			18, 148	_2},
{G,0,"tilesets/winter/orc/buildings/%-85",			18, 149	_2},
{G,0,"tilesets/winter/human/buildings/%-74",			18, 150	_2},
{G,0,"tilesets/winter/orc/buildings/%-75",			18, 151	_2},
{G,0,"tilesets/winter/human/buildings/%-80",			18, 152	_2},
{G,0,"tilesets/winter/orc/buildings/%-81",			18, 153	_2},
{G,0,"tilesets/winter/human/buildings/%-86",			18, 154	_2},
{G,0,"tilesets/winter/orc/buildings/%-87",			18, 155	_2},
{G,0,"tilesets/winter/human/buildings/%-88",			18, 156	_2},
{G,0,"tilesets/winter/orc/buildings/%-89",			18, 157	_2},
{G,0,"tilesets/winter/human/buildings/%92",			18, 158	_2},
{G,0,"tilesets/winter/orc/buildings/%93",			18, 159	_2},
{G,0,"tilesets/winter/human/buildings/%82",			18, 160	_2},
{G,0,"tilesets/winter/orc/buildings/%83",			18, 161	_2},
{G,0,"tilesets/winter/neutral/buildings/%94",			18, 162	_2},
{G,0,"tilesets/winter/neutral/buildings/destroyed site",	18, 163	_2},
{G,0,"human/x startpoint",					 2, 164	_2},
{G,0,"orc/o startpoint",					 2, 165	_2},
{G,0,"neutral/buildings/%102",					 2, 166	_2},
{G,0,"tilesets/summer/neutral/buildings/%103",			 2, 167	_2},
{G,0,"tilesets/summer/neutral/buildings/%105",			 2, 168	_2},
{G,0,"tilesets/winter/human/buildings/%-98",			18, 169	_2},
{G,0,"tilesets/winter/orc/buildings/%-99",			18, 170	_2},
{G,0,"tilesets/winter/human/buildings/%-100",			18, 171	_2},
{G,0,"tilesets/winter/orc/buildings/%-101",			18, 172	_2},
{G,0,"tilesets/wasteland/human/buildings/%60",			10, 173	_2},
{G,0,"tilesets/wasteland/orc/buildings/%61",			10, 174	_2},
{G,0,"tilesets/wasteland/human/buildings/%78",			10, 175	_2},
{G,0,"tilesets/wasteland/orc/buildings/%79",			10, 176	_2},
{G,0,"tilesets/wasteland/human/buildings/%-88",			10, 177	_2},
{G,0,"tilesets/wasteland/orc/buildings/%-89",			10, 178	_2},
{G,0,"tilesets/wasteland/neutral/buildings/%94",		10, 179	_2},
{G,0,"tilesets/wasteland/neutral/buildings/%95",		10, 180	_2},
{G,0,"neutral/buildings/%104",					 2, 181	_2},
{G,0,"tilesets/wasteland/human/units/%40",			10, 182	_2},
{G,0,"tilesets/wasteland/orc/units/%41",			10, 183	_2},
{G,0,"tilesets/winter/neutral/buildings/%103",			18, 184	_2},
{G,0,"tilesets/wasteland/neutral/buildings/%103",		10, 185	_2},
{G,0,"tilesets/winter/neutral/buildings/%104",			18, 186	_2},
{U,0,"ui/gold,wood,oil,mana",					 2, 187	_2},
{G,0,"tilesets/wasteland/neutral/buildings/small destroyed site",10,188	_2},
{G,0,"tilesets/summer/neutral/buildings/small destroyed site",	 2, 189	_2},
{G,0,"tilesets/winter/neutral/buildings/small destroyed site",	18, 190	_2},
{G,0,"tilesets/wasteland/neutral/buildings/destroyed site",	10, 191	_2},
//--------------------------------------------------
{P,0,"campaigns/human/level01h",				 192	__},
{P,0,"campaigns/orc/level01o",					 193	__},
{P,0,"campaigns/human/level02h",				 194	__},
{P,0,"campaigns/orc/level02o",					 195	__},
{P,0,"campaigns/human/level03h",				 196	__},
{P,0,"campaigns/orc/level03o",					 197	__},
{P,0,"campaigns/human/level04h",				 198	__},
{P,0,"campaigns/orc/level04o",					 199	__},
{P,0,"campaigns/human/level05h",				 200	__},
{P,0,"campaigns/orc/level05o",					 201	__},
{P,0,"campaigns/human/level06h",				 202	__},
{P,0,"campaigns/orc/level06o",					 203	__},
{P,0,"campaigns/human/level07h",				 204	__},
{P,0,"campaigns/orc/level07o",					 205	__},
{P,0,"campaigns/human/level08h",				 206	__},
{P,0,"campaigns/orc/level08o",					 207	__},
{P,0,"campaigns/human/level09h",				 208	__},
{P,0,"campaigns/orc/level09o",					 209	__},
{P,0,"campaigns/human/level10h",				 210	__},
{P,0,"campaigns/orc/level10o",					 211	__},
{P,0,"campaigns/human/level11h",				 212	__},
{P,0,"campaigns/orc/level11o",					 213	__},
{P,0,"campaigns/human/level12h",				 214	__},
{P,0,"campaigns/orc/level12o",					 215	__},
{P,0,"campaigns/human/level13h",				 216	__},
{P,0,"campaigns/orc/level13o",					 217	__},
{P,0,"campaigns/human/level14h",				 218	__},
{P,0,"campaigns/orc/level14o",					 219	__},
// --------------------------------------------------
	// 6 Gold separates east from west
{P,0,"puds/multi/(6)gold-separates-east-west",				 220	__},
	// 4 Oil is the key
{P,0,"puds/multi/(4)oil-is-the-key",				 221	__},
	// 8 Bridge to bridge combat
{P,0,"puds/multi/(8)bridge-to-bridge-combat",				 222	__},
	// 8 Plains of snow
{P,0,"puds/multi/(8)plains-of-snow",				 223	__},
	// 3 Three ways to cross
{P,0,"puds/multi/(3)three-ways-to-cross",				 224	__},
	// 8 A continent to explore
{P,0,"puds/multi/(8)a-continent-to-explore",				 225	__},
	// 8 High seas combat
{P,0,"puds/multi/(8)high-seas-combat",				 226	__},
	// 4 Islands in the stream
{P,0,"puds/multi/(4)islands-in-the-stream",				 227	__},
	// 4 Opposing city states
{P,0,"puds/multi/(4)opposing-city-states",				 228	__},
	// 4 Death in the middle
{P,0,"puds/multi/(4)death-in-the-middle",				 229	__},
	// 5 The spiral
{P,0,"puds/multi/(5)the-spiral",				 230	__},
	// 2 Mysterious dragon isle
{P,0,"puds/multi/(2)mysterious-dragon-isle",				 231	__},
	// 4 The four corners
{P,0,"puds/multi/(4)the-four-corners",				 232	__},
	// 6 No way out of this maze
{P,0,"puds/multi/(6)no-way-out-of-this-maze",				 233	__},
	// 8 Fierce ocean combat
{P,0,"puds/multi/(8)fierce-ocean-combat",				 234	__},
	// 2 Cross the streams
{P,0,"puds/multi/(2)cross-the-streams",				 235	__},
	// 5 How much can you mine?
{P,0,"puds/multi/(5)how-much-can-you-mine",				 236	__},
	// 2 X marks the spot
{P,0,"puds/multi/(2)x-marks-the-spot",				 237	__},
	// 2 One way in one way out
{P,0,"puds/multi/(2)one-way-in-one-way-out",				 238	__},
	// 4 Nowhere to run, nowhere to hide
{P,0,"puds/multi/(4)nowhere-to-run",				 239	__},
	// 2 2 players
{P,0,"puds/multi/(2)2-players",				 240	__},
	// 7 ..and the rivers ran as blood..
{P,0,"puds/multi/(7)and-the-rivers-ran-as-blood",				 241	__},
	// 3 Critter attack
{P,0,"puds/multi/(3)critter-attack",				 242	__},
	// 6 Skull isle
{P,0,"puds/multi/(6)skull-isle",				 243	__},
	// 8 Cross over
{P,0,"puds/multi/(8)cross-over",				 244	__},
	// 8 Garden of war
{P,0,"puds/multi/(8)garden-of-war",				 245	__},
	// 4 Mine the center
{P,0,"puds/multi/(4)mine-the-center",				 246	__},
	// 3 River fork
{P,0,"puds/multi/(3)river-fork",				 247	__},
// -------------------------------------------------
{P,0,"puds/demo/demo01",					 248	__},
{P,0,"puds/demo/demo02",					 249	__},
{P,0,"puds/demo/demo03",					 250	__},
{P,0,"puds/demo/demo04",					 251	__},
// --------------------------------------------------
{G,0,"neutral/buildings/land construction site",		 2, 252	_2},
{G,0,"human/buildings/shipyard construction site",		 2, 253	_2},
{G,0,"orc/buildings/shipyard construction site",		 2, 254	_2},
{G,0,"tilesets/summer/human/buildings/oil well construction site",2, 255 _2},
{G,0,"tilesets/summer/orc/buildings/oil well construction site", 2, 256	_2},
{G,0,"human/buildings/refinery construction site",		 2, 257	_2},
{G,0,"orc/buildings/refinery construction site",		 2, 258	_2},
{G,0,"human/buildings/foundry construction site",		 2, 259	_2},
{G,0,"orc/buildings/foundry construction site",			 2, 260	_2},
{G,0,"tilesets/summer/neutral/buildings/wall construction site", 2, 261	_2},
{G,0,"tilesets/winter/neutral/buildings/land construction site",18, 262 _2},
{G,0,"tilesets/winter/human/buildings/shipyard construction site",18, 263 _2},
{G,0,"tilesets/winter/orc/buildings/shipyard construction site",18, 264 _2},
{G,0,"tilesets/winter/human/buildings/oil well construction site",18, 265 _2},
{G,0,"tilesets/winter/orc/buildings/oil well construction site",18, 266 _2},
{G,0,"tilesets/winter/human/buildings/refinery construction site",18, 267 _2},
{G,0,"tilesets/winter/orc/buildings/refinery construction site",18, 268 _2},
{G,0,"tilesets/winter/human/buildings/foundry construction site",18, 269 _2},
{G,0,"tilesets/winter/orc/buildings/foundry construction site",	18, 270 _2},
{G,0,"tilesets/wasteland/human/buildings/oil well construction site",10, 271 _2},
{G,0,"tilesets/wasteland/orc/buildings/oil well construction site",10, 272 _2},
{G,0,"tilesets/winter/neutral/buildings/wall",			18, 273 _2},
{G,0,"tilesets/wasteland/neutral/buildings/wall",		10, 274 _2},
{G,0,"tilesets/winter/neutral/buildings/wall construction site",18, 275 _2},
{G,0,"tilesets/wasteland/neutral/buildings/wall construction site",10, 276 _2},
// 277 Control programs for computer player AI
// 278 Control programs for unit movement
// --------------------------------------------------
{N,0,"large episode titles",					279	__},
{N,0,"small episode titles",					280	__},
{N,0,"large",							281	__},
{N,0,"game",							282	__},
{N,0,"small",							283	__},
// --------------------------------------------------
{I,0,"ui/human/menubutton",					 2, 293	_2},
{I,0,"ui/orc/menubutton",					 2, 294	_2},
{I,0,"ui/human/minimap",					 2, 295	_2},
{I,0,"ui/orc/minimap",						 2, 296	_2},
{I,0,"ui/title",						300, 299 _2},
// 284-286 unknown
// --------------------------------------------------
{I,0,"ui/human/640x480/resource",				 2, 287	_2},
{I,0,"ui/orc/640x480/resource",					 2, 288	_2},
{I,0,"ui/human/640x480/filler-right",				 2, 289	_2},
{I,0,"ui/orc/640x480/filler-right",				 2, 290	_2},
{I,0,"ui/human/640x480/statusline",				 2, 291	_2},
{I,0,"ui/orc/640x480/statusline",				 2, 292	_2},
{I,0,"ui/human/640x480/buttonpanel",				 2, 297	_2},
{I,0,"ui/orc/640x480/buttonpanel",				 2, 298	_2},
//---------------------------------------------------
{I,0,"ui/human/800x600/resource",				 2, 287, 608, 16},
{I,0,"ui/orc/800x600/resource",					 2, 288, 608, 16},
{I,0,"ui/human/800x600/filler-right",				 2, 289, 16, 600},
{I,0,"ui/orc/800x600/filler-right",				 2, 290, 16, 600},
{I,0,"ui/human/800x600/statusline",				 2, 291, 608, 16},
{I,0,"ui/orc/800x600/statusline",				 2, 292, 608, 16},
{I,0,"ui/human/800x600/buttonpanel",				 2, 297, 176, 264},
{I,0,"ui/orc/800x600/buttonpanel",				 2, 298, 176, 264},
//---------------------------------------------------
{I,0,"ui/human/1024x768/resource",				 2, 287, 832, 16},
{I,0,"ui/orc/1024x768/resource",				 2, 288, 832, 16},
{I,0,"ui/human/1024x768/filler-right",				 2, 289, 16, 768},
{I,0,"ui/orc/1024x768/filler-right",				 2, 290, 16, 768},
{I,0,"ui/human/1024x768/statusline",				 2, 291, 832, 16},
{I,0,"ui/orc/1024x768/statusline",				 2, 292, 832, 16},
{I,0,"ui/human/1024x768/buttonpanel",				 2, 297, 176, 432},
{I,0,"ui/orc/1024x768/buttonpanel",				 2, 298, 176, 432},
// --------------------------------------------------
{I,0,"ui/human/1280x960/resource",				 2, 287, 1088, 16},
{I,0,"ui/orc/1280x960/resource",				 2, 288, 1088, 16},
{I,0,"ui/human/1280x960/filler-right",				 2, 289, 16, 960},
{I,0,"ui/orc/1280x960/filler-right",				 2, 290, 16, 960},
{I,0,"ui/human/1280x960/statusline",				 2, 291, 1088, 16},
{I,0,"ui/orc/1280x960/statusline",				 2, 292, 1088, 16},
{I,0,"ui/human/1280x960/buttonpanel",				 2, 297, 176, 624},
{I,0,"ui/orc/1280x960/buttonpanel",				 2, 298, 176, 624},
// --------------------------------------------------
{I,0,"ui/human/1600x1200/resource",				 2, 287, 1408, 16},
{I,0,"ui/orc/1600x1200/resource",				 2, 288, 1408, 16},
{I,0,"ui/human/1600x1200/filler-right",				 2, 289, 16, 1200},
{I,0,"ui/orc/1600x1200/filler-right",				 2, 290, 16, 1200},
{I,0,"ui/human/1600x1200/statusline",				 2, 291, 1408, 16},
{I,0,"ui/orc/1600x1200/statusline",				 2, 292, 1408, 16},
{I,0,"ui/human/1600x1200/buttonpanel",				 2, 297, 176, 864},
{I,0,"ui/orc/1600x1200/buttonpanel",				 2, 298, 176, 864},
// --------------------------------------------------
{C,0,"human/cursors/human gauntlet",				 2, 301 _2},
{C,0,"orc/cursors/orcish claw",					 2, 302 _2},
{C,0,"human/cursors/human don't click here",			 2, 303 _2},
{C,0,"orc/cursors/orcish don't click here",			 2, 304 _2},
{C,0,"human/cursors/yellow eagle",				 2, 305 _2},
{C,0,"orc/cursors/yellow crosshairs",				 2, 306 _2},
{C,0,"human/cursors/red eagle",					 2, 307 _2},
{C,0,"orc/cursors/red crosshairs",				 2, 308 _2},
{C,0,"human/cursors/green eagle",				 2, 309 _2},
{C,0,"orc/cursors/green crosshairs",				 2, 310 _2},
{C,0,"cursors/magnifying glass",				 2, 311 _2},
{C,0,"cursors/small green cross",				 2, 312 _2},
{C,0,"cursors/hourglass",					 2, 313 _2},
{C,0,"cursors/credits arrow",					 27, 314 _2},
{C,0,"cursors/arrow N",						 2, 315 _2},
{C,0,"cursors/arrow NE",					 2, 316 _2},
{C,0,"cursors/arrow E",						 2, 317 _2},
{C,0,"cursors/arrow SE",					 2, 318 _2},
{C,0,"cursors/arrow S",						 2, 319 _2},
{C,0,"cursors/arrow SW",					 2, 320 _2},
{C,0,"cursors/arrow W",						 2, 321 _2},
{C,0,"cursors/arrow NW",					 2, 322 _2},
{U,0,"ui/bloodlust,haste,slow,invisible,shield",		 2, 323 _2},
// --------------------------------------------------------
{G,0,"missiles/lightning",					 2, 324 _2},
{G,0,"missiles/gryphon hammer",					 2, 325 _2},
// "fireball (also dragon breath)"
{G,0,"missiles/dragon breath",					 2, 326 _2},
// "fireball (when casting flameshield)"
{G,0,"missiles/fireball",					 2, 327 _2},
{G,0,"missiles/flame shield",					 2, 328 _2},
{G,0,"missiles/blizzard",					 2, 329 _2},
{G,0,"missiles/death and decay",				 2, 330 _2},
{G,0,"missiles/big cannon",					 2, 331 _2},
{G,0,"missiles/exorcism",					 2, 332 _2},
{G,0,"missiles/heal effect",					 2, 333 _2},
{G,0,"missiles/touch of death",					 2, 334 _2},
{G,0,"missiles/rune",						 2, 335 _2},
{G,0,"missiles/tornado",					 2, 336 _2},
{G,0,"missiles/catapult rock",					 2, 337 _2},
{G,0,"missiles/ballista bolt",					 2, 338 _2},
{G,0,"missiles/arrow",						 2, 339 _2},
{G,0,"missiles/axe",						 2, 340 _2},
{G,0,"missiles/submarine missile",				 2, 341 _2},
{G,0,"missiles/turtle missile",					 2, 342 _2},
{G,0,"missiles/small fire",					 2, 343 _2},
{G,0,"missiles/big fire",					 2, 344 _2},
{G,0,"missiles/ballista-catapult impact",			 2, 345 _2},
{G,0,"missiles/normal spell",					 2, 346 _2},
{G,0,"missiles/explosion",					 2, 347 _2},
{G,0,"missiles/cannon",						 2, 348 _2},
{G,0,"missiles/cannon explosion",				 2, 349 _2},
{G,0,"missiles/cannon-tower explosion",				 2, 350 _2},
{G,0,"missiles/daemon fire",					 2, 351 _2},
{G,0,"missiles/green cross",					 2, 352 _2},
{G,0,"missiles/unit shadow",					 2, 353 _2},
{U,0,"ui/human/infopanel",					 2, 354 _2},
{U,0,"ui/orc/infopanel",					 2, 355 _2},
{G,0,"tilesets/summer/icons",					 2, 356 _2},
{G,0,"tilesets/winter/icons",					18, 357 _2},
{G,0,"tilesets/wasteland/icons",				10, 358 _2},

{I,0,"../campaigns/human/interface/introscreen1",	       367, 369 _2},
{I,0,"../campaigns/orc/interface/introscreen1",		       368, 370 _2},
{I,0,"../campaigns/orc/interface/introscreen2",		       368, 371 _2},
{I,0,"../campaigns/orc/interface/introscreen3",		       368, 372 _2},
{I,0,"../campaigns/orc/interface/introscreen4",		       368, 373 _2},
{I,0,"../campaigns/orc/interface/introscreen5",		       368, 374 _2},
{I,0,"../campaigns/human/interface/introscreen2",	       367, 375 _2},
{I,0,"../campaigns/human/interface/introscreen3",	       367, 376 _2},
{I,0,"../campaigns/human/interface/introscreen4",	       367, 377 _2},
{I,0,"../campaigns/human/interface/introscreen5",	       367, 378 _2},

{W,0,"ui/click",						432	__},
{W,0,"ui/highclick",						435	__},

{V,0,"videos/gameintro",					429	__},

{R,2,"swamp/swamp",						438	__},
{T,2,"swamp/terrain/swamp",			438,	439,	440,	441 },

// --------------------------------------------------
{P,2,"campaigns/human-exp/levelx01h",				 446	__},
{P,2,"campaigns/orc-exp/levelx01o",				 447	__},
{P,2,"campaigns/human-exp/levelx02h",				 448	__},
{P,2,"campaigns/orc-exp/levelx02o",				 449	__},
{P,2,"campaigns/human-exp/levelx03h",				 450	__},
{P,2,"campaigns/orc-exp/levelx03o",				 451	__},
{P,2,"campaigns/human-exp/levelx04h",				 452	__},
{P,2,"campaigns/orc-exp/levelx04o",				 453	__},
{P,2,"campaigns/human-exp/levelx05h",				 454	__},
{P,2,"campaigns/orc-exp/levelx05o",				 455	__},
{P,2,"campaigns/human-exp/levelx06h",				 456	__},
{P,2,"campaigns/orc-exp/levelx06o",				 457	__},
{P,2,"campaigns/human-exp/levelx07h",				 458	__},
{P,2,"campaigns/orc-exp/levelx07o",				 459	__},
{P,2,"campaigns/human-exp/levelx08h",				 460	__},
{P,2,"campaigns/orc-exp/levelx08o",				 461	__},
{P,2,"campaigns/human-exp/levelx09h",				 462	__},
{P,2,"campaigns/orc-exp/levelx09o",				 463	__},
{P,2,"campaigns/human-exp/levelx10h",				 464	__},
{P,2,"campaigns/orc-exp/levelx10o",				 465	__},
{P,2,"campaigns/human-exp/levelx11h",				 466	__},
{P,2,"campaigns/orc-exp/levelx11o",				 467	__},
{P,2,"campaigns/human-exp/levelx12h",				 468	__},
{P,2,"campaigns/orc-exp/levelx12o",				 469	__},
// ------------------------------------------
{G,2,"tilesets/swamp/neutral/units/%59",			438, 470 _2},
{G,2,"tilesets/swamp/icons",					438, 471 _2},
// 472: default UDTA for expansion PUDs
{G,2,"tilesets/swamp/human/buildings/%90",			438, 473 _2},
{G,2,"tilesets/swamp/orc/buildings/%91",			438, 474 _2},
{G,2,"tilesets/swamp/human/buildings/%72",			438, 475 _2},
{G,2,"tilesets/swamp/orc/buildings/%73",			438, 476 _2},
{G,2,"tilesets/swamp/human/buildings/%70",			438, 477 _2},
{G,2,"tilesets/swamp/orc/buildings/%71",			438, 478 _2},
{G,2,"tilesets/swamp/human/buildings/%60",			438, 479 _2},
{G,2,"tilesets/swamp/orc/buildings/%61",			438, 480 _2},
{G,2,"tilesets/swamp/human/buildings/%-62",			438, 481 _2},
{G,2,"tilesets/swamp/orc/buildings/%-63",			438, 482 _2},
{G,2,"tilesets/swamp/human/buildings/%64",			438, 483 _2},
{G,2,"tilesets/swamp/orc/buildings/%65",			438, 484 _2},
{G,2,"tilesets/swamp/human/buildings/%66",			438, 485 _2},
{G,2,"tilesets/swamp/orc/buildings/%67",			438, 486 _2},
{G,2,"tilesets/swamp/human/buildings/%76",			438, 487 _2},
{G,2,"tilesets/swamp/orc/buildings/%77",			438, 488 _2},
{G,2,"tilesets/swamp/human/buildings/%78",			438, 489 _2},
{G,2,"tilesets/swamp/orc/buildings/%79",			438, 490 _2},
{G,2,"tilesets/swamp/human/buildings/%68",			438, 491 _2},
{G,2,"tilesets/swamp/orc/buildings/%69",			438, 492 _2},
{G,2,"tilesets/swamp/human/buildings/%-84",			438, 493 _2},
{G,2,"tilesets/swamp/orc/buildings/%-85",			438, 494 _2},
{G,2,"tilesets/swamp/human/buildings/%-74",			438, 495 _2},
{G,2,"tilesets/swamp/orc/buildings/%-75",			438, 496 _2},
{G,2,"tilesets/swamp/human/buildings/%-80",			438, 497 _2},
{G,2,"tilesets/swamp/orc/buildings/%-81",			438, 498 _2},
{G,2,"tilesets/swamp/human/buildings/%-86",			438, 499 _2},
{G,2,"tilesets/swamp/orc/buildings/%-87",			438, 500 _2},
{G,2,"tilesets/swamp/human/buildings/%-88",			438, 501 _2},
{G,2,"tilesets/swamp/orc/buildings/%-89",			438, 502 _2},
{G,2,"tilesets/swamp/human/buildings/%92",			438, 503 _2},
{G,2,"tilesets/swamp/orc/buildings/%93",			438, 504 _2},
{G,2,"tilesets/swamp/human/buildings/%82",			438, 505 _2},
{G,2,"tilesets/swamp/orc/buildings/%83",			438, 506 _2},
{G,2,"tilesets/swamp/human/buildings/%-98",			438, 507 _2},
{G,2,"tilesets/swamp/orc/buildings/%-99",			438, 508 _2},
{G,2,"tilesets/swamp/human/buildings/%-100",			438, 509 _2},
{G,2,"tilesets/swamp/orc/buildings/%-101",			438, 510 _2},
{G,2,"tilesets/swamp/neutral/buildings/%94",			438, 511 _2},
{G,2,"tilesets/swamp/neutral/buildings/destroyed site",		438, 512 _2},
{G,2,"tilesets/swamp/neutral/buildings/%103",			438, 513 _2},
{G,2,"tilesets/swamp/neutral/buildings/%104",			438, 514 _2},
{G,2,"tilesets/swamp/neutral/buildings/%95",			438, 515 _2},
{G,2,"tilesets/swamp/human/buildings/%-74 construction site",	438, 516 _2},
{G,2,"tilesets/swamp/orc/buildings/%-75 construction site",	438, 517 _2},
{G,2,"tilesets/swamp/human/buildings/%-88 construction site",	438, 518 _2},
{G,2,"tilesets/swamp/orc/buildings/%-89 construction site",	438, 519 _2},
{G,2,"tilesets/swamp/human/buildings/%-86 construction site",	438, 520 _2},
{G,2,"tilesets/swamp/orc/buildings/%-87 construction site",	438, 521 _2},
{G,2,"tilesets/swamp/human/buildings/%-80 construction site",	438, 522 _2},
{G,2,"tilesets/swamp/orc/buildings/%-81 construction site",	438, 523 _2},
{G,2,"tilesets/swamp/neutral/buildings/small destroyed site",	438, 524 _2},
{G,2,"tilesets/swamp/neutral/buildings/%102",			438, 525 _2},
{G,2,"tilesets/swamp/human/units/%40",				438, 526 _2},
{G,2,"tilesets/swamp/orc/units/%41",				438, 527 _2},

///////////////////////////////////////////////////////////////////////////////
//	SOUNDS
///////////////////////////////////////////////////////////////////////////////

#ifdef USE_BEOS
{F,0,"SFXDAT.SUD",				5000 __},
#else
{F,0,"sfxdat.sud",				5000 __},
#endif

// 0 file length
// 1 description
{W,0,"ui/placement error",					  2	__},
{W,0,"ui/placement success",					  3	__},
{W,0,"misc/building construction",				  4	__},
{W,0,"human/basic_voices/selected/1",				  5	__},
{W,0,"orc/basic_voices/selected/1",				  6	__},
{W,0,"human/basic_voices/selected/2",				  7	__},
{W,0,"orc/basic_voices/selected/2",				  8	__},
{W,0,"human/basic_voices/selected/3",				  9	__},
{W,0,"orc/basic_voices/selected/3",				 10	__},
{W,0,"human/basic_voices/selected/4",				 11	__},
{W,0,"orc/basic_voices/selected/4",				 12	__},
{W,0,"human/basic_voices/selected/5",				 13	__},
{W,0,"orc/basic_voices/selected/5",				 14	__},
{W,0,"human/basic_voices/selected/6",				 15	__},
{W,0,"orc/basic_voices/selected/6",				 16	__},
{W,0,"human/basic_voices/annoyed/1",				 17	__},
{W,0,"orc/basic_voices/annoyed/1",				 18	__},
{W,0,"human/basic_voices/annoyed/2",				 19	__},
{W,0,"orc/basic_voices/annoyed/2",				 20	__},
{W,0,"human/basic_voices/annoyed/3",				 21	__},
{W,0,"orc/basic_voices/annoyed/3",				 22	__},
{W,0,"human/basic_voices/annoyed/4",				 23	__},
{W,0,"orc/basic_voices/annoyed/4",				 24	__},
{W,0,"human/basic_voices/annoyed/5",				 25	__},
{W,0,"orc/basic_voices/annoyed/5",				 26	__},
{W,0,"human/basic_voices/annoyed/6",				 27	__},
{W,0,"orc/basic_voices/annoyed/6",				 28	__},
{W,0,"human/basic_voices/annoyed/7",				 29	__},
{W,0,"orc/basic_voices/annoyed/7",				 30	__},
{W,0,"misc/explosion",						 31	__},
{W,0,"human/basic_voices/acknowledgement/1",			 32	__},
{W,0,"orc/basic_voices/acknowledgement/1",			 33	__},
{W,0,"human/basic_voices/acknowledgement/2",			 34	__},
{W,0,"orc/basic_voices/acknowledgement/2",			 35	__},
{W,0,"human/basic_voices/acknowledgement/3",			 36	__},
{W,0,"orc/basic_voices/acknowledgement/3",			 37	__},
{W,0,"human/basic_voices/acknowledgement/4",			 38	__},
{W,0,"orc/basic_voices/acknowledgement/4",			 39	__},
{W,0,"human/basic_voices/work_complete",			 40	__},
{W,0,"orc/basic_voices/work_complete",				 41	__},
{W,0,"human/units/peasant/work_complete",			 42	__},
{W,0,"human/basic_voices/ready",				 43	__},
{W,0,"orc/basic_voices/ready",					 44	__},
{W,0,"human/basic_voices/help/1",				 45	__},
{W,0,"orc/basic_voices/help/1",					 46	__},
{W,0,"human/basic_voices/help/2",				 47	__},
{W,0,"orc/basic_voices/help/2",					 48	__},
{W,0,"human/basic_voices/dead",					 49	__},
{W,0,"orc/basic_voices/dead",					 50	__},
{W,0,"ships/sinking",						 51	__},
{W,0,"misc/building explosion/1",				 52	__},
{W,0,"misc/building explosion/2",				 53	__},
{W,0,"misc/building explosion/3",				 54	__},
{W,0,"missiles/catapult-ballista attack",			 55	__},
{W,0,"misc/tree chopping/1",					 56	__},
{W,0,"misc/tree chopping/2",					 57	__},
{W,0,"misc/tree chopping/3",					 58	__},
{W,0,"misc/tree chopping/4",					 59	__},
{W,0,"missiles/sword attack/1",					 60	__},
{W,0,"missiles/sword attack/2",					 61	__},
{W,0,"missiles/sword attack/3",					 62	__},
{W,0,"missiles/punch",						 63	__},
{W,0,"missiles/fireball hit",					 64	__},
{W,0,"missiles/fireball throw",					 65	__},
{W,0,"missiles/bow throw",					 66	__},
{W,0,"missiles/bow hit",					 67	__},
{W,0,"spells/basic spell sound",				 68	__},
{W,0,"buildings/blacksmith",					 69	__},
{W,0,"human/buildings/church",					 70	__},
{W,0,"orc/buildings/altar of storms",				 71	__},
{W,0,"human/buildings/stables",					 72	__},
{W,0,"orc/buildings/ogre mound",				 73	__},
{W,0,"human/buildings/farm",					 74	__},
{W,0,"orc/buildings/pig farm",					 75	__},
{W,0,"neutral/buildings/gold mine",				 76	__},
{W,0,"missiles/axe throw",					 77	__},
{W,0,"ships/tanker/acknowledgement/1",				 78	__},
{W,0,"missiles/fist",						 79	__},
{W,0,"buildings/shipyard",					 80	__},
{W,0,"human/units/peasant/attack",				 81	__},
{W,0,"buildings/oil platform",					 82	__},
{W,0,"buildings/oil refinery",					 83	__},
{W,0,"buildings/lumbermill",					 84	__},
{W,0,"misc/transport docking",					 85	__},
{W,0,"misc/burning",						 86	__},
{W,0,"human/buildings/gryphon aviary",				 87	__},
{W,0,"orc/buildings/dragon roost",				 88	__},
{W,0,"buildings/foundry",					 89	__},
{W,0,"human/buildings/gnomish inventor",			 90	__},
{W,0,"orc/buildings/goblin alchemist",				 91	__},
{W,0,"human/buildings/mage tower",				 92	__},
{W,0,"orc/buildings/temple of the damned",			 93	__},
{W,0,"human/capture",						 94	__},
{W,0,"orc/capture",						 95	__},
{W,0,"human/rescue",						 96	__},
{W,0,"orc/rescue",						 97	__},
{W,0,"spells/bloodlust",					 98	__},
{W,0,"spells/death and decay",					 99	__},
{W,0,"spells/death coil",					100	__},
{W,0,"spells/exorcism",						101	__},
{W,0,"spells/flame shield",					102	__},
{W,0,"spells/haste",						103	__},
{W,0,"spells/healing",						104	__},
{W,0,"spells/holy vision",					105	__},
{W,0,"spells/blizzard",						106	__},
{W,0,"spells/invisibility",					107	__},
{W,0,"spells/eye of kilrogg",					108	__},
{W,0,"spells/polymorph",					109	__},
{W,0,"spells/slow",						110	__},
{W,0,"spells/lightning",					111	__},
{W,0,"spells/touch of darkness",				112	__},
{W,0,"spells/unholy armor",					113	__},
{W,0,"spells/whirlwind",					114	__},
{W,0,"orc/peon/ready",						115	__},
{W,0,"orc/units/death knight/annoyed/1",			116	__},
{W,0,"orc/units/death knight/annoyed/2",			117	__},
{W,0,"orc/units/death knight/annoyed/3",			118	__},
{W,0,"orc/units/death knight/ready",				119	__},
{W,0,"orc/units/death knight/selected/1",			120	__},
{W,0,"orc/units/death knight/selected/2",			121	__},
{W,0,"orc/units/death knight/acknowledgement/1",		122	__},
{W,0,"orc/units/death knight/acknowledgement/2",		123	__},
{W,0,"orc/units/death knight/acknowledgement/3",		124	__},
{W,0,"human/units/dwarven demolition squad/annoyed/1",		125	__},
{W,0,"human/units/dwarven demolition squad/annoyed/2",		126	__},
{W,0,"human/units/dwarven demolition squad/annoyed/3",		127	__},
{W,0,"human/units/dwarven demolition squad/ready",		128	__},
{W,0,"human/units/dwarven demolition squad/selected/1",		129	__},
{W,0,"human/units/dwarven demolition squad/selected/2",		130	__},
{W,0,"human/units/dwarven demolition squad/acknowledgement/1",	131	__},
{W,0,"human/units/dwarven demolition squad/acknowledgement/2",	132	__},
{W,0,"human/units/dwarven demolition squad/acknowledgement/3",	133	__},
{W,0,"human/units/dwarven demolition squad/acknowledgement/4",	134	__},
{W,0,"human/units/dwarven demolition squad/acknowledgement/5",	135	__},
{W,0,"human/units/elven archer-ranger/annoyed/1",		136	__},
{W,0,"human/units/elven archer-ranger/annoyed/2",		137	__},
{W,0,"human/units/elven archer-ranger/annoyed/3",		138	__},
{W,0,"human/units/elven archer-ranger/ready",			139	__},
{W,0,"human/units/elven archer-ranger/selected/1",		140	__},
{W,0,"human/units/elven archer-ranger/selected/2",		141	__},
{W,0,"human/units/elven archer-ranger/selected/3",		142	__},
{W,0,"human/units/elven archer-ranger/selected/4",		143	__},
{W,0,"human/units/elven archer-ranger/acknowledgement/1",	144	__},
{W,0,"human/units/elven archer-ranger/acknowledgement/2",	145	__},
{W,0,"human/units/elven archer-ranger/acknowledgement/3",	146	__},
{W,0,"human/units/elven archer-ranger/acknowledgement/4",	147	__},
{W,0,"human/units/gnomish flying machine/annoyed/1",		148	__},
{W,0,"human/units/gnomish flying machine/annoyed/2",		149	__},
{W,0,"human/units/gnomish flying machine/annoyed/3",		150	__},
{W,0,"human/units/gnomish flying machine/annoyed/4",		151	__},
{W,0,"human/units/gnomish flying machine/annoyed/5",		152	__},
{W,0,"human/units/gnomish flying machine/ready",		153	__},
{W,0,"human/units/gnomish flying machine/acknowledgement/1",	154	__},
{W,0,"orc/units/goblin sappers/annoyed/1",			155	__},
{W,0,"orc/units/goblin sappers/annoyed/2",			156	__},
{W,0,"orc/units/goblin sappers/annoyed/3",			157	__},
{W,0,"orc/units/goblin sappers/ready",				158	__},
{W,0,"orc/units/goblin sappers/selected/1",			159	__},
{W,0,"orc/units/goblin sappers/selected/2",			160	__},
{W,0,"orc/units/goblin sappers/selected/3",			161	__},
{W,0,"orc/units/goblin sappers/selected/4",			162	__},
{W,0,"orc/units/goblin sappers/acknowledgement/1",		163	__},
{W,0,"orc/units/goblin sappers/acknowledgement/2",		164	__},
{W,0,"orc/units/goblin sappers/acknowledgement/3",		165	__},
{W,0,"orc/units/goblin sappers/acknowledgement/4",		166	__},
{W,0,"orc/units/goblin zeppelin/annoyed/1",			167	__},
{W,0,"orc/units/goblin zeppelin/annoyed/2",			168	__},
{W,0,"orc/units/goblin zeppelin/ready",				169	__},
{W,0,"orc/units/goblin zeppelin/acknowledgement/1",		170	__},
{W,0,"human/units/knight/annoyed/1",				171	__},
{W,0,"human/units/knight/annoyed/2",				172	__},
{W,0,"human/units/knight/annoyed/3",				173	__},
{W,0,"human/units/knight/ready",				174	__},
{W,0,"human/units/knight/selected/1",				175	__},
{W,0,"human/units/knight/selected/2",				176	__},
{W,0,"human/units/knight/selected/3",				177	__},
{W,0,"human/units/knight/selected/4",				178	__},
{W,0,"human/units/knight/acknowledgement/1",			179	__},
{W,0,"human/units/knight/acknowledgement/2",			180	__},
{W,0,"human/units/knight/acknowledgement/3",			181	__},
{W,0,"human/units/knight/acknowledgement/4",			182	__},
{W,0,"human/units/paladin/annoyed/1",				183	__},
{W,0,"human/units/paladin/annoyed/2",				184	__},
{W,0,"human/units/paladin/annoyed/3",				185	__},
{W,0,"human/units/paladin/ready",				186	__},
{W,0,"human/units/paladin/selected/1",				187	__},
{W,0,"human/units/paladin/selected/2",				188	__},
{W,0,"human/units/paladin/selected/3",				189	__},
{W,0,"human/units/paladin/selected/4",				190	__},
{W,0,"human/units/paladin/acknowledgement/1",			191	__},
{W,0,"human/units/paladin/acknowledgement/2",			192	__},
{W,0,"human/units/paladin/acknowledgement/3",			193	__},
{W,0,"human/units/paladin/acknowledgement/4",			194	__},
{W,0,"orc/units/ogre/annoyed/1",				195	__},
{W,0,"orc/units/ogre/annoyed/2",				196	__},
{W,0,"orc/units/ogre/annoyed/3",				197	__},
{W,0,"orc/units/ogre/annoyed/4",				198	__},
{W,0,"orc/units/ogre/annoyed/5",				199	__},
{W,0,"orc/units/ogre/ready",					200	__},
{W,0,"orc/units/ogre/selected/1",				201	__},
{W,0,"orc/units/ogre/selected/2",				202	__},
{W,0,"orc/units/ogre/selected/3",				203	__},
{W,0,"orc/units/ogre/selected/4",				204	__},
{W,0,"orc/units/ogre/acknowledgement/1",			205	__},
{W,0,"orc/units/ogre/acknowledgement/2",			206	__},
{W,0,"orc/units/ogre/acknowledgement/3",			207	__},
{W,0,"orc/units/ogre-mage/annoyed/1",				208	__},
{W,0,"orc/units/ogre-mage/annoyed/2",				209	__},
{W,0,"orc/units/ogre-mage/annoyed/3",				210	__},
{W,0,"orc/units/ogre-mage/ready",				211	__},
{W,0,"orc/units/ogre-mage/selected/1",				212	__},
{W,0,"orc/units/ogre-mage/selected/2",				213	__},
{W,0,"orc/units/ogre-mage/selected/3",				214	__},
{W,0,"orc/units/ogre-mage/selected/4",				215	__},
{W,0,"orc/units/ogre-mage/acknowledgement/1",			216	__},
{W,0,"orc/units/ogre-mage/acknowledgement/2",			217	__},
{W,0,"orc/units/ogre-mage/acknowledgement/3",			218	__},
{W,0,"human/ships/annoyed/1",					219	__},
{W,0,"orc/ships/annoyed/1",					220	__},
{W,0,"human/ships/annoyed/2",					221	__},
{W,0,"orc/ships/annoyed/2",					222	__},
{W,0,"human/ships/annoyed/3",					223	__},
{W,0,"orc/ships/annoyed/3",					224	__},
{W,0,"human/ships/ready",					225	__},
{W,0,"orc/ships/ready",						226	__},
{W,0,"human/ships/selected/1",					227	__},
{W,0,"orc/ships/selected/1",					228	__},
{W,0,"human/ships/selected/2",					229	__},
{W,0,"orc/ships/selected/2",					230	__},
{W,0,"human/ships/selected/3",					231	__},
{W,0,"orc/ships/selected/3",					232	__},
{W,0,"human/ships/acknowledgement/1",				233	__},
{W,0,"orc/ships/acknowledgement/1",				234	__},
{W,0,"human/ships/acknowledgement/2",				235	__},
{W,0,"orc/ships/acknowledgement/2",				236	__},
{W,0,"human/ships/acknowledgement/3",				237	__},
{W,0,"orc/ships/acknowledgement/3",				238	__},
{W,0,"human/ships/gnomish submarine/annoyed/1",			239	__},
{W,0,"human/ships/gnomish submarine/annoyed/2",			240	__},
{W,0,"human/ships/gnomish submarine/annoyed/3",			241	__},
{W,0,"human/ships/gnomish submarine/annoyed/4",			242	__},
{W,0,"orc/units/troll axethrower-berserker/annoyed/1",		243	__},
{W,0,"orc/units/troll axethrower-berserker/annoyed/2",		244	__},
{W,0,"orc/units/troll axethrower-berserker/annoyed/3",		245	__},
{W,0,"orc/units/troll axethrower-berserker/ready",		246	__},
{W,0,"orc/units/troll axethrower-berserker/selected/1",		247	__},
{W,0,"orc/units/troll axethrower-berserker/selected/2",		248	__},
{W,0,"orc/units/troll axethrower-berserker/selected/3",		249	__},
{W,0,"orc/units/troll axethrower-berserker/acknowledgement/1",	250	__},
{W,0,"orc/units/troll axethrower-berserker/acknowledgement/2",	251	__},
{W,0,"orc/units/troll axethrower-berserker/acknowledgement/3",	252	__},
{W,0,"human/units/mage/annoyed/1",				253	__},
{W,0,"human/units/mage/annoyed/2",				254	__},
{W,0,"human/units/mage/annoyed/3",				255	__},
{W,0,"human/units/mage/ready",					256	__},
{W,0,"human/units/mage/selected/1",				257	__},
{W,0,"human/units/mage/selected/2",				258	__},
{W,0,"human/units/mage/selected/3",				259	__},
{W,0,"human/units/mage/acknowledgement/1",			260	__},
{W,0,"human/units/mage/acknowledgement/2",			261	__},
{W,0,"human/units/mage/acknowledgement/3",			262	__},
{W,0,"human/units/peasant/ready",				263	__},
{W,0,"human/units/peasant/annoyed/1",				264	__},
{W,0,"human/units/peasant/annoyed/2",				265	__},
{W,0,"human/units/peasant/annoyed/3",				266	__},
{W,0,"human/units/peasant/annoyed/4",				267	__},
{W,0,"human/units/peasant/annoyed/5",				268	__},
{W,0,"human/units/peasant/annoyed/6",				269	__},
{W,0,"human/units/peasant/annoyed/7",				270	__},
{W,0,"human/units/peasant/selected/1",				271	__},
{W,0,"human/units/peasant/selected/2",				272	__},
{W,0,"human/units/peasant/selected/3",				273	__},
{W,0,"human/units/peasant/selected/4",				274	__},
{W,0,"human/units/peasant/acknowledgement/1",			275	__},
{W,0,"human/units/peasant/acknowledgement/2",			276	__},
{W,0,"human/units/peasant/acknowledgement/3",			277	__},
{W,0,"human/units/peasant/acknowledgement/4",			278	__},
{W,0,"orc/units/dragon/ready",					279	__},
{W,0,"orc/units/dragon/selected/1",				280	__},
{W,0,"orc/units/dragon/acknowledgement/1",			281	__},
{W,0,"orc/units/dragon/acknowledgement/2",			282	__},
{W,0,"human/units/gryphon rider/selected/1",			283	__},
{W,0,"human/units/gryphon rider/ready",				284	__},
{W,0,"human/units/gryphon rider/acknowledgement/2",		285	__},
{W,0,"neutral/units/sheep/selected/1",				286	__},
{W,0,"neutral/units/sheep/annoyed/1",				287	__},
{W,0,"neutral/units/seal/selected/1",				288	__},
{W,0,"neutral/units/seal/annoyed/1",				289	__},
{W,0,"neutral/units/pig/selected/1",				290	__},
{W,0,"neutral/units/pig/annoyed/1",				291	__},
{W,0,"units/catapult-ballista/acknowledgement/1",		292	__},
{W,2,"human/units/alleria/annoyed/1",				293	__},
{W,2,"human/units/alleria/annoyed/2",				294	__},
{W,2,"human/units/alleria/annoyed/3",				295	__},
{W,2,"human/units/alleria/selected/1",				296	__},
{W,2,"human/units/alleria/selected/2",				297	__},
{W,2,"human/units/alleria/selected/3",				298	__},
{W,2,"human/units/alleria/acknowledgement/1",			299	__},
{W,2,"human/units/alleria/acknowledgement/2",			300	__},
{W,2,"human/units/alleria/acknowledgement/3",			301	__},
{W,2,"human/units/danath/annoyed/1",				302	__},
{W,2,"human/units/danath/annoyed/2",				303	__},
{W,2,"human/units/danath/annoyed/3",				304	__},
{W,2,"human/units/danath/selected/1",				305	__},
{W,2,"human/units/danath/selected/2",				306	__},
{W,2,"human/units/danath/selected/3",				307	__},
{W,2,"human/units/danath/acknowledgement/1",			308	__},
{W,2,"human/units/danath/acknowledgement/2",			309	__},
{W,2,"human/units/danath/acknowledgement/3",			310	__},
{W,2,"human/units/khadgar/annoyed/1",				311	__},
{W,2,"human/units/khadgar/annoyed/2",				312	__},
{W,2,"human/units/khadgar/annoyed/3",				313	__},
{W,2,"human/units/khadgar/selected/1",				314	__},
{W,2,"human/units/khadgar/selected/2",				315	__},
{W,2,"human/units/khadgar/selected/3",				316	__},
{W,2,"human/units/khadgar/acknowledgement/1",			317	__},
{W,2,"human/units/khadgar/acknowledgement/2",			318	__},
{W,2,"human/units/khadgar/acknowledgement/3",			319	__},
{W,2,"human/units/kurdan/annoyed/1",				320	__},
{W,2,"human/units/kurdan/annoyed/2",				321	__},
{W,2,"human/units/kurdan/annoyed/3",				322	__},
{W,2,"human/units/kurdan/selected/1",				323	__},
{W,2,"human/units/kurdan/selected/2",				324	__},
{W,2,"human/units/kurdan/selected/3",				325	__},
{W,2,"human/units/kurdan/acknowledgement/1",			326	__},
{W,2,"human/units/kurdan/acknowledgement/2",			327	__},
{W,2,"human/units/kurdan/acknowledgement/3",			328	__},
{W,2,"human/units/turalyon/annoyed/1",				329	__},
{W,2,"human/units/turalyon/annoyed/2",				330	__},
{W,2,"human/units/turalyon/annoyed/3",				331	__},
{W,2,"human/units/turalyon/selected/1",				332	__},
{W,2,"human/units/turalyon/selected/2",				333	__},
{W,2,"human/units/turalyon/selected/3",				334	__},
{W,2,"human/units/turalyon/acknowledgement/1",			335	__},
{W,2,"human/units/turalyon/acknowledgement/2",			336	__},
{W,2,"human/units/turalyon/acknowledgement/3",			337	__},
{W,2,"orc/units/deathwing/annoyed/1",				338	__},
{W,2,"orc/units/deathwing/annoyed/2",				339	__},
{W,2,"orc/units/deathwing/annoyed/3",				340	__},
{W,2,"orc/units/deathwing/selected/1",				341	__},
{W,2,"orc/units/deathwing/selected/2",				342	__},
{W,2,"orc/units/deathwing/selected/3",				343	__},
{W,2,"orc/units/deathwing/acknowledgement/1",			344	__},
{W,2,"orc/units/deathwing/acknowledgement/2",			345	__},
{W,2,"orc/units/deathwing/acknowledgement/3",			346	__},
{W,2,"orc/units/dentarg/annoyed/1",				347	__},
{W,2,"orc/units/dentarg/annoyed/2",				348	__},
{W,2,"orc/units/dentarg/annoyed/3",				349	__},
{W,2,"orc/units/dentarg/selected/1",				350	__},
{W,2,"orc/units/dentarg/selected/2",				351	__},
{W,2,"orc/units/dentarg/selected/3",				352	__},
{W,2,"orc/units/dentarg/acknowledgement/1",			353	__},
{W,2,"orc/units/dentarg/acknowledgement/2",			354	__},
{W,2,"orc/units/dentarg/acknowledgement/3",			355	__},
{W,2,"orc/units/grom hellscream/annoyed/1",			356	__},
{W,2,"orc/units/grom hellscream/annoyed/2",			357	__},
{W,2,"orc/units/grom hellscream/annoyed/3",			358	__},
{W,2,"orc/units/grom hellscream/selected/1",			359	__},
{W,2,"orc/units/grom hellscream/selected/2",			360	__},
{W,2,"orc/units/grom hellscream/selected/3",			361	__},
{W,2,"orc/units/grom hellscream/acknowledgement/1",		362	__},
{W,2,"orc/units/grom hellscream/acknowledgement/2",		363	__},
{W,2,"orc/units/grom hellscream/acknowledgement/3",		364	__},
{W,2,"orc/units/korgath bladefist/annoyed/1",			365	__},
{W,2,"orc/units/korgath bladefist/annoyed/2",			366	__},
{W,2,"orc/units/korgath bladefist/annoyed/3",			367	__},
{W,2,"orc/units/korgath bladefist/selected/1",			368	__},
{W,2,"orc/units/korgath bladefist/selected/2",			369	__},
{W,2,"orc/units/korgath bladefist/selected/3",			370	__},
{W,2,"orc/units/korgath bladefist/acknowledgement/1",		371	__},
{W,2,"orc/units/korgath bladefist/acknowledgement/2",		372	__},
{W,2,"orc/units/korgath bladefist/acknowledgement/3",		373	__},
{W,2,"orc/units/teron gorefiend/annoyed/1",			374	__},
{W,2,"orc/units/teron gorefiend/annoyed/2",			375	__},
{W,2,"orc/units/teron gorefiend/annoyed/3",			376	__},
{W,2,"orc/units/teron gorefiend/selected/1",			377	__},
{W,2,"orc/units/teron gorefiend/selected/2",			378	__},
{W,2,"orc/units/teron gorefiend/selected/3",			379	__},
{W,2,"orc/units/teron gorefiend/acknowledgement/1",		380	__},
{W,2,"orc/units/teron gorefiend/acknowledgement/2",		381	__},
{W,2,"orc/units/teron gorefiend/acknowledgement/3",		382	__},
{W,2,"neutral/units/warthog/selected/1",			383	__},
{W,2,"neutral/units/warthog/annoyed/1",				384	__},

///////////////////////////////////////////////////////////////////////////////
//	INTERFACE
///////////////////////////////////////////////////////////////////////////////

#ifdef USE_BEOS
{F,0,"REZDAT.WAR",				3000 __},
#else
{F,0,"rezdat.war",				3000 __},
#endif

// (correct palette is #2 in maindat)
{U,0,"ui/buttons 1",						14, 0	_2},
// (correct palette is #2 in maindat)
{U,0,"ui/buttons 2",						14, 1	_2},
{I,0,"ui/cd-icon",						14, 2	_2},
{I,0,"ui/human/panel 1",					14, 3	_2},
{I,0,"ui/orc/panel 1",						14, 4	_2},
{I,0,"ui/human/panel 2",					14, 5	_2},
{I,0,"ui/orc/panel 2",						14, 6	_2},
{I,0,"ui/human/panel 3",					14, 7	_2},
{I,0,"ui/orc/panel 3",						14, 8	_2},
{I,0,"ui/human/panel 4",					14, 9	_2},
{I,0,"ui/orc/panel 4",						14, 10	_2},
{I,0,"ui/human/panel 5",					14, 11	_2},
{I,0,"ui/orc/panel 5",						14, 12	_2},
{I,0,"ui/Menu background with title",				14, 13	_2},
{I,0,"ui/Menu background without title",			16, 15	_2},
{I,0,"../campaigns/human/interface/Act I   - Shores of Lordareon",17, 19 _2},
{I,0,"../campaigns/orc/interface/Act I   - Seas of Blood",	17, 20 _2},
{I,0,"../campaigns/human/interface/Act II  - Khaz Modan",	17, 21 _2},
{I,0,"../campaigns/orc/interface/Act II  - Khaz Modan",		17, 22 _2},
{I,0,"../campaigns/human/interface/Act III - The Northlands",	17, 23 _2},
{I,0,"../campaigns/orc/interface/Act III - Quel'Thalas",	17, 24 _2},
{I,0,"../campaigns/human/interface/Act IV  - Return to Azeroth",17, 25 _2},
{I,0,"../campaigns/orc/interface/Act IV  - Tides of Darkness",	17, 26 _2},

{I,0,"ui/human/The End",					27, 29 _2},
{I,0,"ui/orc/Smashing of Lordaeron scroll",			32, 30 _2},
{I,2,"ui/Patch",						14, 91 _2},
{I,2,"ui/Credits for extension background",			93, 94 _2},
{I,2,"../campaigns/human-exp/interface/Act I  - A Time for Heroes",17,96 _2},
{I,2,"../campaigns/orc-exp/interface/Act I  - Draenor, the Red World",17,97 _2},
{I,2,"../campaigns/human-exp/interface/Act II - Draenor, the Red World",17,98 _2},
{I,2,"../campaigns/orc-exp/interface/Act II - The Burning of Azeroth",17,99 _2},
{I,2,"../campaigns/human-exp/interface/Act III- War in the Shadows",17, 100 _2},
{I,2,"../campaigns/orc-exp/interface/Act III- The Great Sea",	17, 101 _2},
{I,2,"../campaigns/human-exp/interface/Act IV - The Measure of Valor",17,102 _2},
{I,2,"../campaigns/orc-exp/interface/Act IV - Prelude to New Worlds",17,103 _2},

///////////////////////////////////////////////////////////////////////////////
//	SPEACH INTROS
///////////////////////////////////////////////////////////////////////////////

	// FIXME: this file contains different data, if expansion or not.
	// FIXME: Where and what are the expansion entries

#ifdef USE_BEOS
{F,0,"SNDDAT.WAR",				2000 __},
#else
{F,0,"snddat.war",				2000 __},
#endif
{W,0,"../campaigns/human/victory",					2  __},
{W,0,"../campaigns/orc/victory",					3  __},
{W,0,"../campaigns/human/level01h-intro1",				4  __},
{W,0,"../campaigns/human/level01h-intro2",				5  __},
{W,0,"../campaigns/human/level02h-intro1",				6  __},
{W,0,"../campaigns/human/level02h-intro2",				7  __},
{W,0,"../campaigns/human/level03h-intro1",				8  __},
{W,0,"../campaigns/human/level03h-intro2",				9  __},
{W,0,"../campaigns/human/level04h-intro1",				10 __},
{W,0,"../campaigns/human/level04h-intro2",				11 __},
{W,0,"../campaigns/human/level05h-intro1",				12 __},
{W,0,"../campaigns/human/level05h-intro2",				13 __},
{W,0,"../campaigns/human/level06h-intro1",				14 __},
{W,0,"../campaigns/human/level07h-intro1",				15 __},
{W,0,"../campaigns/human/level07h-intro2",				16 __},
{W,0,"../campaigns/human/level08h-intro1",				17 __},
{W,0,"../campaigns/human/level08h-intro2",				18 __},
{W,0,"../campaigns/human/level09h-intro1",				19 __},
{W,0,"../campaigns/human/level10h-intro1",				20 __},
{W,0,"../campaigns/human/level11h-intro1",				21 __},
{W,0,"../campaigns/human/level11h-intro2",				22 __},
{W,0,"../campaigns/human/level12h-intro1",				23 __},
{W,0,"../campaigns/human/level13h-intro1",				24 __},
{W,0,"../campaigns/human/level13h-intro2",				25 __},
{W,0,"../campaigns/human/level14h-intro1",				26 __},

{W,0,"../campaigns/orc/level01o-intro1",				27 __},
{W,0,"../campaigns/orc/level02o-intro1",				28 __},
{W,0,"../campaigns/orc/level03o-intro1",				29 __},
{W,0,"../campaigns/orc/level03o-intro2",				30 __},
{W,0,"../campaigns/orc/level04o-intro1",				31 __},
{W,0,"../campaigns/orc/level05o-intro1",				32 __},
{W,0,"../campaigns/orc/level06o-intro1",				33 __},
{W,0,"../campaigns/orc/level07o-intro1",				34 __},
{W,0,"../campaigns/orc/level07o-intro2",				35 __},
{W,0,"../campaigns/orc/level08o-intro1",				36 __},
{W,0,"../campaigns/orc/level09o-intro1",				37 __},
{W,0,"../campaigns/orc/level10o-intro1",				38 __},
{W,0,"../campaigns/orc/level11o-intro1",				39 __},
{W,0,"../campaigns/orc/level11o-intro2",				40 __},
{W,0,"../campaigns/orc/level12o-intro1",				41 __},
{W,0,"../campaigns/orc/level12o-intro2",				42 __},
{W,0,"../campaigns/orc/level13o-intro1",				43 __},
{W,0,"../campaigns/orc/level13o-intro2",				44 __},
{W,0,"../campaigns/orc/level14o-intro1",				45 __},

{W,2,"../campaigns/human-exp/victory",					50 __},
{W,2,"../campaigns/human-exp/victory-2",				51 __},

{W,2,"../campaigns/orc-exp/victory-1",					52 __},
{W,2,"../campaigns/orc-exp/victory-2",					53 __},
{W,2,"../campaigns/orc-exp/victory-3",					54 __},
{W,2,"../campaigns/human-exp/levelx01h-intro1",				55 __},
{W,2,"../campaigns/human-exp/levelx01h-intro2",				56 __},
{W,2,"../campaigns/human-exp/levelx02h-intro1",				57 __},
{W,2,"../campaigns/human-exp/levelx02h-intro2",				58 __},
{W,2,"../campaigns/human-exp/levelx03h-intro1",				59 __},
{W,2,"../campaigns/human-exp/levelx03h-intro2",				60 __},
{W,2,"../campaigns/human-exp/levelx04h-intro1",				61 __},
{W,2,"../campaigns/human-exp/levelx04h-intro2",				62 __},
{W,2,"../campaigns/human-exp/levelx04h-intro3",				63 __},
{W,2,"../campaigns/human-exp/levelx05h-intro1",				64 __},
{W,2,"../campaigns/human-exp/levelx05h-intro2",				65 __},
{W,2,"../campaigns/human-exp/levelx06h-intro1",				66 __},
{W,2,"../campaigns/human-exp/levelx06h-intro2",				67 __},
{W,2,"../campaigns/human-exp/levelx06h-intro3",				68 __},
{W,2,"../campaigns/human-exp/levelx07h-intro1",				69 __},
{W,2,"../campaigns/human-exp/levelx07h-intro2",				70 __},
{W,2,"../campaigns/human-exp/levelx07h-intro3",				71 __},
{W,2,"../campaigns/human-exp/levelx08h-intro1",				72 __},
{W,2,"../campaigns/human-exp/levelx08h-intro2",				73 __},
{W,2,"../campaigns/human-exp/levelx09h-intro1",				74 __},
{W,2,"../campaigns/human-exp/levelx09h-intro2",				75 __},
{W,2,"../campaigns/human-exp/levelx10h-intro1",				76 __},
{W,2,"../campaigns/human-exp/levelx10h-intro2",				77 __},
{W,2,"../campaigns/human-exp/levelx10h-intro3",				78 __},
{W,2,"../campaigns/human-exp/levelx11h-intro1",				79 __},
{W,2,"../campaigns/human-exp/levelx11h-intro2",				80 __},
{W,2,"../campaigns/human-exp/levelx12h-intro1",				81 __},
{W,2,"../campaigns/human-exp/levelx12h-intro2",				82 __},
{W,2,"../campaigns/orc-exp/levelx01o-intro1",				83 __},
{W,2,"../campaigns/orc-exp/levelx01o-intro2",				84 __},
{W,2,"../campaigns/orc-exp/levelx01o-intro3",				85 __},
{W,2,"../campaigns/orc-exp/levelx02o-intro1",				86 __},
{W,2,"../campaigns/orc-exp/levelx02o-intro2",				87 __},
{W,2,"../campaigns/orc-exp/levelx03o-intro1",				88 __},
{W,2,"../campaigns/orc-exp/levelx03o-intro2",				89 __},
{W,2,"../campaigns/orc-exp/levelx04o-intro1",				90 __},
{W,2,"../campaigns/orc-exp/levelx04o-intro2",				91 __},
{W,2,"../campaigns/orc-exp/levelx05o-intro1",				92 __},
{W,2,"../campaigns/orc-exp/levelx05o-intro2",				93 __},
{W,2,"../campaigns/orc-exp/levelx06o-intro1",				94 __},
{W,2,"../campaigns/orc-exp/levelx06o-intro2",				95 __},
{W,2,"../campaigns/orc-exp/levelx07o-intro1",				96 __},
{W,2,"../campaigns/orc-exp/levelx07o-intro2",				97 __},
{W,2,"../campaigns/orc-exp/levelx07o-intro3",				98 __},
{W,2,"../campaigns/orc-exp/levelx08o-intro1",				99 __},
{W,2,"../campaigns/orc-exp/levelx09o-intro1",				100 __},
{W,2,"../campaigns/orc-exp/levelx09o-intro2",				101 __},
{W,2,"../campaigns/orc-exp/levelx10o-intro1",				102 __},
{W,2,"../campaigns/orc-exp/levelx10o-intro2",				103 __},
{W,2,"../campaigns/orc-exp/levelx10o-intro3",				104 __},
{W,2,"../campaigns/orc-exp/levelx11o-intro1",				105 __},
{W,2,"../campaigns/orc-exp/levelx11o-intro2",				106 __},
{W,2,"../campaigns/orc-exp/levelx12o-intro1",				107 __},
{W,2,"../campaigns/orc-exp/levelx12o-intro2",				108 __},
{W,2,"../campaigns/orc-exp/levelx12o-intro3",				109 __},
#if 0
{W,2,"../campaigns/levelx057-intro1",					110 __},
{W,2,"../campaigns/levelx058-intro1",					111 __},
{W,2,"../campaigns/levelx059-intro1",					112 __},
{W,2,"../campaigns/levelx060-intro1",					113 __},
{W,2,"../campaigns/levelx061-intro1",					114 __},
{W,2,"../campaigns/levelx062-intro1",					115 __},
{W,2,"../campaigns/levelx063-intro1",					116 __},
{W,2,"../campaigns/levelx064-intro1",					117 __},
{W,2,"../campaigns/levelx065-intro1",					118 __},
{W,2,"../campaigns/levelx066-intro1",					119 __},
{W,2,"../campaigns/levelx067-intro1",					120 __},
{W,2,"../campaigns/levelx068-intro1",					121 __},
{W,2,"../campaigns/levelx069-intro1",					122 __},
{W,2,"../campaigns/levelx070-intro1",					123 __},
{W,2,"../campaigns/levelx071-intro1",					124 __},
{W,2,"../campaigns/levelx072-intro1",					125 __},
{W,2,"../campaigns/levelx073-intro1",					126 __},
{W,2,"../campaigns/levelx074-intro1",					127 __},
{W,2,"../campaigns/levelx075-intro1",					128 __},
{W,2,"../campaigns/levelx076-intro1",					129 __},
{W,2,"../campaigns/levelx077-intro1",					130 __},
{W,2,"../campaigns/levelx078-intro1",					131 __},
{W,2,"../campaigns/levelx079-intro1",					132 __},
{W,2,"../campaigns/levelx080-intro1",					133 __},
{W,2,"../campaigns/levelx081-intro1",					134 __},
{W,2,"../campaigns/levelx082-intro1",					135 __},
{W,2,"../campaigns/levelx083-intro1",					136 __},
{W,2,"../campaigns/levelx084-intro1",					137 __},
{W,2,"../campaigns/levelx085-intro1",					138 __},
{W,2,"../campaigns/levelx086-intro1",					139 __},
{W,2,"../campaigns/levelx087-intro1",					140 __},
{W,2,"../campaigns/levelx088-intro1",					141 __},
{W,2,"../campaigns/levelx089-intro1",					142 __},
{W,2,"../campaigns/levelx090-intro1",					143 __},
{W,2,"../campaigns/levelx091-intro1",					144 __},
{W,2,"../campaigns/levelx092-intro1",					145 __},
{W,2,"../campaigns/levelx093-intro1",					146 __},
{W,2,"../campaigns/levelx094-intro1",					147 __},
{W,2,"../campaigns/levelx095-intro1",					148 __},
{W,2,"../campaigns/levelx096-intro1",					149 __},
{W,2,"../campaigns/levelx097-intro1",					150 __},
{W,2,"../campaigns/levelx098-intro1",					151 __},
{W,2,"../campaigns/levelx099-intro1",					152 __},
{W,2,"../campaigns/levelx100-intro1",					153 __},
{W,2,"../campaigns/levelx101-intro1",					154 __},
{W,2,"../campaigns/levelx102-intro1",					155 __},
{W,2,"../campaigns/levelx103-intro1",					156 __},
{W,2,"../campaigns/levelx104-intro1",					157 __},
{W,2,"../campaigns/levelx105-intro1",					158 __},
{W,2,"../campaigns/levelx106-intro1",					159 __},
{W,2,"../campaigns/levelx107-intro1",					160 __},
{W,2,"../campaigns/levelx108-intro1",					161 __},
{W,2,"../campaigns/levelx109-intro1",					162 __},
{W,2,"../campaigns/levelx110-intro1",					163 __},
{W,2,"../campaigns/levelx111-intro1",					164 __},
{W,2,"../campaigns/levelx112-intro1",					165 __},
{W,2,"../campaigns/levelx113-intro1",					166 __},
{W,2,"../campaigns/levelx114-intro1",					167 __},
{W,2,"../campaigns/levelx115-intro1",					168 __},
{W,2,"../campaigns/levelx116-intro1",					169 __},
{W,2,"../campaigns/levelx117-intro1",					170 __},
{W,2,"../campaigns/levelx118-intro1",					171 __},
{W,2,"../campaigns/levelx119-intro1",					172 __},
{W,2,"../campaigns/levelx120-intro1",					173 __},
#endif

///////////////////////////////////////////////////////////////////////////////
//	INTERFACE
///////////////////////////////////////////////////////////////////////////////

#ifdef USE_BEOS
{F,0,"MUDDAT.CUD",				6000 __},
#else
{F,0,"muddat.cud",				6000 __},
#endif

{V,0,"videos/video1",						0	__},
{V,0,"videos/video2",						2	__},
{V,0,"videos/video3",						3	__},
{V,0,"videos/video4",						4	__},
{V,0,"videos/video5",						5	__},
{V,0,"videos/video6",						6	__},

{V,0,"videos/video7",						8	__},
{V,0,"videos/video8",						9	__},
{V,0,"videos/video9",						10	__},
{V,0,"videos/video10",						11	__},
{V,0,"videos/video11",						12	__},

{V,0,"videos/video12",						14	__},

{V,2,"videos/video13",						15	__},
{V,2,"videos/video14",						16	__},
{V,2,"videos/video15",						17	__},
{V,2,"videos/video16",						18	__},

#undef __
};

/**
**	File names.
*/
char* UnitNames[110];

//----------------------------------------------------------------------------
//	TOOLS
//----------------------------------------------------------------------------

/**
**	Check if path exists, if not make all directories.
*/
void CheckPath(const char* path)
{
    char* cp;
    char* s;

    if( *path && path[0]=='.' ) {	// relative don't work
	return;
    }
    cp=strdup(path);
    s=strrchr(cp,'/');
    if( s ) {
	*s='\0';			// remove file
	s=cp;
	for( ;; ) {			// make each path element
	    s=strchr(s,'/');
	    if( s ) {
		*s='\0';
	    }
#ifdef USE_WIN32
	    mkdir(cp);
#else
	    mkdir(cp,0777);
#endif
	    if( s ) {
		*s++='/';
	    } else {
		break;
	    }
	}
    }
    free(cp);
}

/**
**	Given a file name that would appear in a PC archive convert it to what
**	would appear on the Mac.
*/
void ConvertToMac(char *filename)
{
    if (!strcmp(filename, "rezdat.war")) {
	strcpy(filename, "War Resources");
	return;
    }
    if (!strcmp(filename, "strdat.war")) {
	strcpy(filename, "War Strings");
	return;
    }
    if (!strcmp(filename, "maindat.war")) {
	strcpy(filename, "War Data");
	return;
    }
    if (!strcmp(filename, "snddat.war")) {
	strcpy(filename, "War Music");
	return;
    }
    if (!strcmp(filename, "muddat.cud")) {
	strcpy(filename, "War Movies");
	return;
    }
    if (!strcmp(filename, "sfxdat.sud")) {
	strcpy(filename, "War Sounds");
	return;
    }
}

//----------------------------------------------------------------------------
//	PNG
//----------------------------------------------------------------------------

/**
**	Save a png file.
**
**	@param name	File name
**	@param image	Graphic data
**	@param w	Graphic width
**	@param h	Graphic height
**	@param pal	Palette
*/
int SavePNG(const char* name,unsigned char* image,int w,int h
	,unsigned char* pal)
{
    FILE* fp;
    png_structp png_ptr;
    png_infop info_ptr;
    unsigned char** lines;
    int i;

    if( !(fp=fopen(name,"wb")) ) {
	printf("%s:",name);
	perror("Can't open file");
	return 1;
    }

    png_ptr=png_create_write_struct(PNG_LIBPNG_VER_STRING,NULL,NULL,NULL);
    if( !png_ptr ) {
	fclose(fp);
	return 1;
    }
    info_ptr=png_create_info_struct(png_ptr);
    if( !info_ptr ) {
	png_destroy_write_struct(&png_ptr,NULL);
	fclose(fp);
	return 1;
    }

    if( setjmp(png_ptr->jmpbuf) ) {
	// FIXME: must free buffers!!
	png_destroy_write_struct(&png_ptr,&info_ptr);
	fclose(fp);
	return 1;
    }
    png_init_io(png_ptr,fp);

    // zlib parameters
    png_set_compression_level(png_ptr,Z_BEST_COMPRESSION);

    //	prepare the file information

    info_ptr->width=w;
    info_ptr->height=h;
    info_ptr->bit_depth=8;
    info_ptr->color_type=PNG_COLOR_TYPE_PALETTE;
    info_ptr->interlace_type=0;
    info_ptr->valid|=PNG_INFO_PLTE;
    info_ptr->palette=(void*)pal;
    info_ptr->num_palette=256;

    png_write_info(png_ptr,info_ptr);	// write the file header information

    //	set transformation

    //	prepare image

    lines=malloc(h*sizeof(*lines));
    if( !lines ) {
	png_destroy_write_struct(&png_ptr,&info_ptr);
	fclose(fp);
	return 1;
    }

    for( i=0; i<h; ++i ) {
	lines[i]=image+i*w;
    }

    png_write_image(png_ptr,lines);
    png_write_end(png_ptr,info_ptr);

    png_destroy_write_struct(&png_ptr,&info_ptr);
    fclose(fp);

    free(lines);

    return 0;
}

//----------------------------------------------------------------------------
//	Archive
//----------------------------------------------------------------------------

/**
**	Open the archive file.
**
**	@param file	Archive file name
**	@param type	Archive type requested
*/
int OpenArchive(const char* file,int type)
{
    int f;
    struct stat stat_buf;
    unsigned char* buf;
    unsigned char* cp;
    unsigned char** op;
    int entries;
    int i;

    //
    //	Open the archive file
    //
    f=open(file,O_RDONLY|O_BINARY,0);
    if( f==-1 ) {
	printf("Can't open %s\n",file);
	exit(-1);
    }
    if( fstat(f,&stat_buf) ) {
	printf("Can't fstat %s\n",file);
	exit(-1);
    }
    DebugLevel3("Filesize %ld %ldk\n"
	_C_ (long)stat_buf.st_size _C_ stat_buf.st_size/1024);

    //
    //	Read in the archive
    //
    buf=malloc(stat_buf.st_size);
    if( !buf ) {
	printf("Can't malloc %ld\n",(long)stat_buf.st_size);
	exit(-1);
    }
    if( read(f,buf,stat_buf.st_size)!=stat_buf.st_size ) {
	printf("Can't read %ld\n",(long)stat_buf.st_size);
	exit(-1);
    }
    close(f);

    cp=buf;
    i=FetchLE32(cp);
    DebugLevel2("Magic\t%08X\t" _C_ i);
    if( i!=0x19 ) {
	printf("Wrong magic %08x, expected %08x\n",i,0x00000019);
	exit(-1);
    }
    entries=FetchLE16(cp);
    DebugLevel3("Entries\t%5d\t" _C_ entries);
    i=FetchLE16(cp);
    DebugLevel3("ID\t%d\n" _C_ i);
    if( i!=type ) {
	printf("Wrong type %08x, expected %08x\n",i,type);
	exit(-1);
    }

    //
    //	Read offsets.
    //
    op=malloc((entries+1)*sizeof(unsigned char**));
    if( !op ) {
	printf("Can't malloc %d entries\n",entries);
	exit(-1);
    }
    for( i=0; i<entries; ++i ) {
	op[i]=buf+FetchLE32(cp);
	DebugLevel3("Offset\t%d\n" _C_ op[i]);
    }
    op[i]=buf+stat_buf.st_size;

    ArchiveOffsets=op;
    ArchiveBuffer=buf;

    return 0;
}

/**
**	Extract/uncompress entry.
**
**	@param cp	Pointer to compressed entry
**	@param lenp	Return pointer of length of the entry
**
**	@return		Pointer to uncompressed entry
*/
unsigned char* ExtractEntry(unsigned char* cp,int* lenp)
{
    unsigned char* dp;
    unsigned char* dest;
    int uncompressed_length;
    int flags;

    uncompressed_length=FetchLE32(cp);
    flags=uncompressed_length>>24;
    uncompressed_length&=0x00FFFFFF;
    DebugLevel3("Entry length %8d flags %02x\t" _C_ uncompressed_length _C_ flags);

    dp=dest=malloc(uncompressed_length);
    if( !dest ) {
	printf("Can't malloc %d\n",uncompressed_length);
	exit(-1);
    }

    if( flags==0x20 ) {
	unsigned char buf[4096];
	unsigned char* ep;
	int bi;

	DebugLevel3("Compressed entry\n");

	bi=0;
	memset(buf,0,sizeof(buf));
	ep=dp+uncompressed_length;

	// FIXME: If the decompression is too slow, optimise this loop :->
	while( dp<ep ) {
	    int i;
	    int bflags;

	    bflags=FetchByte(cp);
	    DebugLevel3("Ctrl %02x " _C_ bflags);
	    for( i=0; i<8; ++i ) {
		int j;
		int o;

		if( bflags&1 ) {
		    j=FetchByte(cp);
		    *dp++=j;
		    buf[bi++&0xFFF]=j;
		    DebugLevel3("=%02x" _C_ j);
		} else {
		    o=FetchLE16(cp);
		    DebugLevel3("*%d,%d" _C_ o>>12 _C_ o&0xFFF);
		    j=(o>>12)+3;
		    o&=0xFFF;
		    while( j-- ) {
			buf[bi++&0xFFF]=*dp++=buf[o++&0xFFF];
			if( dp==ep ) {
			    break;
			}
		    }
		}
		if( dp==ep ) {
		    break;
		}
		bflags>>=1;
	    }
	    DebugLevel3("\n");
	}
	//if( dp!=ep ) printf("%p,%p %d\n",dp,ep,dp-dest);
    } else if( flags==0x00 ) {
	DebugLevel3("Uncompressed entry\n");
	memcpy(dest,cp,uncompressed_length);
    } else {
	printf("Unknown flags %x\n",flags);
	exit(-1);
    }

    if( lenp ) {			// return resulting length
	*lenp=uncompressed_length;
    }

    return dest;
}

/**
**	Close the archive file.
*/
int CloseArchive(void)
{
    free(ArchiveBuffer);
    free(ArchiveOffsets);
    ArchiveBuffer=0;
    ArchiveOffsets=0;

    return 0;
}

//----------------------------------------------------------------------------
//	Palette
//----------------------------------------------------------------------------

/**
**	Convert palette.
**
**	@param pal	Pointer to palette
**
**	@return		Pointer to palette
*/
unsigned char* ConvertPalette(unsigned char* pal)
{
    int i;

    for( i=0; i<768; ++i ) {		// PNG needs 0-256
	pal[i]<<=2;
    }

    return pal;
}

/**
**	Convert rgb to my format.
*/
int ConvertRgb(char* file,int rgbe)
{
    unsigned char* rgbp;
    char buf[1024];
    FILE* f;
    int i;
    size_t l;

    rgbp=ExtractEntry(ArchiveOffsets[rgbe],&l);
    ConvertPalette(rgbp);

    //
    //	Generate RGB File.
    //
    sprintf(buf,"%s/%s/%s.rgb",Dir,TILESET_PATH,file);
    CheckPath(buf);
    f=fopen(buf,"wb");
    if( !f ) {
	perror("");
	printf("Can't open %s\n",buf);
	exit(-1);
    }
    if( l!=fwrite(rgbp,1,l,f) ) {
	printf("Can't write %d bytes\n",l);
    }

    fclose(f);

    //
    //	Generate GIMP palette
    //
    sprintf(buf,"%s/%s/%s.gimp",Dir,TILESET_PATH,file);
    CheckPath(buf);
    f=fopen(buf,"wb");
    if( !f ) {
	perror("");
	printf("Can't open %s\n",buf);
	exit(-1);
    }
    fprintf(f,"GIMP Palette\n# FreeCraft %c%s -- GIMP Palette file\n"
	    ,toupper(*file),file+1);

    for( i=0; i<256; ++i ) {
	// FIXME: insert nice names!
	fprintf(f,"%d %d %d\t#%d\n"
		,rgbp[i*3],rgbp[i*3+1],rgbp[i*3+2],i);
    }

    free(rgbp);

    return 0;
}

//----------------------------------------------------------------------------
//	Tileset
//----------------------------------------------------------------------------

/**
**	Count used mega tiles for map.
*/
int CountUsedTiles(const unsigned char* map,const unsigned char* mega
	,int* map2tile)
{
    int i;
    int j;
    int used;
    const char* tp;
    int img2tile[0x9E0];

    DebugLevel3Fn("\n");
    memset(map2tile,0,sizeof(map2tile));

    //
    //	Build conversion table.
    //
    for( i=0; i<0x9E; ++i ) {
	tp=map+i*42;
	DebugLevel3("%02X:" _C_ i);
	for( j=0; j<0x10; ++j ) {
	    DebugLevel3("%04X " _C_ AccessLE16(tp+j*2));
	    map2tile[(i<<4)|j]=AccessLE16(tp+j*2);
	}
	DebugLevel3("\n");
    }

    //
    //	Mark all used mega tiles.
    //
    used=0;
    for( i=0; i<0x9E0; ++i ) {
	if( !map2tile[i] ) {
	    continue;
	}
	for( j=0; j<used; ++j ) {
	    if( img2tile[j]==map2tile[i] ) {
		break;
	    }
	}
	if( j==used ) {
	    //
	    //	Check unique mega tiles.
	    //
	    for( j=0; j<used; ++j ) {
		if( !memcmp(mega+img2tile[j]*32
			    ,mega+map2tile[i]*32,32) ) {
		    break;
		}
	    }
	    if( j==used ) {
		img2tile[used++]=map2tile[i];
	    }
	}
    }
    DebugLevel3("Used mega tiles %d\n" _C_ used);
#if 0
    for( i=0; i<used; ++i ) {
	if( !(i%16) ) {
	    DebugLevel1("\n");
	}
	DebugLevel1("%3d ",img2tile[i]);
    }
    DebugLevel1("\n");
#endif

    return used;
}

/**
**	Convert for ccl.
*/
void SaveCCL(const char* name,unsigned char* map __attribute__((unused)),const int* map2tile)
{
    int i;
    char* cp;
    FILE* f;
    char file[1024];
    char tileset[1024];

    f=stdout;
    // FIXME: open file!

    if( (cp=strrchr(name,'/')) ) {	// remove leading path
	++cp;
    } else {
	cp=(char*)name;
    }
    strcpy(file,cp);
    strcpy(tileset,cp);
    if( (cp=strrchr(tileset,'.')) ) {	// remove suffix
	*cp='\0';
    }

    fprintf(f,"(tileset Tileset%c%s \"%s\" \"%s\"\n"
	,toupper(*tileset),tileset+1,tileset,file);

    fprintf(f,"  #(");
    for( i=0; i<0x9E0; ++i ) {
	if( i&15 ) {
	    fprintf(f," ");
	} else if( i ) {
	    fprintf(f,"\t; %03X\n    ",i-16);
	}
	fprintf(f,"%3d",map2tile[i]);
    }

    fprintf(f,"  ))\n");

    // fclose(f);
}

/**
**	Decode a minitile into the image.
*/
void DecodeMiniTile(unsigned char* image,int ix,int iy,int iadd
	,unsigned char* mini,int index,int flipx,int flipy)
{
    int x;
    int y;

    DebugLevel3Fn("index %d\n" _C_ index);
    for( y=0; y<8; ++y ) {
	for( x=0; x<8; ++x ) {
	    image[(y+iy*8)*iadd+ix*8+x]=mini[index+
		(flipy ? (8-y) : y)*8+(flipx ? (8-x) : x)];
	}
    }
}

/**
**	Convert tiles into image.
*/
unsigned char* ConvertTile(unsigned char* mini,const char* mega,int msize
	,const char* map __attribute__((unused)),int *wp,int *hp)
{
    unsigned char* image;
    const unsigned short* mp;
    int height;
    int width;
    int i;
    int x;
    int y;
    int offset;
    int numtiles;

    DebugLevel3("Tiles in mega %d\t" _C_ msize/32);
    numtiles=msize/32;

    width=TILE_PER_ROW*32;
    height=((numtiles+TILE_PER_ROW-1)/TILE_PER_ROW)*32;
    DebugLevel3("Image %dx%d\n" _C_ width _C_ height);
    image=malloc(height*width);
    memset(image,0,height*width);

    for( i=0; i<numtiles; ++i ) {
	//mp=(const unsigned short*)(mega+img2tile[i]*32);
	mp=(const unsigned short*)(mega+i*32);
	if( i<16 ) {		// fog of war
	    for( y=0; y<32; ++y ) {
		offset=i*32*32+y*32;
		memcpy(image+(i%TILE_PER_ROW)*32
			+(((i/TILE_PER_ROW)*32)+y)*width
			,mini+offset,32);
	    }
	} else {		// normal tile
	    for( y=0; y<4; ++y ) {
		for( x=0; x<4; ++x ) {
		    offset=ConvertLE16(mp[x+y*4]);
		    DecodeMiniTile(image
			,x+((i%TILE_PER_ROW)*4),y+(i/TILE_PER_ROW)*4,width
			,mini,(offset&0xFFFC)*16,offset&2,offset&1);
		}
	    }
	}
    }

    *wp=width;
    *hp=height;

    return image;
}

/**
**	Convert a tileset to my format.
*/
int ConvertTileset(char* file,int pale,int mege,int mine,int mape)
{
    unsigned char* palp;
    unsigned char* megp;
    unsigned char* minp;
    unsigned char* mapp;
    unsigned char* image;
    int w;
    int h;
    int megl;
    char buf[1024];

    palp=ExtractEntry(ArchiveOffsets[pale],NULL);
    megp=ExtractEntry(ArchiveOffsets[mege],&megl);
    minp=ExtractEntry(ArchiveOffsets[mine],NULL);
    mapp=ExtractEntry(ArchiveOffsets[mape],NULL);

    DebugLevel3("%s:\t" _C_ file);
    image=ConvertTile(minp,megp,megl,mapp,&w,&h);

    free(megp);
    free(minp);
    free(mapp);

    ConvertPalette(palp);

    sprintf(buf,"%s/%s/%s.png",Dir,TILESET_PATH,file);
    CheckPath(buf);
    SavePNG(buf,image,w,h,palp);

    free(image);
    free(palp);

    return 0;
}

//----------------------------------------------------------------------------
//	Graphics
//----------------------------------------------------------------------------

/**
**	Decode a entry(frame) into image.
*/
void DecodeGfxEntry(int index,unsigned char* start
	,unsigned char* image,int ix,int iy,int iadd)
{
    unsigned char* bp;
    unsigned char* sp;
    unsigned char* dp;
    int xoff;
    int yoff;
    int width;
    int height;
    int offset;
    unsigned char* rows;
    int h;
    int w;
    int ctrl;

    bp=start+index*8;
    xoff=FetchByte(bp);
    yoff=FetchByte(bp);
    width=FetchByte(bp);
    height=FetchByte(bp);
    offset=FetchLE32(bp);

    DebugLevel3("%2d: +x %2d +y %2d width %2d height %2d offset %d\n"
	_C_ index _C_ xoff _C_ yoff _C_ width _C_ height _C_ offset);

    rows=start+offset-6;
    dp=image+xoff-ix+(yoff-iy)*iadd;

    for( h=0; h<height; ++h ) {
	DebugLevel3("%2d: row-offset %2d\t" _C_ index _C_ AccessLE16(rows+h*2));
	sp=rows+AccessLE16(rows+h*2);
	for( w=0; w<width; ) {
	    ctrl=*sp++;
	    DebugLevel3("%02X" _C_ ctrl);
	    if( ctrl&0x80 ) {		// transparent
		ctrl&=0x7F;
		DebugLevel3("-%d," _C_ ctrl);
		memset(dp+h*iadd+w,255,ctrl);
		w+=ctrl;
	    } else if( ctrl&0x40 ) {	// repeat
		ctrl&=0x3F;
		DebugLevel3("*%d," _C_ ctrl);
		memset(dp+h*iadd+w,*sp++,ctrl);
		w+=ctrl;
	    } else {			// set pixels
		ctrl&=0x3F;
		DebugLevel3("=%d," _C_ ctrl);
		memcpy(dp+h*iadd+w,sp,ctrl);
		sp+=ctrl;
		w+=ctrl;
	    }
	}
	//dp[h*iadd+width-1]=0;
	DebugLevel3("\n");
    }
}

/**
**	Decode a entry(frame) into image.
*/
void DecodeGfuEntry(int index,unsigned char* start
	,unsigned char* image,int ix,int iy,int iadd)
{
    unsigned char* bp;
    unsigned char* sp;
    unsigned char* dp;
    int i;
    int xoff;
    int yoff;
    int width;
    int height;
    int offset;

    bp=start+index*8;
    xoff=FetchByte(bp);
    yoff=FetchByte(bp);
    width=FetchByte(bp);
    height=FetchByte(bp);
    offset=FetchLE32(bp);
    if( offset<0 ) {			// High bit of width
	offset&=0x7FFFFFFF;
	width+=256;
    }

    DebugLevel3("%2d: +x %2d +y %2d width %2d height %2d offset %d\n"
	_C_ index _C_ xoff _C_ yoff _C_ width _C_ height _C_ offset);

    sp=start+offset-6;
    dp=image+xoff-ix+(yoff-iy)*iadd;
    for( i=0; i<height; ++i ) {
	memcpy(dp,sp,width);
	dp+=iadd;
	sp+=width;
    }
}
/**
**	Convert graphics into image.
*/
unsigned char* ConvertGraphic(int gfx,unsigned char* bp,int *wp,int *hp
	,unsigned char* bp2,int start2)
{
    int i;
    int count;
    int length;
    int max_width;
    int max_height;
    int minx;
    int miny;
    int best_width;
    int best_height;
    unsigned char* image;
    int IPR;

    if (bp2) {	// Init pointer to 2nd animation
	count=FetchLE16(bp2);
	max_width=FetchLE16(bp2);
	max_height=FetchLE16(bp2);
    }
    count=FetchLE16(bp);
    max_width=FetchLE16(bp);
    max_height=FetchLE16(bp);


    DebugLevel3("Entries %2d Max width %3d height %3d, " _C_ count
	    _C_ max_width _C_ max_height);

    // Find best image size
    minx=999;
    miny=999;
    best_width=0;
    best_height=0;
    for( i=0; i<count; ++i ) {
	unsigned char* p;
	int xoff;
	int yoff;
	int width;
	int height;

	p=bp+i*8;
	xoff=FetchByte(p);
	yoff=FetchByte(p);
	width=FetchByte(p);
	height=FetchByte(p);
	if( FetchLE32(p)&0x80000000 ) {	// high bit of width
	    width+=256;
	}
	if( xoff<minx ) minx=xoff;
	if( yoff<miny ) miny=yoff;
	if( xoff+width>best_width ) best_width=xoff+width;
	if( yoff+height>best_height ) best_height=yoff+height;
    }
    // FIXME: the image isn't centered!!

#if 0
    // Taken out, must be rewritten.
    if( max_width-best_width<minx ) {
	minx=max_width-best_width;
	best_width-=minx;
    } else {
	best_width=max_width-minx;
    }
    if( max_height-best_height<miny ) {
	miny=max_height-best_height;
	best_height-=miny;
    } else {
	best_height=max_width-miny;
    }

    //best_width-=minx;
    //best_height-=miny;
#endif

    DebugLevel3("Best image size %3d, %3d\n" _C_ best_width _C_ best_height);

    minx=0;
    miny=0;

    if( gfx ) {
	best_width=max_width;
	best_height=max_height;
	IPR=5;				// st*rcr*ft 17!
	if( count<IPR ) {		// images per row !!
	    IPR=1;
	    length=count;
	} else {
	    length=((count+IPR-1)/IPR)*IPR;
	}
    } else {
	max_width=best_width;
	max_height=best_height;
	IPR=1;
	length=count;
    }

    image=malloc(best_width*best_height*length);

    //	Image:	0, 1, 2, 3, 4,
    //		5, 6, 7, 8, 9, ...
    if( !image ) {
	printf("Can't allocate image\n");
	exit(-1);
    }
    // Set all to transparent.
    memset(image,255,best_width*best_height*length);

    if( gfx ) {
	for( i=0; i<count; ++i ) {
    // Hardcoded support for worker with resource repairing
	    if (i>=start2 && bp2) DecodeGfxEntry(i,bp2
		,image+best_width*(i%IPR)+best_height*best_width*IPR*(i/IPR)
		,minx,miny,best_width*IPR);
	    else DecodeGfxEntry(i,bp
		,image+best_width*(i%IPR)+best_height*best_width*IPR*(i/IPR)
		,minx,miny,best_width*IPR);
	}
    } else {
	for( i=0; i<count; ++i ) {
	    DecodeGfuEntry(i,bp
		,image+best_width*(i%IPR)+best_height*best_width*IPR*(i/IPR)
		,minx,miny,best_width*IPR);
	}
    }

    *wp=best_width*IPR;
    *hp=best_height*(length/IPR);

    return image;
}

/**
**	Convert a graphic to my format.
*/
int ConvertGfx(char* file,int pale,int gfxe,int gfxe2,int start2)
{
    unsigned char* palp;
    unsigned char* gfxp;
    unsigned char* gfxp2;
    unsigned char* image;
    int w;
    int h;
    char buf[1024];

    palp=ExtractEntry(ArchiveOffsets[pale],NULL);
    gfxp=ExtractEntry(ArchiveOffsets[gfxe],NULL);
    if (gfxe2) gfxp2=ExtractEntry(ArchiveOffsets[gfxe2],NULL);
    else gfxp2=NULL;

    image=ConvertGraphic(1,gfxp,&w,&h,gfxp2,start2);

    free(gfxp);
    ConvertPalette(palp);

    sprintf(buf,"%s/%s/%s.png",Dir,UNIT_PATH,file);
    CheckPath(buf);
    SavePNG(buf,image,w,h,palp);

    free(image);
    free(palp);

    return 0;
}

/**
**	Convert a uncompressed graphic to my format.
*/
int ConvertGfu(char* file,int pale,int gfue)
{
    unsigned char* palp;
    unsigned char* gfup;
    unsigned char* image;
    int w;
    int h;
    char buf[1024];

    palp=ExtractEntry(ArchiveOffsets[pale],NULL);
    gfup=ExtractEntry(ArchiveOffsets[gfue],NULL);

    image=ConvertGraphic(0,gfup,&w,&h,NULL,0);

    free(gfup);
    ConvertPalette(palp);

    sprintf(buf,"%s/%s/%s.png",Dir,UNIT_PATH,file);
    CheckPath(buf);
    SavePNG(buf,image,w,h,palp);

    free(image);
    free(palp);

    return 0;
}

//----------------------------------------------------------------------------
//	Puds
//----------------------------------------------------------------------------

/**
**	Convert pud to my format.
*/
void ConvertPud(char* file,int pude)
{
    unsigned char* pudp;
    char buf[1024];
    gzFile gf;
    int l;

    pudp=ExtractEntry(ArchiveOffsets[pude],&l);

    sprintf(buf,"%s/%s/%s.pud.gz",Dir,PUD_PATH,file);
    CheckPath(buf);
    gf=gzopen(buf,"wb9");
    if( !gf ) {
	perror("");
	printf("Can't open %s\n",buf);
	exit(-1);
    }
    if( l!=gzwrite(gf,pudp,l) ) {
	printf("Can't write %d bytes\n",l);
    }

    free(pudp);

    gzclose(gf);
}

//----------------------------------------------------------------------------
//	Font
//----------------------------------------------------------------------------

/**
**	Convert font into image.
*/
unsigned char* ConvertFnt(unsigned char* start,int *wp,int *hp)
{
    int i;
    int count;
    int max_width;
    int max_height;
    int width;
    int height;
    int w;
    int h;
    int xoff;
    int yoff;
    unsigned char* bp;
    unsigned char* dp;
    unsigned char* image;
    unsigned* offsets;

    bp=start+5;				// skip "FONT "
    count=FetchByte(bp)-32;
    max_width=FetchByte(bp);
    max_height=FetchByte(bp);

    DebugLevel3("Font: count %d max-width %2d max-height %2d\n"
	    _C_ count _C_ max_width _C_ max_height);

    offsets=malloc(count*sizeof(u_int32_t));
    for( i=0; i<count; ++i ) {
	offsets[i]=FetchLE32(bp);
	DebugLevel3("%03d: offset %d\n" _C_ i _C_ offsets[i]);
    }

    image=malloc(max_width*max_height*count);
    if( !image ) {
	printf("Can't allocate image\n");
	exit(-1);
    }
    memset(image,255,max_width*max_height*count);

    for( i=0; i<count; ++i ) {
	if( !offsets[i] ) {
	    DebugLevel3("%03d: unused\n" _C_ i);
	    continue;
	}
	bp=start+offsets[i];
	width=FetchByte(bp);
	height=FetchByte(bp);
	xoff=FetchByte(bp);
	yoff=FetchByte(bp);

	DebugLevel3("%03d: width %d height %d xoff %d yoff %d\n"
		_C_ i _C_ width _C_ height _C_ xoff _C_ yoff);

	dp=image+xoff+yoff*max_width+i*(max_width*max_height);
	h=w=0;
	for( ;; ) {
	    int ctrl;

	    ctrl=FetchByte(bp);
	    DebugLevel3("%d,%d " _C_ ctrl>>3 _C_ ctrl&7);
	    w+=(ctrl>>3)&0x1F;
	    if( w>=width ) {
		DebugLevel3("\n");
		w-=width;
		++h;
		if( h>=height ) {
		    break;
		}
	    }
	    dp[h*max_width+w]=ctrl&0x07;
	    ++w;
	    if( w>=width ) {
		DebugLevel3("\n");
		w-=width;
		++h;
		if( h>=height ) {
		    break;
		}
	    }
	}
    }

    free(offsets);

    *wp=max_width;
    *hp=max_height*count;

    return image;
}

/**
**	Convert a font to my format.
*/
int ConvertFont(char* file,int pale,int fnte)
{
    unsigned char* palp;
    unsigned char* fntp;
    unsigned char* image;
    int w;
    int h;
    char buf[1024];

    palp=ExtractEntry(ArchiveOffsets[pale],NULL);
    fntp=ExtractEntry(ArchiveOffsets[fnte],NULL);

    image=ConvertFnt(fntp,&w,&h);

    free(fntp);
    ConvertPalette(palp);

    sprintf(buf,"%s/%s/%s.png",Dir,FONT_PATH,file);
    CheckPath(buf);
    SavePNG(buf,image,w,h,palp);

    free(image);
    free(palp);

    return 0;
}

//----------------------------------------------------------------------------
//	Image
//----------------------------------------------------------------------------

/**
**	Convert image into image.
*/
unsigned char* ConvertImg(unsigned char* bp,int *wp,int *hp)
{
    int width;
    int height;
    unsigned char* image;

    width=FetchLE16(bp);
    height=FetchLE16(bp);

    DebugLevel3("Image: width %3d height %3d\n" _C_ width _C_ height);

    image=malloc(width*height);
    if( !image ) {
	printf("Can't allocate image\n");
	exit(-1);
    }
    memcpy(image,bp,width*height);

    *wp=width;
    *hp=height;

    return image;
}

/**
**	Resize an image
**
**	@param image	image data to be converted
**	@param ow	old image width
**	@param oh	old image height
**	@param nw	new image width
**	@param nh	new image height
*/
void ResizeImage(unsigned char** image,int ow,int oh,int nw,int nh)
{
    int i;
    int j;
    unsigned char *data;
    int x;

    if( ow==nw && nh==oh ) {
	return;
    }

    data = (unsigned char*)malloc(nw*nh);
    x=0;
    for( i=0; i<nh; ++i ) {
	for( j=0; j<nw; ++j ) {
	    data[x] = ((unsigned char*)*image)[
		(i*oh+nh/2)/nh*ow + (j*ow+nw/2)/nw];
	    ++x;
	}
    }

    free(*image);
    *image=data;
}

/**
**	Convert an image to my format.
*/
int ConvertImage(char* file,int pale,int imge, int nw, int nh)
{
    unsigned char* palp;
    unsigned char* imgp;
    unsigned char* image;
    int w;
    int h;
    char buf[1024];

    palp=ExtractEntry(ArchiveOffsets[pale],NULL);
    if (pale == 27 && imge == 28) {
	Pal27 = palp;
    }
    imgp=ExtractEntry(ArchiveOffsets[imge],NULL);

    image=ConvertImg(imgp,&w,&h);

    free(imgp);
    ConvertPalette(palp);

    sprintf(buf,"%s/%s/%s.png",Dir,GRAPHIC_PATH,file);
    CheckPath(buf);

    // Only resize if parameters 3 and 4 are non-zero
    if (nw && nh) {
	ResizeImage(&image,w,h,nw,nh);
	w=nw; h=nh;
    }
    SavePNG(buf,image,w,h,palp);

    free(image);
    if (pale != 27 && imge != 28) {
	free(palp);
    }

    return 0;
}

//----------------------------------------------------------------------------
//	Cursor
//----------------------------------------------------------------------------

/**
**	Convert cursor into image.
*/
unsigned char* ConvertCur(unsigned char* bp,int *wp,int *hp)
{
    int i;
    int hotx;
    int hoty;
    int width;
    int height;
    unsigned char* image;

    hotx=FetchLE16(bp);
    hoty=FetchLE16(bp);
    width=FetchLE16(bp);
    height=FetchLE16(bp);

    DebugLevel3("Cursor: hotx %d hoty %d width %d height %d\n"
	    _C_ hotx _C_ hoty _C_ width _C_ height);

    image=malloc(width*height);
    if( !image ) {
	printf("Can't allocate image\n");
	exit(-1);
    }
    for( i=0; i<width*height; ++i ) {
	image[i]=bp[i] ? bp[i] : 255;
    }

    *wp=width;
    *hp=height;

    return image;
}

/**
**	Convert a cursor to my format.
*/
int ConvertCursor(char* file,int pale,int cure)
{
    unsigned char* palp;
    unsigned char* curp;
    unsigned char* image;
    int w;
    int h;
    char buf[1024];

    if (pale == 27 && cure == 314 && Pal27 ) { // Credits arrow (Blue arrow NW)
	palp = Pal27;
    } else {
	palp=ExtractEntry(ArchiveOffsets[pale],NULL);
    }
    curp=ExtractEntry(ArchiveOffsets[cure],NULL);

    image=ConvertCur(curp,&w,&h);

    free(curp);
    ConvertPalette(palp);

    sprintf(buf,"%s/%s/%s.png",Dir,CURSOR_PATH,file);
    CheckPath(buf);
    SavePNG(buf,image,w,h,palp);

    free(image);
    if (pale != 27 && cure != 314) {
	free(palp);
    }

    return 0;
}

//----------------------------------------------------------------------------
//	Wav
//----------------------------------------------------------------------------

/**
**	Convert pud to my format.
*/
int ConvertWav(char* file,int wave)
{
    unsigned char* wavp;
    char buf[1024];
    gzFile gf;
    int l;

    wavp=ExtractEntry(ArchiveOffsets[wave],&l);

    sprintf(buf,"%s/%s/%s.wav.gz",Dir,SOUND_PATH,file);
    CheckPath(buf);
    gf=gzopen(buf,"wb9");
    if( !gf ) {
	perror("");
	printf("Can't open %s\n",buf);
	exit(-1);
    }
    if( l!=gzwrite(gf,wavp,l) ) {
	printf("Can't write %d bytes\n",l);
    }

    free(wavp);

    gzclose(gf);
    return 0;
}

//----------------------------------------------------------------------------
//	Video
//----------------------------------------------------------------------------

/**
**	Convert pud to my format.
*/
int ConvertVideo(char* file,int video)
{
    unsigned char* vidp;
    char buf[1024];
    FILE* gf;
    size_t l;

    vidp=ExtractEntry(ArchiveOffsets[video],&l);

    sprintf(buf,"%s/%s.smk",Dir,file);
    CheckPath(buf);
    gf=fopen(buf,"wb");
    if( !gf ) {
	perror("");
	printf("Can't open %s\n",buf);
	exit(-1);
    }
    if( l!=fwrite(vidp,1,l,gf) ) {
	printf("Can't write %d bytes\n",l);
    }

    free(vidp);

    fclose(gf);
    return 0;
}

//----------------------------------------------------------------------------
//	Text
//----------------------------------------------------------------------------

/**
**	Convert text to my format.
*/
int ConvertText(char* file,int txte,int ofs)
{
    unsigned char* txtp;
    char buf[1024];
    gzFile gf;
    int l;
    char strdat[1024];
    struct stat st;

    // need this for German version of original cd
#ifdef USE_BEOS
    sprintf(strdat, "%s/STRDAT.WAR", ArchiveDir);
#else
    sprintf(strdat, "%s/strdat.war", ArchiveDir);
#endif
    stat(strdat, &st);
    if (st.st_size == 55724) {
	--txte;
    }

    txtp=ExtractEntry(ArchiveOffsets[txte],&l);

    sprintf(buf,"%s/%s/%s.txt.gz",Dir,TEXT_PATH,file);
    CheckPath(buf);
    gf=gzopen(buf,"wb9");
    if( !gf ) {
	perror("");
	printf("Can't open %s\n",buf);
	exit(-1);
    }
    if( l-ofs!=gzwrite(gf,txtp+ofs,l-ofs) ) {
	printf("Can't write %d bytes\n",l);
    }

    free(txtp);

    gzclose(gf);
    return 0;
}

/**
**	Names for localised versions.
*/
unsigned char Names[]={
0xDF,0x01,0xC0,0x03,0xC1,0x03,0xC9,0x03,0xCF,0x03,0xD7,0x03,0xDC,0x03,0xE5,0x03,
0xEE,0x03,0xF5,0x03,0xFA,0x03,0x07,0x04,0x18,0x04,0x1D,0x04,0x2A,0x04,0x32,0x04,
0x3C,0x04,0x55,0x04,0x64,0x04,0x73,0x04,0x7F,0x04,0x86,0x04,0x90,0x04,0x98,0x04,
0xA8,0x04,0xBC,0x04,0xC4,0x04,0xCC,0x04,0xDC,0x04,0xED,0x04,0xFC,0x04,0x0C,0x05,
0x1A,0x05,0x2A,0x05,0x3A,0x05,0x45,0x05,0x57,0x05,0x58,0x05,0x62,0x05,0x63,0x05,
0x64,0x05,0x76,0x05,0x83,0x05,0x9A,0x05,0xAA,0x05,0xB8,0x05,0xBF,0x05,0xC8,0x05,
0xD7,0x05,0xDE,0x05,0xF0,0x05,0xF1,0x05,0xFA,0x05,0x01,0x06,0x09,0x06,0x1C,0x06,
0x23,0x06,0x24,0x06,0x2D,0x06,0x34,0x06,0x3C,0x06,0x41,0x06,0x4A,0x06,0x59,0x06,
0x66,0x06,0x6D,0x06,0x7D,0x06,0x89,0x06,0x95,0x06,0x9D,0x06,0xA8,0x06,0xB9,0x06,
0xCA,0x06,0xD9,0x06,0xE6,0x06,0xF5,0x06,0x02,0x07,0x0C,0x07,0x17,0x07,0x29,0x07,
0x3B,0x07,0x49,0x07,0x55,0x07,0x60,0x07,0x75,0x07,0x86,0x07,0x95,0x07,0xA4,0x07,
0xB1,0x07,0xC4,0x07,0xD5,0x07,0xDA,0x07,0xE5,0x07,0xEC,0x07,0xF5,0x07,0xFF,0x07,
0x09,0x08,0x1E,0x08,0x31,0x08,0x43,0x08,0x53,0x08,0x66,0x08,0x77,0x08,0x87,0x08,
0x93,0x08,0x9D,0x08,0xA2,0x08,0xA3,0x08,0xBC,0x08,0xD5,0x08,0xEC,0x08,0x03,0x09,
0x1C,0x09,0x35,0x09,0x4E,0x09,0x67,0x09,0x87,0x09,0xA7,0x09,0xC5,0x09,0xE3,0x09,
0xFF,0x09,0x1B,0x0A,0x35,0x0A,0x4F,0x0A,0x6A,0x0A,0x85,0x0A,0x9E,0x0A,0xB7,0x0A,
0xD3,0x0A,0xEF,0x0A,0x0B,0x0B,0x27,0x0B,0x3D,0x0B,0x4E,0x0B,0x5E,0x0B,0x72,0x0B,
0x8B,0x0B,0xA1,0x0B,0xB4,0x0B,0xCB,0x0B,0xE7,0x0B,0x03,0x0C,0x17,0x0C,0x27,0x0C,
0x38,0x0C,0x4D,0x0C,0x5E,0x0C,0x6B,0x0C,0x80,0x0C,0x92,0x0C,0xA3,0x0C,0xBA,0x0C,
0xCC,0x0C,0xDF,0x0C,0xF2,0x0C,0x04,0x0D,0x12,0x0D,0x27,0x0D,0x35,0x0D,0x4D,0x0D,
0x4E,0x0D,0x5A,0x0D,0x62,0x0D,0x69,0x0D,0x72,0x0D,0x79,0x0D,0x82,0x0D,0x89,0x0D,
0x92,0x0D,0x99,0x0D,0xA2,0x0D,0xA9,0x0D,0xB2,0x0D,0xB9,0x0D,0xC2,0x0D,0xC9,0x0D,
0xD3,0x0D,0xDB,0x0D,0xE5,0x0D,0xED,0x0D,0xF7,0x0D,0xFF,0x0D,0x09,0x0E,0x11,0x0E,
0x24,0x0E,0x33,0x0E,0x3E,0x0E,0x49,0x0E,0x59,0x0E,0x6B,0x0E,0x7D,0x0E,0x8D,0x0E,
0x9D,0x0E,0xA9,0x0E,0xB5,0x0E,0xC2,0x0E,0xCE,0x0E,0xDB,0x0E,0xE8,0x0E,0xF5,0x0E,
0x02,0x0F,0x10,0x0F,0x1E,0x0F,0x31,0x0F,0x46,0x0F,0x5C,0x0F,0x72,0x0F,0x85,0x0F,
0x9B,0x0F,0xB0,0x0F,0xC3,0x0F,0xD8,0x0F,0xED,0x0F,0x03,0x10,0x19,0x10,0x2F,0x10,
0x44,0x10,0x59,0x10,0x6F,0x10,0x82,0x10,0x97,0x10,0xAD,0x10,0xC3,0x10,0xD8,0x10,
0xEB,0x10,0x00,0x11,0x15,0x11,0x2B,0x11,0x40,0x11,0x55,0x11,0x62,0x11,0x6F,0x11,
0x7C,0x11,0x88,0x11,0x94,0x11,0xA0,0x11,0xAC,0x11,0xB9,0x11,0xC6,0x11,0xD3,0x11,
0xE0,0x11,0xEB,0x11,0xF7,0x11,0x02,0x12,0x03,0x12,0x16,0x12,0x21,0x12,0x2C,0x12,
0x36,0x12,0x40,0x12,0x49,0x12,0x52,0x12,0x5B,0x12,0x64,0x12,0x6C,0x12,0x74,0x12,
0x7F,0x12,0x8A,0x12,0x93,0x12,0x9C,0x12,0xA9,0x12,0xB6,0x12,0xC1,0x12,0xD6,0x12,
0xE2,0x12,0xEE,0x12,0xFB,0x12,0x08,0x13,0x17,0x13,0x1B,0x13,0x2A,0x13,0x3C,0x13,
0x51,0x13,0x62,0x13,0x73,0x13,0x87,0x13,0x98,0x13,0xB2,0x13,0xC4,0x13,0xD8,0x13,
0xEF,0x13,0x00,0x14,0x0F,0x14,0x1F,0x14,0x31,0x14,0x44,0x14,0x57,0x14,0x6C,0x14,
0x80,0x14,0x94,0x14,0xA9,0x14,0xC0,0x14,0xDC,0x14,0xF3,0x14,0x0D,0x15,0x26,0x15,
0x3E,0x15,0x4F,0x15,0x72,0x15,0x8B,0x15,0x9E,0x15,0xB4,0x15,0xC6,0x15,0xDB,0x15,
0xEB,0x15,0xFC,0x15,0x16,0x16,0x25,0x16,0x3B,0x16,0x52,0x16,0x69,0x16,0x80,0x16,
0x92,0x16,0xA1,0x16,0xB4,0x16,0xC9,0x16,0xDF,0x16,0xF7,0x16,0x0B,0x17,0x25,0x17,
0x40,0x17,0x5C,0x17,0x77,0x17,0x92,0x17,0xAB,0x17,0xC1,0x17,0xD6,0x17,0xF5,0x17,
0x0D,0x18,0x25,0x18,0x44,0x18,0x6A,0x18,0x8A,0x18,0xA9,0x18,0xC8,0x18,0xE7,0x18,
0x07,0x19,0x29,0x19,0x40,0x19,0x5A,0x19,0x7A,0x19,0x98,0x19,0xBC,0x19,0xD9,0x19,
0xFE,0x19,0x1F,0x1A,0x3A,0x1A,0x5D,0x1A,0x80,0x1A,0x95,0x1A,0xA2,0x1A,0xB3,0x1A,
0xBC,0x1A,0xCD,0x1A,0xDB,0x1A,0xE8,0x1A,0xFE,0x1A,0x12,0x1B,0x21,0x1B,0x2B,0x1B,
0x3C,0x1B,0x46,0x1B,0x54,0x1B,0x64,0x1B,0x7B,0x1B,0x8F,0x1B,0x9C,0x1B,0xAF,0x1B,
0xBD,0x1B,0xCD,0x1B,0xDC,0x1B,0xFC,0x1B,0x17,0x1C,0x2D,0x1C,0x47,0x1C,0x59,0x1C,
0x73,0x1C,0x8A,0x1C,0xA0,0x1C,0xBD,0x1C,0xD5,0x1C,0xE8,0x1C,0x02,0x1D,0x15,0x1D,
0x2C,0x1D,0x45,0x1D,0x5A,0x1D,0x77,0x1D,0x8D,0x1D,0xA9,0x1D,0xC0,0x1D,0xD9,0x1D,
0xF1,0x1D,0xFA,0x1D,0x03,0x1E,0x0E,0x1E,0x19,0x1E,0x36,0x1E,0x43,0x1E,0x5D,0x1E,
0x7A,0x1E,0x8D,0x1E,0xA3,0x1E,0xB5,0x1E,0xC6,0x1E,0xD1,0x1E,0xE6,0x1E,0xF3,0x1E,
0x04,0x1F,0x22,0x1F,0x41,0x1F,0x5A,0x1F,0x60,0x1F,0x67,0x1F,0x6F,0x1F,0x76,0x1F,
0x7D,0x1F,0x84,0x1F,0x8B,0x1F,0x95,0x1F,0xA1,0x1F,0xA8,0x1F,0xAE,0x1F,0xB8,0x1F,
0xC3,0x1F,0xCD,0x1F,0xDA,0x1F,0xE5,0x1F,0xF1,0x1F,0xF7,0x1F,0xFF,0x1F,0x04,0x20,
0x0E,0x20,0x1D,0x20,0x29,0x20,0x34,0x20,0x53,0x20,0x79,0x20,0x93,0x20,0xB7,0x20,
0xD9,0x20,0xFE,0x20,0x1E,0x21,0x3C,0x21,0x54,0x21,0x7F,0x21,0x9D,0x21,0xD1,0x21,
0x02,0x22,0x2C,0x22,0x31,0x22,0x37,0x22,0x3D,0x22,0x42,0x22,0x49,0x22,0x50,0x22,
0x5C,0x22,0x68,0x22,0x74,0x22,0x7B,0x22,0x81,0x22,0x8E,0x22,0x9B,0x22,0xA1,0x22,
0xA9,0x22,0xB0,0x22,0xB6,0x22,0xBC,0x22,0xC3,0x22,0xCA,0x22,0xCF,0x22,0xD6,0x22,
0xDB,0x22,0xE1,0x22,0xEB,0x22,0xF1,0x22,0xFB,0x22,0x00,0x23,0x09,0x23,0x14,0x23,
0x00,0x46,0x6F,0x6F,0x74,0x6D,0x61,0x6E,0x00,0x47,0x72,0x75,0x6E,0x74,0x00,0x50,
0x65,0x61,0x73,0x61,0x6E,0x74,0x00,0x50,0x65,0x6F,0x6E,0x00,0x42,0x61,0x6C,0x6C,
0x69,0x73,0x74,0x61,0x00,0x43,0x61,0x74,0x61,0x70,0x75,0x6C,0x74,0x00,0x4B,0x6E,
0x69,0x67,0x68,0x74,0x00,0x4F,0x67,0x72,0x65,0x00,0x45,0x6C,0x76,0x65,0x6E,0x20,
0x41,0x72,0x63,0x68,0x65,0x72,0x00,0x54,0x72,0x6F,0x6C,0x6C,0x20,0x41,0x78,0x65,
0x74,0x68,0x72,0x6F,0x77,0x65,0x72,0x00,0x4D,0x61,0x67,0x65,0x00,0x44,0x65,0x61,
0x74,0x68,0x20,0x4B,0x6E,0x69,0x67,0x68,0x74,0x00,0x50,0x61,0x6C,0x61,0x64,0x69,
0x6E,0x00,0x4F,0x67,0x72,0x65,0x2D,0x4D,0x61,0x67,0x65,0x00,0x44,0x77,0x61,0x72,
0x76,0x65,0x6E,0x20,0x44,0x65,0x6D,0x6F,0x6C,0x69,0x74,0x69,0x6F,0x6E,0x20,0x53,
0x71,0x75,0x61,0x64,0x00,0x47,0x6F,0x62,0x6C,0x69,0x6E,0x20,0x53,0x61,0x70,0x70,
0x65,0x72,0x73,0x00,0x41,0x74,0x74,0x61,0x63,0x6B,0x20,0x50,0x65,0x61,0x73,0x61,
0x6E,0x74,0x00,0x41,0x74,0x74,0x61,0x63,0x6B,0x20,0x50,0x65,0x6F,0x6E,0x00,0x52,
0x61,0x6E,0x67,0x65,0x72,0x00,0x42,0x65,0x72,0x73,0x65,0x72,0x6B,0x65,0x72,0x00,
0x41,0x6C,0x6C,0x65,0x72,0x69,0x61,0x00,0x54,0x65,0x72,0x6F,0x6E,0x20,0x47,0x6F,
0x72,0x65,0x66,0x69,0x65,0x6E,0x64,0x00,0x4B,0x75,0x72,0x64,0x72,0x61,0x6E,0x20,
0x61,0x6E,0x64,0x20,0x53,0x6B,0x79,0x27,0x72,0x65,0x65,0x00,0x44,0x65,0x6E,0x74,
0x61,0x72,0x67,0x00,0x4B,0x68,0x61,0x64,0x67,0x61,0x72,0x00,0x47,0x72,0x6F,0x6D,
0x20,0x48,0x65,0x6C,0x6C,0x73,0x63,0x72,0x65,0x61,0x6D,0x00,0x48,0x75,0x6D,0x61,
0x6E,0x20,0x4F,0x69,0x6C,0x20,0x54,0x61,0x6E,0x6B,0x65,0x72,0x00,0x4F,0x72,0x63,
0x20,0x4F,0x69,0x6C,0x20,0x54,0x61,0x6E,0x6B,0x65,0x72,0x00,0x48,0x75,0x6D,0x61,
0x6E,0x20,0x54,0x72,0x61,0x6E,0x73,0x70,0x6F,0x72,0x74,0x00,0x4F,0x72,0x63,0x20,
0x54,0x72,0x61,0x6E,0x73,0x70,0x6F,0x72,0x74,0x00,0x45,0x6C,0x76,0x65,0x6E,0x20,
0x44,0x65,0x73,0x74,0x72,0x6F,0x79,0x65,0x72,0x00,0x54,0x72,0x6F,0x6C,0x6C,0x20,
0x44,0x65,0x73,0x74,0x72,0x6F,0x79,0x65,0x72,0x00,0x42,0x61,0x74,0x74,0x6C,0x65,
0x73,0x68,0x69,0x70,0x00,0x4F,0x67,0x72,0x65,0x20,0x4A,0x75,0x67,0x67,0x65,0x72,
0x6E,0x61,0x75,0x67,0x68,0x74,0x00,0x00,0x44,0x65,0x61,0x74,0x68,0x77,0x69,0x6E,
0x67,0x00,0x00,0x00,0x47,0x6E,0x6F,0x6D,0x69,0x73,0x68,0x20,0x53,0x75,0x62,0x6D,
0x61,0x72,0x69,0x6E,0x65,0x00,0x47,0x69,0x61,0x6E,0x74,0x20,0x54,0x75,0x72,0x74,
0x6C,0x65,0x00,0x47,0x6E,0x6F,0x6D,0x69,0x73,0x68,0x20,0x46,0x6C,0x79,0x69,0x6E,
0x67,0x20,0x4D,0x61,0x63,0x68,0x69,0x6E,0x65,0x00,0x47,0x6F,0x62,0x6C,0x69,0x6E,
0x20,0x5A,0x65,0x70,0x70,0x65,0x6C,0x69,0x6E,0x00,0x47,0x72,0x79,0x70,0x68,0x6F,
0x6E,0x20,0x52,0x69,0x64,0x65,0x72,0x00,0x44,0x72,0x61,0x67,0x6F,0x6E,0x00,0x54,
0x75,0x72,0x61,0x6C,0x79,0x6F,0x6E,0x00,0x45,0x79,0x65,0x20,0x6F,0x66,0x20,0x4B,
0x69,0x6C,0x72,0x6F,0x67,0x67,0x00,0x44,0x61,0x6E,0x61,0x74,0x68,0x00,0x4B,0x6F,
0x72,0x67,0x61,0x74,0x68,0x20,0x42,0x6C,0x61,0x64,0x65,0x66,0x69,0x73,0x74,0x00,
0x00,0x43,0x68,0x6F,0x27,0x67,0x61,0x6C,0x6C,0x00,0x4C,0x6F,0x74,0x68,0x61,0x72,
0x00,0x47,0x75,0x6C,0x27,0x64,0x61,0x6E,0x00,0x55,0x74,0x68,0x65,0x72,0x20,0x4C,
0x69,0x67,0x68,0x74,0x62,0x72,0x69,0x6E,0x67,0x65,0x72,0x00,0x5A,0x75,0x6C,0x6A,
0x69,0x6E,0x00,0x00,0x53,0x6B,0x65,0x6C,0x65,0x74,0x6F,0x6E,0x00,0x44,0x61,0x65,
0x6D,0x6F,0x6E,0x00,0x43,0x72,0x69,0x74,0x74,0x65,0x72,0x00,0x46,0x61,0x72,0x6D,
0x00,0x50,0x69,0x67,0x20,0x46,0x61,0x72,0x6D,0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x42,0x61,0x72,0x72,0x61,0x63,0x6B,0x73,0x00,0x4F,0x72,0x63,0x20,0x42,0x61,0x72,
0x72,0x61,0x63,0x6B,0x73,0x00,0x43,0x68,0x75,0x72,0x63,0x68,0x00,0x41,0x6C,0x74,
0x61,0x72,0x20,0x6F,0x66,0x20,0x53,0x74,0x6F,0x72,0x6D,0x73,0x00,0x53,0x63,0x6F,
0x75,0x74,0x20,0x54,0x6F,0x77,0x65,0x72,0x00,0x57,0x61,0x74,0x63,0x68,0x20,0x54,
0x6F,0x77,0x65,0x72,0x00,0x53,0x74,0x61,0x62,0x6C,0x65,0x73,0x00,0x4F,0x67,0x72,
0x65,0x20,0x4D,0x6F,0x75,0x6E,0x64,0x00,0x47,0x6E,0x6F,0x6D,0x69,0x73,0x68,0x20,
0x49,0x6E,0x76,0x65,0x6E,0x74,0x6F,0x72,0x00,0x47,0x6F,0x62,0x6C,0x69,0x6E,0x20,
0x41,0x6C,0x63,0x68,0x65,0x6D,0x69,0x73,0x74,0x00,0x47,0x72,0x79,0x70,0x68,0x6F,
0x6E,0x20,0x41,0x76,0x69,0x61,0x72,0x79,0x00,0x44,0x72,0x61,0x67,0x6F,0x6E,0x20,
0x52,0x6F,0x6F,0x73,0x74,0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,0x53,0x68,0x69,0x70,
0x79,0x61,0x72,0x64,0x00,0x4F,0x72,0x63,0x20,0x53,0x68,0x69,0x70,0x79,0x61,0x72,
0x64,0x00,0x54,0x6F,0x77,0x6E,0x20,0x48,0x61,0x6C,0x6C,0x00,0x47,0x72,0x65,0x61,
0x74,0x20,0x48,0x61,0x6C,0x6C,0x00,0x45,0x6C,0x76,0x65,0x6E,0x20,0x4C,0x75,0x6D,
0x62,0x65,0x72,0x20,0x4D,0x69,0x6C,0x6C,0x00,0x54,0x72,0x6F,0x6C,0x6C,0x20,0x4C,
0x75,0x6D,0x62,0x65,0x72,0x20,0x4D,0x69,0x6C,0x6C,0x00,0x48,0x75,0x6D,0x61,0x6E,
0x20,0x46,0x6F,0x75,0x6E,0x64,0x72,0x79,0x00,0x4F,0x72,0x63,0x20,0x46,0x6F,0x75,
0x6E,0x64,0x72,0x79,0x00,0x4D,0x61,0x67,0x65,0x20,0x54,0x6F,0x77,0x65,0x72,0x00,
0x54,0x65,0x6D,0x70,0x6C,0x65,0x20,0x6F,0x66,0x20,0x74,0x68,0x65,0x20,0x44,0x61,
0x6D,0x6E,0x65,0x64,0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,0x42,0x6C,0x61,0x63,0x6B,
0x73,0x6D,0x69,0x74,0x68,0x00,0x4F,0x72,0x63,0x20,0x42,0x6C,0x61,0x63,0x6B,0x73,
0x6D,0x69,0x74,0x68,0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,0x52,0x65,0x66,0x69,0x6E,
0x65,0x72,0x79,0x00,0x4F,0x72,0x63,0x20,0x52,0x65,0x66,0x69,0x6E,0x65,0x72,0x79,
0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,0x4F,0x69,0x6C,0x20,0x50,0x6C,0x61,0x74,0x66,
0x6F,0x72,0x6D,0x00,0x4F,0x72,0x63,0x20,0x4F,0x69,0x6C,0x20,0x50,0x6C,0x61,0x74,
0x66,0x6F,0x72,0x6D,0x00,0x4B,0x65,0x65,0x70,0x00,0x53,0x74,0x72,0x6F,0x6E,0x67,
0x68,0x6F,0x6C,0x64,0x00,0x43,0x61,0x73,0x74,0x6C,0x65,0x00,0x46,0x6F,0x72,0x74,
0x72,0x65,0x73,0x73,0x00,0x47,0x6F,0x6C,0x64,0x20,0x4D,0x69,0x6E,0x65,0x00,0x4F,
0x69,0x6C,0x20,0x50,0x61,0x74,0x63,0x68,0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,0x53,
0x74,0x61,0x72,0x74,0x20,0x4C,0x6F,0x63,0x61,0x74,0x69,0x6F,0x6E,0x00,0x4F,0x72,
0x63,0x20,0x53,0x74,0x61,0x72,0x74,0x20,0x4C,0x6F,0x63,0x61,0x74,0x69,0x6F,0x6E,
0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,0x47,0x75,0x61,0x72,0x64,0x20,0x54,0x6F,0x77,
0x65,0x72,0x00,0x4F,0x72,0x63,0x20,0x47,0x75,0x61,0x72,0x64,0x20,0x54,0x6F,0x77,
0x65,0x72,0x00,0x48,0x75,0x6D,0x61,0x6E,0x20,0x43,0x61,0x6E,0x6E,0x6F,0x6E,0x20,
0x54,0x6F,0x77,0x65,0x72,0x00,0x4F,0x72,0x63,0x20,0x43,0x61,0x6E,0x6E,0x6F,0x6E,
0x20,0x54,0x6F,0x77,0x65,0x72,0x00,0x43,0x69,0x72,0x63,0x6C,0x65,0x20,0x6F,0x66,
0x20,0x50,0x6F,0x77,0x65,0x72,0x00,0x44,0x61,0x72,0x6B,0x20,0x50,0x6F,0x72,0x74,
0x61,0x6C,0x00,0x52,0x75,0x6E,0x65,0x73,0x74,0x6F,0x6E,0x65,0x00,0x57,0x61,0x6C,
0x6C,0x00,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x53,0x77,0x6F,0x72,0x64,
0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,0x20,0x31,0x00,0x55,0x70,0x67,0x72,
0x61,0x64,0x65,0x0A,0x53,0x77,0x6F,0x72,0x64,0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,
0x74,0x68,0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x41,0x78,0x65,
0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,0x20,0x31,0x00,0x55,0x70,0x67,0x72,
0x61,0x64,0x65,0x0A,0x41,0x78,0x65,0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,
0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x41,0x72,0x72,0x6F,0x77,
0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,0x20,0x31,0x00,0x55,0x70,0x67,0x72,
0x61,0x64,0x65,0x0A,0x41,0x72,0x72,0x6F,0x77,0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,
0x74,0x68,0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x53,0x70,0x65,
0x61,0x72,0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,0x20,0x31,0x00,0x55,0x70,
0x67,0x72,0x61,0x64,0x65,0x0A,0x53,0x70,0x65,0x61,0x72,0x0A,0x53,0x74,0x72,0x65,
0x6E,0x67,0x74,0x68,0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x48,
0x75,0x6D,0x61,0x6E,0x20,0x53,0x68,0x69,0x65,0x6C,0x64,0x0A,0x53,0x74,0x72,0x65,
0x6E,0x67,0x74,0x68,0x20,0x31,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x48,
0x75,0x6D,0x61,0x6E,0x20,0x53,0x68,0x69,0x65,0x6C,0x64,0x0A,0x53,0x74,0x72,0x65,
0x6E,0x67,0x74,0x68,0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x4F,
0x72,0x63,0x20,0x53,0x68,0x69,0x65,0x6C,0x64,0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,
0x74,0x68,0x20,0x31,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x4F,0x72,0x63,
0x20,0x53,0x68,0x69,0x65,0x6C,0x64,0x0A,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,
0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x48,0x75,0x6D,0x61,0x6E,
0x20,0x53,0x68,0x69,0x70,0x0A,0x41,0x74,0x74,0x61,0x63,0x6B,0x20,0x31,0x00,0x55,
0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x48,0x75,0x6D,0x61,0x6E,0x20,0x53,0x68,0x69,
0x70,0x0A,0x41,0x74,0x74,0x61,0x63,0x6B,0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,
0x64,0x65,0x0A,0x4F,0x72,0x63,0x20,0x53,0x68,0x69,0x70,0x0A,0x41,0x74,0x74,0x61,
0x63,0x6B,0x20,0x31,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x4F,0x72,0x63,
0x20,0x53,0x68,0x69,0x70,0x0A,0x41,0x74,0x74,0x61,0x63,0x6B,0x20,0x32,0x00,0x55,
0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x48,0x75,0x6D,0x61,0x6E,0x20,0x53,0x68,0x69,
0x70,0x0A,0x41,0x72,0x6D,0x6F,0x72,0x20,0x31,0x00,0x55,0x70,0x67,0x72,0x61,0x64,
0x65,0x0A,0x48,0x75,0x6D,0x61,0x6E,0x20,0x53,0x68,0x69,0x70,0x0A,0x41,0x72,0x6D,
0x6F,0x72,0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x4F,0x72,0x63,
0x20,0x53,0x68,0x69,0x70,0x0A,0x41,0x72,0x6D,0x6F,0x72,0x20,0x31,0x00,0x55,0x70,
0x67,0x72,0x61,0x64,0x65,0x0A,0x4F,0x72,0x63,0x20,0x53,0x68,0x69,0x70,0x0A,0x41,
0x72,0x6D,0x6F,0x72,0x20,0x32,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x43,
0x61,0x74,0x61,0x70,0x75,0x6C,0x74,0x20,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,
0x20,0x31,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x43,0x61,0x74,0x61,0x70,
0x75,0x6C,0x74,0x20,0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,0x20,0x32,0x00,0x55,
0x70,0x67,0x72,0x61,0x64,0x65,0x0A,0x42,0x61,0x6C,0x6C,0x69,0x73,0x74,0x61,0x20,
0x53,0x74,0x72,0x65,0x6E,0x67,0x74,0x68,0x20,0x31,0x00,0x55,0x70,0x67,0x72,0x61,
0x64,0x65,0x0A,0x42,0x61,0x6C,0x6C,0x69,0x73,0x74,0x61,0x20,0x53,0x74,0x72,0x65,
0x6E,0x67,0x74,0x68,0x20,0x32,0x00,0x45,0x6C,0x76,0x65,0x6E,0x20,0x52,0x61,0x6E,
0x67,0x65,0x72,0x20,0x54,0x72,0x61,0x69,0x6E,0x69,0x6E,0x67,0x00,0x52,0x65,0x73,
0x65,0x61,0x72,0x63,0x68,0x20,0x4C,0x6F,0x6E,0x67,0x62,0x6F,0x77,0x00,0x52,0x61,
0x6E,0x67,0x65,0x72,0x20,0x53,0x63,0x6F,0x75,0x74,0x69,0x6E,0x67,0x00,0x52,0x61,
0x6E,0x67,0x65,0x72,0x20,0x4D,0x61,0x72,0x6B,0x73,0x6D,0x61,0x6E,0x73,0x68,0x69,
0x70,0x00,0x54,0x72,0x6F,0x6C,0x6C,0x20,0x42,0x65,0x72,0x73,0x65,0x72,0x6B,0x65,
0x72,0x20,0x54,0x72,0x61,0x69,0x6E,0x69,0x6E,0x67,0x00,0x52,0x65,0x73,0x65,0x61,
0x72,0x63,0x68,0x20,0x4C,0x69,0x67,0x68,0x74,0x65,0x72,0x20,0x41,0x78,0x65,0x73,
0x00,0x42,0x65,0x72,0x73,0x65,0x72,0x6B,0x65,0x72,0x20,0x53,0x63,0x6F,0x75,0x74,
0x69,0x6E,0x67,0x00,0x42,0x65,0x72,0x73,0x65,0x72,0x6B,0x65,0x72,0x20,0x52,0x65,
0x67,0x65,0x6E,0x65,0x72,0x61,0x74,0x69,0x6F,0x6E,0x00,0x55,0x70,0x67,0x72,0x61,
0x64,0x65,0x20,0x4F,0x67,0x72,0x65,0x73,0x20,0x74,0x6F,0x20,0x4F,0x67,0x72,0x65,
0x2D,0x4D,0x61,0x67,0x65,0x73,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x65,0x20,0x4B,
0x6E,0x69,0x67,0x68,0x74,0x73,0x20,0x74,0x6F,0x20,0x50,0x61,0x6C,0x61,0x64,0x69,
0x6E,0x73,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x48,0x6F,0x6C,0x79,0x20,
0x56,0x69,0x73,0x69,0x6F,0x6E,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x48,
0x65,0x61,0x6C,0x69,0x6E,0x67,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x45,
0x78,0x6F,0x72,0x63,0x69,0x73,0x6D,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,
0x46,0x6C,0x61,0x6D,0x65,0x20,0x53,0x68,0x69,0x65,0x6C,0x64,0x00,0x53,0x70,0x65,
0x6C,0x6C,0x20,0x2D,0x0A,0x46,0x69,0x72,0x65,0x62,0x61,0x6C,0x6C,0x00,0x53,0x70,
0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x53,0x6C,0x6F,0x77,0x00,0x53,0x70,0x65,0x6C,0x6C,
0x20,0x2D,0x0A,0x49,0x6E,0x76,0x69,0x73,0x69,0x62,0x69,0x6C,0x69,0x74,0x79,0x00,
0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x50,0x6F,0x6C,0x79,0x6D,0x6F,0x72,0x70,
0x68,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x42,0x6C,0x69,0x7A,0x7A,0x61,
0x72,0x64,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x45,0x79,0x65,0x20,0x6F,
0x66,0x20,0x4B,0x69,0x6C,0x72,0x6F,0x67,0x67,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,
0x2D,0x0A,0x42,0x6C,0x6F,0x6F,0x64,0x6C,0x75,0x73,0x74,0x00,0x53,0x70,0x65,0x6C,
0x6C,0x20,0x2D,0x0A,0x52,0x61,0x69,0x73,0x65,0x20,0x44,0x65,0x61,0x64,0x00,0x53,
0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x44,0x65,0x61,0x74,0x68,0x20,0x43,0x6F,0x69,
0x6C,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x57,0x68,0x69,0x72,0x6C,0x77,
0x69,0x6E,0x64,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x48,0x61,0x73,0x74,
0x65,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x55,0x6E,0x68,0x6F,0x6C,0x79,
0x20,0x41,0x72,0x6D,0x6F,0x72,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x52,
0x75,0x6E,0x65,0x73,0x00,0x53,0x70,0x65,0x6C,0x6C,0x20,0x2D,0x0A,0x44,0x65,0x61,
0x74,0x68,0x20,0x61,0x6E,0x64,0x20,0x44,0x65,0x63,0x61,0x79,0x00,0x00,0x4C,0x61,
0x6E,0x64,0x20,0x41,0x74,0x74,0x61,0x63,0x6B,0x00,0x50,0x61,0x73,0x73,0x69,0x76,
0x65,0x00,0x5F,0x4F,0x72,0x63,0x20,0x33,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x34,0x00,0x5F,0x4F,0x72,0x63,0x20,0x34,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x35,0x00,0x5F,0x4F,0x72,0x63,0x20,0x35,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x36,0x00,0x5F,0x4F,0x72,0x63,0x20,0x36,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x37,0x00,0x5F,0x4F,0x72,0x63,0x20,0x37,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x38,0x00,0x5F,0x4F,0x72,0x63,0x20,0x38,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x39,0x00,0x5F,0x4F,0x72,0x63,0x20,0x39,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x31,0x30,0x00,0x5F,0x4F,0x72,0x63,0x20,0x31,0x30,0x00,0x5F,0x48,0x75,0x6D,0x61,
0x6E,0x20,0x31,0x31,0x00,0x5F,0x4F,0x72,0x63,0x20,0x31,0x31,0x00,0x5F,0x48,0x75,
0x6D,0x61,0x6E,0x20,0x31,0x32,0x00,0x5F,0x4F,0x72,0x63,0x20,0x31,0x32,0x00,0x5F,
0x48,0x75,0x6D,0x61,0x6E,0x20,0x31,0x33,0x00,0x5F,0x4F,0x72,0x63,0x20,0x31,0x33,
0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,0x31,0x34,0x20,0x28,0x4F,0x72,0x61,0x6E,
0x67,0x65,0x29,0x00,0x5F,0x4F,0x72,0x63,0x20,0x31,0x34,0x20,0x28,0x42,0x6C,0x75,
0x65,0x29,0x00,0x53,0x65,0x61,0x20,0x41,0x74,0x74,0x61,0x63,0x6B,0x00,0x41,0x69,
0x72,0x20,0x41,0x74,0x74,0x61,0x63,0x6B,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x31,0x34,0x20,0x28,0x52,0x65,0x64,0x29,0x00,0x5F,0x48,0x75,0x6D,0x61,0x6E,0x20,
0x31,0x34,0x20,0x28,0x57,0x68,0x69,0x74,0x65,0x29,0x00,0x5F,0x48,0x75,0x6D,0x61,
0x6E,0x20,0x31,0x34,0x20,0x28,0x42,0x6C,0x61,0x63,0x6B,0x29,0x00,0x5F,0x4F,0x72,
0x63,0x20,0x31,0x34,0x20,0x28,0x47,0x72,0x65,0x65,0x6E,0x29,0x00,0x5F,0x4F,0x72,
0x63,0x20,0x31,0x34,0x20,0x28,0x57,0x68,0x69,0x74,0x65,0x29,0x00,0x5F,0x4F,0x72,
0x63,0x20,0x45,0x78,0x70,0x2E,0x20,0x34,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,
0x70,0x2E,0x20,0x35,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x20,0x37,
0x61,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x20,0x39,0x00,0x5F,0x4F,
0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x20,0x31,0x30,0x00,0x5F,0x4F,0x72,0x63,0x20,
0x45,0x78,0x70,0x2E,0x20,0x31,0x32,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,
0x2E,0x20,0x36,0x61,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x20,0x36,
0x62,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x20,0x31,0x31,0x61,0x00,
0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x20,0x31,0x31,0x62,0x00,0x5F,0x48,
0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x32,0x61,0x20,0x28,0x52,0x65,0x64,0x29,
0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x32,0x62,0x20,0x28,0x42,
0x6C,0x61,0x63,0x6B,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,
0x32,0x63,0x20,0x28,0x59,0x65,0x6C,0x6C,0x6F,0x77,0x29,0x00,0x5F,0x48,0x75,0x6D,
0x20,0x45,0x78,0x70,0x2E,0x20,0x33,0x61,0x20,0x28,0x4F,0x72,0x61,0x6E,0x67,0x65,
0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x33,0x62,0x20,0x28,
0x52,0x65,0x64,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x33,
0x63,0x20,0x28,0x56,0x69,0x6F,0x6C,0x65,0x74,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,
0x45,0x78,0x70,0x2E,0x20,0x34,0x61,0x20,0x28,0x42,0x6C,0x61,0x63,0x6B,0x29,0x00,
0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x34,0x62,0x20,0x28,0x52,0x65,
0x64,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x34,0x63,0x20,
0x28,0x57,0x68,0x69,0x74,0x65,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,
0x2E,0x20,0x35,0x61,0x20,0x28,0x47,0x72,0x65,0x65,0x6E,0x29,0x00,0x5F,0x48,0x75,
0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x35,0x62,0x20,0x28,0x4F,0x72,0x61,0x6E,0x67,
0x65,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x35,0x63,0x20,
0x28,0x56,0x69,0x6F,0x6C,0x65,0x74,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,
0x70,0x2E,0x20,0x35,0x64,0x20,0x28,0x59,0x65,0x6C,0x6C,0x6F,0x77,0x29,0x00,0x5F,
0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x36,0x61,0x20,0x28,0x47,0x72,0x65,
0x65,0x6E,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x36,0x62,
0x20,0x28,0x42,0x6C,0x61,0x63,0x6B,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,
0x70,0x2E,0x20,0x36,0x63,0x20,0x28,0x4F,0x72,0x61,0x6E,0x67,0x65,0x29,0x00,0x5F,
0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x36,0x64,0x20,0x28,0x52,0x65,0x64,
0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x38,0x61,0x20,0x28,
0x57,0x68,0x69,0x74,0x65,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,
0x20,0x38,0x62,0x20,0x28,0x59,0x65,0x6C,0x6C,0x6F,0x77,0x29,0x00,0x5F,0x48,0x75,
0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x38,0x63,0x20,0x28,0x56,0x69,0x6F,0x6C,0x65,
0x74,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x39,0x61,0x20,
0x28,0x42,0x6C,0x61,0x63,0x6B,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,
0x2E,0x20,0x39,0x62,0x20,0x28,0x52,0x65,0x64,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,
0x45,0x78,0x70,0x2E,0x20,0x39,0x63,0x20,0x28,0x47,0x72,0x65,0x65,0x6E,0x29,0x00,
0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x20,0x39,0x64,0x20,0x28,0x57,0x68,
0x69,0x74,0x65,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x31,0x30,
0x61,0x20,0x28,0x56,0x69,0x6F,0x6C,0x65,0x74,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,
0x45,0x78,0x70,0x2E,0x31,0x30,0x62,0x20,0x28,0x47,0x72,0x65,0x65,0x6E,0x29,0x00,
0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x31,0x30,0x63,0x20,0x28,0x42,0x6C,
0x61,0x63,0x6B,0x29,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x31,0x31,
0x61,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x31,0x31,0x62,0x00,0x5F,
0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x31,0x32,0x61,0x00,0x5F,0x4F,0x72,0x63,
0x20,0x45,0x78,0x70,0x2E,0x35,0x62,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,
0x2E,0x37,0x61,0x00,0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x37,0x62,0x00,
0x5F,0x48,0x75,0x6D,0x20,0x45,0x78,0x70,0x2E,0x37,0x63,0x00,0x5F,0x4F,0x72,0x63,
0x20,0x45,0x78,0x70,0x2E,0x31,0x32,0x61,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,
0x70,0x2E,0x31,0x32,0x62,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x31,
0x32,0x63,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x31,0x32,0x64,0x00,
0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,0x32,0x00,0x5F,0x4F,0x72,0x63,0x20,
0x45,0x78,0x70,0x2E,0x37,0x62,0x00,0x5F,0x4F,0x72,0x63,0x20,0x45,0x78,0x70,0x2E,
0x33,0x00,0x00,0x44,0x77,0x61,0x72,0x76,0x65,0x6E,0x20,0x44,0x65,0x6D,0x6F,0x20,
0x53,0x71,0x75,0x61,0x64,0x00,0x4F,0x69,0x6C,0x20,0x54,0x61,0x6E,0x6B,0x65,0x72,
0x00,0x4F,0x69,0x6C,0x20,0x54,0x61,0x6E,0x6B,0x65,0x72,0x00,0x54,0x72,0x61,0x6E,
0x73,0x70,0x6F,0x72,0x74,0x00,0x54,0x72,0x61,0x6E,0x73,0x70,0x6F,0x72,0x74,0x00,
0x42,0x61,0x72,0x72,0x61,0x63,0x6B,0x73,0x00,0x42,0x61,0x72,0x72,0x61,0x63,0x6B,
0x73,0x00,0x53,0x68,0x69,0x70,0x79,0x61,0x72,0x64,0x00,0x53,0x68,0x69,0x70,0x79,
0x61,0x72,0x64,0x00,0x46,0x6F,0x75,0x6E,0x64,0x72,0x79,0x00,0x46,0x6F,0x75,0x6E,
0x64,0x72,0x79,0x00,0x42,0x6C,0x61,0x63,0x6B,0x73,0x6D,0x69,0x74,0x68,0x00,0x42,
0x6C,0x61,0x63,0x6B,0x73,0x6D,0x69,0x74,0x68,0x00,0x52,0x65,0x66,0x69,0x6E,0x65,
0x72,0x79,0x00,0x52,0x65,0x66,0x69,0x6E,0x65,0x72,0x79,0x00,0x4F,0x69,0x6C,0x20,
0x50,0x6C,0x61,0x74,0x66,0x6F,0x72,0x6D,0x00,0x4F,0x69,0x6C,0x20,0x50,0x6C,0x61,
0x74,0x66,0x6F,0x72,0x6D,0x00,0x4D,0x61,0x67,0x65,0x20,0x54,0x6F,0x77,0x65,0x72,
0x00,0x54,0x65,0x6D,0x70,0x6C,0x65,0x20,0x6F,0x66,0x20,0x74,0x68,0x65,0x20,0x44,
0x61,0x6D,0x6E,0x65,0x64,0x00,0x47,0x75,0x61,0x72,0x64,0x20,0x54,0x6F,0x77,0x65,
0x72,0x00,0x47,0x75,0x61,0x72,0x64,0x20,0x54,0x6F,0x77,0x65,0x72,0x00,0x43,0x61,
0x6E,0x6E,0x6F,0x6E,0x20,0x54,0x6F,0x77,0x65,0x72,0x00,0x43,0x61,0x6E,0x6E,0x6F,
0x6E,0x20,0x54,0x6F,0x77,0x65,0x72,0x00,0x45,0x79,0x65,0x20,0x6F,0x66,0x20,0x4B,
0x69,0x6C,0x72,0x6F,0x67,0x67,0x00,0x45,0x53,0x43,0x00,0x70,0x01,0x54,0x52,0x41,
0x49,0x4E,0x20,0x04,0x50,0x01,0x45,0x4F,0x4E,0x00,0x70,0x01,0x54,0x52,0x41,0x49,
0x4E,0x20,0x04,0x50,0x01,0x45,0x41,0x53,0x41,0x4E,0x54,0x00,0x61,0x01,0x54,0x52,
0x41,0x49,0x4E,0x20,0x04,0x41,0x01,0x58,0x45,0x54,0x48,0x52,0x4F,0x57,0x45,0x52,
0x00,0x61,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,0x41,0x01,0x52,0x43,0x48,0x45,
0x52,0x00,0x61,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x52,0x04,0x41,0x01,0x4E,0x47,
0x45,0x52,0x00,0x61,0x01,0x54,0x52,0x04,0x41,0x01,0x49,0x4E,0x20,0x42,0x45,0x52,
0x53,0x45,0x52,0x4B,0x45,0x52,0x00,0x6B,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,
0x4B,0x01,0x4E,0x49,0x47,0x48,0x54,0x00,0x6F,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,
0x54,0x57,0x4F,0x2D,0x48,0x45,0x41,0x44,0x45,0x44,0x20,0x04,0x4F,0x01,0x47,0x52,
0x45,0x00,0x70,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,0x50,0x01,0x41,0x4C,0x41,
0x44,0x49,0x4E,0x00,0x6F,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,0x4F,0x01,0x47,
0x52,0x45,0x2D,0x4D,0x41,0x47,0x45,0x00,0x74,0x01,0x04,0x54,0x01,0x52,0x41,0x49,
0x4E,0x20,0x44,0x45,0x41,0x54,0x48,0x20,0x4B,0x4E,0x49,0x47,0x48,0x54,0x00,0x74,
0x01,0x04,0x54,0x01,0x52,0x41,0x49,0x4E,0x20,0x43,0x4C,0x45,0x52,0x49,0x43,0x00,
0x74,0x01,0x04,0x54,0x01,0x52,0x41,0x49,0x4E,0x20,0x4D,0x41,0x47,0x45,0x00,0x67,
0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,0x47,0x01,0x52,0x55,0x4E,0x54,0x00,0x66,
0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,0x46,0x01,0x4F,0x4F,0x54,0x4D,0x41,0x4E,
0x00,0x62,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x42,0x01,0x41,0x4C,0x4C,0x49,
0x53,0x54,0x41,0x00,0x63,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x43,0x01,0x41,
0x54,0x41,0x50,0x55,0x4C,0x54,0x00,0x6F,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,
0x4F,0x01,0x49,0x4C,0x20,0x54,0x41,0x4E,0x4B,0x45,0x52,0x00,0x64,0x01,0x42,0x55,
0x49,0x4C,0x44,0x20,0x04,0x44,0x01,0x45,0x53,0x54,0x52,0x4F,0x59,0x45,0x52,0x00,
0x74,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x54,0x01,0x52,0x41,0x4E,0x53,0x50,
0x4F,0x52,0x54,0x00,0x62,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x42,0x01,0x41,
0x54,0x54,0x4C,0x45,0x53,0x48,0x49,0x50,0x00,0x6A,0x01,0x42,0x55,0x49,0x4C,0x44,
0x20,0x04,0x4A,0x01,0x55,0x47,0x47,0x45,0x52,0x4E,0x41,0x55,0x47,0x48,0x54,0x00,
0x73,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x47,0x4E,0x4F,0x4D,0x49,0x53,0x48,0x20,
0x04,0x53,0x01,0x55,0x42,0x4D,0x41,0x52,0x49,0x4E,0x45,0x00,0x67,0x01,0x54,0x52,
0x41,0x49,0x4E,0x20,0x04,0x47,0x01,0x49,0x41,0x4E,0x54,0x20,0x54,0x55,0x52,0x54,
0x4C,0x45,0x00,0x7A,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x47,0x4F,0x42,0x4C,0x49,
0x4E,0x20,0x04,0x5A,0x01,0x45,0x50,0x50,0x45,0x4C,0x49,0x4E,0x00,0x66,0x01,0x42,
0x55,0x49,0x4C,0x44,0x20,0x04,0x46,0x01,0x4C,0x59,0x49,0x4E,0x47,0x20,0x4D,0x41,
0x43,0x48,0x49,0x4E,0x45,0x00,0x67,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,0x47,
0x01,0x52,0x59,0x50,0x48,0x4F,0x4E,0x20,0x52,0x49,0x44,0x45,0x52,0x00,0x64,0x01,
0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x44,0x01,0x52,0x41,0x47,0x4F,0x4E,0x00,0x64,
0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x04,0x44,0x01,0x57,0x41,0x52,0x56,0x45,0x4E,
0x20,0x44,0x45,0x4D,0x4F,0x4C,0x49,0x54,0x49,0x4F,0x4E,0x20,0x53,0x51,0x55,0x41,
0x44,0x00,0x73,0x01,0x54,0x52,0x41,0x49,0x4E,0x20,0x47,0x4F,0x42,0x4C,0x49,0x4E,
0x20,0x04,0x53,0x01,0x41,0x50,0x50,0x45,0x52,0x53,0x00,0x62,0x01,0x42,0x55,0x49,
0x4C,0x44,0x20,0x04,0x42,0x01,0x41,0x52,0x52,0x41,0x43,0x4B,0x53,0x00,0x6C,0x01,
0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x4C,0x01,0x55,0x4D,0x42,0x45,0x52,0x20,0x4D,
0x49,0x4C,0x4C,0x00,0x61,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x53,0x54,0x04,0x41,
0x01,0x42,0x4C,0x45,0x53,0x00,0x6F,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x4F,
0x01,0x47,0x52,0x45,0x20,0x4D,0x4F,0x55,0x4E,0x44,0x00,0x74,0x01,0x42,0x55,0x49,
0x4C,0x44,0x20,0x04,0x54,0x01,0x4F,0x57,0x45,0x52,0x00,0x63,0x01,0x42,0x55,0x49,
0x4C,0x44,0x20,0x04,0x43,0x01,0x48,0x55,0x52,0x43,0x48,0x00,0x6C,0x01,0x42,0x55,
0x49,0x4C,0x44,0x20,0x41,0x04,0x4C,0x01,0x54,0x41,0x52,0x20,0x4F,0x46,0x20,0x53,
0x54,0x4F,0x52,0x4D,0x53,0x00,0x66,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x46,
0x01,0x41,0x52,0x4D,0x00,0x68,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x41,0x20,0x54,
0x4F,0x57,0x4E,0x20,0x04,0x48,0x01,0x41,0x4C,0x4C,0x00,0x68,0x01,0x42,0x55,0x49,
0x4C,0x44,0x20,0x41,0x20,0x47,0x52,0x45,0x41,0x54,0x20,0x04,0x48,0x01,0x41,0x4C,
0x4C,0x00,0x62,0x01,0x04,0x42,0x01,0x55,0x49,0x4C,0x44,0x20,0x4F,0x49,0x4C,0x20,
0x50,0x4C,0x41,0x54,0x46,0x4F,0x52,0x4D,0x00,0x72,0x01,0x42,0x55,0x49,0x4C,0x44,
0x20,0x4F,0x49,0x4C,0x20,0x04,0x52,0x01,0x45,0x46,0x49,0x4E,0x45,0x52,0x59,0x00,
0x66,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x46,0x01,0x4F,0x55,0x4E,0x44,0x52,
0x59,0x00,0x77,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x57,0x01,0x41,0x4C,0x4C,
0x00,0x73,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x53,0x01,0x48,0x49,0x50,0x59,
0x41,0x52,0x44,0x00,0x73,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x42,0x4C,0x41,0x43,
0x4B,0x04,0x53,0x01,0x4D,0x49,0x54,0x48,0x00,0x63,0x01,0x55,0x50,0x47,0x52,0x41,
0x44,0x45,0x20,0x54,0x4F,0x20,0x04,0x43,0x01,0x41,0x53,0x54,0x4C,0x45,0x00,0x66,
0x01,0x55,0x50,0x47,0x52,0x41,0x44,0x45,0x20,0x54,0x4F,0x20,0x04,0x46,0x01,0x4F,
0x52,0x54,0x52,0x45,0x53,0x53,0x00,0x6B,0x01,0x55,0x50,0x47,0x52,0x41,0x44,0x45,
0x20,0x54,0x4F,0x20,0x04,0x4B,0x01,0x45,0x45,0x50,0x00,0x73,0x01,0x55,0x50,0x47,
0x52,0x41,0x44,0x45,0x20,0x54,0x4F,0x20,0x04,0x53,0x01,0x54,0x52,0x4F,0x4E,0x47,
0x48,0x4F,0x4C,0x44,0x00,0x67,0x01,0x55,0x50,0x47,0x52,0x41,0x44,0x45,0x20,0x54,
0x4F,0x20,0x04,0x47,0x01,0x55,0x41,0x52,0x44,0x20,0x54,0x4F,0x57,0x45,0x52,0x00,
0x63,0x01,0x55,0x50,0x47,0x52,0x41,0x44,0x45,0x20,0x54,0x4F,0x20,0x04,0x43,0x01,
0x41,0x4E,0x4E,0x4F,0x4E,0x20,0x54,0x4F,0x57,0x45,0x52,0x00,0x69,0x01,0x42,0x55,
0x49,0x4C,0x44,0x20,0x47,0x4E,0x4F,0x4D,0x49,0x53,0x48,0x20,0x04,0x49,0x01,0x4E,
0x56,0x45,0x4E,0x54,0x4F,0x52,0x00,0x61,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x47,
0x4F,0x42,0x4C,0x49,0x4E,0x20,0x04,0x41,0x01,0x4C,0x43,0x48,0x45,0x4D,0x49,0x53,
0x54,0x00,0x67,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x47,0x01,0x52,0x59,0x50,
0x48,0x4F,0x4E,0x20,0x41,0x56,0x49,0x41,0x52,0x59,0x00,0x64,0x01,0x4D,0x41,0x4B,
0x45,0x20,0x04,0x44,0x01,0x52,0x41,0x47,0x4F,0x4E,0x20,0x52,0x4F,0x4F,0x53,0x54,
0x00,0x6D,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x4D,0x01,0x41,0x47,0x45,0x20,
0x54,0x4F,0x57,0x45,0x52,0x00,0x74,0x01,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x54,
0x01,0x45,0x4D,0x50,0x4C,0x45,0x20,0x4F,0x46,0x20,0x54,0x48,0x45,0x20,0x44,0x41,
0x4D,0x4E,0x45,0x44,0x00,0x62,0x02,0x04,0x42,0x01,0x52,0x45,0x45,0x44,0x20,0x46,
0x41,0x53,0x54,0x45,0x52,0x20,0x48,0x4F,0x52,0x53,0x45,0x53,0x00,0x62,0x02,0x04,
0x42,0x01,0x52,0x45,0x45,0x44,0x20,0x46,0x41,0x53,0x54,0x45,0x52,0x20,0x57,0x4F,
0x4C,0x56,0x45,0x53,0x00,0x77,0x02,0x55,0x50,0x47,0x52,0x41,0x44,0x45,0x20,0x53,
0x04,0x57,0x01,0x4F,0x52,0x44,0x53,0x20,0x28,0x44,0x61,0x6D,0x61,0x67,0x65,0x20,
0x2B,0x32,0x29,0x00,0x75,0x02,0x04,0x55,0x01,0x50,0x47,0x52,0x41,0x44,0x45,0x20,
0x54,0x48,0x52,0x4F,0x57,0x49,0x4E,0x47,0x20,0x41,0x58,0x45,0x53,0x20,0x28,0x44,
0x61,0x6D,0x61,0x67,0x65,0x20,0x2B,0x31,0x29,0x00,0x77,0x02,0x55,0x50,0x47,0x52,
0x41,0x44,0x45,0x20,0x04,0x57,0x01,0x45,0x41,0x50,0x4F,0x4E,0x53,0x20,0x28,0x44,
0x61,0x6D,0x61,0x67,0x65,0x20,0x2B,0x32,0x29,0x00,0x75,0x02,0x04,0x55,0x01,0x50,
0x47,0x52,0x41,0x44,0x45,0x20,0x41,0x52,0x52,0x4F,0x57,0x53,0x20,0x28,0x44,0x61,
0x6D,0x61,0x67,0x65,0x20,0x2B,0x31,0x29,0x00,0x68,0x02,0x55,0x50,0x47,0x52,0x41,
0x44,0x45,0x20,0x53,0x04,0x48,0x01,0x49,0x45,0x4C,0x44,0x53,0x20,0x28,0x41,0x72,
0x6D,0x6F,0x72,0x20,0x2B,0x32,0x29,0x00,0x68,0x02,0x55,0x50,0x47,0x52,0x41,0x44,
0x45,0x20,0x53,0x04,0x48,0x01,0x49,0x45,0x4C,0x44,0x53,0x20,0x28,0x41,0x72,0x6D,
0x6F,0x72,0x20,0x2B,0x32,0x29,0x00,0x63,0x02,0x55,0x50,0x47,0x52,0x41,0x44,0x45,
0x20,0x04,0x43,0x01,0x41,0x4E,0x4E,0x4F,0x4E,0x53,0x20,0x28,0x44,0x61,0x6D,0x61,
0x67,0x65,0x20,0x2B,0x35,0x29,0x00,0x61,0x02,0x55,0x50,0x47,0x52,0x41,0x44,0x45,
0x20,0x53,0x48,0x49,0x50,0x20,0x04,0x41,0x01,0x52,0x4D,0x4F,0x52,0x20,0x28,0x41,
0x72,0x6D,0x6F,0x72,0x20,0x2B,0x35,0x29,0x00,0x73,0x02,0x55,0x50,0x47,0x52,0x41,
0x44,0x45,0x20,0x53,0x48,0x49,0x50,0x20,0x04,0x53,0x01,0x50,0x45,0x45,0x44,0x00,
0x72,0x02,0x45,0x4C,0x56,0x45,0x4E,0x20,0x04,0x52,0x01,0x41,0x4E,0x47,0x45,0x52,
0x20,0x54,0x52,0x41,0x49,0x4E,0x49,0x4E,0x47,0x00,0x6C,0x02,0x52,0x45,0x53,0x45,
0x41,0x52,0x43,0x48,0x20,0x04,0x4C,0x01,0x4F,0x4E,0x47,0x42,0x4F,0x57,0x20,0x28,
0x52,0x61,0x6E,0x67,0x65,0x20,0x2B,0x31,0x29,0x00,0x73,0x02,0x52,0x41,0x4E,0x47,
0x45,0x52,0x20,0x04,0x53,0x01,0x43,0x4F,0x55,0x54,0x49,0x4E,0x47,0x20,0x28,0x53,
0x69,0x67,0x68,0x74,0x3A,0x39,0x29,0x00,0x6D,0x02,0x52,0x41,0x4E,0x47,0x45,0x52,
0x20,0x04,0x4D,0x01,0x41,0x52,0x4B,0x53,0x4D,0x41,0x4E,0x53,0x48,0x49,0x50,0x20,
0x28,0x44,0x61,0x6D,0x61,0x67,0x65,0x20,0x2B,0x33,0x29,0x00,0x62,0x02,0x54,0x52,
0x4F,0x4C,0x4C,0x20,0x04,0x42,0x01,0x45,0x52,0x53,0x45,0x52,0x4B,0x45,0x52,0x20,
0x54,0x52,0x41,0x49,0x4E,0x49,0x4E,0x47,0x00,0x61,0x02,0x52,0x45,0x53,0x45,0x41,
0x52,0x43,0x48,0x20,0x4C,0x49,0x47,0x48,0x54,0x45,0x52,0x20,0x04,0x41,0x01,0x58,
0x45,0x53,0x20,0x28,0x52,0x61,0x6E,0x67,0x65,0x20,0x2B,0x31,0x29,0x00,0x73,0x02,
0x42,0x45,0x52,0x53,0x45,0x52,0x4B,0x45,0x52,0x20,0x04,0x53,0x01,0x43,0x4F,0x55,
0x54,0x49,0x4E,0x47,0x20,0x28,0x53,0x69,0x67,0x68,0x74,0x3A,0x39,0x29,0x00,0x72,
0x02,0x42,0x45,0x52,0x53,0x45,0x52,0x4B,0x45,0x52,0x20,0x04,0x52,0x01,0x45,0x47,
0x45,0x4E,0x45,0x52,0x41,0x54,0x49,0x4F,0x4E,0x00,0x63,0x02,0x55,0x50,0x47,0x52,
0x41,0x44,0x45,0x20,0x04,0x43,0x01,0x41,0x54,0x41,0x50,0x55,0x4C,0x54,0x53,0x20,
0x28,0x44,0x61,0x6D,0x61,0x67,0x65,0x20,0x2B,0x31,0x35,0x29,0x00,0x62,0x02,0x55,
0x50,0x47,0x52,0x41,0x44,0x45,0x20,0x04,0x42,0x01,0x41,0x4C,0x4C,0x49,0x53,0x54,
0x41,0x53,0x20,0x28,0x44,0x61,0x6D,0x61,0x67,0x65,0x20,0x2B,0x31,0x35,0x29,0x00,
0x61,0x00,0x4C,0x49,0x47,0x48,0x54,0x4E,0x49,0x4E,0x47,0x20,0x04,0x41,0x01,0x54,
0x54,0x41,0x43,0x4B,0x00,0x66,0x03,0x04,0x46,0x01,0x49,0x52,0x45,0x42,0x41,0x4C,
0x4C,0x00,0x6C,0x03,0x46,0x04,0x4C,0x01,0x41,0x4D,0x45,0x20,0x53,0x48,0x49,0x45,
0x4C,0x44,0x00,0x6F,0x03,0x53,0x4C,0x04,0x4F,0x01,0x57,0x00,0x69,0x03,0x04,0x49,
0x01,0x4E,0x56,0x49,0x53,0x49,0x42,0x49,0x4C,0x49,0x54,0x59,0x00,0x70,0x03,0x04,
0x50,0x01,0x4F,0x4C,0x59,0x4D,0x4F,0x52,0x50,0x48,0x00,0x62,0x03,0x04,0x42,0x01,
0x4C,0x49,0x5A,0x5A,0x41,0x52,0x44,0x00,0x61,0x00,0x54,0x4F,0x55,0x43,0x48,0x20,
0x4F,0x46,0x20,0x44,0x04,0x41,0x01,0x52,0x4B,0x4E,0x45,0x53,0x53,0x00,0x64,0x03,
0x04,0x44,0x01,0x45,0x41,0x54,0x48,0x20,0x41,0x4E,0x44,0x20,0x44,0x45,0x43,0x41,
0x59,0x00,0x63,0x03,0x44,0x45,0x41,0x54,0x48,0x20,0x04,0x43,0x01,0x4F,0x49,0x4C,
0x00,0x68,0x03,0x04,0x48,0x01,0x41,0x53,0x54,0x45,0x00,0x75,0x03,0x04,0x55,0x01,
0x4E,0x48,0x4F,0x4C,0x59,0x20,0x41,0x52,0x4D,0x4F,0x52,0x00,0x72,0x03,0x04,0x52,
0x01,0x55,0x4E,0x45,0x53,0x00,0x77,0x03,0x04,0x57,0x01,0x48,0x49,0x52,0x4C,0x57,
0x49,0x4E,0x44,0x00,0x76,0x03,0x48,0x4F,0x4C,0x59,0x20,0x04,0x56,0x01,0x49,0x53,
0x49,0x4F,0x4E,0x00,0x68,0x03,0x04,0x48,0x01,0x45,0x41,0x4C,0x49,0x4E,0x47,0x20,
0x28,0x70,0x65,0x72,0x20,0x31,0x20,0x48,0x50,0x29,0x00,0x67,0x03,0x04,0x47,0x01,
0x52,0x45,0x41,0x54,0x45,0x52,0x20,0x48,0x45,0x41,0x4C,0x49,0x4E,0x47,0x00,0x65,
0x03,0x04,0x45,0x01,0x58,0x4F,0x52,0x43,0x49,0x53,0x4D,0x00,0x65,0x03,0x04,0x45,
0x01,0x59,0x45,0x20,0x4F,0x46,0x20,0x4B,0x49,0x4C,0x52,0x4F,0x47,0x47,0x00,0x62,
0x03,0x04,0x42,0x01,0x4C,0x4F,0x4F,0x44,0x4C,0x55,0x53,0x54,0x00,0x68,0x03,0x04,
0x48,0x01,0x41,0x4C,0x4C,0x55,0x43,0x49,0x4E,0x41,0x54,0x45,0x00,0x72,0x03,0x04,
0x52,0x01,0x41,0x49,0x53,0x45,0x20,0x44,0x45,0x41,0x44,0x00,0x70,0x02,0x55,0x50,
0x47,0x52,0x41,0x44,0x45,0x20,0x4B,0x4E,0x49,0x47,0x48,0x54,0x53,0x20,0x54,0x4F,
0x20,0x04,0x50,0x01,0x41,0x4C,0x41,0x44,0x49,0x4E,0x53,0x00,0x6D,0x02,0x55,0x50,
0x47,0x52,0x41,0x44,0x45,0x20,0x4F,0x47,0x52,0x45,0x53,0x20,0x54,0x4F,0x20,0x04,
0x4D,0x01,0x41,0x47,0x45,0x53,0x00,0x66,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,
0x48,0x20,0x04,0x46,0x01,0x49,0x52,0x45,0x42,0x41,0x4C,0x4C,0x00,0x6C,0x02,0x52,
0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x46,0x04,0x4C,0x01,0x41,0x4D,0x45,0x20,
0x53,0x48,0x49,0x45,0x4C,0x44,0x00,0x6F,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,
0x48,0x20,0x53,0x4C,0x04,0x4F,0x01,0x57,0x00,0x69,0x02,0x52,0x45,0x53,0x45,0x41,
0x52,0x43,0x48,0x20,0x04,0x49,0x01,0x4E,0x56,0x49,0x53,0x49,0x42,0x49,0x4C,0x49,
0x54,0x59,0x00,0x70,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x04,0x50,
0x01,0x4F,0x4C,0x59,0x4D,0x4F,0x52,0x50,0x48,0x00,0x62,0x02,0x52,0x45,0x53,0x45,
0x41,0x52,0x43,0x48,0x20,0x04,0x42,0x01,0x4C,0x49,0x5A,0x5A,0x41,0x52,0x44,0x00,
0x64,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x04,0x44,0x01,0x45,0x41,
0x54,0x48,0x20,0x41,0x4E,0x44,0x20,0x44,0x45,0x43,0x41,0x59,0x00,0x63,0x02,0x52,
0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x44,0x45,0x41,0x54,0x48,0x20,0x04,0x43,
0x01,0x4F,0x49,0x4C,0x00,0x68,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,
0x04,0x48,0x01,0x41,0x53,0x54,0x45,0x00,0x75,0x02,0x52,0x45,0x53,0x45,0x41,0x52,
0x43,0x48,0x20,0x04,0x55,0x01,0x4E,0x48,0x4F,0x4C,0x59,0x20,0x41,0x52,0x4D,0x4F,
0x52,0x00,0x72,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x04,0x52,0x01,
0x55,0x4E,0x45,0x53,0x00,0x77,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,
0x04,0x57,0x01,0x48,0x49,0x52,0x4C,0x57,0x49,0x4E,0x44,0x00,0x76,0x02,0x52,0x45,
0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x48,0x4F,0x4C,0x59,0x20,0x04,0x56,0x01,0x49,
0x53,0x49,0x4F,0x4E,0x00,0x68,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,
0x04,0x48,0x01,0x45,0x41,0x4C,0x49,0x4E,0x47,0x00,0x67,0x02,0x52,0x45,0x53,0x45,
0x41,0x52,0x43,0x48,0x20,0x04,0x47,0x01,0x52,0x45,0x41,0x54,0x45,0x52,0x20,0x48,
0x45,0x41,0x4C,0x49,0x4E,0x47,0x00,0x65,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,
0x48,0x20,0x04,0x45,0x01,0x58,0x4F,0x52,0x43,0x49,0x53,0x4D,0x00,0x65,0x02,0x52,
0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x04,0x45,0x01,0x59,0x45,0x20,0x4F,0x46,
0x20,0x4B,0x49,0x4C,0x52,0x4F,0x47,0x47,0x00,0x62,0x02,0x52,0x45,0x53,0x45,0x41,
0x52,0x43,0x48,0x20,0x04,0x42,0x01,0x4C,0x4F,0x4F,0x44,0x4C,0x55,0x53,0x54,0x00,
0x68,0x02,0x52,0x45,0x53,0x45,0x41,0x52,0x43,0x48,0x20,0x04,0x48,0x01,0x41,0x4C,
0x4C,0x55,0x43,0x49,0x4E,0x41,0x54,0x45,0x00,0x72,0x02,0x52,0x45,0x53,0x45,0x41,
0x52,0x43,0x48,0x20,0x04,0x52,0x01,0x41,0x49,0x53,0x45,0x20,0x44,0x45,0x41,0x44,
0x00,0x6D,0x00,0x04,0x4D,0x01,0x4F,0x56,0x45,0x00,0x73,0x00,0x04,0x53,0x01,0x54,
0x4F,0x50,0x00,0x61,0x00,0x04,0x41,0x01,0x54,0x54,0x41,0x43,0x4B,0x00,0x72,0x00,
0x04,0x52,0x01,0x45,0x50,0x41,0x49,0x52,0x00,0x68,0x00,0x04,0x48,0x01,0x41,0x52,
0x56,0x45,0x53,0x54,0x20,0x4C,0x55,0x4D,0x42,0x45,0x52,0x2F,0x4D,0x49,0x4E,0x45,
0x20,0x47,0x4F,0x4C,0x44,0x00,0x68,0x00,0x04,0x48,0x01,0x41,0x55,0x4C,0x20,0x4F,
0x49,0x4C,0x00,0x62,0x00,0x42,0x55,0x49,0x4C,0x44,0x20,0x04,0x42,0x01,0x41,0x53,
0x49,0x43,0x20,0x53,0x54,0x52,0x55,0x43,0x54,0x55,0x52,0x45,0x00,0x76,0x00,0x42,
0x55,0x49,0x4C,0x44,0x20,0x41,0x44,0x04,0x56,0x01,0x41,0x4E,0x43,0x45,0x44,0x20,
0x53,0x54,0x52,0x55,0x43,0x54,0x55,0x52,0x45,0x00,0x6F,0x00,0x53,0x45,0x41,0x52,
0x43,0x48,0x20,0x46,0x4F,0x52,0x20,0x04,0x4F,0x01,0x49,0x4C,0x00,0x67,0x00,0x52,
0x45,0x54,0x55,0x52,0x4E,0x20,0x57,0x49,0x54,0x48,0x20,0x04,0x47,0x01,0x4F,0x4F,
0x44,0x53,0x00,0x67,0x00,0x41,0x54,0x54,0x41,0x43,0x4B,0x20,0x04,0x47,0x01,0x52,
0x4F,0x55,0x4E,0x44,0x00,0x74,0x00,0x53,0x04,0x54,0x01,0x41,0x4E,0x44,0x20,0x47,
0x52,0x4F,0x55,0x4E,0x44,0x00,0x70,0x00,0x04,0x50,0x01,0x41,0x54,0x52,0x4F,0x4C,
0x00,0x75,0x00,0x04,0x55,0x01,0x4E,0x4C,0x4F,0x41,0x44,0x20,0x54,0x52,0x41,0x4E,
0x53,0x50,0x4F,0x52,0x54,0x00,0x64,0x00,0x04,0x44,0x01,0x45,0x4D,0x4F,0x4C,0x49,
0x53,0x48,0x00,0x10,0x00,0x04,0x45,0x53,0x43,0x01,0x20,0x2D,0x20,0x43,0x41,0x4E,
0x43,0x45,0x4C,0x00,0x10,0x00,0x04,0x45,0x53,0x43,0x01,0x20,0x2D,0x20,0x43,0x41,
0x4E,0x43,0x45,0x4C,0x20,0x43,0x4F,0x4E,0x53,0x54,0x52,0x55,0x43,0x54,0x49,0x4F,
0x4E,0x00,0x10,0x00,0x04,0x45,0x53,0x43,0x01,0x20,0x2D,0x20,0x43,0x41,0x4E,0x43,
0x45,0x4C,0x20,0x55,0x4E,0x49,0x54,0x20,0x54,0x52,0x41,0x49,0x4E,0x49,0x4E,0x47,
0x00,0x10,0x00,0x04,0x45,0x53,0x43,0x01,0x20,0x2D,0x20,0x43,0x41,0x4E,0x43,0x45,
0x4C,0x20,0x55,0x50,0x47,0x52,0x41,0x44,0x45,0x00,0x4C,0x65,0x76,0x65,0x6C,0x00,
0x41,0x72,0x6D,0x6F,0x72,0x3A,0x00,0x44,0x61,0x6D,0x61,0x67,0x65,0x3A,0x00,0x52,
0x61,0x6E,0x67,0x65,0x3A,0x00,0x53,0x69,0x67,0x68,0x74,0x3A,0x00,0x53,0x70,0x65,
0x65,0x64,0x3A,0x00,0x4D,0x61,0x67,0x69,0x63,0x3A,0x00,0x4F,0x69,0x6C,0x20,0x4C,
0x65,0x66,0x74,0x3A,0x00,0x46,0x6F,0x6F,0x64,0x20,0x55,0x73,0x61,0x67,0x65,0x20,
0x00,0x47,0x72,0x6F,0x77,0x6E,0x3A,0x00,0x55,0x73,0x65,0x64,0x3A,0x00,0x54,0x72,
0x61,0x69,0x6E,0x69,0x6E,0x67,0x3A,0x00,0x55,0x70,0x67,0x72,0x61,0x64,0x69,0x6E,
0x67,0x3A,0x00,0x42,0x75,0x69,0x6C,0x64,0x69,0x6E,0x67,0x3A,0x00,0x52,0x65,0x73,
0x65,0x61,0x72,0x63,0x68,0x69,0x6E,0x67,0x3A,0x00,0x47,0x6F,0x6C,0x64,0x20,0x4C,
0x65,0x66,0x74,0x3A,0x00,0x50,0x72,0x6F,0x64,0x75,0x63,0x74,0x69,0x6F,0x6E,0x20,
0x00,0x47,0x6F,0x6C,0x64,0x3A,0x00,0x4C,0x75,0x6D,0x62,0x65,0x72,0x3A,0x00,0x4F,
0x69,0x6C,0x3A,0x00,0x55,0x6E,0x69,0x74,0x20,0x50,0x74,0x72,0x3A,0x00,0x43,0x75,
0x72,0x72,0x65,0x6E,0x74,0x20,0x4F,0x72,0x64,0x65,0x72,0x3A,0x00,0x4E,0x65,0x78,
0x74,0x20,0x4F,0x72,0x64,0x65,0x72,0x3A,0x00,0x25,0x20,0x43,0x6F,0x6D,0x70,0x6C,
0x65,0x74,0x65,0x00,0x4E,0x6F,0x74,0x20,0x65,0x6E,0x6F,0x75,0x67,0x68,0x20,0x6D,
0x61,0x6E,0x61,0x20,0x74,0x6F,0x20,0x63,0x61,0x73,0x74,0x20,0x73,0x70,0x65,0x6C,
0x6C,0x2E,0x00,0x4E,0x6F,0x77,0x68,0x65,0x72,0x65,0x20,0x74,0x6F,0x20,0x72,0x65,
0x74,0x75,0x72,0x6E,0x20,0x74,0x6F,0x2E,0x2E,0x2E,0x63,0x61,0x6E,0x6E,0x6F,0x74,
0x20,0x72,0x65,0x74,0x75,0x72,0x6E,0x2E,0x00,0x43,0x61,0x6E,0x6E,0x6F,0x74,0x20,
0x63,0x61,0x73,0x74,0x20,0x6F,0x6E,0x20,0x62,0x75,0x69,0x6C,0x64,0x69,0x6E,0x67,
0x73,0x2E,0x00,0x4E,0x6F,0x74,0x20,0x65,0x6E,0x6F,0x75,0x67,0x68,0x20,0x66,0x6F,
0x6F,0x64,0x2E,0x2E,0x2E,0x62,0x75,0x69,0x6C,0x64,0x20,0x6D,0x6F,0x72,0x65,0x20,
0x66,0x61,0x72,0x6D,0x73,0x2E,0x00,0x4E,0x6F,0x74,0x20,0x65,0x6E,0x6F,0x75,0x67,
0x68,0x20,0x67,0x6F,0x6C,0x64,0x2E,0x2E,0x2E,0x6D,0x69,0x6E,0x65,0x20,0x6D,0x6F,
0x72,0x65,0x20,0x67,0x6F,0x6C,0x64,0x2E,0x00,0x4E,0x6F,0x74,0x20,0x65,0x6E,0x6F,
0x75,0x67,0x68,0x20,0x6C,0x75,0x6D,0x62,0x65,0x72,0x2E,0x2E,0x2E,0x63,0x68,0x6F,
0x70,0x20,0x6D,0x6F,0x72,0x65,0x20,0x74,0x72,0x65,0x65,0x73,0x2E,0x00,0x4E,0x6F,
0x74,0x20,0x65,0x6E,0x6F,0x75,0x67,0x68,0x20,0x6F,0x69,0x6C,0x2E,0x2E,0x2E,0x64,
0x72,0x69,0x6C,0x6C,0x20,0x66,0x6F,0x72,0x20,0x6F,0x69,0x6C,0x2E,0x00,0x59,0x6F,
0x75,0x20,0x63,0x61,0x6E,0x6E,0x6F,0x74,0x20,0x62,0x75,0x69,0x6C,0x64,0x20,0x6F,
0x66,0x66,0x20,0x74,0x68,0x65,0x20,0x6D,0x61,0x70,0x2E,0x00,0x59,0x6F,0x75,0x20,
0x63,0x61,0x6E,0x6E,0x6F,0x74,0x20,0x62,0x75,0x69,0x6C,0x64,0x20,0x74,0x68,0x65,
0x72,0x65,0x2E,0x00,0x59,0x6F,0x75,0x20,0x6D,0x75,0x73,0x74,0x20,0x62,0x75,0x69,
0x6C,0x64,0x20,0x74,0x68,0x69,0x73,0x20,0x62,0x75,0x69,0x6C,0x64,0x69,0x6E,0x67,
0x20,0x6F,0x6E,0x20,0x74,0x68,0x65,0x20,0x63,0x6F,0x61,0x73,0x74,0x2E,0x00,0x59,
0x6F,0x75,0x20,0x6D,0x75,0x73,0x74,0x20,0x65,0x78,0x70,0x6C,0x6F,0x72,0x65,0x20,
0x74,0x68,0x65,0x72,0x65,0x20,0x66,0x69,0x72,0x73,0x74,0x2E,0x00,0x59,0x6F,0x75,
0x20,0x6D,0x75,0x73,0x74,0x20,0x62,0x75,0x69,0x6C,0x64,0x20,0x61,0x6E,0x20,0x6F,
0x69,0x6C,0x20,0x70,0x6C,0x61,0x74,0x66,0x6F,0x72,0x6D,0x20,0x6F,0x76,0x65,0x72,
0x20,0x61,0x20,0x70,0x61,0x74,0x63,0x68,0x20,0x6F,0x66,0x20,0x6F,0x69,0x6C,0x2E,
0x00,0x59,0x6F,0x75,0x20,0x63,0x61,0x6E,0x6E,0x6F,0x74,0x20,0x62,0x75,0x69,0x6C,
0x64,0x20,0x61,0x20,0x74,0x6F,0x77,0x6E,0x68,0x61,0x6C,0x6C,0x20,0x74,0x6F,0x6F,
0x20,0x6E,0x65,0x61,0x72,0x20,0x61,0x20,0x67,0x6F,0x6C,0x64,0x6D,0x69,0x6E,0x65,
0x2E,0x00,0x59,0x6F,0x75,0x20,0x63,0x61,0x6E,0x6E,0x6F,0x74,0x20,0x62,0x75,0x69,
0x6C,0x64,0x20,0x74,0x6F,0x6F,0x20,0x6E,0x65,0x61,0x72,0x20,0x61,0x20,0x70,0x61,
0x74,0x63,0x68,0x20,0x6F,0x66,0x20,0x6F,0x69,0x6C,0x2E,0x00,0x44,0x65,0x61,0x64,
0x00,0x44,0x79,0x69,0x6E,0x67,0x00,0x47,0x75,0x61,0x72,0x64,0x00,0x4D,0x6F,0x76,
0x65,0x00,0x50,0x61,0x74,0x72,0x6F,0x6C,0x00,0x41,0x74,0x74,0x61,0x63,0x6B,0x00,
0x41,0x74,0x74,0x61,0x63,0x6B,0x20,0x54,0x61,0x72,0x67,0x00,0x41,0x74,0x74,0x61,
0x63,0x6B,0x20,0x41,0x72,0x65,0x61,0x00,0x41,0x74,0x74,0x61,0x63,0x6B,0x20,0x57,
0x61,0x6C,0x6C,0x00,0x44,0x65,0x66,0x65,0x6E,0x64,0x00,0x53,0x74,0x61,0x6E,0x64,
0x00,0x53,0x74,0x61,0x6E,0x64,0x20,0x41,0x74,0x74,0x61,0x63,0x6B,0x00,0x41,0x74,
0x74,0x61,0x63,0x6B,0x20,0x50,0x6C,0x61,0x63,0x65,0x00,0x42,0x75,0x69,0x6C,0x64,
0x00,0x48,0x61,0x72,0x76,0x65,0x73,0x74,0x00,0x52,0x65,0x74,0x75,0x72,0x6E,0x00,
0x45,0x6E,0x74,0x65,0x72,0x00,0x4C,0x65,0x61,0x76,0x65,0x00,0x52,0x65,0x70,0x61,
0x69,0x72,0x00,0x43,0x72,0x65,0x61,0x74,0x65,0x00,0x44,0x6F,0x63,0x6B,0x00,0x4C,
0x61,0x75,0x6E,0x63,0x68,0x00,0x57,0x61,0x69,0x74,0x00,0x42,0x6F,0x61,0x72,0x64,
0x00,0x44,0x69,0x73,0x65,0x6D,0x62,0x61,0x72,0x6B,0x00,0x54,0x72,0x61,0x69,0x6E,
0x00,0x52,0x65,0x73,0x75,0x72,0x72,0x65,0x63,0x74,0x00,0x57,0x61,0x69,0x74,0x00,
0x4D,0x6F,0x76,0x65,0x55,0x6E,0x69,0x74,0x00,0x50,0x61,0x74,0x72,0x6F,0x6C,0x55,
0x6E,0x69,0x74,0x00,0x4E,0x6F,0x6E,0x65,0x00,
};

/**
**	Convert text to my format.
*/
int SetupNames(char* file __attribute__((unused)),int txte __attribute__((unused)))
{
    unsigned char* txtp;
    const unsigned short* mp;
    size_t l;
    unsigned u;
    unsigned n;

    //txtp=ExtractEntry(ArchiveOffsets[txte],&l);
    txtp=Names;
    l=sizeof(Names);
    mp=(const unsigned short*)txtp;

    n=ConvertLE16(mp[0]);
    for( u=1; u<n; ++u ) {
	DebugLevel3("%d %x " _C_ u _C_ ConvertLE16(mp[u]));
	DebugLevel3("%s\n" _C_ txtp+ConvertLE16(mp[u]));
	if( u<sizeof(UnitNames)/sizeof(*UnitNames) ) {
	    UnitNames[u]=strdup(txtp+ConvertLE16(mp[u]));
	}
    }

    if( txtp!=Names ) {
	free(txtp);
    }
    return 0;
}

/**
**	Parse string.
*/
char* ParseString(char* input)
{
    static char buf[1024];
    char* dp;
    char* sp;
    char* tp;
    int i;
    int f;

    for( sp=input,dp=buf; *sp; ) {
	if( *sp=='%' ) {
	    f=0;
	    if( *++sp=='-' ) {
		f=1;
		++sp;
	    }
	    i=strtol(sp,&sp,0);
	    tp=UnitNames[i];
	    if( f ) {
		tp=strchr(tp,' ')+1;
	    }
	    while( *tp ) {	// make them readabler
		if( *tp=='-' ) {
		    *dp++='_';
		    tp++;
		} else {
		    *dp++=tolower(*tp++);
		}
	    }
	    continue;
	}
	*dp++=*sp++;
    }
    *dp='\0';

    return buf;
}

//----------------------------------------------------------------------------
//	Import the campaigns
//----------------------------------------------------------------------------

#ifndef NO_IMPORT_CAMPAIGNS

/**
**	FIXME: docu
*/
int CampaignsCreate(char *file __attribute__((unused)), int txte, int ofs,
	int expansion)
{
    unsigned char *objectives;
    char buf[1024];
    unsigned char *CampaignData[2][26][10];
    unsigned char *current, *next, *nextobj, *currentobj;
    FILE *inlevel, *outlevel;
    int l, levelno, noobjs, race;
    struct stat s;
    char rezdat[1024];

    //Campaign data is in different spots on the original and
    //expansion CD's, have to take care of this at runtime.
    if (expansion) {
      ofs=236;
      txte=54;
    } else {
      ofs=140;
#ifdef USE_BEOS
      sprintf(rezdat, "%s/REZDAT.WAR", ArchiveDir);
#else
      sprintf(rezdat, "%s/rezdat.war", ArchiveDir);
#endif
      stat(rezdat, &s);
      if (s.st_size == 1894026) {
        txte=54;
      } else {
        txte=53;
      }
    }

    objectives = ExtractEntry(ArchiveOffsets[txte], &l);
    if (!objectives) {
	printf("Objectives allocation failed\n");
	exit(-1);
    }
    objectives = realloc(objectives, l + 1);
    if (!objectives) {
	printf("Objectives allocation failed\n");
	exit(-1);
    }
    objectives[l] = '\0';

    //Now Search from start of objective data
    levelno = 0;
    race = 0;

    //Extract all the values for objectives
    if (expansion) {
	expansion = 52;
    } else {
	expansion = 28;
    }
    current = objectives + ofs;
    for (l = 0; l < expansion; l++) {
	next = current + strlen(current) + 1;

	noobjs = 1;			//Number of objectives is zero.
	currentobj = current;
	while ((nextobj = strchr(currentobj, '\n')) != NULL) {
	    *nextobj = '\0';
	    nextobj++;
	    CampaignData[race][levelno][noobjs] = currentobj;
	    currentobj = nextobj;
	    noobjs++;
	}
	//Get the final one.
	CampaignData[race][levelno][noobjs] = currentobj;
	for (noobjs++; noobjs < 10; noobjs++) {
	    CampaignData[race][levelno][noobjs] = NULL;
	}
	current = next;
	if (race == 0) {
	    race = 1;
	} else if (race == 1) {
	    race = 0;
	    levelno++;
	};
    }

    //Extract the Level titles now.
    race = 0;
    levelno = 0;
    //Find the start of the Levels
    while (current[0] && current[0] != 'I' && current[1] != '.') {
	current = current + strlen(current) + 1;
    }
    for (l = 0; l < expansion; l++) {
	next = current + strlen(current) + 1;
	CampaignData[race][levelno][0] = current;
	current = next;
	if (race == 0) {
	    race = 1;
	} else {
	    if (race == 1) {
		race = 0;
		levelno++;
	    }
	}
    }

    for (levelno = 0; levelno < expansion / 2; levelno++) {
	for (race = 0; race < 2; race++) {
	    //Open Relevant file, to write stuff too.
	    sprintf(buf, "%s/../%s/%s/%s.cm", Dir, "contrib", TEXT_PATH,
		Todo[2 * levelno + 1 + race + 7].File);
	    if (!(inlevel = fopen(buf, "rb"))) {
		sprintf(buf, "./contrib/%s/%s.cm", TEXT_PATH, 
		    Todo[2 * levelno + 1 + race + 7].File);
		if (!(inlevel = fopen(buf, "rb"))) {
		    printf("Cannot Open File (Skipping Level): %s\n", buf);
		    continue;
		}
	    }
	    sprintf(buf, "%s/%s/%s.cm", Dir, TEXT_PATH,
		Todo[2 * levelno + 1 + race + 7].File);
	    CheckPath(buf);
	    if (!(outlevel = fopen(buf, "wb"))) {
		printf("Cannot Write File (Skipping Level: %s\n", buf);
		continue;
	    }
	    //Title Key is ^^TITLE^^
	    //Objectives Key is ^^OBJECTIVES^^
	    while (fgets(buf, 1023, inlevel) != 0) {
		if (!strncmp(buf, "^^TITLE^^", 9)) {
		    sprintf(buf, "    'title \"%s\"\n",
			CampaignData[race][levelno][0]);
		    fputs(buf, outlevel);
		} else {
		    if (!strncmp(buf, "^^OBJECTIVES^^", 14)) {
			for (noobjs = 1; noobjs < 10; noobjs++) {
			    if (CampaignData[race][levelno][noobjs] != NULL) {
				sprintf(buf, "    'objective \"%s\"\n",
				    CampaignData[race][levelno][noobjs]);
				fputs(buf, outlevel);
			    }
			}
		    } else {
			fputs(buf, outlevel);
		    }
		}
	    }
	    //Close levels and move on.
	    fclose(inlevel);
	    fclose(outlevel);
	}
    }
    
    free(objectives);
    return 0;
}

#endif


//----------------------------------------------------------------------------
//	Main loop
//----------------------------------------------------------------------------

/**
**	Display the usage.
*/
void Usage(const char* name)
{
    printf("wartool for FreeCraft V" VERSION ", (c) 1999-2002 by the FreeCraft Project\n\
Usage: %s [-e] archive-directory [destination-directory]\n\
\t-e\tThe archive is expansion compatible\n\
\t-n\tThe archive is not expansion compatible\n\
\t-v\tExtract also the videos needs additional 70Mb\n\
\t-m\tTreat the archive-directory as a Macintosh archive\n\
archive-directory\tDirectory which includes the archives maindat.war...\n\
destination-directory\tDirectory where the extracted files are placed.\n"
    ,name);
}

/**
**	Main
*/
#undef main
int main(int argc,char** argv)
{
    unsigned u;
    char buf[1024];
    struct stat stat_buf;
    int expansion_cd;
    int video;
    int a;
    char filename[1024];

    a=1;
    video=expansion_cd=UseMacCd=0;
    while( argc>=2 ) {
	if( !strcmp(argv[a],"-v") ) {
	    video=1;
	    ++a;
	    --argc;
	    continue;
	}
	if( !strcmp(argv[a],"-e") ) {
	    expansion_cd=1;
	    ++a;
	    --argc;
	    continue;
	}
	if( !strcmp(argv[a],"-n") ) {
	    expansion_cd=-1;
	    ++a;
	    --argc;
	    continue;
	}
	if( !strcmp(argv[a],"-h") ) {
	    Usage(argv[0]);
	    ++a;
	    --argc;
	    exit(0);
	}
	if( !strcmp(argv[a],"-m") ) {
	    UseMacCd=1;
	    ++a;
	    --argc;
	    continue;
	}
	break;
    }

    if( argc!=2 && argc!=3 ) {
	Usage(argv[0]);
	exit(-1);
    }

    ArchiveDir=argv[a];
    if( argc==3 ) {
	Dir=argv[a+1];
    } else {
	Dir="data";
    }

    // detect Expansion CD by getting size of rezdat.war
#ifdef USE_BEOS
    sprintf(buf, "%s/REZDAT.WAR", ArchiveDir);
#else
    sprintf(buf, "%s/rezdat.war", ArchiveDir);
#endif
    stat(buf, &stat_buf);
    if ( expansion_cd==-1 || (expansion_cd!=1 && (stat_buf.st_size != 2811086)) ) {
	expansion_cd=0;
    } else {
	expansion_cd=1;
    }

    DebugLevel2("Extract from \"%s\" to \"%s\"\n" _C_ ArchiveDir _C_ Dir);
    for( u=0; u<sizeof(Todo)/sizeof(*Todo); ++u ) {
	if (UseMacCd) {
	    strcpy(filename,Todo[u].File);
	    Todo[u].File=filename;
	    ConvertToMac(Todo[u].File);
	}
	// Should only be on the expansion cd
	DebugLevel2("%s:\n" _C_ ParseString(Todo[u].File));
	if (!expansion_cd && Todo[u].Version==2 ) {
	    continue;
	}
	switch( Todo[u].Type ) {
		
	    case F:
		sprintf(buf,"%s/%s",ArchiveDir,Todo[u].File);
		DebugLevel2("Archive \"%s\"\n" _C_ buf);
		if( ArchiveBuffer ) {
		    CloseArchive();
		}
		OpenArchive(buf,Todo[u].Arg1);
		break;
	    case R:
		ConvertRgb(Todo[u].File,Todo[u].Arg1);
		break;
	    case T:
		ConvertTileset(Todo[u].File,Todo[u].Arg1,Todo[u].Arg2
			,Todo[u].Arg3,Todo[u].Arg4);
		break;
	    case G:
		ConvertGfx(ParseString(Todo[u].File),Todo[u].Arg1,Todo[u].Arg2
			,Todo[u].Arg3,Todo[u].Arg4);
		break;
	    case U:
		ConvertGfu(Todo[u].File,Todo[u].Arg1,Todo[u].Arg2);
		break;
	    case P:
		ConvertPud(Todo[u].File,Todo[u].Arg1);
		break;
	    case N:
		ConvertFont(Todo[u].File,2,Todo[u].Arg1);
		break;
	    case I:
		ConvertImage(Todo[u].File,Todo[u].Arg1,Todo[u].Arg2,
		    Todo[u].Arg3,Todo[u].Arg4);
		break;
	    case C:
		ConvertCursor(Todo[u].File,Todo[u].Arg1,Todo[u].Arg2);
		break;
	    case W:
		ConvertWav(Todo[u].File,Todo[u].Arg1);
		break;
	    case X:
		ConvertText(Todo[u].File,Todo[u].Arg1,Todo[u].Arg2);
		break;
	    case S:
		SetupNames(Todo[u].File,Todo[u].Arg1);
		break;
	    case V:
		if( video ) {
		    ConvertVideo(Todo[u].File,Todo[u].Arg1);
		}
		break; 
#ifndef NO_IMPORT_CAMPAIGNS
	    case L:
		CampaignsCreate(Todo[u].File,Todo[u].Arg1,Todo[u].Arg2,
		    expansion_cd);
		break;
#endif
	    default:
		break;
	}
    }

    return 0;
}

//@}
