#import "InstallerPrefs.h"
#import "InstallerMedia.h"

@implementation InstallerPrefs

- (void)make
{
	NSString *prefsString;
	
	// Create the preferences directory (if it does not exist
	if (![fileManager fileExistsAtPath:prefsPath]) {
		[fileManager createDirectoryAtPath:prefsPath attributes:nil];
		
		// Insist on a suitable resolution
		if ([installerMedia useLowRes]) 
			prefsString = [NSString stringWithString:@"(set-video-resolution! 640 480)"];
		else
			prefsString = [NSString stringWithString:@"(set-video-resolution! 800 600)"];
		[prefsString writeToFile:[prefsPath stringByAppendingString:@"preferences1.ccl"] atomically:YES];
		
		// Insist on a full screen
		prefsString = [NSString stringWithString:@"(set-video-fullscreen! 1)"];
		[prefsString writeToFile:[prefsPath stringByAppendingString:@"preferences2.ccl"] atomically:YES];
	
	}
	
}

- (void)setup
{
}

@end
