//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Cube.cpp,v 1.2 2003/08/08 08:39:56 delpinux Exp $

// This class provides a toolkit to manipulate Cubes. It inherits from the
// Shape class.

#include <Cube.hpp>


//! copies a the Cube \a C.
const Cube&  Cube::operator = (const Cube& C)
{
  __lower  = C.__lower;
  __higher = C.__higher;
  __trans  = C.__trans;
  return *this;
}

//! Default constructor.
Cube::Cube()
  : Shape(cube)
{
  ;
}

/*!
  Builds a Cube based on vertices \a a and \a b.
  The edges of the Cube are parallel to the axis.
*/
Cube::Cube(const Vertex& a, const Vertex& b)
  : Shape(cube)
{
  const real_t& x0 = std::min (a.x(), b.x());
  const real_t& x1 = std::max (a.x(), b.x());
  const real_t& y0 = std::min (a.y(), b.y());
  const real_t& y1 = std::max (a.y(), b.y());
  const real_t& z0 = std::min (a.z(), b.z());
  const real_t& z1 = std::max (a.z(), b.z());
  __lower.x() = x0;
  __lower.y() = y0;
  __lower.z() = z0;
  __higher.x() = x1;
  __higher.y() = y1;
  __higher.z() = z1;
}

//! Copy constructor.
Cube::Cube(const Cube& C)
  : Shape(C),
    __lower (C.__lower),
    __higher(C.__higher)
{
  ;
}

//! Prints the Cube informations using the stream \a s.
std::ostream& Cube::put(std::ostream& s) const
{
  s << "box {\n" << __lower
    << ", " << __higher << '\n';
  for (size_t i=0; i<nbTransform(); i++)
    s << (*__trans[i]).povWrite() << '\n';
  s << "}\n";

  return s;
}

