//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: main.cpp,v 1.1.1.1 2003/02/17 16:32:47 delpinux Exp $

/*!
  \mainpage The FreeFEM3D developper Manual.
  \section intro Introduction.
  Write an introdution to the FreeFEM3D project.
  \section code Getting the Code.
  \li How to get the code (download from www.freefem.org, using cvs, ...)
  \li Submitting patches, become a FreeFEM3D developper, ...
  \author Stphane Del Pino
*/

#include <system.h>

#include <StaticCenter.hpp>

#include <StreamCenter.hpp>
#include <ParameterCenter.hpp>

#include <fstream>

#include <vector>

#include <ParametersInitialization.hpp>
#include <FFLexer.hpp>

#include <ReferenceCounting.hpp>

#include <RealExpression.hpp>

#include <Expression.hpp>
#include <Instruction.hpp>

#include <Timer.hpp>

#include <typeinfo>

#include <iostream>

#ifdef HAVE_LIBOPTS
#include <getopt.h>
#include "system.h"
#include "checkopt.h"
#endif // HAVE_LIBOPTS

// The lexer pointer.
Lexer* fflexer;

// The parser function.
int ffparse();

// The static center (everything is there :-)
static StaticCenter staticCenter;

std::vector<ReferenceCounting<Instruction> > iSet;
VariableList variableList;

int main (int argc, char *argv[])
{
  Timer totalTime;
  totalTime.start();

#ifdef HAVE_LIBOPTS
  {
    int arg_ct = optionProcess( &ff3dOptions, argc, argv );
    argc -= arg_ct;
    argv += arg_ct;

    if (argc != 1) {
      USAGE(1);
    }

    int level = OPT_VALUE_VERBOSITY;

    if (HAVE_OPT(QUIET)) {
      level = 0;
    }

    StreamCenter::instance().setDebugLevel(level);
  }

  if (argc<1) {
    ffout(-1) << "usage: " << argv[0] << " filename\n";
    std::exit(0);
  }

  std::ifstream fin(argv[0]);

  if (!fin) {
    ffout(-1) << argv[0] << ": No such file or directory\n";
    std::exit(1);
  }

#else // HAVE_LIBOPTS

  if (argc<2) {
    ffout(-1) << "usage: " << argv[0] << " filename\n";
    std::exit(0);
  }

  StreamCenter::instance().setDebugLevel(3);

  std::ifstream fin(argv[1]);

  if (!fin) {
    ffout(-1) << argv[1] << ": No such file or directory\n";
    std::exit(1);
  }
  
#endif // HAVE_LIBOPTS

  ParametersInitialization();

  ffout(1) << "Parsing the file ...";
  {
    fflexer = new FFLexer(fin);
    ffparse();
    delete fflexer;
  }
  ffout(1) << " done\n";

#ifdef HAVE_LIBOPTS
  if (!HAVE_OPT(PARSE_ONLY)) {
#endif // HAVE_LIBOPTS
    ffout(1) << "Treating data\n";
    for (std::vector<ReferenceCounting<Instruction> >::iterator i = iSet.begin();
	 i != iSet.end(); ++i)
      {
	(*(*i)).execute();
      }
    ffout(1) << "done\n";
#ifdef HAVE_LIBOPTS
  }
#endif // HAVE_LIBOPTS

  iSet.clear();
  variableList.clear();

  totalTime.stop();
  ffout(1) << "Execution time: " << totalTime << '\n';

  return 0;
}
