//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FiniteElementTraits.hpp,v 1.4 2004/01/30 17:34:12 delpinux Exp $

#ifndef FINITE_ELEMENT_TRAITS_HPP
#define FINITE_ELEMENT_TRAITS_HPP

#include <Cell.hpp>
#include <Hexahedron.hpp>
#include <Tetrahedron.hpp>
#include <Triangle.hpp>
#include <Quadrangle.hpp>

#include <ConformTransformation.hpp>

#include <Q1FiniteElement.hpp>
#include <P1FiniteElement.hpp>

template <typename T>
class FiniteElementTraits
{
  ;
};

template <>
class FiniteElementTraits<Hexahedron>
{
public:
  typedef Q1FiniteElement Type;

  typedef ConformTransformationQ1Hexahedron
  Transformation;

  typedef ConformTransformationQ1HexahedronJacobian
  JacobianTransformation;
};

template <>
class FiniteElementTraits<CartesianHexahedron>
{
public:
  typedef Q1FiniteElement Type;

  typedef ConformTransformationQ1CartesianHexahedron
  Transformation;

  typedef ConformTransformationQ1CartesianHexahedronJacobian
  JacobianTransformation;
};

template <>
class FiniteElementTraits<Tetrahedron>
{
public:
  enum {
    NumberOfDOF = 4		/**< DOF means Degrees of Freedom */
  };

  typedef P1FiniteElement Type;

  typedef ConformTransformationP1Tetrahedron
  Transformation;

  typedef ConformTransformationP1TetrahedronJacobian
  JacobianTransformation;
};

template <>
class FiniteElementTraits<Triangle>
{
public:
  enum {
    NumberOfDOF = 3		/**< DOF means Degrees of Freedom */
  };

  typedef ConformTransformationP1Triangle
  Transformation;

  typedef ConformTransformationP1TriangleJacobian
  JacobianTransformation;

  typedef TinyVector<NumberOfDOF> ElementaryVector;

  typedef TinyMatrix<NumberOfDOF,
		     NumberOfDOF> ElementaryMatrix;
};

template <>
class FiniteElementTraits<Quadrangle>
{
public:
  enum {
    NumberOfDOF = 4		/**< DOF means Degrees of Freedom */
  };

  typedef ConformTransformationQ1Quadrangle
  Transformation;

  typedef ConformTransformationQ1QuadrangleJacobian
  JacobianTransformation;

  typedef TinyVector<NumberOfDOF> ElementaryVector;

  typedef TinyMatrix<NumberOfDOF,
		     NumberOfDOF> ElementaryMatrix;
};

#endif // FINITE_ELEMENT_TRAITS_HPP

