# Module: ftape-format.tcl
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

# module contents
global moduleList
global autoLoadList
set moduleList(ftape-format.tcl) { VFrame.frame6 .top8 UpdateFmtOptWidgets UpdateEraseTime UpdateProgress RunFormatCmd ParseFormatParms MakeFormatFrame FormatCmdHandler ComposeFormatCmd StopFormatCmd}
set autoLoadList(ftape-format.tcl) {1}

# procedures to show toplevel windows


# procedure to show window ShowWindow.top8
proc ShowWindow.top8 { args} {
# xf ignore me 7

  # build widget .top8
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top8"
  } {
    catch "destroy .top8"
  }
  toplevel .top8 

  # Window manager configurations
  wm positionfrom .top8 ""
  wm sizefrom .top8 ""
  wm maxsize .top8 1000 1000
  wm minsize .top8 10 10
  wm title .top8 {Format Dialog}
  wm resizable .top8 0 0

  # build widget .top8.frame0
  frame .top8.frame0  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame0.menubutton1
  menubutton .top8.frame0.menubutton1  -menu {.top8.frame0.menubutton1.m}  -padx {4}  -pady {3}  -text {File}  -underline {0}

  # build widget .top8.frame0.menubutton1.m
  menu .top8.frame0.menubutton1.m  -tearoff {0}
  .top8.frame0.menubutton1.m add command  -command {DestroyWindow.top8}  -label {Close}  -state {active}

  # build widget .top8.frame0.menubutton2
  menubutton .top8.frame0.menubutton2  -menu {.top8.frame0.menubutton2.m}  -padx {4}  -pady {3}  -text {Help}  -underline {0}

  # build widget .top8.frame0.menubutton2.m
  menu .top8.frame0.menubutton2.m

  # build widget .top8.frame9
  frame .top8.frame9  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame9.button10
  button .top8.frame9.button10  -command {DestroyWindow.top8}  -foreground {Red}  -padx {9}  -pady {3}  -state {active}  -text {Close}

  # build widget .top8.frame11
  frame .top8.frame11  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame11.frame0
  frame .top8.frame11.frame0  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame0.value
  entry .top8.frame11.frame0.value  -textvariable {FmtOpt(qic-standard)}  -width {14}

  # build widget .top8.frame11.frame0.menubutton2
  menubutton .top8.frame11.frame0.menubutton2  -menu {.top8.frame11.frame0.menubutton2.m}  -padx {4}  -pady {3}  -state {disabled}  -text {v}

  # build widget .top8.frame11.frame0.menubutton2.m
  menu .top8.frame11.frame0.menubutton2.m
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-40}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-80}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-80/WIDE}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-3010}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-3010/WIDE}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-3020}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-3020/WIDE}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {TR-1}
  .top8.frame11.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {TR-3}

  # build widget .top8.frame11.frame0.checkbutton1
  checkbutton .top8.frame11.frame0.checkbutton1  -command {UpdateFmtOptWidgets FmtOpt}  -text {QIC Standard}  -variable {FmtOptStatus(qic-standard)}

  # build widget .top8.frame11.frame15
  frame .top8.frame11.frame15  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame15.value
  entry .top8.frame11.frame15.value  -state {disabled}  -textvariable {FmtOpt(format-code)}  -width {14}

  # build widget .top8.frame11.frame15.menubutton2
  menubutton .top8.frame11.frame15.menubutton2  -menu {.top8.frame11.frame15.menubutton2.m}  -padx {4}  -pady {3}  -state {disabled}  -text {v}

  # build widget .top8.frame11.frame15.menubutton2.m
  menu .top8.frame11.frame15.menubutton2.m
  .top8.frame11.frame15.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame15
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {normal}
  .top8.frame11.frame15.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame15
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {1100ft}
  .top8.frame11.frame15.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame15
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {variable}
  .top8.frame11.frame15.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame15
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {425ft}
  .top8.frame11.frame15.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame15
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {large}

  # build widget .top8.frame11.frame15.checkbutton2
  checkbutton .top8.frame11.frame15.checkbutton2  -command {UpdateFmtOptWidgets FmtOpt}  -text {Format Code}  -variable {FmtOptStatus(format-code)}

  # build widget .top8.frame11.frame16
  frame .top8.frame11.frame16  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame16.value
  entry .top8.frame11.frame16.value  -state {disabled}  -textvariable {FmtOpt(gap3)}  -width {14}

  # build widget .top8.frame11.frame16.menubutton2
  menubutton .top8.frame11.frame16.menubutton2  -menu {.top8.frame11.frame16.menubutton2.m}  -padx {4}  -pady {3}  -state {disabled}  -text {v}

  # build widget .top8.frame11.frame16.menubutton2.m
  menu .top8.frame11.frame16.menubutton2.m
  .top8.frame11.frame16.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame16
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {233}  -state {active}
  .top8.frame11.frame16.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame16
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {248}

  # build widget .top8.frame11.frame16.checkbutton3
  checkbutton .top8.frame11.frame16.checkbutton3  -command {UpdateFmtOptWidgets FmtOpt}  -text {GAP3}  -variable {FmtOptStatus(gap3)}

  # build widget .top8.frame11.frame17
  frame .top8.frame11.frame17  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame17.value
  entry .top8.frame11.frame17.value  -state {disabled}  -textvariable {FmtOpt(floppy-head-max)}  -width {14}

  # build widget .top8.frame11.frame17.checkbutton0
  checkbutton .top8.frame11.frame17.checkbutton0  -command {UpdateFmtOptWidgets FmtOpt}  -text {Max. Floppy Head}  -variable {FmtOptStatus(floppy-head-max)}

  # build widget .top8.frame11.frame18
  frame .top8.frame11.frame18  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame18.value
  entry .top8.frame11.frame18.value  -state {disabled}  -textvariable {FmtOpt(floppy-track-max)}  -width {14}

  # build widget .top8.frame11.frame18.checkbutton4
  checkbutton .top8.frame11.frame18.checkbutton4  -command {UpdateFmtOptWidgets FmtOpt}  -text {Max. Floppy Track}  -variable {FmtOptStatus(floppy-track-max)}

  # build widget .top8.frame11.frame19
  frame .top8.frame11.frame19  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame19.value
  entry .top8.frame11.frame19.value  -state {disabled}  -textvariable {FmtOpt(segments-per-track)}  -width {14}

  # build widget .top8.frame11.frame19.checkbutton5
  checkbutton .top8.frame11.frame19.checkbutton5  -command {UpdateFmtOptWidgets FmtOpt}  -text {Segments/Track}  -variable {FmtOptStatus(segments-per-track)}

  # build widget .top8.frame11.frame20
  frame .top8.frame11.frame20  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame20.value
  entry .top8.frame11.frame20.value  -state {disabled}  -textvariable {FmtOpt(tracks-per-tape)}  -width {14}

  # build widget .top8.frame11.frame20.checkbutton6
  checkbutton .top8.frame11.frame20.checkbutton6  -command {UpdateFmtOptWidgets FmtOpt}  -text {Tracks/Tape}  -variable {FmtOptStatus(tracks-per-tape)}

  # build widget .top8.frame11.frame21
  frame .top8.frame11.frame21  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame11.frame21.value
  entry .top8.frame11.frame21.value  -state {disabled}  -textvariable {FmtOpt(fixed-formats)}  -width {14}

  # build widget .top8.frame11.frame21.menubutton2
  menubutton .top8.frame11.frame21.menubutton2  -menu {.top8.frame11.frame21.menubutton2.m}  -padx {4}  -pady {3}  -state {disabled}  -text {v}

  # build widget .top8.frame11.frame21.menubutton2.m
  menu .top8.frame11.frame21.menubutton2.m  -tearoff {0}
  .top8.frame11.frame21.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 68
set FmtOpt(floppy-head-max) 1
set FmtOpt(floppy-track-max) 169
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed-formats) "QIC-40/205ft"
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-40/205ft}
  .top8.frame11.frame21.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 102
set FmtOpt(floppy-head-max) 1
set FmtOpt(floppy-track-max) 254
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed-formats) "QIC-40/307ft"
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-40/307ft}
  .top8.frame11.frame21.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 365
set FmtOpt(floppy-head-max) 7
set FmtOpt(floppy-track-max) 253
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed-formats) "QIC-40/1100ft"
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-40/1100ft}
  .top8.frame11.frame21.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 100
set FmtOpt(floppy-head-max) 4
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed-formats) "QIC-80/205ft"  
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-80/205ft}
  .top8.frame11.frame21.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 150
set FmtOpt(floppy-head-max) 6
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed-formats) "QIC-80/307ft"
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-80/307ft}
  .top8.frame11.frame21.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 207
set FmtOpt(floppy-head-max) 9
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed-formats) "QIC-80/425ft"
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-80/425ft}
  .top8.frame11.frame21.menubutton2.m add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 537
set FmtOpt(floppy-head-max) 14
set FmtOpt(floppy-track-max) 253
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed-formats) "QIC-80/1100ft"
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {QIC-80/1100ft}

  # build widget .top8.frame11.frame21.checkbutton25
  checkbutton .top8.frame11.frame21.checkbutton25  -command {UpdateFmtOptWidgets FmtOpt}  -pady {0}  -text {Fixed Formats}  -variable {FmtOptStatus(fixed-formats)}

  # build widget .top8.frame11.frame22
  frame .top8.frame11.frame22  -borderwidth {2}  -height {8}  -relief {raised}  -width {30}

  # build widget .top8.frame11.frame23
  frame .top8.frame11.frame23  -borderwidth {2}  -height {14}  -relief {raised}  -width {30}

  # build widget .top8.frame11.label27
  label .top8.frame11.label27  -foreground {Blue}  -relief {raised}  -text {Format Parameters}

  # build widget .top8.frame11.frame28
  frame .top8.frame11.frame28  -borderwidth {2}  -height {8}  -relief {raised}  -width {30}

  # build widget .top8.frame30
  frame .top8.frame30  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame30.frame0
  frame .top8.frame30.frame0  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame30.frame0.label1
  label .top8.frame30.frame0.label1  -borderwidth {0}  -text {Mode of operation}

  # build widget .top8.frame30.frame0.value
  label .top8.frame30.frame0.value  -anchor {w}  -relief {sunken}  -text {probe}  -textvariable {FmtOpt(mode)}  -width {5}

  # build widget .top8.frame30.frame0.menubutton2
  menubutton .top8.frame30.frame0.menubutton2  -menu {.top8.frame30.frame0.menubutton2.m}  -padx {4}  -pady {3}  -relief {groove}  -text {v}

  # build widget .top8.frame30.frame0.menubutton2.m
  menu .top8.frame30.frame0.menubutton2.m
  .top8.frame30.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame30.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {probe}
  .top8.frame30.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame30.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {auto}
  .top8.frame30.frame0.menubutton2.m add command  -command {OptionButtonSet .top8.frame30.frame0
ComposeFormatCmd $Options(RawNoRewindDevice)}  -label {force}

  # build widget .top8.frame30.frame36
  frame .top8.frame30.frame36  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame30.frame36.checkbutton35
  checkbutton .top8.frame30.frame36.checkbutton35  -command {ComposeFormatCmd $Options(RawNoRewindDevice)}  -text {do not erase the old format}  -variable {FmtOpt(omiterase)}

  # build widget .top8.frame30.frame38
  frame .top8.frame30.frame38  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame30.frame38.checkbutton35
  checkbutton .top8.frame30.frame38.checkbutton35  -command {ComposeFormatCmd $Options(RawNoRewindDevice)}  -text {do not read the header segment}  -variable {FmtOpt(discardheader)}

  # build widget .top8.frame30.frame39
  frame .top8.frame30.frame39  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame30.frame39.checkbutton35
  checkbutton .top8.frame30.frame39.checkbutton35  -command {ComposeFormatCmd $Options(RawNoRewindDevice)}  -text {do not write the reference bursts}  -variable {FmtOpt(noref)}

  # build widget .top8.frame30.frame40
  frame .top8.frame30.frame40  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame30.frame40.checkbutton35
  checkbutton .top8.frame30.frame40.checkbutton35  -command {ComposeFormatCmd /dev/nrawft0}  -text {do not format, only verify}  -variable {FmtOpt(verifyonly)}

  # build widget .top8.frame30.frame28
  frame .top8.frame30.frame28  -borderwidth {2}  -height {8}  -relief {raised}  -width {30}

  # build widget .top8.frame30.label27
  label .top8.frame30.label27  -foreground {Blue}  -relief {raised}  -text {Format Options}

  # build widget .top8.frame31
  frame .top8.frame31  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top8.frame31.frame
  frame .top8.frame31.frame  -borderwidth {2}  -relief {raised}

  # build widget .top8.frame31.frame.frame
  frame .top8.frame31.frame.frame

  # build widget .top8.frame31.frame.frame.scrollbar1
  scrollbar .top8.frame31.frame.frame.scrollbar1  -command {.top8.frame31.frame.frame.entry2 xview}  -orient {horizontal}  -width {11}

  # build widget .top8.frame31.frame.frame.entry2
  entry .top8.frame31.frame.frame.entry2  -state {disabled}  -textvariable {formatcmd}  -xscrollcommand {.top8.frame31.frame.frame.scrollbar1 set}

  # build widget .top8.tearoff1
  menu .top8.tearoff1  -tearoff {0}
  .top8.tearoff1 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 68
set FmtOpt(floppy-head-max) 1
set FmtOpt(floppy-track-max) 169
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed) "QIC-40/205ft"}  -label {QIC-40/205ft}
  .top8.tearoff1 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 102
set FmtOpt(floppy-head-max) 1
set FmtOpt(floppy-track-max) 254
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed) "QIC-40/307ft"}  -label {QIC-40/307ft}
  .top8.tearoff1 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 365
set FmtOpt(floppy-head-max) 7
set FmtOpt(floppy-track-max) 253
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed) "QIC-40/1100ft"}  -label {QIC-40/1100ft}
  .top8.tearoff1 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 100
set FmtOpt(floppy-head-max) 4
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/205ft"  }  -label {QIC-80/205ft}
  .top8.tearoff1 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 150
set FmtOpt(floppy-head-max) 6
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/307ft"}  -label {QIC-80/307ft}
  .top8.tearoff1 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 207
set FmtOpt(floppy-head-max) 9
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/425ft"}  -label {QIC-80/425ft}
  .top8.tearoff1 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 537
set FmtOpt(floppy-head-max) 14
set FmtOpt(floppy-track-max) 253
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/1100ft"}  -label {QIC-80/1100ft}
  # bindings
  bind .top8.tearoff1 <Enter> {
	set tkPriv(focus) %W
    }

  # build widget .top8.tearoff2
  menu .top8.tearoff2  -tearoff {0}
  .top8.tearoff2 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 68
set FmtOpt(floppy-head-max) 1
set FmtOpt(floppy-track-max) 169
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed) "QIC-40/205ft"}  -label {QIC-40/205ft}
  .top8.tearoff2 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 102
set FmtOpt(floppy-head-max) 1
set FmtOpt(floppy-track-max) 254
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed) "QIC-40/307ft"}  -label {QIC-40/307ft}
  .top8.tearoff2 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 20
set FmtOpt(segments-per-track) 365
set FmtOpt(floppy-head-max) 7
set FmtOpt(floppy-track-max) 253
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-40"
set FmtOpt(fixed) "QIC-40/1100ft"}  -label {QIC-40/1100ft}
  .top8.tearoff2 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 100
set FmtOpt(floppy-head-max) 4
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/205ft"  }  -label {QIC-80/205ft}
  .top8.tearoff2 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 150
set FmtOpt(floppy-head-max) 6
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/307ft"}  -label {QIC-80/307ft}
  .top8.tearoff2 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 207
set FmtOpt(floppy-head-max) 9
set FmtOpt(floppy-track-max) 149
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/425ft"}  -label {QIC-80/425ft}
  .top8.tearoff2 add command  -command {OptionButtonSet .top8.frame11.frame21
set FmtOpt(tracks-per-tape) 28
set FmtOpt(segments-per-track) 537
set FmtOpt(floppy-head-max) 14
set FmtOpt(floppy-track-max) 253
set FmtOpt(gap3) 233
set FmtOpt(format-code) "normal"
set FmtOpt(qic-standard) "QIC-80"
set FmtOpt(fixed) "QIC-80/1100ft"}  -label {QIC-80/1100ft}
  # bindings
  bind .top8.tearoff2 <Enter> {
	set tkPriv(focus) %W
    }

  # build widget .top8.frame1
  frame .top8.frame1  -borderwidth {2}  -height {30}  -relief {raised}  -width {31}

  # build widget .top8.frame1.label5
  label .top8.frame1.label5  -image {ftapetooltinyflopLOGO}  -relief {raised}

  # build widget .top8.frame1.label6
  label .top8.frame1.label6  -image {ftapetooltinyLOGO}  -relief {raised}

  # pack master .top8.frame0
  pack configure .top8.frame0.menubutton1  -side left
  pack configure .top8.frame0.menubutton2  -side right

  # pack master .top8.frame9
  pack configure .top8.frame9.button10  -expand 1  -fill x

  # pack master .top8.frame11
  pack configure .top8.frame11.frame21  -fill x  -side bottom
  pack configure .top8.frame11.label27  -fill x
  pack configure .top8.frame11.frame28  -fill x
  pack configure .top8.frame11.frame0  -fill x
  pack configure .top8.frame11.frame15  -fill x
  pack configure .top8.frame11.frame16  -fill x
  pack configure .top8.frame11.frame17  -fill x
  pack configure .top8.frame11.frame18  -fill x
  pack configure .top8.frame11.frame19  -fill x
  pack configure .top8.frame11.frame20  -fill x
  pack configure .top8.frame11.frame23  -fill x

  # pack master .top8.frame11.frame0
  pack configure .top8.frame11.frame0.value  -side right
  pack configure .top8.frame11.frame0.menubutton2  -fill x  -side right
  pack configure .top8.frame11.frame0.checkbutton1  -side left

  # pack master .top8.frame11.frame15
  pack configure .top8.frame11.frame15.value  -side right
  pack configure .top8.frame11.frame15.menubutton2  -fill x  -side right
  pack configure .top8.frame11.frame15.checkbutton2  -side left

  # pack master .top8.frame11.frame16
  pack configure .top8.frame11.frame16.value  -side right
  pack configure .top8.frame11.frame16.menubutton2  -fill x  -side right
  pack configure .top8.frame11.frame16.checkbutton3  -side left

  # pack master .top8.frame11.frame17
  pack configure .top8.frame11.frame17.value  -side right
  pack configure .top8.frame11.frame17.checkbutton0  -anchor w

  # pack master .top8.frame11.frame18
  pack configure .top8.frame11.frame18.value  -side right
  pack configure .top8.frame11.frame18.checkbutton4  -side left

  # pack master .top8.frame11.frame19
  pack configure .top8.frame11.frame19.value  -side right
  pack configure .top8.frame11.frame19.checkbutton5  -side left

  # pack master .top8.frame11.frame20
  pack configure .top8.frame11.frame20.value  -side right
  pack configure .top8.frame11.frame20.checkbutton6  -side left

  # pack master .top8.frame11.frame21
  pack configure .top8.frame11.frame21.value  -side right
  pack configure .top8.frame11.frame21.menubutton2  -fill x  -side right
  pack configure .top8.frame11.frame21.checkbutton25  -side left

  # pack master .top8.frame30
  pack configure .top8.frame30.label27  -expand 1  -fill both
  pack configure .top8.frame30.frame28  -fill x
  pack configure .top8.frame30.frame0  -fill x
  pack configure .top8.frame30.frame36  -expand 1  -fill both
  pack configure .top8.frame30.frame38  -expand 1  -fill both
  pack configure .top8.frame30.frame39  -expand 1  -fill both
  pack configure .top8.frame30.frame40  -expand 1  -fill both

  # pack master .top8.frame30.frame0
  pack configure .top8.frame30.frame0.label1  -fill both  -side right
  pack configure .top8.frame30.frame0.value  -expand 1  -fill both  -side left
  pack configure .top8.frame30.frame0.menubutton2  -fill both  -side left

  # pack master .top8.frame30.frame36
  pack configure .top8.frame30.frame36.checkbutton35  -anchor w

  # pack master .top8.frame30.frame38
  pack configure .top8.frame30.frame38.checkbutton35  -anchor w

  # pack master .top8.frame30.frame39
  pack configure .top8.frame30.frame39.checkbutton35  -anchor w

  # pack master .top8.frame30.frame40
  pack configure .top8.frame30.frame40.checkbutton35  -anchor w

  # pack master .top8.frame31
  pack configure .top8.frame31.frame  -fill both

  # pack master .top8.frame31.frame
  pack configure .top8.frame31.frame.frame  -fill x

  # pack master .top8.frame31.frame.frame
  pack configure .top8.frame31.frame.frame.entry2  -expand 1  -fill both
  pack configure .top8.frame31.frame.frame.scrollbar1  -fill x

  # pack master .top8.frame1
  pack configure .top8.frame1.label5  -fill both  -side left
  pack configure .top8.frame1.label6  -fill both  -side right

  # pack master .top8
  pack configure .top8.frame0  -fill x
  pack configure .top8.frame9  -fill x  -side bottom
  pack configure .top8.frame31  -fill x  -side bottom
  pack configure .top8.frame11  -anchor n  -side left
  pack configure .top8.frame30  -anchor n  -fill x
  pack configure .top8.frame1  -expand 1  -fill both

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top8"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top8 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top8]" != ""} {
      global xfShowWindow.top8
      set xfShowWindow.top8 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top8; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top8"
    update
  }
}


# User defined procedures


# Procedure: VFrame.frame6
proc VFrame.frame6 { insertWidgetPath args} {

  set xfCounter 0
  set xfLength [llength $args]
  while {$xfCounter < $xfLength} {
    set xfElement [lindex $args $xfCounter]
    if {"$xfElement" == "-startupSrc" ||
        "$xfElement" == "-middleSrc" ||
        "$xfElement" == "-endSrc"} {
      if {$xfLength > [expr $xfCounter+1]} {
        incr xfCounter
        set xfSource($xfElement) [lindex $args $xfCounter]
      }
    } {
      if {[string match -* $xfElement]} {
        if {$xfLength > [expr $xfCounter+1]} {
          incr xfCounter
          set xfGenResource($xfElement) [lindex $args $xfCounter]
        }
      } {
        if {[string match $insertWidgetPath* $xfElement]} {
          if {$xfLength > [expr $xfCounter+2]} {
            incr xfCounter
            set xfSpecResource($xfElement) [lindex $args $xfCounter]
            incr xfCounter
            lappend xfSpecResource($xfElement) [lindex $args $xfCounter]
          }
        }
      }
    }
    incr xfCounter
  }

  if {"[info commands $insertWidgetPath]" == ""} {
  if {[info exists xfSource(-startupSrc)]} {
    if {[catch "$xfSource(-startupSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  set widgetCode {

  # build widget $insertWidgetPath.frame6
  frame $insertWidgetPath.frame6  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41
  frame $insertWidgetPath.frame6.frame41  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.label42
  label $insertWidgetPath.frame6.frame41.label42  -foreground {Blue}  -relief {raised}  -text {Format Status}  -textvariable {FormatStatusLabel}

  # build widget $insertWidgetPath.frame6.frame41.frame28
  frame $insertWidgetPath.frame6.frame41.frame28  -borderwidth {2}  -height {8}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.frame1
  frame $insertWidgetPath.frame6.frame41.frame1  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.frame1.label3
  label $insertWidgetPath.frame6.frame41.frame1.label3  -text {Erasing:}  -width {10}

  # build widget $insertWidgetPath.frame6.frame41.frame1.frame0
  frame $insertWidgetPath.frame6.frame41.frame1.frame0  -borderwidth {2}  -relief {groove}

  # build widget $insertWidgetPath.frame6.frame41.frame1.frame0.frame1
  frame $insertWidgetPath.frame6.frame41.frame1.frame0.frame1  -background {Blue}  -borderwidth {2}  -height {30}  -relief {groove}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.frame1.label4
  label $insertWidgetPath.frame6.frame41.frame1.label4  -justify {right}  -relief {ridge}  -text {0%}  -width {5}

  # build widget $insertWidgetPath.frame6.frame41.frame2
  frame $insertWidgetPath.frame6.frame41.frame2  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.frame2.label3
  label $insertWidgetPath.frame6.frame41.frame2.label3  -text {Formatting:}  -width {10}

  # build widget $insertWidgetPath.frame6.frame41.frame2.frame0
  frame $insertWidgetPath.frame6.frame41.frame2.frame0  -borderwidth {2}  -relief {groove}

  # build widget $insertWidgetPath.frame6.frame41.frame2.frame0.frame1
  frame $insertWidgetPath.frame6.frame41.frame2.frame0.frame1  -background {Blue}  -borderwidth {2}  -height {30}  -relief {groove}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.frame2.label4
  label $insertWidgetPath.frame6.frame41.frame2.label4  -justify {right}  -relief {ridge}  -text {0%}  -width {5}

  # build widget $insertWidgetPath.frame6.frame41.frame3
  frame $insertWidgetPath.frame6.frame41.frame3  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.frame3.label3
  label $insertWidgetPath.frame6.frame41.frame3.label3  -text {Verifying:}  -width {10}

  # build widget $insertWidgetPath.frame6.frame41.frame3.frame0
  frame $insertWidgetPath.frame6.frame41.frame3.frame0  -borderwidth {2}  -relief {groove}

  # build widget $insertWidgetPath.frame6.frame41.frame3.frame0.frame1
  frame $insertWidgetPath.frame6.frame41.frame3.frame0.frame1  -background {Blue}  -borderwidth {2}  -height {30}  -relief {groove}  -width {30}

  # build widget $insertWidgetPath.frame6.frame41.frame3.label4
  label $insertWidgetPath.frame6.frame41.frame3.label4  -justify {right}  -relief {ridge}  -text {0%}  -width {5}

  # build widget $insertWidgetPath.frame6.frame15
  frame $insertWidgetPath.frame6.frame15  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame6.frame15.frame9
  frame $insertWidgetPath.frame6.frame15.frame9  -height {30}  -width {30}

  # build widget $insertWidgetPath.frame6.frame15.frame9.button10
  button $insertWidgetPath.frame6.frame15.frame9.button10  -command {ComposeFormatCmd $Options(RawNoRewindDevice) FmtOpt
RunFormatCmd [SN FormatErrorOutput] $formatcmd FmtOpt}  -foreground {Blue}  -padx {9}  -pady {3}  -text {Start Formatting}

  # build widget $insertWidgetPath.frame6.frame15.frame9.button11
  button $insertWidgetPath.frame6.frame15.frame9.button11  -command {ShowWindow.top8}  -foreground {DarkGreen}  -padx {9}  -pady {3}  -text {Format Options}

  # build widget $insertWidgetPath.frame6.frame15.frame13
  frame $insertWidgetPath.frame6.frame15.frame13  -height {30}  -width {30}

  # build widget $insertWidgetPath.frame6.frame15.frame13.button14
  button $insertWidgetPath.frame6.frame15.frame13.button14  -command {StopFormatCmd}  -foreground {Red}  -padx {9}  -pady {3}  -text {Stop Formatting}

  # build widget $insertWidgetPath.frame6.squeezer
  frame $insertWidgetPath.frame6.squeezer  -borderwidth {4}  -relief {ridge}

  # build widget $insertWidgetPath.frame6.squeezer.frame4
  frame $insertWidgetPath.frame6.squeezer.frame4

  # build widget $insertWidgetPath.frame6.squeezer.frame4.listbox5
  listbox $insertWidgetPath.frame6.squeezer.frame4.listbox5  -height {5}  -width {1}  -xscrollcommand {$insertWidgetPath.frame6.squeezer.frame4.scrollbar7 set}  -yscrollcommand {$insertWidgetPath.frame6.squeezer.frame4.scrollbar6 set}

  # build widget $insertWidgetPath.frame6.squeezer.frame4.scrollbar6
  scrollbar $insertWidgetPath.frame6.squeezer.frame4.scrollbar6  -command {$insertWidgetPath.frame6.squeezer.frame4.listbox5 yview}

  # build widget $insertWidgetPath.frame6.squeezer.frame4.scrollbar7
  scrollbar $insertWidgetPath.frame6.squeezer.frame4.scrollbar7  -command {$insertWidgetPath.frame6.squeezer.frame4.listbox5 xview}  -orient {horizontal}

  # build widget $insertWidgetPath.frame6.squeezer.frame7
  frame $insertWidgetPath.frame6.squeezer.frame7  -height {30}  -width {30}

  # build widget $insertWidgetPath.frame6.squeezer.frame7.checkbutton8
  checkbutton $insertWidgetPath.frame6.squeezer.frame7.checkbutton8  -anchor {w}  -command {if {$squeeze(.squeezer.checkbutton8)} {
  pack configure $insertWidgetPath.frame6.squeezer.frame4 -side bottom -fill both -expand true
} {
  pack forget $insertWidgetPath.frame6.squeezer.frame4
} }  -text {Messages}  -variable {squeeze(.squeezer.checkbutton8)}

  # build widget $insertWidgetPath.frame6.squeezer.frame7.message8
  message $insertWidgetPath.frame6.squeezer.frame7.message8  -aspect {1500}  -foreground {Blue}  -justify {right}  -padx {5}  -pady {2}  -relief {ridge}  -text {00:00:00}  -textvariable {TimeString}

  # build widget $insertWidgetPath.frame6.squeezer.frame7.label9
  label $insertWidgetPath.frame6.squeezer.frame7.label9  -text {Elapsed Time}

  # pack master $insertWidgetPath.frame6.frame41
  pack configure $insertWidgetPath.frame6.frame41.label42  -fill x
  pack configure $insertWidgetPath.frame6.frame41.frame28  -fill x
  pack configure $insertWidgetPath.frame6.frame41.frame1  -expand 1  -fill both
  pack configure $insertWidgetPath.frame6.frame41.frame2  -expand 1  -fill both
  pack configure $insertWidgetPath.frame6.frame41.frame3  -expand 1  -fill both

  # pack master $insertWidgetPath.frame6.frame41.frame1
  pack configure $insertWidgetPath.frame6.frame41.frame1.label3  -side left
  pack configure $insertWidgetPath.frame6.frame41.frame1.frame0  -expand 1  -fill both  -side left
  pack configure $insertWidgetPath.frame6.frame41.frame1.label4  -anchor ne  -fill y  -side right

  # place
  place $insertWidgetPath.frame6.frame41.frame1.frame0.frame1 -x 0 -relx 0 -y 0 -rely 0 -width {} -relwidth 0 -height {} -relheight 1 -anchor nw


  # pack master $insertWidgetPath.frame6.frame41.frame2
  pack configure $insertWidgetPath.frame6.frame41.frame2.label3  -side left
  pack configure $insertWidgetPath.frame6.frame41.frame2.frame0  -expand 1  -fill both  -side left
  pack configure $insertWidgetPath.frame6.frame41.frame2.label4  -anchor ne  -fill y  -side right

  # place
  place $insertWidgetPath.frame6.frame41.frame2.frame0.frame1 -x 0 -relx 0 -y 0 -rely 0 -width {} -relwidth 0 -height {} -relheight 1 -anchor nw


  # pack master $insertWidgetPath.frame6.frame41.frame3
  pack configure $insertWidgetPath.frame6.frame41.frame3.label3  -side left
  pack configure $insertWidgetPath.frame6.frame41.frame3.frame0  -expand 1  -fill both  -side left
  pack configure $insertWidgetPath.frame6.frame41.frame3.label4  -anchor ne  -fill y  -side right

  # place
  place $insertWidgetPath.frame6.frame41.frame3.frame0.frame1 -x 0 -relx 0 -y 0 -rely 0 -width {} -relwidth 0 -height {} -relheight 1 -anchor nw


  # pack master $insertWidgetPath.frame6.frame15
  pack configure $insertWidgetPath.frame6.frame15.frame13  -expand 1  -fill both  -side bottom
  pack configure $insertWidgetPath.frame6.frame15.frame9  -expand 1  -fill both

  # pack master $insertWidgetPath.frame6.frame15.frame9
  pack configure $insertWidgetPath.frame6.frame15.frame9.button10  -expand 1  -fill both  -side left
  pack configure $insertWidgetPath.frame6.frame15.frame9.button11  -expand 1  -fill both  -side right

  # pack master $insertWidgetPath.frame6.frame15.frame13
  pack configure $insertWidgetPath.frame6.frame15.frame13.button14  -expand 1  -fill both

  # pack master $insertWidgetPath.frame6.squeezer
  pack configure $insertWidgetPath.frame6.squeezer.frame7  -fill x

  # pack master $insertWidgetPath.frame6.squeezer.frame4
  pack configure $insertWidgetPath.frame6.squeezer.frame4.scrollbar6  -fill y  -side right
  pack configure $insertWidgetPath.frame6.squeezer.frame4.listbox5  -expand 1  -fill both
  pack configure $insertWidgetPath.frame6.squeezer.frame4.scrollbar7  -fill x  -side bottom

  # pack master $insertWidgetPath.frame6.squeezer.frame7
  pack configure $insertWidgetPath.frame6.squeezer.frame7.checkbutton8  -side left
  pack configure $insertWidgetPath.frame6.squeezer.frame7.message8  -side right
  pack configure $insertWidgetPath.frame6.squeezer.frame7.label9  -side right
  }
  set subst ""
  append subst \\ [string trim { $insertWidgetPath.frame6 }]
  regsub -all $subst $widgetCode $insertWidgetPath widgetCode
  regsub -all {%ThisTopWidget} $widgetCode $insertWidgetPath widgetCode
  eval $widgetCode

  if {[info exists xfSource(-middleSrc)]} {
    if {[catch "$xfSource(-middleSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  set geometryCode {

  # pack master $insertWidgetPath.frame6
  pack configure $insertWidgetPath.frame6.frame41  -expand 1  -fill both
  pack configure $insertWidgetPath.frame6.frame15  -expand 1  -fill both
  pack configure $insertWidgetPath.frame6.squeezer  -fill x

  # pack slave $insertWidgetPath.frame6
  pack configure $insertWidgetPath.frame6  -expand 1  -fill both

  $insertWidgetPath.frame6.squeezer.frame4.listbox5 insert end {--format-parameters qic-standard=0x83,format-code=4,floppy-head-max=53,floppy-track-max=254,segments-per-track=1088,tracks-per-tape=50,gap3=248}


  }
  set subst ""
  append subst \\ [string trim { $insertWidgetPath.frame6 }]
  regsub -all $subst $geometryCode $insertWidgetPath geometryCode
  regsub -all {\$insertWidgetPath} $geometryCode [winfo parent $insertWidgetPath] geometryCode
  eval $geometryCode

  if {[info exists xfSource(-endSrc)]} {
    if {[catch "$xfSource(-endSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  }

  if {[info exists xfGenResource]} {
    set xfWidgetList ""
    set xfTmpWidgetList $insertWidgetPath
    while {1} {
      if {[llength $xfTmpWidgetList] == 0} {
        break
      }
      set xfFirstWidget [lindex $xfTmpWidgetList 0]
      lappend xfWidgetList $xfFirstWidget
      set xfTmpWidgetList [lreplace $xfTmpWidgetList 0 0]
      if {"[winfo children $xfFirstWidget]" != ""} {
        eval lappend xfTmpWidgetList [winfo children $xfFirstWidget]
      }
    }
    foreach xfCounter $xfWidgetList {
      if {[info exists xfGenResource]} {
        foreach xfResource [array names xfGenResource] {
          catch "$xfCounter config $xfResource [set xfGenResource($xfResource)]"
        }
      }
    }
  }
  if {[info exists xfSpecResource]} {
    foreach xfCounter [array names xfSpecResource] {
      if {"[info commands $xfCounter]" != ""} {
        catch "$xfCounter config [lindex $xfSpecResource($xfCounter) 0] [lindex $xfSpecResource($xfCounter) 1]"
      }
    }
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree $insertWidgetPath"
    after 2 "catch {XFEditSetShowWindows}"
  }
  return $insertWidgetPath
}


# Procedure: UpdateFmtOptWidgets
proc UpdateFmtOptWidgets { {Parms "FmtOpt"}} {
    upvar ${Parms}Status State
    upvar $Parms Opt
    global {symbolicName}

    foreach opt {
	qic-standard
	format-code
	gap3
	floppy-head-max
	floppy-track-max
	segments-per-track
	tracks-per-tape} {
#	puts "$opt: $State($opt)\n"
	if {$State($opt) && !$State(fixed-formats)} {
	    if {[CSN ${opt}entry]} {
		[SN ${opt}entry] configure -state normal
	    }
	    if {[CSN ${opt}menu]} {
		[SN ${opt}menu] configure -state normal
	    }
	} else {
	    if {[CSN ${opt}entry]} {
		[SN ${opt}entry] configure -state disabled
	    }
	    if {[CSN ${opt}menu]} {
		[SN ${opt}menu] configure -state disabled
	    }
	}
    }
    set opt fixed-formats
    if {$State($opt)} {
	if {[CSN ${opt}entry]} {
	    [SN ${opt}entry] configure -state normal
	}
	if {[CSN ${opt}menu]} {
	    [SN ${opt}menu] configure -state normal
	}
    } else {
	if {[CSN ${opt}entry]} {
	    [SN ${opt}entry] configure -state disabled
	}
	if {[CSN ${opt}menu]} {
	    [SN ${opt}menu] configure -state disabled
	}
    }
}


# Procedure: UpdateEraseTime
proc UpdateEraseTime {} {
    global estimate
    global erasestart

    if {[catch {clock seconds} nowtime] == 0} {
	set elapsed [expr $nowtime - $erasestart]
	UpdateProgress [SN EraseBar] [expr ($elapsed*100.0+50)/$estimate]
	update
	after 1000 UpdateEraseTime
    }
}


# Procedure: UpdateProgress
proc UpdateProgress { {widget ""} {val ""}} {
# xf ignore me 5
##########
# Procedure: UpdateProgress
# Description: update a "percentage progress bar"
# Arguments: {widget} - base widget that contains bar and label
#            {val} - 0 <= $val <= 100
# Returns: nothing
# Sideeffects: none
##########
	place configure $widget.frame0.frame1 -relwidth [expr $val/100.0]
	$widget.label4 configure -text "[expr round($val)]%"
}


# Procedure: RunFormatCmd
proc RunFormatCmd { listWidget {cmd "ftformat -f /dev/nrawft0 --mode=probe"} {Parms "FmtOpt"}} {
    global formatcmd
    global fixedformats
    global cmdstatus
    global starttime
    global CmdPipeFD
    upvar $Parms Opts
    upvar ${Parms}Status OptsStatus
    
    [SN StartFormatButton] configure -state disabled

    CloseFD CmdPipeFD 1
#    puts "$Opts(qic-standard)\n"
    set cmdstatus $cmd
    #tkwait visibility $listWidget
    puts $cmd\n
#    puts "error file: /tmp/ftape-tool.[pid]\n" 
    ClearList $listWidget
    if {[catch {open "|$cmd --parsable-output 2> /tmp/ftape-tool.[pid]" RDONLY} CmdPipeFD]} {
	foreach fileLine [split $CmdPipeFD "\n"] {
	    $listWidget insert end $fileLine
	}
	set CmdPipeFD ""
	[SN StartFormatButton] configure -state normal
	return
    }
#    puts "pid of ftformat: [pid $CmdPipeFD]\n"
    catch { fconfigure $CmdPipeFD -blocking 0 }
    if {[catch {clock seconds} starttime] == 0} {
	after 1000 UpdateTime
    }
    fileevent $CmdPipeFD readable [list FormatCmdHandler $listWidget $CmdPipeFD $Parms]
}


# Procedure: ParseFormatParms
proc ParseFormatParms { line {Parms "FmtOpts"}} {
    upvar $Parms Opts
    upvar ${Parms}Status State

#    puts "$line\n"
#    puts "$Opts(qic-standard)\n"
    foreach {opt} {
	qic-standard
	format-code
	floppy-head-max
	floppy-track-max
	segments-per-track
	tracks-per-tape} {
	set newopt($opt) $Opts($opt)
	if {[regexp -- $opt=(\[0x0-9A-Fa-f\]+) $line tmp newopt($opt)]} {
	    puts stdout "found $tmp, value $newopt($opt), symbolic [MapFtapeNames 1 $opt newopt]\n"
	} else {
	    puts stderr "no match for $opt\n"
	}
	if {!$State($opt) || $State(fixed-formats)} {
	    # user didn't want to set this parameter himself. Also, we
	    # trust ftformat when using fixed formats.
	    set Opts($opt) $newopt($opt)
	} else  { if {[MapFtapeNames 0 $opt Opts] !=
		      [MapFtapeNames 0 $opt newopt]} {
	    # ask the user if she wants to use the new value
	    if {[AlertBox [concat "WARNING:"  "ftformat detected a different value for "  "the $opt format parameter. "  "Which one do you want?"]  "" "" "Format Parameter Mismatch"  "Use autodetected value: $opt=[MapFtapeNames 1 $opt newopt]"  "Use user specified value: $opt=[MapFtapeNames 1 $opt Opts]"] == 0} {
		set Opts($opt) [MapFtapeNames 0 $opt newopt]
	    }
	} }
    }
}


# Procedure: MakeFormatFrame
proc MakeFormatFrame {} {
    global outputframe
    global FormatStatusLabel
    global Options
    global FmtOpt
    global FmtOptStatus
    global CmdPipeFD
    global UserInfoString

    if {[lindex [[SN FormatButton] config -text] 4] == "Cancel"} {
	if {$CmdPipeFD != ""} {
	    CloseFD CmdPipeFD 1
	}
	UpdateTapeButtons Format "stop"
	catch {destroy $outputframe}
	set outputframe [SN logoframe]
	VFrame[SN logoframe] [SN logoframe]
	return
    }
    UpdateTapeButtons Format "start"   

    catch {destroy $outputframe}
    set outputframe [SN formatframe]
    VFrame[SN formatframe] [SN formatframe]
    UpdateProgress [SN EraseBar] "0.0"
    UpdateProgress [SN FormatBar] "0.0"
    UpdateProgress [SN VerifyBar] "0.0"
    set FormatStatusLabel "Format Status"
    ComposeFormatCmd $Options(RawNoRewindDevice) FmtOpt
}


# Procedure: FormatCmdHandler
proc FormatCmdHandler { listWidget fd {Parms "FmtOpt"}} {
    upvar $Parms Opts
    upvar ${Parms}Status OptsStatus
    global FormatStatus
    global FormatStatusLabel
    global CmdPipeFD
    global estimate
    global erasestart

#    puts "$Opts(qic-standard)\n"
    set formatline {}
    if {[catch {gets $CmdPipeFD formatline}]} {
	after cancel UpdateTime
	exec sync
	FileInList $listWidget "/tmp/ftape-tool.[pid]"
	CloseFD CmdPipeFD 1
	[SN StartFormatButton] configure -state normal
	return
    }
    if {[eof $fd]} {
	after cancel UpdateTime
	CloseFD CmdPipeFD 0
	FileInList $listWidget "/tmp/ftape-tool.[pid]"
	[SN StartFormatButton] configure -state normal
	return
    }
#    puts stdout "$formatline\n"
    switch -regexp -- $formatline {
	^--format-parameters.*
	{
	    $listWidget insert end $formatline
	    $listWidget yview scroll 1 units
	    ParseFormatParms $formatline Opts
	}
	^Erasing.*
	{
	    $listWidget insert end $formatline
	    $listWidget yview scroll 1 units
	    set FormatStatus Erasing
	    if {[regexp -- ^Erasing\ *track\ *(\[0-9\]+) $formatline tmp track]} {
		UpdateProgress [SN EraseBar] [expr ($track*100.0+50)/$Opts(tracks-per-tape)]
		if {$track == 0} {
		    catch {clock seconds} erasestart
		} else {
		    if {[catch {clock seconds} nowtime] == 0} {
			set elapsed [expr $nowtime - $erasestart]
			set erasevelocity [expr $elapsed*1.0/$track]
			set estimate [expr $erasevelocity *  $Opts(tracks-per-tape)]
			after cancel UpdateEraseTime
			after 1000 UpdateEraseTime
		    }		    
		}
	    } 
	    set FormatStatusLabel $formatline
	}
	.*reference.*burst.*
	{
	    after cancel UpdateEraseTime
	    $listWidget insert end $formatline
	    $listWidget yview scroll 1 units
	    set FormatStatus Referencing
	    if {!$Opts(omiterase)} {
		UpdateProgress [SN EraseBar] 100
	    }
	    set FormatStatusLabel $formatline
	}
	^Formatting.*
	{
	    after cancel UpdateEraseTime
	    $listWidget insert end $formatline
	    $listWidget yview scroll 1 units
	    set FormatStatus Formatting
	    set FormatStatusLabel $formatline
	}
	^Retrying.*
	{
	    after cancel UpdateEraseTime
	    $listWidget insert end $formatline
	    $listWidget yview scroll 1 units
	    set FormatStatus Formatting
	    set FormatStatusLabel $formatline
	}
	^Verifying.*
	{
	    after cancel UpdateEraseTime
	    $listWidget insert end $formatline
	    $listWidget yview scroll 1 units
	    set FormatStatus Verifying
	    set FormatStatusLabel $formatline
	}
	^segment.*
	{
	    after cancel UpdateEraseTime
	    set FormatStatusLabel "$FormatStatus $formatline"
	    if {$FormatStatus == "Formatting" &&
		[regexp -- ^segment\ *(\[0-9\]+) $formatline tmp segment]} {
		UpdateProgress [SN FormatBar]  [expr ($segment*100.0+50)/($Opts(tracks-per-tape)*$Opts(segments-per-track))]
	    }	    	    
	    if {$FormatStatus == "Verifying" &&
		[regexp -- ^segment\ *(\[0-9\]+) $formatline tmp segment]} {
		UpdateProgress [SN VerifyBar]  [expr ($segment*100.0+50)/($Opts(tracks-per-tape)*$Opts(segments-per-track))]
	    }	    	    
	}
	default
	{
	    after cancel UpdateEraseTime
	    if {$formatline != ""} {
		$listWidget insert end $formatline
		set FormatStatusLabel $formatline
		$listWidget yview scroll 1 units
	    }
	}
    }
    update
}


# Procedure: ComposeFormatCmd
proc ComposeFormatCmd { {tapedev "/dev/nrawft0"} {Parms "FmtOpt"}} {
    global formatcmd
    global fixedformats
    upvar $Parms Opts
    upvar ${Parms}Status state

    set formatcmd "ftformat -f $tapedev --mode=$Opts(mode)"
    if {$Opts(omiterase)} {
	set formatcmd "$formatcmd --omit-erase"
    }
    if {$Opts(noref)} {
       set formatcmd "$formatcmd --no-reference-bursts"
    }
    if {$Opts(discardheader)} {
	set formatcmd "$formatcmd --discard-header"
    }
    if {$Opts(verifyonly)} {
	set formatcmd "$formatcmd --verify-only"
    }
    if {$state(fixed-formats)} {
	set formatcmd "$formatcmd --format-parameters="
	switch $Opts(fixed-formats) {
	    "QIC-40/205ft" {
		set formatcmd "${formatcmd}qic40-205ft"
	    }
	    "QIC-40/307ft" {
		set formatcmd "${formatcmd}qic40-307ft"
	    }
	    "QIC-40/1100ft" {
		set formatcmd "${formatcmd}qic40-1100ft"
	    }
	    "QIC-80/205ft" {
		set formatcmd "${formatcmd}qic80-205ft"
	    }
	    "QIC-80/307ft" {
		set formatcmd "${formatcmd}qic80-307ft"
	    }
	    "QIC-80/425ft" {
		set formatcmd "${formatcmd}qic80-425ft"
	    }
	    "QIC-80/1100ft" {
		set formatcmd "${formatcmd}qic80-1100ft"
	    }
	}
    } else {
	set fmtparms ""
	foreach opt {
	    qic-standard
	    format-code
	    gap3
	    floppy-head-max 
	    floppy-track-max
	    segments-per-track
	    tracks-per-tape} {
	    if {$state($opt)} {
		if {$fmtparms != ""} {
		    set fmtparms "${fmtparms},$opt=[MapFtapeNames 0 $opt Opts]"
		} else {
		    set fmtparms "$opt=[MapFtapeNames 0 $opt Opts]"
		}
	    }
	}
	if {$fmtparms != ""} {
	    set formatcmd "$formatcmd --format-parameters=$fmtparms"
	}
    }
}


# Procedure: StopFormatCmd
proc StopFormatCmd {} {
    global outputframe

    CloseFD CmdPipeFD 1
    if {[lindex [[SN StartFormatButton] config -state] 4] == "disabled"} {
	[SN StartFormatButton] configure -state normal
    } else {
	UpdateTapeButtons Format "stop"
	catch {destroy $outputframe}
	set outputframe [SN logoframe]
	VFrame[SN logoframe] [SN logoframe]
    }
}


# Internal procedures

# eof
#

