/* sqlaccess.h
 *
 * Copyright (C) 1999 - 2001 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


/*
 * Implementation of the objects here is in two files:
 *    sqlaccess.c
 *    sqldata.c
 */

#ifndef __SQL_ACCESS__
#define __SQL_ACCESS__

#include <config.h>
#include <gnome.h>
#include "sqlqueryres.h"
#include <gda-connection.h>
#include <gda-command.h>
#include "sqldatadisplay.h"
#include "gasql_xml.h"

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

	typedef struct _SqlAccess SqlAccess;
	typedef struct _SqlAccessClass SqlAccessClass;
	typedef struct _SqlAccessItemType SqlAccessItemType;

	typedef struct _SqlDataType SqlDataType;
	typedef struct _SqlDataTypeClass SqlDataTypeClass;

	typedef struct _SqlDataFunction SqlDataFunction;
	typedef struct _SqlDataFunctionClass SqlDataFunctionClass;

	typedef struct _SqlDataOperator SqlDataOperator;
	typedef struct _SqlDataOperatorClass SqlDataOperatorClass;

	typedef struct _SqlDataAggregate SqlDataAggregate;
	typedef struct _SqlDataAggregateClass SqlDataAggregateClass;

/*
 * 
 * SqlAccess object
 *
 */
#define SQL_ACCESS(obj)          GTK_CHECK_CAST (obj, sql_access_get_type(), SqlAccess)
#define SQL_ACCESS_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_access_get_type (), SqlAccessClass)
#define IS_SQL_ACCESS(obj)       GTK_CHECK_TYPE (obj, sql_access_get_type ())


	typedef struct
	{
		gboolean sequences;
		gboolean procs;
		gboolean inheritance;
		gboolean xml_queries;
	}
	GdaConnection_Supports;

	/* struct for the object's data */
	struct _SqlAccess
	{
		GdaConnection object;

		/* serveur description */
		gchar *description;
		GdaConnection_Supports features;

		/* SQL connectivity */
		GString *gda_datasource;
		GString *user_name;
		GString *password;

		/* Data types and stuff */
		GSList *data_types;
		GSList *data_functions;
		GSList *data_aggregates;
		GSList *data_types_display;	/* list of SqlDataDisplayFns structs */
		GHashTable *types_objects_hash;	/* hash to store the bindings of Display 
						   fns to several objects */
		GSList *bindable_objects;	/* list the functions called by 
						   sql_access_get_object_display_fns() */

		/* Queries execution */
		GdaCommand *cmd;
	};

	/* struct for the object's class */
	struct _SqlAccessClass
	{
		GdaConnectionClass parent_class;

		void (*conn_opened) (SqlAccess * srv);
		void (*conn_to_close) (SqlAccess * srv);	/* connexion about to be closed */
		void (*conn_closed) (SqlAccess * srv);
		/* data types, functions, operators and aggregates signals */
		void (*data_types_updated) (SqlAccess * srv);
		void (*data_function_added) (SqlAccess * srv,
					     SqlDataFunction * func);
		void (*data_function_removed) (SqlAccess * srv,
					       SqlDataFunction * func);
		void (*data_function_updated) (SqlAccess * srv);
		void (*data_aggregate_added) (SqlAccess * srv,
					      SqlDataAggregate * func);
		void (*data_aggregate_removed) (SqlAccess * srv,
						SqlDataAggregate * func);
		void (*data_aggregate_updated) (SqlAccess * srv);
		void (*progress) (SqlAccess * srv, gchar * msg, guint now,
				  guint total);
		/* for the objects to plugins bindings */
		void (*objects_bindings_updated) (SqlAccess * srv);
	};

	/*
	 * generic widget's functions
	 */
	GtkType sql_access_get_type (void);
	GtkObject *sql_access_new (CORBA_ORB orb);
	void sql_access_free (SqlAccess * srv);

	/*
	 * open/close and query functions
	 */
	void sql_access_open_connect (SqlAccess * srv);
	gboolean sql_access_is_open (SqlAccess * srv);
	void sql_access_close_connect (SqlAccess * srv);
	void sql_access_close_connect_no_warning (SqlAccess * srv);
	SqlQueryRes *sql_access_do_query (SqlAccess * srv, gchar * query);

	/*
	 * data type, etc lookup and management
	 */
	void sql_access_refresh_datas (SqlAccess * srv);
	gchar *sql_access_get_data_type (SqlAccess * srv, gchar * oid);
	GList *sql_access_get_data_type_list (SqlAccess * srv);	/* to free */
	SqlDataType *sql_access_get_type_from_name (SqlAccess * srv,
						    gchar * name);
	SqlDataType *sql_access_get_type_from_oid (SqlAccess * srv,
						   gchar * oid);

	/*
	 * XML functions
	 */
	void sql_access_build_xml_tree (SqlAccess * srv, xmlDocPtr doc);
	gboolean sql_access_build_from_xml_tree (SqlAccess * srv,
						 xmlNodePtr tree);

	/*
	 * plugins management
	 */
	SqlDataDisplayFns *sql_access_get_display_fns_from_gda (SqlAccess *
								srv,
								SqlDataType *
								dt);
	/* returns the display functions associated with an object 
	   (SqlDataType objects get their onw default data functions in case 
	   they are non overloaded) Cannot return NULL! */
	SqlDataDisplayFns *sql_access_get_object_display_fns (SqlAccess * srv,
							      GtkObject *
							      obj);
	void sql_access_bind_object_display (SqlAccess * srv, GtkObject * obj,
					     SqlDataDisplayFns * fns);
	void sql_access_unbind_object_display (SqlAccess * srv,
					       GtkObject * obj);
	void sql_access_rescan_display_plugins (SqlAccess * srv,
						gchar * path);
	/* this function allows modules to give another object to look for in the 
	   hash table, given an object. For example if the object is a 
	   SqlMemTableField, then the 'func' function will return the 
	   data type of the field (this is set by the SqlDb module) */
	void sql_access_declare_object_bindable (SqlAccess * srv,
						 gpointer (*func) (GtkObject
								   *));



/*
 *
 * SqlDataType object
 *
 */

#define SQL_DATA_TYPE(obj)          GTK_CHECK_CAST (obj, sql_data_type_get_type(), SqlDataType)
#define SQL_DATA_TYPE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_data_type_get_type (), SqlDataTypeClass)
#define IS_SQL_DATA_TYPE(obj)       GTK_CHECK_TYPE (obj, sql_data_type_get_type ())


	/* struct for the object's data */
	struct _SqlDataType
	{
		GtkObject object;

		gchar *descr;
		gchar *sqlname;
		guint numparams;
		gint server_type;	/* provider representation for the type */
		GDA_ValueType gda_type;

		/* Types display implementation */
		SqlDataDisplayFns *display_fns;
		gboolean updated;
	};

	/* struct for the object's class */
	struct _SqlDataTypeClass
	{
		GtkObjectClass parent_class;
	};

	/*
	 * generic widget's functions
	 */
	GtkType sql_data_type_get_type (void);
	GtkObject *sql_data_type_new (void);

	/*
	 * data types management
	 */
	void sql_data_type_set_sqlname (SqlDataType * dt, gchar * name);
	void sql_data_type_set_descr (SqlDataType * dt, gchar * name);
	void sql_data_type_update_list (struct _SqlAccess *srv);
#ifdef debug
	void sql_data_type_show_types (GSList * dtl);
#endif

	/* 
	 * data types lookup
	 */
	SqlDataType *sql_data_type_get_from_server_type (GSList * dtl,
							 gint st);
	SqlDataType *sql_data_type_get_from_name (GSList * dtl, gchar * name);
	GList *sql_data_type_get_name_list (GSList * dtl);
	SqlDataType *sql_data_type_get_from_xml_id (struct _SqlAccess *srv,
						    gchar * id);



/*
 *
 * SqlDataFunction object
 *
 */

#define SQL_DATA_FUNCTION(obj)          GTK_CHECK_CAST (obj, sql_data_function_get_type(), SqlDataFunction)
#define SQL_DATA_FUNCTION_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_data_function_get_type (), SqlDataFunctionClass)
#define IS_SQL_DATA_FUNCTION(obj)       GTK_CHECK_TYPE (obj, sql_data_function_get_type ())

	/* struct for the object's data */
	struct _SqlDataFunction
	{
		GtkObject object;

		gchar *descr;
		gchar *sqlname;
		gchar *objectid;	/* unique id for the function */
		SqlDataType *result_type;
		GSList *args;	/* SqlDataType list */
		gboolean is_user;	/* TRUE  if user defined function */
		gboolean updated;
	};

	/* struct for the object's class */
	struct _SqlDataFunctionClass
	{
		GtkObjectClass parent_class;
	};

	/*
	 * generic widget's functions 
	 */
	GtkType sql_data_function_get_type (void);
	GtkObject *sql_data_function_new (void);

	/*
	 * function management
	 */
	void sql_data_function_set_sqlname (SqlDataFunction * df,
					    gchar * name);
	void sql_data_function_set_descr (SqlDataFunction * df, gchar * name);
	void sql_data_function_update_list (struct _SqlAccess *srv);
#ifdef debug
	void sql_data_function_show_functions (GSList * dfl);
#endif

	/* 
	 * functions lookup
	 */
	GSList *sql_data_function_get_list_from_name (GSList * dfl,
						      gchar * name);
	/* argtypes is a list of SqlDataTypes in the right order */
	SqlDataFunction *sql_data_function_get_from_name (GSList * dfl,
							  gchar * name,
							  GSList * argtypes);
	SqlDataFunction *sql_data_function_get_from_objid (GSList * dfl,
							   gchar * id);
	SqlDataFunction *sql_data_function_get_from_xml_id (struct _SqlAccess
							    *srv, gchar * id);
	/* function to bind for data types and plugins usage */
	gpointer sql_data_function_binding_func (GtkObject * obj);

/*
 *
 * SqlDataAggregate object
 *
 */

#define SQL_DATA_AGGREGATE(obj)          GTK_CHECK_CAST (obj, sql_data_aggregate_get_type(), SqlDataAggregate)
#define SQL_DATA_AGGREGATE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_data_aggregate_get_type (), SqlDataAggregateClass)
#define IS_SQL_DATA_AGGREGATE(obj)       GTK_CHECK_TYPE (obj, sql_data_aggregate_get_type ())


	/* struct for the object's data */
	struct _SqlDataAggregate
	{
		GtkObject object;

		gchar *descr;
		gchar *sqlname;
		gchar *objectid;
		SqlDataType *arg_type;
		gboolean updated;
	};

	/* struct for the object's class */
	struct _SqlDataAggregateClass
	{
		GtkObjectClass parent_class;
	};

	/*
	 * generic widget's aggregates 
	 */
	GtkType sql_data_aggregate_get_type (void);
	GtkObject *sql_data_aggregate_new (void);

	/*
	 * aggregate management
	 */
	void sql_data_aggregate_set_sqlname (SqlDataAggregate * da,
					     gchar * name);
	void sql_data_aggregate_set_descr (SqlDataAggregate * da,
					   gchar * name);
	void sql_data_aggregate_update_list (struct _SqlAccess *srv);
#ifdef debug
	void sql_data_aggregate_show_aggregates (GSList * dal);
#endif


	/*
	 * aggregates lookup
	 */
	SqlDataAggregate *sql_data_aggregate_get_from_name (GSList * dal,
							    gchar * name,
							    SqlDataType *
							    arg_type);
	SqlDataAggregate *sql_data_aggregate_get_from_objid (GSList * dal,
							     gchar * oid);
	SqlDataAggregate *sql_data_aggregate_get_from_xml_id (struct
							      _SqlAccess *srv,
							      gchar * id);


#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
